/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BBoxChannel;
import com.tridium.box.BoxOp;
import com.tridium.box.json.BoxWriter;
import com.tridium.json.JSONObject;
import com.tridium.nre.util.NiagaraFiles;
import com.tridium.sys.Nre;
import java.io.File;
import java.security.AccessController;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;
import javax.baja.units.UnitDatabase;

@NiagaraType
public class BUnitChannel
extends BBoxChannel {
    @Generated
    public static final Type TYPE = Sys.loadType(BUnitChannel.class);
    private static final long VERSION = 1L;
    private static final String UNITS_XML_PATH = BUnitChannel.getUnitsFilePath(NiagaraFiles.isNiagaraHomeReadonly()).replace('/', File.separatorChar);
    private static final File UNITS_XML_FILE = new File(Nre.niagaraHome, UNITS_XML_PATH);
    private static final String UNIT_CONVERSION_XML_PATH = BUnitChannel.getUnitConversionFilePath(NiagaraFiles.isNiagaraHomeReadonly()).replace('/', File.separatorChar);
    private static final File UNIT_CONVERSION_XML_FILE = new File(Nre.niagaraHome, UNIT_CONVERSION_XML_PATH);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    private static Long getOnlyIfModifiedSince(Object body) {
        JSONObject obj;
        if (body instanceof JSONObject && (obj = (JSONObject)body).has("ifModifiedSince")) {
            return obj.getLong("ifModifiedSince");
        }
        return null;
    }

    private static void writeQuantities(BoxWriter out, Context cx) {
        UnitDatabase unitDb = UnitDatabase.getDefault();
        UnitDatabase.Quantity[] quantities = unitDb.getQuantities();
        out.array();
        for (UnitDatabase.Quantity q : quantities) {
            out.object();
            out.key("n").value((Object)q.getName());
            out.key("d").value((Object)q.getDimension().encodeToString());
            out.key("u").array();
            for (BUnit unit : q.getUnits()) {
                out.object().key("n").value((Object)unit.getUnitName(cx)).key("s").value((Object)unit.getSymbol(cx)).key("d").value((Object)unit.getDimension().encodeToString()).key("sc").value(unit.getScale()).key("o").value(unit.getOffset()).key("p").value(unit.getIsPrefix()).endObject();
            }
            out.endArray();
            out.endObject();
        }
        out.endArray();
    }

    private static void writeUnitConversions(BoxWriter out) {
        out.array();
        for (BUnitConversion.Entry entry : BUnitConversion.getEntries()) {
            out.object().key("english").value((Object)entry.getEnglish().getUnitName()).key("metric").value((Object)entry.getMetric().getUnitName()).endObject();
        }
        out.endArray();
    }

    private static void writeUnitDatabase(Object body, BoxWriter out, Context cx) {
        Long modifiedSince = BUnitChannel.getOnlyIfModifiedSince(body);
        long buildTimestamp = BUnitChannel.getUnitDatabaseBuildTimestamp();
        if (modifiedSince != null && modifiedSince >= buildTimestamp) {
            BUnitChannel.writeUnitDatabaseBuildTimestamp(out);
            return;
        }
        out.object();
        out.key("buildTime").value(buildTimestamp);
        out.key("v").value(1L);
        out.key("db");
        BUnitChannel.writeQuantities(out, cx);
        out.key("cdb");
        BUnitChannel.writeUnitConversions(out);
        out.endObject();
    }

    private static long getUnitDatabaseBuildTimestamp() {
        return AccessController.doPrivileged(() -> Math.max(UNITS_XML_FILE.lastModified(), Math.max(UNIT_CONVERSION_XML_FILE.lastModified(), Sys.getRegistry().getLastBuildTime().getMillis())));
    }

    private static void writeUnitDatabaseBuildTimestamp(BoxWriter out) {
        out.object().key("buildTime").value(BUnitChannel.getUnitDatabaseBuildTimestamp()).endObject();
    }

    @Override
    public String getChannelName() {
        return "unit";
    }

    @Override
    public boolean service(String key, Object body, BoxWriter out, BoxOp op) {
        switch (key) {
            case "getUnitDatabase": {
                BUnitChannel.writeUnitDatabase(body, out, (Context)op);
                return true;
            }
            case "getUnitDatabaseBuildTime": {
                BUnitChannel.writeUnitDatabaseBuildTimestamp(out);
                return true;
            }
        }
        return false;
    }

    private static String getUnitsFilePath(boolean isNiagaraHomeReadonly) {
        return isNiagaraHomeReadonly ? "/etc/units.xml" : "/defaults/units.xml";
    }

    private static String getUnitConversionFilePath(boolean isNiagaraHomeReadonly) {
        return isNiagaraHomeReadonly ? "/etc/unitConversion.xml" : "/defaults/unitConversion.xml";
    }
}

