/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BBoxChannel;
import com.tridium.box.BOrdChannel;
import com.tridium.box.BoxOp;
import com.tridium.box.json.BoxWriter;
import com.tridium.box.util.DeleteRecord;
import com.tridium.box.util.PasteRecord;
import com.tridium.box.util.UndoableRecord;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.sys.transfer.CompToComp;
import java.io.IOException;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.Mark;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.LexiconModule;

@NiagaraType
public class BTransferChannel
extends BBoxChannel {
    @Generated
    public static final Type TYPE = Sys.loadType(BTransferChannel.class);
    private static final String COMPUTE_ORIGIN = "compute";
    private static final String CHANNEL_NAME = "transfer";
    private static final String DELETES_PROP = "deletes";
    private static final String KEEP_LINKS_PROP = "keepLinks";
    private static final String KEEP_RELATIONS_PROP = "keepRelations";
    private static final String NAMES_PROP = "names";
    private static final String NUM_COPIES_PROP = "numCopies";
    private static final String ORIGIN_PROP = "origin";
    private static final String SOURCES_PROP = "sources";
    private static final String SPACE_ORDS_PROP = "spaceOrds";
    private static final String TARGET_PROP = "target";
    private static final String UNDO_KEY_PROP = "undoKey";
    private static final int MIN_NUM_COPIES = 1;
    private static final int MAX_NUM_COPIES = 100;
    private static final LexiconModule LEX = LexiconModule.make((Type)TYPE);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean service(String key, Object body, BoxWriter out, BoxOp op) throws Exception {
        switch (key) {
            case "copy": {
                BTransferChannel.doTransfer((JSONObject)body, out, false, op);
                return true;
            }
            case "move": {
                BTransferChannel.doTransfer((JSONObject)body, out, true, op);
                return true;
            }
            case "delete": {
                BTransferChannel.doDelete((JSONObject)body, out, op);
                return true;
            }
            case "undo": {
                BTransferChannel.undoTransfer((String)body, out, op);
                return true;
            }
        }
        return false;
    }

    private static void doTransfer(JSONObject body, BoxWriter out, boolean move, BoxOp op) throws Exception {
        int numCopies;
        JSONArray sources = body.getJSONArray(SOURCES_PROP);
        JSONObject targetObj = body.getJSONObject(TARGET_PROP);
        int n = numCopies = body.has(NUM_COPIES_PROP) ? body.getInt(NUM_COPIES_PROP) : 1;
        if (numCopies < 1 || numCopies > 100) {
            throw new IllegalArgumentException(LEX.getText("transfer.invalidNumCopies", (Context)op, new Object[]{1, 100}));
        }
        String[] names = null;
        if (body.has(NAMES_PROP)) {
            JSONArray arr = body.getJSONArray(NAMES_PROP);
            if (arr.length() != sources.length()) {
                throw new JSONException("different number of sources and names");
            }
            names = new String[arr.length()];
            for (int i = 0; i < names.length; ++i) {
                names[i] = JSONUtil.getString((JSONArray)arr, (int)i);
            }
        }
        BObject[] sourceObjects = BTransferChannel.resolveOrdsFromJson(sources, (Context)op);
        OrdTarget target = BOrdChannel.resolveOrd(targetObj, (Context)op);
        BObject targetObject = target.get();
        Mark mark = names == null ? new Mark(sourceObjects) : new Mark(sourceObjects, names);
        BComponent params = BTransferChannel.copyParams(body, mark);
        out.object();
        PasteRecord record = move ? PasteRecord.move(mark, targetObject, params, out, op) : PasteRecord.copy(mark, targetObject, params, numCopies, out, op);
        BTransferChannel.writeUndoKeyToObject(record, out);
        BTransferChannel.writeSpaceOrdsToObject(record, out);
        UndoableRecord.put(record, op);
        out.endObject();
    }

    private static void doDelete(JSONObject body, BoxWriter out, BoxOp op) throws IOException {
        JSONArray deletes = body.getJSONArray(DELETES_PROP);
        BObject[] toDelete = BTransferChannel.resolveOrdsFromJson(deletes, (Context)op);
        Mark mark = new Mark(toDelete);
        if (!mark.areAllValuesComponents()) {
            throw new IllegalArgumentException("Nav nodes to delete must be all components");
        }
        out.object();
        DeleteRecord record = DeleteRecord.deleteComponents(mark, op);
        BTransferChannel.writeUndoKeyToObject(record, out);
        BTransferChannel.writeSpaceOrdsToObject(record, out);
        UndoableRecord.put(record, op);
        out.endObject();
    }

    private static void undoTransfer(String recordId, BoxWriter out, BoxOp op) throws Exception {
        UndoableRecord record = UndoableRecord.get(recordId, op).orElseThrow(() -> new LocalizableException("box", "unknownTransferRecordKey", new Object[]{UndoableRecord.MAX_UNDO_HISTORY_SIZE}));
        out.object();
        record.undoTransfer(out);
        BTransferChannel.writeSpaceOrdsToObject(record, out);
        out.endObject();
        UndoableRecord.del(recordId, op);
    }

    private static void writeUndoKeyToObject(UndoableRecord record, BoxWriter out) {
        out.key(UNDO_KEY_PROP).value((Object)record.getId());
    }

    private static void writeSpaceOrdsToObject(UndoableRecord record, BoxWriter out) {
        out.key(SPACE_ORDS_PROP).array();
        for (String ord : record.getAffectedSpaceOrds()) {
            out.value(ord);
        }
        out.endArray();
    }

    private static BComponent copyParams(JSONObject body, Mark mark) throws IOException {
        boolean keepLinks = body.has(KEEP_LINKS_PROP) && body.getBoolean(KEEP_LINKS_PROP);
        boolean keepRelations = body.has(KEEP_RELATIONS_PROP) && body.getBoolean(KEEP_RELATIONS_PROP);
        String origin = body.has(ORIGIN_PROP) ? JSONUtil.getString((JSONObject)body, (String)ORIGIN_PROP) : null;
        BComponent params = new BComponent();
        if (keepLinks) {
            params.add("keepAllLinks", (BValue)BBoolean.TRUE);
        }
        if (keepRelations) {
            params.add("keepAllRelations", (BValue)BBoolean.TRUE);
        }
        if (origin != null) {
            params.add(ORIGIN_PROP, (BValue)BTransferChannel.parseOrigin(origin, mark));
        }
        return params;
    }

    private static BWsAnnotation parseOrigin(String origin, Mark mark) throws IOException {
        if (COMPUTE_ORIGIN.equals(origin)) {
            BWsAnnotation anno = CompToComp.computeOrigin((BObject[])mark.getValues(), (int)mark.size());
            return anno.translate(1, 1);
        }
        return (BWsAnnotation)BWsAnnotation.DEFAULT.decodeFromString(origin);
    }

    @Override
    public String getChannelName() {
        return CHANNEL_NAME;
    }

    private static BObject[] resolveOrdsFromJson(JSONArray ordObjects, Context cx) {
        int len = ordObjects.length();
        BObject[] toDelete = new BObject[len];
        for (int i = 0; i < len; ++i) {
            OrdTarget target = BOrdChannel.resolveOrd(ordObjects.getJSONObject(i), cx);
            toDelete[i] = target.get();
        }
        return toDelete;
    }
}

