/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BBoxChannel;
import com.tridium.box.BBoxRecordType;
import com.tridium.box.BBoxService;
import com.tridium.box.BServerSessionChannel;
import com.tridium.box.BServerSessionHandler;
import com.tridium.box.BoxOp;
import com.tridium.box.BoxWebSocketServlet;
import com.tridium.box.BoxWsHttpSessionListener;
import com.tridium.box.IBoxEventHandler;
import com.tridium.box.json.BoxWriter;
import com.tridium.box.mux.BoxEnvelope;
import com.tridium.box.mux.BoxEnvelopeDemux;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.function.ConsumerCanThrowException;
import javax.baja.nre.function.RunnableCanThrowException;
import javax.baja.nre.function.SupplierCanThrowException;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.web.WebOp;
import javax.servlet.http.HttpSession;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="userName", type="String", defaultValue="", flags=65), @NiagaraProperty(name="created", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=65), @NiagaraProperty(name="lastPollChanges", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=65)})
@NiagaraActions(value={@NiagaraAction(name="renew", flags=20), @NiagaraAction(name="expire", flags=20)})
public final class BServerSession
extends BComponent {
    @Generated
    public static final Property userName = BServerSession.newProperty((int)65, (String)"", null);
    @Generated
    public static final Property created = BServerSession.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property lastPollChanges = BServerSession.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Action renew = BServerSession.newAction((int)20, null);
    @Generated
    public static final Action expire = BServerSession.newAction((int)20, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BServerSession.class);
    private long lastRenewTime;
    private long renewCount;
    private Clock.Ticket expireTicket = Clock.expiredTicket;
    public static final String KEY = "serverSession";
    private static final Logger log = Logger.getLogger("box.serverSession");
    private static final int POLL_INTERVAL = Math.max(AccessController.doPrivileged(() -> Integer.getInteger("box.serverSessionPollInterval", 2000)), 0);
    private static final BRelTime serverSessionExpiryTime = BRelTime.make((long)AccessController.doPrivileged(() -> Integer.getInteger("box.serverSessionExpiryTime", 90000)).intValue());
    private volatile IBoxEventHandler eventHandler;
    private BrokerPoller brokerPoller;
    private final Object brokerMonitor = new Object();
    private volatile boolean hasNewEvent;
    private BoxEnvelopeDemux demux;
    private long envelopeCounter;
    private final Map<String, Object> sessionMap = new HashMap<String, Object>();
    private final String id;
    private HttpSession httpSession;
    private static final int CORE_POOL_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("box.serverSession.corePoolSize", 2));
    private static final int MAX_THREADS = AccessController.doPrivileged(() -> Integer.getInteger("box.serverSession.maxThreads", Integer.MAX_VALUE));
    private static final int KEEP_ALIVE_SECONDS = AccessController.doPrivileged(() -> Integer.getInteger("box.serverSession.keepAliveSeconds", 60));
    private static int threadCounter = 0;

    @Generated
    public String getUserName() {
        return this.getString(userName);
    }

    @Generated
    public void setUserName(String v) {
        this.setString(userName, v, null);
    }

    @Generated
    public BAbsTime getCreated() {
        return (BAbsTime)this.get(created);
    }

    @Generated
    public void setCreated(BAbsTime v) {
        this.set(created, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastPollChanges() {
        return (BAbsTime)this.get(lastPollChanges);
    }

    @Generated
    public void setLastPollChanges(BAbsTime v) {
        this.set(lastPollChanges, (BValue)v, null);
    }

    @Generated
    public void renew() {
        this.invoke(renew, null, null);
    }

    @Generated
    public void expire() {
        this.invoke(expire, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BServerSession() {
        this("");
    }

    public BServerSession(String id) {
        this.id = id;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BServerSessionChannel;
    }

    public void started() throws Exception {
        this.getBoxService().incrementSessionCount();
        this.setCreated(BAbsTime.now());
        this.renew();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Server Session Started: " + this.toPathString());
        }
    }

    public void stopped() throws Exception {
        if (this.httpSession != null) {
            BoxWsHttpSessionListener.boxSessionExpired(this.httpSession);
            this.httpSession = null;
        }
        if (this.brokerPoller != null) {
            this.brokerPoller.stop();
            this.brokerPoller = null;
        }
        this.getBoxService().decrementSessionCount();
    }

    public boolean isNavChild() {
        return false;
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == renew) {
            ++this.renewCount;
        }
        return super.post(action, argument, cx);
    }

    public void pollChanges(BoxWriter out, BoxOp op) throws Exception {
        JSONArray resp;
        this.initEventHandler(op);
        this.renew();
        this.setLastPollChanges(BAbsTime.now());
        if (log.isLoggable(Level.FINE)) {
            log.fine("Server Session Poll Changes: " + this.toPathString());
        }
        out.value((resp = this.detachEvents(op)) == null ? new JSONArray() : resp);
    }

    private JSONArray detachEvents(BoxOp op) throws Exception {
        return (JSONArray)this.synchronizedOnEventBroker(() -> {
            this.hasNewEvent = false;
            BServerSessionHandler[] sessionComps = (BServerSessionHandler[])this.getChildren(BServerSessionHandler.class);
            JSONArray resp = null;
            for (BServerSessionHandler sessionComp : sessionComps) {
                Object events = sessionComp.detachEvents(op);
                if (events == null) continue;
                if (resp == null) {
                    resp = new JSONArray();
                }
                JSONObject obj = new JSONObject();
                obj.put("scid", (Object)SlotPath.unescape((String)sessionComp.getName()));
                obj.put("evs", events);
                resp.put((Object)obj);
            }
            return resp;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <E extends Exception> void synchronizedOnEventBroker(RunnableCanThrowException<E> runnable) throws E {
        Object object = this.brokerMonitor;
        synchronized (object) {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T, E extends Exception> T synchronizedOnEventBroker(SupplierCanThrowException<T, E> supplier) throws E {
        Object object = this.brokerMonitor;
        synchronized (object) {
            return (T)supplier.get();
        }
    }

    private void sendUnsolicitedEventsToClient(BoxOp op) {
        JSONArray events;
        this.hasNewEvent = false;
        boolean muxEnabled = this.eventHandler.isMuxEnabled();
        try {
            events = this.detachEvents(op);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error decoding events: " + this.toPathString(), e);
            return;
        }
        if (events != null) {
            byte[] data = BoxEnvelope.writeStrings((ConsumerCanThrowException<Writer, ? extends Exception>)((ConsumerCanThrowException)w -> {
                BoxWriter out = new BoxWriter((Writer)w);
                if (muxEnabled) {
                    out.array();
                }
                out.object().key("p").value((Object)"box").key("v").value((Object)"2.4").key("m").array().object().key("t").value((Object)"u").key("c").value((Object)"ssession").key("k").value((Object)"evs").key("b").object().key("id").value((Object)this.getId()).key("d").value((Object)events).endObject().endObject().endArray().endObject();
                if (muxEnabled) {
                    out.endArray();
                }
            }));
            BBoxService service = this.getBoxService();
            if (service.hasListeners()) {
                service.notifyListeners((Context)op, BBoxRecordType.unsolicited, data);
            }
            String serverSessionId = this.getId();
            if (muxEnabled) {
                BoxEnvelope env = BoxEnvelope.unsolicited(serverSessionId, this.envelopeCounter++, BoxWebSocketServlet.isBinary() ? BoxWebSocketServlet.MAX_BINARY_MESSAGE_SIZE : BoxWebSocketServlet.MAX_TEXT_MESSAGE_SIZE, BoxEnvelope.MAX_ENVELOPE_SIZE);
                env.append(data);
                env.writeBoxFragments(this.eventHandler, (Context)op);
            } else {
                this.eventHandler.writeBoxEvents(serverSessionId, data, (Context)op);
            }
        }
    }

    private static IBoxEventHandler getEventHandler(BoxOp op) {
        return (IBoxEventHandler)op.get("boxEventHandler");
    }

    private void initEventHandler(BoxOp op) {
        IBoxEventHandler handler = BServerSession.getEventHandler(op);
        if (handler != null && this.eventHandler == null && op.isVersion2OrGreater()) {
            this.synchronizedOnEventBroker(() -> {
                if (this.eventHandler == null) {
                    this.eventHandler = handler;
                    this.brokerPoller = new BrokerPoller(op);
                    this.brokerPoller.start();
                }
                return null;
            });
        }
    }

    private static void submitToThreadPool(Runnable r) {
        ThreadPoolHolder.threadPool.submit(r);
    }

    public void newEvents(BServerSessionHandler handler) {
        if (this.brokerPoller != null) {
            this.hasNewEvent = true;
            this.brokerPoller.newEvent();
        }
    }

    String getId() {
        return this.id;
    }

    public void init(BoxOp op) {
        WebOp webOp = op.getWebOp();
        if (webOp != null) {
            this.httpSession = webOp.getRequest().getSession();
        }
        this.setUserName(op.getUsername());
        this.initEventHandler(op);
        this.demux = new BoxEnvelopeDemux(this.getId(), BoxWebSocketServlet.isBinary() ? BoxWebSocketServlet.MAX_BINARY_MESSAGE_SIZE : BoxWebSocketServlet.MAX_TEXT_MESSAGE_SIZE, BoxEnvelope.MAX_ENVELOPE_SIZE, (ConsumerCanThrowException<BoxEnvelope, ? extends Exception>)((ConsumerCanThrowException)this::envelopeComplete));
    }

    public void makeServerSessionHandler(JSONObject body, BoxWriter out, BoxOp op) throws Exception {
        Object resp;
        this.initEventHandler(op);
        String scid = SlotPath.escape((String)JSONUtil.getString((JSONObject)body, (String)"scid"));
        Type type = Sys.getType((String)JSONUtil.getString((JSONObject)body, (String)"scts"));
        Object arg = body.get("scarg");
        BServerSessionHandler handler = (BServerSessionHandler)type.getInstance();
        Property prop = this.add(scid, (BValue)handler, 3);
        try {
            resp = handler.init(arg, op);
        }
        catch (Exception e) {
            this.remove(prop);
            throw e;
        }
        out.value(resp);
    }

    public void removeServerSessionHandler(JSONObject body, BoxOp op) throws Exception {
        this.initEventHandler(op);
        String scid = SlotPath.escape((String)JSONUtil.getString((JSONObject)body, (String)"scid"));
        this.remove(scid);
    }

    public void service(JSONObject body, BoxWriter out, BoxOp op) throws Exception {
        BServerSessionHandler handler;
        this.initEventHandler(op);
        String scid = SlotPath.escape((String)JSONUtil.getString((JSONObject)body, (String)"scid"));
        String sckey = JSONUtil.getString((JSONObject)body, (String)"sck").intern();
        Object arg = null;
        if (body.has("scarg")) {
            arg = body.get("scarg");
        }
        if ((handler = (BServerSessionHandler)this.get(scid)) == null) {
            throw new Exception("Could not find Server Session Handler: " + scid);
        }
        boolean handled = handler.service(sckey, arg, out, op);
        if (!handled) {
            throw new Exception("Unsupported Key: " + sckey + " for Server Session Handler: " + scid);
        }
    }

    public void handleFragment(long envelopeId, int fragmentCount, int fragmentIndex, byte[] payload, BoxOp op) {
        this.demux.receiveFragment(envelopeId, fragmentCount, fragmentIndex, payload, op);
    }

    private void envelopeComplete(BoxEnvelope envelope) throws Exception {
        BoxOp op = envelope.getOp();
        IBoxEventHandler eventHandler = BServerSession.getEventHandler(op);
        if (eventHandler == null) {
            throw new IllegalStateException("no event handler present");
        }
        envelope.respond(this.getBoxService(), eventHandler, (Context)op);
    }

    public void doRenew() {
        this.expireTicket.cancel();
        if (this.isRunning()) {
            this.expireTicket = Clock.schedule((BComponent)this, (BRelTime)serverSessionExpiryTime, (Action)expire, null);
        }
        this.lastRenewTime = System.currentTimeMillis();
    }

    public void doExpire() {
        String pathString;
        boolean isFine = log.isLoggable(Level.FINE);
        String string = pathString = isFine ? this.toPathString() : null;
        if (isFine) {
            log.fine("Server Session expired: " + pathString);
        }
        this.expireTicket.cancel();
        BServerSession.submitToThreadPool(() -> {
            BBoxService service = this.getBoxService();
            if (service.hasListeners()) {
                service.notifyListeners((Context)BFacets.DEFAULT, BBoxRecordType.status, ("Server Session Expired: " + pathString).getBytes(StandardCharsets.UTF_8));
            }
            ((BComponent)this.getParent()).remove((BComplex)this);
            if (isFine) {
                log.fine("Server Session removed: " + pathString);
            }
        });
    }

    public long getRenewCount() {
        return this.renewCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String key) {
        Map<String, Object> map = this.sessionMap;
        synchronized (map) {
            return this.sessionMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setAttribute(String key, Object value) {
        Map<String, Object> map = this.sessionMap;
        synchronized (map) {
            this.sessionMap.put(key, value);
        }
    }

    private BBoxService getBoxService() {
        return ((BBoxChannel)this.getParent()).getBoxService();
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Server Session");
        out.prop((Object)"Last renew time", (Object)(this.lastRenewTime <= 0L ? "n/a" : BAbsTime.make((long)this.lastRenewTime).toString((Context)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE))));
        out.endProps();
        super.spy(out);
    }

    private static interface ThreadPoolHolder {
        public static final ExecutorService threadPool = ThreadPoolHolder.makeThreadPool();

        public static ExecutorService makeThreadPool() {
            return new ThreadPoolExecutor(CORE_POOL_SIZE, MAX_THREADS, (long)KEEP_ALIVE_SECONDS, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), r -> {
                Thread t = new Thread(r, "BServerSession.BrokerPoller" + threadCounter++);
                t.setDaemon(true);
                return t;
            });
        }
    }

    private class BrokerPoller
    implements Runnable {
        private final BoxOp originatingOp;
        private final Object newEventsMonitor = new Object();
        private volatile boolean activelyPollingForEvents = true;

        private BrokerPoller(BoxOp originatingOp) {
            this.originatingOp = originatingOp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (this.activelyPollingForEvents) {
                    Object object = this.newEventsMonitor;
                    synchronized (object) {
                        if (!BServerSession.this.hasNewEvent) {
                            this.newEventsMonitor.wait();
                        }
                    }
                    if (BServerSession.this.eventHandler.isClosed()) {
                        BServerSession.this.eventHandler = null;
                        this.activelyPollingForEvents = false;
                        continue;
                    }
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!BServerSession.this.hasNewEvent) continue;
                    BServerSession.this.sendUnsolicitedEventsToClient(this.originatingOp);
                    try {
                        Thread.sleep(POLL_INTERVAL);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Exception processing unsolicited BOX message", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void newEvent() {
            Object object = this.newEventsMonitor;
            synchronized (object) {
                this.newEventsMonitor.notifyAll();
            }
        }

        private void start() {
            BServerSession.submitToThreadPool(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stop() {
            this.activelyPollingForEvents = false;
            Object object = this.newEventsMonitor;
            synchronized (object) {
                this.newEventsMonitor.notifyAll();
            }
        }
    }
}

