/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BBoxService;
import com.tridium.box.IBoxEventHandler;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.fox.sys.FoxHttpsSocket;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.baja.fox.FoxConnectionTypeEnum;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.net.ssl.SSLSocket;

@NiagaraType
public final class BFoxBoxChannel
extends BFoxChannel {
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxBoxChannel.class);
    public static final String channel = "box";
    private static final String sendBox = "send";
    private static final String sendUnsolicited = "sendUnsolicited";
    private final FoxBoxEventHandler eventHandler = new FoxBoxEventHandler();
    private final Map<String, Consumer<String>> unsolicitedListeners = new HashMap<String, Consumer<String>>();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFoxBoxChannel() {
        super(channel);
    }

    public FoxResponse process(FoxRequest req) throws Throwable {
        if (req.command == sendBox) {
            return this.sendBox(req);
        }
        if (req.command == sendUnsolicited) {
            return this.sendUnsolicited(req);
        }
        return null;
    }

    public String sendBox(String data) throws Exception {
        FoxRequest req = this.makeRequest(sendBox);
        req.add("d", data);
        if (this.isTraceOn()) {
            this.trace("c:send");
            req.dump();
        }
        FoxResponse resp = this.sendSync(req);
        return resp.getString("d");
    }

    private FoxResponse sendBox(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        String data = req.getString("d");
        FoxSession session = this.getServerConnection().session();
        int port = session.getRemotePort();
        String remoteAddr = session.getRemoteHost();
        FoxConnectionTypeEnum foxConnectionType = FoxConnectionTypeEnum.FOX;
        if (session.getSocket() instanceof SSLSocket) {
            foxConnectionType = FoxConnectionTypeEnum.FOXS;
        } else if (session.getSocket() instanceof FoxHttpsSocket) {
            foxConnectionType = FoxConnectionTypeEnum.FOXWSS;
        }
        BBoxService service = (BBoxService)Sys.getService((Type)BBoxService.TYPE);
        String respData = service.getFoxAcceptor().newMessage(data, remoteAddr, port, foxConnectionType, this.eventHandler, this.getSessionContext());
        resp.add("d", respData);
        if (this.isTraceOn()) {
            this.trace("s:send");
            resp.dump();
        }
        return resp;
    }

    public void sendUnsolicited(String serverSessionId, byte[] data) {
        try {
            FoxRequest req = this.makeRequest(sendUnsolicited);
            req.add("s", serverSessionId);
            req.add("f", new String(data, StandardCharsets.UTF_8));
            if (this.isTraceOn()) {
                this.trace("s:sendUnsolicited");
                req.dump();
            }
            this.sendAsync(req);
        }
        catch (Exception e) {
            this.log.error("Error sending Fox Box Unsolicited messages", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FoxResponse sendUnsolicited(FoxRequest req) throws IOException {
        Consumer<String> listener;
        String serverSessionId = req.getString("s");
        String boxFrame = req.getString("f");
        Map<String, Consumer<String>> map = this.unsolicitedListeners;
        synchronized (map) {
            listener = this.unsolicitedListeners.get(serverSessionId);
        }
        if (listener != null) {
            listener.accept(boxFrame);
        }
        if (this.isTraceOn()) {
            this.trace("c:sendUnsolicited");
        }
        return new FoxResponse(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerUnsolicitedListener(String serverSessionId, Consumer<String> listener) {
        Map<String, Consumer<String>> map = this.unsolicitedListeners;
        synchronized (map) {
            this.unsolicitedListeners.put(serverSessionId, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterUnsolicitedListener(String serverSessionId) {
        Map<String, Consumer<String>> map = this.unsolicitedListeners;
        synchronized (map) {
            this.unsolicitedListeners.remove(serverSessionId);
        }
    }

    private final class FoxBoxEventHandler
    implements IBoxEventHandler {
        private FoxBoxEventHandler() {
        }

        @Override
        public void writeBoxEvents(String serverSessionId, byte[] data, Context cx) {
            BFoxBoxChannel.this.sendUnsolicited(serverSessionId, data);
        }

        @Override
        public boolean isClosed() {
            BFoxServerConnection conn = BFoxBoxChannel.this.getServerConnection();
            return conn != null ? !conn.isConnected() : true;
        }

        @Override
        public boolean isMuxEnabled() {
            return false;
        }
    }
}

