/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxMonnitDriver.sensor;

import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxMonnitDriver.BOnyxxMonnitIntervalDevice;
import com.lynxspring.onyxxMonnitDriver.BOnyxxMonnitNetwork;
import com.lynxspring.onyxxMonnitDriver.enums.BOnyxxMonnitSensorTypeEnum;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="assessmentsPerHeartbeatReported", type="int", defaultValue="1", flags=1), @NiagaraProperty(name="assessmentsPerHeartbeatSet", type="int", defaultValue="1", facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="250")}), @NiagaraProperty(name="awareStateLowerLimitReported", type="float", defaultValue="-250", facets={@Facet(value="BFacets.make(\"precision\", BInteger.make(1))"), @Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"celsius\")")}, flags=1), @NiagaraProperty(name="awareStateLowerLimitSet", type="float", defaultValue="-250", facets={@Facet(name="BFacets.MIN", value="-100"), @Facet(name="BFacets.MAX", value="400"), @Facet(value="BFacets.make(\"precision\", BInteger.make(1))"), @Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"celsius\")")}), @NiagaraProperty(name="awareStateUpperLimitReported", type="float", defaultValue="250", facets={@Facet(value="BFacets.make(\"precision\", BInteger.make(1))"), @Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"celsius\")")}, flags=1), @NiagaraProperty(name="awareStateUpperLimitSet", type="float", defaultValue="250", facets={@Facet(name="BFacets.MIN", value="-100"), @Facet(name="BFacets.MAX", value="400"), @Facet(value="BFacets.make(\"precision\", BInteger.make(1))"), @Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"celsius\")")}), @NiagaraProperty(name="awareStateBufferReported", type="float", defaultValue="0", facets={@Facet(value="BFacets.make(\"precision\", BInteger.make(1))"), @Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"celsius\")")}, flags=1), @NiagaraProperty(name="awareStateBufferSet", type="float", defaultValue="0", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="155"), @Facet(value="BFacets.make(\"precision\", BInteger.make(1))"), @Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"celsius\")")}), @NiagaraProperty(name="calibrationValueReported", type="float", defaultValue="0", facets={@Facet(value="BFacets.make(\"precision\", BInteger.make(1))"), @Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"celsius\")")}, flags=5), @NiagaraProperty(name="calibrationValueSet", type="float", defaultValue="0", facets={@Facet(name="BFacets.MIN", value="-10"), @Facet(name="BFacets.MAX", value="10"), @Facet(value="BFacets.make(\"precision\", BInteger.make(1))"), @Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"celsius\")")}, flags=4)})
public class BOnyxxMonnitThermocoupleDevice
extends BOnyxxMonnitIntervalDevice {
    public static final Property assessmentsPerHeartbeatReported = BOnyxxMonnitThermocoupleDevice.newProperty((int)1, (int)1, null);
    public static final Property assessmentsPerHeartbeatSet = BOnyxxMonnitThermocoupleDevice.newProperty((int)0, (int)1, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)250)));
    public static final Property awareStateLowerLimitReported = BOnyxxMonnitThermocoupleDevice.newProperty((int)1, (int)-250, (BFacets)BFacets.make((BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)1)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"celsius"))));
    public static final Property awareStateLowerLimitSet = BOnyxxMonnitThermocoupleDevice.newProperty((int)0, (int)-250, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)-100), (BFacets)BFacets.make((String)"max", (int)400)), (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)1))), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"celsius"))));
    public static final Property awareStateUpperLimitReported = BOnyxxMonnitThermocoupleDevice.newProperty((int)1, (int)250, (BFacets)BFacets.make((BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)1)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"celsius"))));
    public static final Property awareStateUpperLimitSet = BOnyxxMonnitThermocoupleDevice.newProperty((int)0, (int)250, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)-100), (BFacets)BFacets.make((String)"max", (int)400)), (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)1))), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"celsius"))));
    public static final Property awareStateBufferReported = BOnyxxMonnitThermocoupleDevice.newProperty((int)1, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)1)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"celsius"))));
    public static final Property awareStateBufferSet = BOnyxxMonnitThermocoupleDevice.newProperty((int)0, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)155)), (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)1))), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"celsius"))));
    public static final Property calibrationValueReported = BOnyxxMonnitThermocoupleDevice.newProperty((int)5, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)1)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"celsius"))));
    public static final Property calibrationValueSet = BOnyxxMonnitThermocoupleDevice.newProperty((int)4, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)-10), (BFacets)BFacets.make((String)"max", (int)10)), (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)1))), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"celsius"))));
    public static final Type TYPE = Sys.loadType(BOnyxxMonnitThermocoupleDevice.class);
    public static Log LOG = Log.getLog((String)Sys.getModuleForClass(BOnyxxMonnitNetwork.class).getModuleName());
    private static String ASSESSMENTS_REPORTED_FILE = "assessments_per_heartbeat_reported";
    private static String ASSESSMENTS_SET_FILE = "assessments_per_heartbeat_set";
    private static String AWARE_STATE_LOWER_LIMIT_REPORTED_FILE = "minimum_aware_threshold_reported";
    private static String AWARE_STATE_LOWER_LIMIT_SET_FILE = "minimum_aware_threshold_set";
    private static String AWARE_STATE_UPPER_LIMIT_REPORTED_FILE = "maximum_aware_threshold_reported";
    private static String AWARE_STATE_UPPER_LIMIT_SET_FILE = "maximum_aware_threshold_set";
    private static String AWARE_STATE_BUFFER_REPORTED_FILE = "hysteresis_reported";
    private static String AWARE_STATE_BUFFER_SET_FILE = "hysteresis_set";
    private static String AWARE_STATE_SYNCHRONIZE_REPORTED_FILE = "synchronization_mask_reported";
    private static String AWARE_STATE_SYNCHRONIZE_SET_FILE = "synchronization_mask_set";
    private static String CALIBRATION_VALUE_REPORTED_FILE = "calibration_offset_reported";
    private static String CALIBRATION_VALUE_SET_FILE = "calibration_offset_set";

    public int getAssessmentsPerHeartbeatReported() {
        return this.getInt(assessmentsPerHeartbeatReported);
    }

    public void setAssessmentsPerHeartbeatReported(int v) {
        this.setInt(assessmentsPerHeartbeatReported, v, null);
    }

    public int getAssessmentsPerHeartbeatSet() {
        return this.getInt(assessmentsPerHeartbeatSet);
    }

    public void setAssessmentsPerHeartbeatSet(int v) {
        this.setInt(assessmentsPerHeartbeatSet, v, null);
    }

    public float getAwareStateLowerLimitReported() {
        return this.getFloat(awareStateLowerLimitReported);
    }

    public void setAwareStateLowerLimitReported(float v) {
        this.setFloat(awareStateLowerLimitReported, v, null);
    }

    public float getAwareStateLowerLimitSet() {
        return this.getFloat(awareStateLowerLimitSet);
    }

    public void setAwareStateLowerLimitSet(float v) {
        this.setFloat(awareStateLowerLimitSet, v, null);
    }

    public float getAwareStateUpperLimitReported() {
        return this.getFloat(awareStateUpperLimitReported);
    }

    public void setAwareStateUpperLimitReported(float v) {
        this.setFloat(awareStateUpperLimitReported, v, null);
    }

    public float getAwareStateUpperLimitSet() {
        return this.getFloat(awareStateUpperLimitSet);
    }

    public void setAwareStateUpperLimitSet(float v) {
        this.setFloat(awareStateUpperLimitSet, v, null);
    }

    public float getAwareStateBufferReported() {
        return this.getFloat(awareStateBufferReported);
    }

    public void setAwareStateBufferReported(float v) {
        this.setFloat(awareStateBufferReported, v, null);
    }

    public float getAwareStateBufferSet() {
        return this.getFloat(awareStateBufferSet);
    }

    public void setAwareStateBufferSet(float v) {
        this.setFloat(awareStateBufferSet, v, null);
    }

    public float getCalibrationValueReported() {
        return this.getFloat(calibrationValueReported);
    }

    public void setCalibrationValueReported(float v) {
        this.setFloat(calibrationValueReported, v, null);
    }

    public float getCalibrationValueSet() {
        return this.getFloat(calibrationValueSet);
    }

    public void setCalibrationValueSet(float v) {
        this.setFloat(calibrationValueSet, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        String CONFIG_DIR_PATH = this.getFullDevicePath() + "config/";
        String fileName = null;
        Property prop = null;
        String textValue = null;
        super.started();
        this.setExpectedSensorType(BOnyxxMonnitSensorTypeEnum.thermocouple);
        try {
            prop = assessmentsPerHeartbeatSet;
            fileName = ASSESSMENTS_SET_FILE;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, "", false);
            if (this.getAssessmentsPerHeartbeatSet() != new Integer(textValue).intValue()) {
                OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, Integer.toString(this.getAssessmentsPerHeartbeatSet()), true);
            }
            prop = awareStateLowerLimitSet;
            fileName = AWARE_STATE_LOWER_LIMIT_SET_FILE;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, "", false);
            if (this.getAwareStateLowerLimitSet() != new Float(textValue).floatValue()) {
                OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, String.format("%.1f", Float.valueOf(this.getAwareStateLowerLimitSet())), true);
            }
            prop = awareStateUpperLimitSet;
            fileName = AWARE_STATE_UPPER_LIMIT_SET_FILE;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, "", false);
            if (this.getAwareStateUpperLimitSet() != new Float(textValue).floatValue()) {
                OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, String.format("%.1f", Float.valueOf(this.getAwareStateUpperLimitSet())), true);
            }
            prop = awareStateBufferSet;
            fileName = AWARE_STATE_BUFFER_SET_FILE;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, "", false);
            if (this.getAwareStateBufferSet() != new Float(textValue).floatValue()) {
                OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, String.format("%.1f", Float.valueOf(this.getAwareStateBufferSet())), true);
            }
            prop = calibrationValueSet;
            fileName = CALIBRATION_VALUE_SET_FILE;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, "", false);
            if (this.getCalibrationValueSet() != new Float(textValue).floatValue()) {
                OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, String.format("%.1f", Float.valueOf(this.getCalibrationValueSet())), true);
            }
        }
        catch (Exception e) {
            BOnyxxMonnitNetwork.COMM_LOG.error("Error when accessing file for " + prop.getName() + ": ", (Throwable)e);
            this.configFail("Error when accessing file for " + prop.getName() + ": " + e);
            return;
        }
    }

    @Override
    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (this.isRunning()) {
            String CONFIG_DIR_PATH = this.getFullDevicePath() + "config/";
            try {
                if (prop == assessmentsPerHeartbeatSet) {
                    OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, ASSESSMENTS_SET_FILE, Integer.toString(this.getAssessmentsPerHeartbeatSet()), true);
                } else if (prop == awareStateLowerLimitSet) {
                    OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, AWARE_STATE_LOWER_LIMIT_SET_FILE, String.format("%.1f", Float.valueOf(this.getAwareStateLowerLimitSet())), true);
                } else if (prop == awareStateUpperLimitSet) {
                    OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, AWARE_STATE_UPPER_LIMIT_SET_FILE, String.format("%.1f", Float.valueOf(this.getAwareStateUpperLimitSet())), true);
                } else if (prop == awareStateBufferSet) {
                    OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, AWARE_STATE_BUFFER_SET_FILE, String.format("%.1f", Float.valueOf(this.getAwareStateBufferSet())), true);
                } else if (prop == calibrationValueSet) {
                    OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, CALIBRATION_VALUE_SET_FILE, String.format("%.1f", Float.valueOf(this.getCalibrationValueSet())), true);
                }
            }
            catch (Exception e) {
                BOnyxxMonnitNetwork.COMM_LOG.error("Error when accessing file for " + prop.getName() + ": ", (Throwable)e);
                this.configFail("Error when accessing file for " + prop.getName() + ": " + e);
                return;
            }
        }
    }

    @Override
    protected boolean pingUniqueProperties(boolean readSetValues) {
        String CONFIG_DIR_PATH = this.getFullDevicePath() + "config/";
        Property prop = null;
        String textValue = null;
        if (!super.pingUniqueProperties(readSetValues)) {
            return false;
        }
        try {
            prop = assessmentsPerHeartbeatReported;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, ASSESSMENTS_REPORTED_FILE, "", false);
            this.setAssessmentsPerHeartbeatReported(new Integer(textValue));
            prop = awareStateLowerLimitReported;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, AWARE_STATE_LOWER_LIMIT_REPORTED_FILE, "", false);
            this.setAwareStateLowerLimitReported(new Float(textValue).floatValue());
            prop = awareStateUpperLimitReported;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, AWARE_STATE_UPPER_LIMIT_REPORTED_FILE, "", false);
            this.setAwareStateUpperLimitReported(new Float(textValue).floatValue());
            prop = awareStateBufferReported;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, AWARE_STATE_BUFFER_REPORTED_FILE, "", false);
            this.setAwareStateBufferReported(new Float(textValue).floatValue());
            prop = calibrationValueReported;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, CALIBRATION_VALUE_REPORTED_FILE, "", false);
            this.setCalibrationValueReported(new Float(textValue).floatValue());
            if (readSetValues) {
                prop = assessmentsPerHeartbeatSet;
                textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, ASSESSMENTS_SET_FILE, "", false);
                this.setAssessmentsPerHeartbeatSet(new Integer(textValue));
                prop = awareStateLowerLimitSet;
                textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, AWARE_STATE_LOWER_LIMIT_SET_FILE, "", false);
                this.setAwareStateLowerLimitSet(new Float(textValue).floatValue());
                prop = awareStateUpperLimitSet;
                textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, AWARE_STATE_UPPER_LIMIT_SET_FILE, "", false);
                this.setAwareStateUpperLimitSet(new Float(textValue).floatValue());
                prop = awareStateBufferSet;
                textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, AWARE_STATE_BUFFER_SET_FILE, "", false);
                this.setAwareStateBufferSet(new Float(textValue).floatValue());
                prop = calibrationValueSet;
                textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, CALIBRATION_VALUE_SET_FILE, "", false);
                this.setCalibrationValueSet(new Float(textValue).floatValue());
            }
        }
        catch (Exception e) {
            BOnyxxMonnitNetwork.COMM_LOG.error("Error when reading file for " + prop.getName() + ": ", (Throwable)e);
            this.configFail("Error when reading file for " + prop.getName() + ": " + e);
            return false;
        }
        return true;
    }
}

