/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxMonnitDriver.sensor;

import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxMonnitDriver.BOnyxxMonnitIntervalDevice;
import com.lynxspring.onyxxMonnitDriver.BOnyxxMonnitNetwork;
import com.lynxspring.onyxxMonnitDriver.enums.BOnyxxMonnitEdgeDetectionEnum;
import com.lynxspring.onyxxMonnitDriver.enums.BOnyxxMonnitPulseFilterEnum;
import com.lynxspring.onyxxMonnitDriver.enums.BOnyxxMonnitSensorTypeEnum;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="overflowCountReported", type="BLong", defaultValue="BLong.make(1L)", flags=1), @NiagaraProperty(name="overflowCountSet", type="BLong", defaultValue="BLong.make(1L)", facets={@Facet(name="BFacets.MIN", value="1L"), @Facet(name="BFacets.MAX", value="4294967295L")}), @NiagaraProperty(name="awareStateOverflowCountReported", type="BLong", defaultValue="BLong.make(1L)", flags=1), @NiagaraProperty(name="awareStateOverflowCountSet", type="BLong", defaultValue="BLong.make(1L)", facets={@Facet(name="BFacets.MIN", value="1L"), @Facet(name="BFacets.MAX", value="4294967295L")}), @NiagaraProperty(name="accumulateReported", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="accumulateSet", type="boolean", defaultValue="false"), @NiagaraProperty(name="pulseEdgeDetectionReported", type="BOnyxxMonnitEdgeDetectionEnum", defaultValue="BOnyxxMonnitEdgeDetectionEnum.positiveEdge", flags=1), @NiagaraProperty(name="pulseEdgeDetectionSet", type="BOnyxxMonnitEdgeDetectionEnum", defaultValue="BOnyxxMonnitEdgeDetectionEnum.positiveEdge"), @NiagaraProperty(name="filterReported", type="BOnyxxMonnitPulseFilterEnum", defaultValue="BOnyxxMonnitPulseFilterEnum.none", flags=1), @NiagaraProperty(name="filterSet", type="BOnyxxMonnitPulseFilterEnum", defaultValue="BOnyxxMonnitPulseFilterEnum.none")})
public class BOnyxxMonnitPulseCounterDevice
extends BOnyxxMonnitIntervalDevice {
    public static final Property overflowCountReported = BOnyxxMonnitPulseCounterDevice.newProperty((int)1, (long)BLong.make((long)1L).getLong(), null);
    public static final Property overflowCountSet = BOnyxxMonnitPulseCounterDevice.newProperty((int)0, (long)BLong.make((long)1L).getLong(), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (long)1L), (BFacets)BFacets.make((String)"max", (long)0xFFFFFFFFL)));
    public static final Property awareStateOverflowCountReported = BOnyxxMonnitPulseCounterDevice.newProperty((int)1, (long)BLong.make((long)1L).getLong(), null);
    public static final Property awareStateOverflowCountSet = BOnyxxMonnitPulseCounterDevice.newProperty((int)0, (long)BLong.make((long)1L).getLong(), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (long)1L), (BFacets)BFacets.make((String)"max", (long)0xFFFFFFFFL)));
    public static final Property accumulateReported = BOnyxxMonnitPulseCounterDevice.newProperty((int)1, (boolean)false, null);
    public static final Property accumulateSet = BOnyxxMonnitPulseCounterDevice.newProperty((int)0, (boolean)false, null);
    public static final Property pulseEdgeDetectionReported = BOnyxxMonnitPulseCounterDevice.newProperty((int)1, (BValue)BOnyxxMonnitEdgeDetectionEnum.positiveEdge, null);
    public static final Property pulseEdgeDetectionSet = BOnyxxMonnitPulseCounterDevice.newProperty((int)0, (BValue)BOnyxxMonnitEdgeDetectionEnum.positiveEdge, null);
    public static final Property filterReported = BOnyxxMonnitPulseCounterDevice.newProperty((int)1, (BValue)BOnyxxMonnitPulseFilterEnum.none, null);
    public static final Property filterSet = BOnyxxMonnitPulseCounterDevice.newProperty((int)0, (BValue)BOnyxxMonnitPulseFilterEnum.none, null);
    public static final Type TYPE = Sys.loadType(BOnyxxMonnitPulseCounterDevice.class);
    public static Log LOG = Log.getLog((String)Sys.getModuleForClass(BOnyxxMonnitNetwork.class).getModuleName());
    private static String OVERFLOW_COUNT_REPORTED_FILE = "overflow_reported";
    private static String OVERFLOW_COUNT_SET_FILE = "overflow_set";
    private static String AWARE_STATE_OVERFLOW_COUNT_REPORTED_FILE = "aware_overflow_reported";
    private static String AWARE_STATE_OVERFLOW_COUNT_SET_FILE = "aware_overflow_set";
    private static String ACCUMULATE_REPORTED_FILE = "accumulate_on_reported";
    private static String ACCUMULATE_SET_FILE = "accumulate_on_set";
    private static String PULSE_EDGE_DETECTION_REPORTED_FILE = "pulse_detection_mode_reported";
    private static String PULSE_EDGE_DETECTION_SET_FILE = "pulse_detection_mode_set";
    private static String FILTER_REPORTED_FILE = "filter_mode_reported";
    private static String FILTER_SET_FILE = "filter_mode_set";

    public long getOverflowCountReported() {
        return this.getLong(overflowCountReported);
    }

    public void setOverflowCountReported(long v) {
        this.setLong(overflowCountReported, v, null);
    }

    public long getOverflowCountSet() {
        return this.getLong(overflowCountSet);
    }

    public void setOverflowCountSet(long v) {
        this.setLong(overflowCountSet, v, null);
    }

    public long getAwareStateOverflowCountReported() {
        return this.getLong(awareStateOverflowCountReported);
    }

    public void setAwareStateOverflowCountReported(long v) {
        this.setLong(awareStateOverflowCountReported, v, null);
    }

    public long getAwareStateOverflowCountSet() {
        return this.getLong(awareStateOverflowCountSet);
    }

    public void setAwareStateOverflowCountSet(long v) {
        this.setLong(awareStateOverflowCountSet, v, null);
    }

    public boolean getAccumulateReported() {
        return this.getBoolean(accumulateReported);
    }

    public void setAccumulateReported(boolean v) {
        this.setBoolean(accumulateReported, v, null);
    }

    public boolean getAccumulateSet() {
        return this.getBoolean(accumulateSet);
    }

    public void setAccumulateSet(boolean v) {
        this.setBoolean(accumulateSet, v, null);
    }

    public BOnyxxMonnitEdgeDetectionEnum getPulseEdgeDetectionReported() {
        return (BOnyxxMonnitEdgeDetectionEnum)this.get(pulseEdgeDetectionReported);
    }

    public void setPulseEdgeDetectionReported(BOnyxxMonnitEdgeDetectionEnum v) {
        this.set(pulseEdgeDetectionReported, (BValue)v, null);
    }

    public BOnyxxMonnitEdgeDetectionEnum getPulseEdgeDetectionSet() {
        return (BOnyxxMonnitEdgeDetectionEnum)this.get(pulseEdgeDetectionSet);
    }

    public void setPulseEdgeDetectionSet(BOnyxxMonnitEdgeDetectionEnum v) {
        this.set(pulseEdgeDetectionSet, (BValue)v, null);
    }

    public BOnyxxMonnitPulseFilterEnum getFilterReported() {
        return (BOnyxxMonnitPulseFilterEnum)this.get(filterReported);
    }

    public void setFilterReported(BOnyxxMonnitPulseFilterEnum v) {
        this.set(filterReported, (BValue)v, null);
    }

    public BOnyxxMonnitPulseFilterEnum getFilterSet() {
        return (BOnyxxMonnitPulseFilterEnum)this.get(filterSet);
    }

    public void setFilterSet(BOnyxxMonnitPulseFilterEnum v) {
        this.set(filterSet, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        String CONFIG_DIR_PATH = this.getFullDevicePath() + "config/";
        String fileName = null;
        Property prop = null;
        String textValue = null;
        super.started();
        this.setExpectedSensorType(BOnyxxMonnitSensorTypeEnum.pulseCounter);
        try {
            prop = overflowCountSet;
            fileName = OVERFLOW_COUNT_SET_FILE;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, "", false);
            if (this.getOverflowCountSet() != new Long(textValue).longValue()) {
                OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, Long.toString(this.getOverflowCountSet()), true);
            }
            prop = awareStateOverflowCountSet;
            fileName = AWARE_STATE_OVERFLOW_COUNT_SET_FILE;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, "", false);
            if (this.getAwareStateOverflowCountSet() != new Long(textValue).longValue()) {
                OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, Long.toString(this.getAwareStateOverflowCountSet()), true);
            }
            prop = accumulateSet;
            fileName = ACCUMULATE_SET_FILE;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, "", false);
            if ((this.getAccumulateSet() ? 1 : 0) != new Integer(textValue)) {
                OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, Integer.toString(this.getAccumulateSet() ? 1 : 0), true);
            }
            prop = pulseEdgeDetectionSet;
            fileName = PULSE_EDGE_DETECTION_SET_FILE;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, "", false);
            if (this.getPulseEdgeDetectionSet().getOrdinal() != new Integer(textValue).intValue()) {
                OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, Integer.toString(this.getPulseEdgeDetectionSet().getOrdinal()), true);
            }
            prop = filterSet;
            fileName = FILTER_SET_FILE;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, "", false);
            if (this.getFilterSet().getOrdinal() != new Integer(textValue).intValue()) {
                OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, Integer.toString(this.getFilterSet().getOrdinal()), true);
            }
        }
        catch (Exception e) {
            BOnyxxMonnitNetwork.COMM_LOG.error("Error when accessing file for " + prop.getName() + ": ", (Throwable)e);
            this.configFail("Error when accessing file for " + prop.getName() + ": " + e);
            return;
        }
    }

    @Override
    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (this.isRunning()) {
            String CONFIG_DIR_PATH = this.getFullDevicePath() + "config/";
            try {
                if (prop == overflowCountSet) {
                    OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, OVERFLOW_COUNT_SET_FILE, Long.toString(this.getOverflowCountSet()), true);
                } else if (prop == awareStateOverflowCountSet) {
                    OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, AWARE_STATE_OVERFLOW_COUNT_SET_FILE, Long.toString(this.getAwareStateOverflowCountSet()), true);
                } else if (prop == accumulateSet) {
                    OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, ACCUMULATE_SET_FILE, Integer.toString(this.getAccumulateSet() ? 1 : 0), true);
                } else if (prop == pulseEdgeDetectionSet) {
                    OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, PULSE_EDGE_DETECTION_SET_FILE, Integer.toString(this.getPulseEdgeDetectionSet().getOrdinal()), true);
                } else if (prop == filterSet) {
                    OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, FILTER_SET_FILE, Integer.toString(this.getFilterSet().getOrdinal()), true);
                }
            }
            catch (Exception e) {
                BOnyxxMonnitNetwork.COMM_LOG.error("Error when accessing file for " + prop.getName() + ": ", (Throwable)e);
                this.configFail("Error when accessing file for " + prop.getName() + ": " + e);
                return;
            }
        }
    }

    @Override
    protected boolean pingUniqueProperties(boolean readSetValues) {
        String CONFIG_DIR_PATH = this.getFullDevicePath() + "config/";
        Property prop = null;
        String textValue = null;
        if (!super.pingUniqueProperties(readSetValues)) {
            return false;
        }
        try {
            prop = overflowCountReported;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, OVERFLOW_COUNT_REPORTED_FILE, "", false);
            this.setOverflowCountReported(new Long(textValue));
            prop = awareStateOverflowCountReported;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, AWARE_STATE_OVERFLOW_COUNT_REPORTED_FILE, "", false);
            this.setAwareStateOverflowCountReported(new Long(textValue));
            prop = accumulateReported;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, ACCUMULATE_REPORTED_FILE, "", false);
            this.setAccumulateReported(new Integer(textValue) == 1);
            prop = pulseEdgeDetectionReported;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, PULSE_EDGE_DETECTION_REPORTED_FILE, "", false);
            this.setPulseEdgeDetectionReported(BOnyxxMonnitEdgeDetectionEnum.make(new Integer(textValue)));
            prop = filterReported;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, FILTER_REPORTED_FILE, "", false);
            this.setFilterReported(BOnyxxMonnitPulseFilterEnum.make(new Integer(textValue)));
            if (readSetValues) {
                prop = overflowCountSet;
                textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, OVERFLOW_COUNT_SET_FILE, "", false);
                this.setOverflowCountSet(new Long(textValue));
                prop = awareStateOverflowCountSet;
                textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, AWARE_STATE_OVERFLOW_COUNT_SET_FILE, "", false);
                this.setAwareStateOverflowCountSet(new Long(textValue));
                prop = accumulateSet;
                textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, ACCUMULATE_SET_FILE, "", false);
                this.setAccumulateSet(new Integer(textValue) == 1);
                prop = pulseEdgeDetectionSet;
                textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, PULSE_EDGE_DETECTION_SET_FILE, "", false);
                this.setPulseEdgeDetectionSet(BOnyxxMonnitEdgeDetectionEnum.make(new Integer(textValue)));
                prop = filterSet;
                textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, FILTER_SET_FILE, "", false);
                this.setFilterSet(BOnyxxMonnitPulseFilterEnum.make(new Integer(textValue)));
            }
        }
        catch (Exception e) {
            BOnyxxMonnitNetwork.COMM_LOG.error("Error when reading file for " + prop.getName() + ": ", (Throwable)e);
            this.configFail("Error when reading file for " + prop.getName() + ": " + e);
            return false;
        }
        return true;
    }
}

