/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxMonnitDriver.point;

import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxMonnitDriver.BOnyxxMonnitDevice;
import com.lynxspring.onyxxMonnitDriver.BOnyxxMonnitNetwork;
import com.lynxspring.onyxxMonnitDriver.point.BOnyxxMonnitPointDeviceExt;
import com.tridium.driver.util.DrUtil;
import com.tridium.ndriver.poll.BINPollable;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal"), @NiagaraProperty(name="valueIndex", type="int", defaultValue="0"), @NiagaraProperty(name="pointPath", type="String", defaultValue="valueIndexToFileName(0)", flags=1), @NiagaraProperty(name="raw", type="String", defaultValue="", flags=1)})
public abstract class BOnyxxMonnitProxyExt
extends BProxyExt
implements BINPollable {
    public static final Property pollFrequency = BOnyxxMonnitProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property valueIndex = BOnyxxMonnitProxyExt.newProperty((int)0, (int)0, null);
    public static final Property pointPath = BOnyxxMonnitProxyExt.newProperty((int)1, (String)BOnyxxMonnitProxyExt.valueIndexToFileName(0), null);
    public static final Property raw = BOnyxxMonnitProxyExt.newProperty((int)1, (String)"", null);
    public static final Type TYPE = Sys.loadType(BOnyxxMonnitProxyExt.class);

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public int getValueIndex() {
        return this.getInt(valueIndex);
    }

    public void setValueIndex(int v) {
        this.setInt(valueIndex, v, null);
    }

    public String getPointPath() {
        return this.getString(pointPath);
    }

    public void setPointPath(String v) {
        this.setString(pointPath, v, null);
    }

    public String getRaw() {
        return this.getString(raw);
    }

    public void setRaw(String v) {
        this.setString(raw, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    private static String valueIndexToFileName(int index) {
        return "value_decoded_" + index;
    }

    protected void read(Context cx) throws Exception {
        this.setRaw(OnyxxFileAccess.FileIO(this.getOnyxxMonnitDevice().getFullDevicePath(), BOnyxxMonnitProxyExt.valueIndexToFileName(this.getValueIndex()), "", false));
    }

    public void stopped() throws Exception {
        super.stopped();
        this.getOnyxxMonnitNetwork().getPollScheduler().unsubscribe((BIPollable)this);
    }

    public final BOnyxxMonnitNetwork getOnyxxMonnitNetwork() {
        return (BOnyxxMonnitNetwork)this.getNetwork();
    }

    public final BOnyxxMonnitDevice getOnyxxMonnitDevice() {
        return (BOnyxxMonnitDevice)DrUtil.getParent((BComplex)this, (Type)BOnyxxMonnitDevice.TYPE);
    }

    public final BOnyxxMonnitPointDeviceExt getOnyxxMonnitPointDeviceExt() {
        return (BOnyxxMonnitPointDeviceExt)this.getDeviceExt();
    }

    public void readSubscribed(Context cx) throws Exception {
        this.getOnyxxMonnitNetwork().getPollScheduler().subscribe((BIPollable)this);
    }

    public void readUnsubscribed(Context cx) throws Exception {
        this.getOnyxxMonnitNetwork().getPollScheduler().unsubscribe((BIPollable)this);
    }

    public Type getDeviceExtType() {
        return BOnyxxMonnitPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return BReadWriteMode.readonly;
    }

    public boolean write(Context cx) throws Exception {
        return false;
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (this.isRunning()) {
            if (p == status) {
                if (this.getStatus().equals((Object)BStatus.disabled) || this.getStatus().equals((Object)BStatus.fault) || this.getStatus().equals((Object)BStatus.down) || this.getStatus().equals((Object)BStatus.stale)) {
                    BOnyxxMonnitNetwork.COMM_LOG.message("Status Value: " + this.getStatus() + "\n\t\tSlot Path: " + this.getSlotPath() + "\n\t\tPoint Path:  " + this.getFullPointPath());
                }
            } else if (p == valueIndex) {
                this.setPointPath(BOnyxxMonnitProxyExt.valueIndexToFileName(this.getValueIndex()));
            }
        }
    }

    public String getFullPointPath() {
        BOnyxxMonnitDevice onyxxMonnitDevice = this.getOnyxxMonnitDevice();
        BOnyxxMonnitNetwork onyxxMonnitNetwork = onyxxMonnitDevice.getOnyxxMonnitNetwork();
        String networkPath = onyxxMonnitNetwork.getNetworkPath();
        String devicePath = this.getOnyxxMonnitDevice().getDevicePath();
        String pointPath = this.getPointPath();
        return networkPath + devicePath + pointPath;
    }

    public void doPoll() {
        BRelTime heartbeatBuffer = null;
        BRelTime heartbeatTime = null;
        BAbsTime measurementTime = null;
        BAbsTime messageTime = null;
        BOnyxxMonnitDevice parentDevice = null;
        BStatus parentDeviceStatus = null;
        BRelTime pingInterval = null;
        try {
            parentDevice = this.getOnyxxMonnitDevice();
            parentDeviceStatus = parentDevice.getStatus();
            if (parentDeviceStatus.isDown() || parentDeviceStatus.isFault() || parentDeviceStatus.isDisabled()) {
                this.setStatus(parentDeviceStatus);
                return;
            }
            this.read(Context.NULL);
            heartbeatBuffer = parentDevice.getCurrentHeartbeatBuffer();
            heartbeatTime = parentDevice.getHeartbeatTimeReported();
            measurementTime = parentDevice.getLastUpdateTimeReportedBySensor();
            messageTime = parentDevice.getLastUpdateTime();
            pingInterval = parentDevice.getOnyxxMonnitNetwork().getMonitor().getPingFrequency();
            if (BAbsTime.make().isAfter(measurementTime.add(heartbeatTime).add(heartbeatBuffer).add(pingInterval))) {
                BOnyxxMonnitNetwork.LOG.trace("Sensor #" + this.getOnyxxMonnitDevice().getDeviceId() + " " + this.getParentPoint().getDisplayName(Context.NULL) + " is stale (measurement time: " + measurementTime.toString((Context)BOnyxxMonnitDevice.lastUpdateTimeReportedBySensor.getFacets()) + ", last message time = " + messageTime.toString((Context)BOnyxxMonnitDevice.lastUpdateTime.getFacets()) + ", heartbeat time = " + heartbeatTime.toString((Context)BOnyxxMonnitDevice.heartbeatTimeReported.getFacets()) + ", buffer = " + heartbeatBuffer + ", ping interval = " + pingInterval + " )");
                this.setStale(true, Context.NULL);
            }
        }
        catch (Exception e) {
            this.readFail(e.getMessage());
        }
    }
}

