/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxMonnitDriver;

import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxMonnitDriver.BOnyxxMonnitDevice;
import com.lynxspring.onyxxMonnitDriver.BOnyxxMonnitNetwork;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="timeToRearmReported", type="BRelTime", defaultValue="BRelTime.make(1000)", flags=1), @NiagaraProperty(name="timeToRearmSet", type="BRelTime", defaultValue="BRelTime.make(1000)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(1000)"), @Facet(name="BFacets.MAX", value="BRelTime.make(600*1000)")})})
public abstract class BOnyxxMonnitTriggerDevice
extends BOnyxxMonnitDevice {
    public static final Property timeToRearmReported = BOnyxxMonnitTriggerDevice.newProperty((int)1, (BValue)BRelTime.make((long)1000L), null);
    public static final Property timeToRearmSet = BOnyxxMonnitTriggerDevice.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1000L)), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.make((long)600000L))));
    public static final Type TYPE = Sys.loadType(BOnyxxMonnitTriggerDevice.class);
    public static Log LOG = Log.getLog((String)Sys.getModuleForClass(BOnyxxMonnitNetwork.class).getModuleName());
    private static final String TIME_TO_REARM_REPORTED_FILE = "time_to_rearm_reported";
    private static final String TIME_TO_REARM_SET_FILE = "time_to_rearm_set";

    public BRelTime getTimeToRearmReported() {
        return (BRelTime)this.get(timeToRearmReported);
    }

    public void setTimeToRearmReported(BRelTime v) {
        this.set(timeToRearmReported, (BValue)v, null);
    }

    public BRelTime getTimeToRearmSet() {
        return (BRelTime)this.get(timeToRearmSet);
    }

    public void setTimeToRearmSet(BRelTime v) {
        this.set(timeToRearmSet, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        String CONFIG_DIR_PATH = this.getFullDevicePath() + "config/";
        String fileName = null;
        Property prop = null;
        String textValue = null;
        super.started();
        try {
            prop = timeToRearmSet;
            fileName = TIME_TO_REARM_SET_FILE;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, "", false);
            if (this.getTimeToRearmSet().getSeconds() != new Integer(textValue).intValue()) {
                OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, Integer.toString(this.getTimeToRearmSet().getSeconds()), true);
            }
        }
        catch (Exception e) {
            BOnyxxMonnitNetwork.COMM_LOG.error("Error when accessing file for " + prop.getName() + ": ", (Throwable)e);
            this.configFail("Error when accessing file for " + prop.getName() + ": " + e);
            return;
        }
    }

    @Override
    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (this.isRunning()) {
            String CONFIG_DIR_PATH = this.getFullDevicePath() + "config/";
            try {
                if (prop == timeToRearmSet) {
                    OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, TIME_TO_REARM_SET_FILE, Integer.toString(this.getTimeToRearmSet().getSeconds()), true);
                }
            }
            catch (Exception e) {
                BOnyxxMonnitNetwork.COMM_LOG.error("Error when accessing file for " + prop.getName() + ": ", (Throwable)e);
                this.configFail("Error when accessing file for " + prop.getName() + ": " + e);
                return;
            }
        }
    }

    @Override
    protected boolean pingUniqueProperties(boolean readSetValues) {
        String CONFIG_DIR_PATH = this.getFullDevicePath() + "config/";
        Property prop = null;
        String textValue = null;
        if (!super.pingUniqueProperties(readSetValues)) {
            return false;
        }
        try {
            prop = timeToRearmReported;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, TIME_TO_REARM_REPORTED_FILE, "", false);
            this.setTimeToRearmReported(BRelTime.make((long)(new Long(textValue) * 1000L)));
            if (readSetValues) {
                prop = timeToRearmSet;
                textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, TIME_TO_REARM_SET_FILE, "", false);
                this.setTimeToRearmSet(BRelTime.make((long)(new Long(textValue) * 1000L)));
            }
        }
        catch (Exception e) {
            BOnyxxMonnitNetwork.COMM_LOG.error("Error when reading file for " + prop.getName() + ": ", (Throwable)e);
            this.configFail("Error when reading file for " + prop.getName() + ": " + e);
            return false;
        }
        return true;
    }
}

