/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxMonnitDriver;

import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxDriver.network.BOnyxxPingMonitor;
import com.lynxspring.onyxxDriver.network.BOnyxxPollScheduler;
import com.lynxspring.onyxxMonnitDriver.BOnyxxMonnitDevice;
import com.lynxspring.onyxxMonnitDriver.BOnyxxMonnitDeviceFolder;
import com.tridium.ndriver.BNNetwork;
import com.tridium.ndriver.poll.BNPollScheduler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="monitor", type="BPingMonitor", defaultValue="new BOnyxxPingMonitor()"), @NiagaraProperty(name="pollScheduler", type="BNPollScheduler", defaultValue="new BOnyxxPollScheduler()"), @NiagaraProperty(name="networkPath", type="String", defaultValue="/home/niagara/shared/mp_monnit/"), @NiagaraProperty(name="apnDeviceId", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="sensorHeartbeatBuffer", type="BRelTime", defaultValue="BRelTime.make(5000)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(0)"), @Facet(name="BFacets.MAX", value="BRelTime.make(60000)")}), @NiagaraProperty(name="apnNetworkDeviceCount", type="int", defaultValue="0", flags=5), @NiagaraProperty(name="networkId", type="int", defaultValue="0", flags=5), @NiagaraProperty(name="protocolVersion", type="int", defaultValue="0", flags=5), @NiagaraProperty(name="apnStateInt", type="int", defaultValue="0", flags=5), @NiagaraProperty(name="selectedChannel", type="int", defaultValue="0", flags=5), @NiagaraProperty(name="lastIncomingMessageTime", type="BAbsTime", defaultValue="BAbsTime.make(0)", flags=5), @NiagaraProperty(name="firmwareVersion", type="String", defaultValue="0.0.0", flags=1)})
@NiagaraActions(value={@NiagaraAction(name="apnPowerOff", flags=4), @NiagaraAction(name="apnPowerOn", flags=4), @NiagaraAction(name="forceActivateNetwork", flags=4), @NiagaraAction(name="forceDeactivateNetwork", flags=4), @NiagaraAction(name="forceReformNetwork", flags=4)})
public class BOnyxxMonnitNetwork
extends BNNetwork {
    public static final Property monitor = BOnyxxMonnitNetwork.newProperty((int)0, (BValue)new BOnyxxPingMonitor(), null);
    public static final Property pollScheduler = BOnyxxMonnitNetwork.newProperty((int)0, (BValue)new BOnyxxPollScheduler(), null);
    public static final Property networkPath = BOnyxxMonnitNetwork.newProperty((int)0, (String)"/home/niagara/shared/mp_monnit/", null);
    public static final Property apnDeviceId = BOnyxxMonnitNetwork.newProperty((int)1, (int)0, null);
    public static final Property sensorHeartbeatBuffer = BOnyxxMonnitNetwork.newProperty((int)0, (BValue)BRelTime.make((long)5000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L)), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.make((long)60000L))));
    public static final Property apnNetworkDeviceCount = BOnyxxMonnitNetwork.newProperty((int)5, (int)0, null);
    public static final Property networkId = BOnyxxMonnitNetwork.newProperty((int)5, (int)0, null);
    public static final Property protocolVersion = BOnyxxMonnitNetwork.newProperty((int)5, (int)0, null);
    public static final Property apnStateInt = BOnyxxMonnitNetwork.newProperty((int)5, (int)0, null);
    public static final Property selectedChannel = BOnyxxMonnitNetwork.newProperty((int)5, (int)0, null);
    public static final Property lastIncomingMessageTime = BOnyxxMonnitNetwork.newProperty((int)5, (BValue)BAbsTime.make((long)0L), null);
    public static final Property firmwareVersion = BOnyxxMonnitNetwork.newProperty((int)1, (String)"0.0.0", null);
    public static final Action apnPowerOff = BOnyxxMonnitNetwork.newAction((int)4, null);
    public static final Action apnPowerOn = BOnyxxMonnitNetwork.newAction((int)4, null);
    public static final Action forceActivateNetwork = BOnyxxMonnitNetwork.newAction((int)4, null);
    public static final Action forceDeactivateNetwork = BOnyxxMonnitNetwork.newAction((int)4, null);
    public static final Action forceReformNetwork = BOnyxxMonnitNetwork.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BOnyxxMonnitNetwork.class);
    public static Log LOG = Log.getLog((String)Sys.getModuleForClass(BOnyxxMonnitNetwork.class).getModuleName());
    public static Log COMM_LOG = Log.getLog((String)(Sys.getModuleForClass(BOnyxxMonnitNetwork.class).getModuleName() + "Comm"));
    public static Lexicon LEX = Lexicon.make(BOnyxxMonnitNetwork.class);
    private static final String SENSOR_NAME_PREFIX = "sensor_";
    private static final String ADD_FILE_NAME = "add_device";
    private static final String ACTIVATE_FILE_NAME = "activate_network";
    private static final String DEACTIVATE_FILE_NAME = "deactivate_network";
    private static final String REFORM_FILE_NAME = "reform_network";
    private static final String REMOVE_FILE_NAME = "remove_device";
    private static final String APN_POWER_OFF_FILE_NAME = "apn_power_off";
    private static final String APN_POWER_ON_FILE_NAME = "apn_power_on";
    private static final String PING_FILE_NAME = "last_received_message_time";
    private static final String NETWORK_STATUS_DIRECTORY = "network_status/";
    private static final String SENSOR_DIRECTORY = "sensors/";
    protected static final String REGISTERED_FILE_NAME = "registered_with_apn";

    public BPingMonitor getMonitor() {
        return (BPingMonitor)this.get(monitor);
    }

    public void setMonitor(BPingMonitor v) {
        this.set(monitor, (BValue)v, null);
    }

    public BNPollScheduler getPollScheduler() {
        return (BNPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BNPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    public String getNetworkPath() {
        return this.getString(networkPath);
    }

    public void setNetworkPath(String v) {
        this.setString(networkPath, v, null);
    }

    public int getApnDeviceId() {
        return this.getInt(apnDeviceId);
    }

    public void setApnDeviceId(int v) {
        this.setInt(apnDeviceId, v, null);
    }

    public BRelTime getSensorHeartbeatBuffer() {
        return (BRelTime)this.get(sensorHeartbeatBuffer);
    }

    public void setSensorHeartbeatBuffer(BRelTime v) {
        this.set(sensorHeartbeatBuffer, (BValue)v, null);
    }

    public int getApnNetworkDeviceCount() {
        return this.getInt(apnNetworkDeviceCount);
    }

    public void setApnNetworkDeviceCount(int v) {
        this.setInt(apnNetworkDeviceCount, v, null);
    }

    public int getNetworkId() {
        return this.getInt(networkId);
    }

    public void setNetworkId(int v) {
        this.setInt(networkId, v, null);
    }

    public int getProtocolVersion() {
        return this.getInt(protocolVersion);
    }

    public void setProtocolVersion(int v) {
        this.setInt(protocolVersion, v, null);
    }

    public int getApnStateInt() {
        return this.getInt(apnStateInt);
    }

    public void setApnStateInt(int v) {
        this.setInt(apnStateInt, v, null);
    }

    public int getSelectedChannel() {
        return this.getInt(selectedChannel);
    }

    public void setSelectedChannel(int v) {
        this.setInt(selectedChannel, v, null);
    }

    public BAbsTime getLastIncomingMessageTime() {
        return (BAbsTime)this.get(lastIncomingMessageTime);
    }

    public void setLastIncomingMessageTime(BAbsTime v) {
        this.set(lastIncomingMessageTime, (BValue)v, null);
    }

    public String getFirmwareVersion() {
        return this.getString(firmwareVersion);
    }

    public void setFirmwareVersion(String v) {
        this.setString(firmwareVersion, v, null);
    }

    public void apnPowerOff() {
        this.invoke(apnPowerOff, null, null);
    }

    public void apnPowerOn() {
        this.invoke(apnPowerOn, null, null);
    }

    public void forceActivateNetwork() {
        this.invoke(forceActivateNetwork, null, null);
    }

    public void forceDeactivateNetwork() {
        this.invoke(forceDeactivateNetwork, null, null);
    }

    public void forceReformNetwork() {
        this.invoke(forceReformNetwork, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        this.updateReadOnlyProperties();
        this.checkMonnitSystemStatus();
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning() || cx == Context.decoding) {
            return;
        }
        if (p == networkPath) {
            File f;
            if (!this.getNetworkPath().endsWith("/")) {
                this.setNetworkPath(this.getNetworkPath() + "/");
            }
            if (!(f = new File(this.getNetworkPath())).exists() || !f.isDirectory()) {
                this.configFail("Network path " + (f.exists() ? "is not a directory" : "does not exist"));
            } else {
                this.configOk();
            }
        }
    }

    public BOnyxxMonnitDevice[] getOnyxxMonnitDevices() {
        BDevice[] devices = this.getDevices();
        BOnyxxMonnitDevice[] onyxxMonnitDevices = new BOnyxxMonnitDevice[devices.length];
        System.arraycopy(devices, 0, onyxxMonnitDevices, 0, devices.length);
        return onyxxMonnitDevices;
    }

    private final boolean isDupDevice(BOnyxxMonnitDevice device) {
        boolean isDuplicate = false;
        BOnyxxMonnitDevice[] devices = this.getOnyxxMonnitDevices();
        for (int i = 0; i < devices.length; ++i) {
            if (devices[i] == device || devices[i].getDeviceId() != device.getDeviceId()) continue;
            isDuplicate = true;
        }
        if (isDuplicate) {
            device.setEnabled(false);
            device.configFail("duplicate device: Device IDs must be unique.");
            return true;
        }
        return false;
    }

    public void deviceChanged(BOnyxxMonnitDevice device) {
        LOG.trace("device was changed for " + device.getName());
        if (!this.isDupDevice(device)) {
            device.configOk();
        }
    }

    public String getNetworkName() {
        return "OnyxxMonnitDeviceNetwork";
    }

    public Type getDeviceFolderType() {
        return BOnyxxMonnitDeviceFolder.TYPE;
    }

    public Type getDeviceType() {
        return BOnyxxMonnitDevice.TYPE;
    }

    public AgentList getAgents(Context cx) {
        int x;
        AgentList agentList = super.getAgents(cx);
        for (x = 0; x < agentList.size(); ++x) {
            if (!agentList.get(x).getAgentType().getTypeName().equals("NDeviceManager") && !agentList.get(x).getAgentType().getTypeName().equals("NDeviceUxManager")) continue;
            agentList.remove(x);
        }
        for (x = 0; x < agentList.size(); ++x) {
            if (!agentList.get(x).getAgentType().getTypeName().equals("OnyxxMonnitDeviceManager")) continue;
            agentList.swap(0, x);
            break;
        }
        return agentList;
    }

    public void doApnPowerOff() {
        try {
            Path apn_power_off_file = Paths.get(this.getNetworkPath() + APN_POWER_OFF_FILE_NAME, new String[0]);
            if (!Files.exists(apn_power_off_file, new LinkOption[0])) {
                throw new NoSuchFileException(apn_power_off_file.toString());
            }
            Files.write(apn_power_off_file, "\n".getBytes(), new OpenOption[0]);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void doApnPowerOn() {
        try {
            Path apn_power_on_file = Paths.get(this.getNetworkPath() + APN_POWER_ON_FILE_NAME, new String[0]);
            if (!Files.exists(apn_power_on_file, new LinkOption[0])) {
                throw new NoSuchFileException(apn_power_on_file.toString());
            }
            Files.write(apn_power_on_file, "\n".getBytes(), new OpenOption[0]);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void doForceActivateNetwork() {
        try {
            Path activate_network_file = Paths.get(this.getNetworkPath() + ACTIVATE_FILE_NAME, new String[0]);
            if (Files.exists(activate_network_file, new LinkOption[0])) {
                Files.write(activate_network_file, "\n".getBytes(), new OpenOption[0]);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    LOG.warning("Thread sleep interrupted: ", (Throwable)ie);
                }
            } else {
                throw new NoSuchFileException(activate_network_file.toString());
            }
            this.updateReadOnlyProperties();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void doForceDeactivateNetwork() {
        try {
            Path deactivate_network_file = Paths.get(this.getNetworkPath() + DEACTIVATE_FILE_NAME, new String[0]);
            if (Files.exists(deactivate_network_file, new LinkOption[0])) {
                Files.write(deactivate_network_file, "\n".getBytes(), new OpenOption[0]);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    LOG.warning("Thread sleep interrupted: ", (Throwable)ie);
                }
            } else {
                throw new NoSuchFileException(deactivate_network_file.toString());
            }
            this.updateReadOnlyProperties();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void doForceReformNetwork() {
        try {
            Path reform_network_file = Paths.get(this.getNetworkPath() + REFORM_FILE_NAME, new String[0]);
            if (Files.exists(reform_network_file, new LinkOption[0])) {
                Files.write(reform_network_file, "\n".getBytes(), new OpenOption[0]);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    LOG.warning("Thread sleep interrupted: ", (Throwable)ie);
                }
            } else {
                throw new NoSuchFileException(reform_network_file.toString());
            }
            this.updateReadOnlyProperties();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void doPing() {
        if (this.isDisabled()) {
            return;
        }
        this.populateLastIncomingMessageTime();
        if (this.getLastIncomingMessageTime() == null) {
            this.configFail("Error when reading ping file");
        } else {
            boolean noCurrentConfigProblems = true;
            boolean noCurrentPingProblems = true;
            if (BAbsTime.make().compareTo((Object)this.getLastIncomingMessageTime().add(this.getMonitor().getPingFrequency())) > 0) {
                try {
                    try {
                        File activateNetworkFile = new File(this.getNetworkPath() + ACTIVATE_FILE_NAME);
                        if (!activateNetworkFile.exists()) {
                            this.pingFail("Cannot open \"activate network\" file! File path " + activateNetworkFile.getPath());
                            noCurrentPingProblems = false;
                        } else {
                            FileOutputStream activateNetworkStream = new FileOutputStream(activateNetworkFile);
                            activateNetworkStream.write(10);
                            activateNetworkStream.close();
                        }
                    }
                    catch (Exception e) {
                        if (e.getMessage().toLowerCase().contains("resource temporarily unavailable")) {
                            LOG.warning("Unable to send ping to APN: ", (Throwable)e);
                        }
                        throw e;
                    }
                    if (noCurrentPingProblems) {
                        Thread.sleep(50L);
                        this.populateLastIncomingMessageTime();
                        if (this.getLastIncomingMessageTime() == null) {
                            this.configFail("Error when reading ping file");
                            noCurrentConfigProblems = false;
                        } else if (BAbsTime.make().compareTo((Object)this.getLastIncomingMessageTime().add(this.getMonitor().getPingFrequency())) > 0) {
                            this.pingFail("No messages from APN in ping interval");
                            noCurrentPingProblems = false;
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error("Error sending ping to APN: ", (Throwable)e);
                    this.configFail("Error sending ping to APN");
                    noCurrentConfigProblems = false;
                }
            }
            if (noCurrentConfigProblems) {
                this.configOk();
            }
            if (noCurrentPingProblems) {
                this.pingOk();
            }
        }
        this.updateReadOnlyProperties();
        COMM_LOG.trace("APN device ID, firmware version, and status properties have been updated.");
    }

    private void populateAPNDeviceID() {
        if (this.isDisabled()) {
            return;
        }
        int serialNumber = 0;
        try {
            serialNumber = new Integer(OnyxxFileAccess.FileIO(this.getNetworkPath() + NETWORK_STATUS_DIRECTORY, "apn_serial_number", "", false));
        }
        catch (Exception e) {
            this.configFail("Error reading APN device ID.");
            LOG.error("Error reading APN device ID.", (Throwable)e);
            this.setEnabled(false);
        }
        finally {
            this.setApnDeviceId(serialNumber);
        }
    }

    private void populateAPNNetworkDeviceCount() {
        if (this.isDisabled()) {
            return;
        }
        int networkDeviceCount = 0;
        try {
            networkDeviceCount = new Integer(OnyxxFileAccess.FileIO(this.getNetworkPath() + NETWORK_STATUS_DIRECTORY, "network_device_count", "", false));
        }
        catch (Exception e) {
            this.configFail("Error reading APN network device count.");
            LOG.error("Error reading APN network device count.", (Throwable)e);
            this.setEnabled(false);
        }
        finally {
            this.setApnNetworkDeviceCount(networkDeviceCount);
        }
    }

    private void populateNetworkId() {
        if (this.isDisabled()) {
            return;
        }
        int networkId = 0;
        try {
            networkId = new Integer(OnyxxFileAccess.FileIO(this.getNetworkPath() + NETWORK_STATUS_DIRECTORY, "network_id", "", false));
        }
        catch (Exception e) {
            this.configFail("Error reading APN network ID.");
            LOG.error("Error reading APN network ID.", (Throwable)e);
            this.setEnabled(false);
        }
        finally {
            this.setNetworkId(networkId);
        }
    }

    private void populateProtocolVersion() {
        if (this.isDisabled()) {
            return;
        }
        int protocolVersion = 0;
        try {
            protocolVersion = new Integer(OnyxxFileAccess.FileIO(this.getNetworkPath() + NETWORK_STATUS_DIRECTORY, "protocol_version", "", false));
        }
        catch (Exception e) {
            this.configFail("Error reading APN protocol version.");
            LOG.error("Error reading APN protocol version.", (Throwable)e);
            this.setEnabled(false);
        }
        finally {
            this.setProtocolVersion(protocolVersion);
        }
    }

    private void populateSelectedChannel() {
        if (this.isDisabled()) {
            return;
        }
        int selectedChannel = 0;
        try {
            selectedChannel = new Integer(OnyxxFileAccess.FileIO(this.getNetworkPath() + NETWORK_STATUS_DIRECTORY, "selected_channel", "", false));
        }
        catch (Exception e) {
            this.configFail("Error reading selected network channel.");
            LOG.error("Error reading selected network channel.", (Throwable)e);
            this.setEnabled(false);
        }
        finally {
            this.setSelectedChannel(selectedChannel);
        }
    }

    private void populateAPNState() {
        if (this.isDisabled()) {
            return;
        }
        int state = 0;
        try {
            state = new Integer(OnyxxFileAccess.FileIO(this.getNetworkPath() + NETWORK_STATUS_DIRECTORY, "current_state", "", false));
        }
        catch (Exception e) {
            this.configFail("Error reading APN state.");
            LOG.error("Error reading APN state.", (Throwable)e);
            this.setEnabled(false);
        }
        finally {
            this.setApnStateInt(state);
        }
    }

    private void populateFirmwareVersion() {
        if (this.isDisabled()) {
            return;
        }
        String version = "";
        try {
            version = OnyxxFileAccess.FileIO(this.getNetworkPath(), "fs_version", "", false);
        }
        catch (Exception e) {
            this.configFail("Error reading file-system version.");
            LOG.error("Error reading file-system version.", (Throwable)e);
            this.setEnabled(false);
        }
        finally {
            this.setFirmwareVersion(version);
        }
    }

    private void populateLastIncomingMessageTime() {
        if (this.isDisabled()) {
            return;
        }
        String timeString = "0";
        try {
            timeString = OnyxxFileAccess.FileIO(this.getNetworkPath() + NETWORK_STATUS_DIRECTORY, PING_FILE_NAME, "", false);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                this.configFail("Error when reading ping file: " + e.toString());
            }
            LOG.error("Error when reading ping file: ", (Throwable)e);
            this.setEnabled(false);
        }
        finally {
            this.setLastIncomingMessageTime(BAbsTime.make((long)(new Long(timeString) * 1000L)));
        }
    }

    private void updateReadOnlyProperties() {
        this.populateAPNDeviceID();
        this.populateAPNNetworkDeviceCount();
        this.populateNetworkId();
        this.populateProtocolVersion();
        this.populateAPNState();
        this.populateSelectedChannel();
        this.populateFirmwareVersion();
    }

    private Integer getSensorIDFromDir(String directoryName) {
        return Integer.parseInt(directoryName.substring(SENSOR_NAME_PREFIX.length()));
    }

    private void checkMonnitSystemStatus() {
        boolean needReform = false;
        BOnyxxMonnitDevice[] omDevArray = this.getOnyxxMonnitDevices();
        ArrayList<Integer> devIdList = new ArrayList<Integer>(omDevArray.length);
        for (BOnyxxMonnitDevice dev : omDevArray) {
            devIdList.add(new Integer(dev.getDeviceId()));
            File devDir = new File(dev.getFullDevicePath());
            String devReg = dev.getFullDevicePath() + "/" + REGISTERED_FILE_NAME;
            if (!devDir.exists()) {
                needReform = true;
                break;
            }
            try {
                String regStatus = OnyxxFileAccess.FileIO(dev.getFullDevicePath(), REGISTERED_FILE_NAME, "", false);
                if (Integer.parseInt(regStatus) == 1) continue;
                needReform = true;
            }
            catch (Exception e) {
                needReform = true;
            }
            break;
        }
        if (!needReform) {
            File[] monnitDeviceArray;
            Collections.sort(devIdList);
            File[] fileArray = monnitDeviceArray = new File(this.getNetworkPath() + SENSOR_DIRECTORY).listFiles();
            int n = fileArray.length;
            for (int dev = 0; dev < n; ++dev) {
                File sensor = fileArray[dev];
                if (devIdList.contains(this.getSensorIDFromDir(sensor.getName()))) continue;
                try {
                    String regStatus = OnyxxFileAccess.FileIO(sensor.toPath().toString(), REGISTERED_FILE_NAME, "", false);
                    if (Integer.parseInt(regStatus) == 0) continue;
                    needReform = true;
                }
                catch (Exception e) {
                    needReform = true;
                }
                break;
            }
        }
        if (needReform && this.reformNetwork()) {
            for (BOnyxxMonnitDevice dev : omDevArray) {
                this.addDevice(dev.getDeviceId(), dev.getSecurityCode());
            }
        }
    }

    protected boolean addDevice(int id) {
        return this.addDevice(id, null);
    }

    protected boolean addDevice(int id, String securityCode) {
        if (id > 0) {
            Path add_dev_file = Paths.get(this.getNetworkPath() + ADD_FILE_NAME, new String[0]);
            try {
                if (!Files.exists(add_dev_file, new LinkOption[0])) {
                    throw new NoSuchFileException(add_dev_file.toString());
                }
                if (securityCode == null || securityCode.isEmpty()) {
                    Files.write(add_dev_file, ("" + id + "\n").getBytes(), new OpenOption[0]);
                } else {
                    Files.write(add_dev_file, ("" + id + "," + securityCode + "\n").getBytes(), new OpenOption[0]);
                }
            }
            catch (IOException ioe) {
                if (ioe.getMessage().toLowerCase().contains("invalid argument")) {
                    LOG.error(String.format("Could not add sensor %06d; security code \"%s\" is invalid.", id, securityCode));
                } else {
                    ioe.printStackTrace();
                }
                return false;
            }
        }
        return true;
    }

    protected boolean removeDevice(int id) {
        if (id > 0) {
            try {
                Path remove_dev_file = Paths.get(this.getNetworkPath() + REMOVE_FILE_NAME, new String[0]);
                if (!Files.exists(remove_dev_file, new LinkOption[0])) {
                    throw new NoSuchFileException(remove_dev_file.toString());
                }
                Files.write(remove_dev_file, ("" + id).getBytes(), new OpenOption[0]);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return false;
            }
        }
        for (BDevice device : this.getBDeviceList()) {
            try {
                if (!device.isFault()) continue;
                device.doPing();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    protected boolean reformNetwork() {
        try {
            Path reform_network_file = Paths.get(this.getNetworkPath() + REFORM_FILE_NAME, new String[0]);
            if (!Files.exists(reform_network_file, new LinkOption[0])) {
                throw new NoSuchFileException(reform_network_file.toString());
            }
            Files.write(reform_network_file, "\n".getBytes(), new OpenOption[0]);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        return true;
    }
}

