/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxMonnitDriver;

import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxMonnitDriver.BOnyxxMonnitNetwork;
import com.lynxspring.onyxxMonnitDriver.enums.BOnyxxMonnitSensorTypeEnum;
import com.lynxspring.onyxxMonnitDriver.point.BOnyxxMonnitPointDeviceExt;
import com.tridium.ndriver.BNDevice;
import com.tridium.ndriver.util.SfUtil;
import java.io.File;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="points", type="BOnyxxMonnitPointDeviceExt", defaultValue="new BOnyxxMonnitPointDeviceExt()"), @NiagaraProperty(name="deviceId", type="int", defaultValue="0", flags=8, facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)"), @Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="9999999")}), @NiagaraProperty(name="securityCode", type="String", defaultValue="\"\"", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)"), @Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"onyxxDriver:SecurityCodeFE\")")}), @NiagaraProperty(name="devicePath", type="String", defaultValue="deviceIDToDevicePath(0)", flags=1), @NiagaraProperty(name="expectedSensorType", type="BOnyxxMonnitSensorTypeEnum", defaultValue="BOnyxxMonnitSensorTypeEnum.unknown", flags=9), @NiagaraProperty(name="expectedApplicationId", type="int", defaultValue="0", flags=13), @NiagaraProperty(name="reportedSensorType", type="BOnyxxMonnitSensorTypeEnum", defaultValue="BOnyxxMonnitSensorTypeEnum.unknown", flags=9), @NiagaraProperty(name="reportedApplicationId", type="int", defaultValue="0", flags=13), @NiagaraProperty(name="registeredWithWirelessGateway", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="batteryVoltage", type="float", defaultValue="0", flags=9, facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"volt\")")}), @NiagaraProperty(name="signalStrength", type="int", defaultValue="0", flags=9), @NiagaraProperty(name="apnRssi", type="int", defaultValue="0", flags=13), @NiagaraProperty(name="fieldRssi", type="int", defaultValue="0", flags=13), @NiagaraProperty(name="lastUpdateTimeReportedBySensor", type="BAbsTime", defaultValue="BAbsTime.make(0)", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="true")}), @NiagaraProperty(name="lastUpdateTime", type="BAbsTime", defaultValue="BAbsTime.make(0)", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="true")}), @NiagaraProperty(name="expectedNextCheckIn", type="BAbsTime", defaultValue="BAbsTime.make(0)", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="true")}), @NiagaraProperty(name="settingsUpdatePending", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="heartbeatTimeReported", type="BRelTime", defaultValue="BRelTime.make(7200000)", flags=1), @NiagaraProperty(name="heartbeatTimeSet", type="BRelTime", defaultValue="BRelTime.make(7200000)", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)"), @Facet(name="BFacets.MIN", value="BRelTime.make(60*1000)"), @Facet(name="BFacets.MAX", value="BRelTime.make(43200*1000)")}), @NiagaraProperty(name="awareHeartbeatTimeReported", type="BRelTime", defaultValue="BRelTime.make(7200000)", flags=1), @NiagaraProperty(name="awareHeartbeatTimeSet", type="BRelTime", defaultValue="BRelTime.make(7200000)", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)"), @Facet(name="BFacets.MIN", value="BRelTime.make(60*1000)"), @Facet(name="BFacets.MAX", value="BRelTime.make(43200*1000)")}), @NiagaraProperty(name="recoveryLimitReported", type="int", defaultValue="2", flags=1), @NiagaraProperty(name="recoveryLimitSet", type="int", defaultValue="2", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)"), @Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="10")}), @NiagaraProperty(name="heartbeatBufferOverride", type="BRelTime", defaultValue="BRelTime.make(0)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(0)"), @Facet(name="BFacets.MAX", value="BRelTime.make(60000)")}, flags=4)})
@NiagaraActions(value={@NiagaraAction(name="pingWithForcedSyncOfReadPropertiesOnly", flags=4), @NiagaraAction(name="pingWithForcedSync", flags=4)})
public class BOnyxxMonnitDevice
extends BNDevice {
    public static final Property status = BOnyxxMonnitDevice.newProperty((int)75, (BValue)BStatus.ok, (BFacets)SfUtil.incl((String)"ed.ro"));
    public static final Property points = BOnyxxMonnitDevice.newProperty((int)0, (BValue)new BOnyxxMonnitPointDeviceExt(), null);
    public static final Property deviceId = BOnyxxMonnitDevice.newProperty((int)8, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)SfUtil.incl((String)"ed"), (BFacets)BFacets.make((String)"min", (int)1)), (BFacets)BFacets.make((String)"max", (int)9999999)));
    public static final Property securityCode = BOnyxxMonnitDevice.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)SfUtil.incl((String)"ed"), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"onyxxDriver:SecurityCodeFE"))));
    public static final Property devicePath = BOnyxxMonnitDevice.newProperty((int)1, (String)BOnyxxMonnitDevice.deviceIDToDevicePath(0), null);
    public static final Property expectedSensorType = BOnyxxMonnitDevice.newProperty((int)9, (BValue)BOnyxxMonnitSensorTypeEnum.unknown, null);
    public static final Property expectedApplicationId = BOnyxxMonnitDevice.newProperty((int)13, (int)0, null);
    public static final Property reportedSensorType = BOnyxxMonnitDevice.newProperty((int)9, (BValue)BOnyxxMonnitSensorTypeEnum.unknown, null);
    public static final Property reportedApplicationId = BOnyxxMonnitDevice.newProperty((int)13, (int)0, null);
    public static final Property registeredWithWirelessGateway = BOnyxxMonnitDevice.newProperty((int)5, (boolean)false, null);
    public static final Property batteryVoltage = BOnyxxMonnitDevice.newProperty((int)9, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"volt")));
    public static final Property signalStrength = BOnyxxMonnitDevice.newProperty((int)9, (int)0, null);
    public static final Property apnRssi = BOnyxxMonnitDevice.newProperty((int)13, (int)0, null);
    public static final Property fieldRssi = BOnyxxMonnitDevice.newProperty((int)13, (int)0, null);
    public static final Property lastUpdateTimeReportedBySensor = BOnyxxMonnitDevice.newProperty((int)1, (BValue)BAbsTime.make((long)0L), (BFacets)BFacets.make((String)"showSeconds", (boolean)true));
    public static final Property lastUpdateTime = BOnyxxMonnitDevice.newProperty((int)1, (BValue)BAbsTime.make((long)0L), (BFacets)BFacets.make((String)"showSeconds", (boolean)true));
    public static final Property expectedNextCheckIn = BOnyxxMonnitDevice.newProperty((int)1, (BValue)BAbsTime.make((long)0L), (BFacets)BFacets.make((String)"showSeconds", (boolean)true));
    public static final Property settingsUpdatePending = BOnyxxMonnitDevice.newProperty((int)1, (boolean)false, null);
    public static final Property heartbeatTimeReported = BOnyxxMonnitDevice.newProperty((int)1, (BValue)BRelTime.make((long)0x6DDD00L), null);
    public static final Property heartbeatTimeSet = BOnyxxMonnitDevice.newProperty((int)0, (BValue)BRelTime.make((long)0x6DDD00L), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)SfUtil.incl((String)"ed"), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)60000L))), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.make((long)43200000L))));
    public static final Property awareHeartbeatTimeReported = BOnyxxMonnitDevice.newProperty((int)1, (BValue)BRelTime.make((long)0x6DDD00L), null);
    public static final Property awareHeartbeatTimeSet = BOnyxxMonnitDevice.newProperty((int)0, (BValue)BRelTime.make((long)0x6DDD00L), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)SfUtil.incl((String)"ed"), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)60000L))), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.make((long)43200000L))));
    public static final Property recoveryLimitReported = BOnyxxMonnitDevice.newProperty((int)1, (int)2, null);
    public static final Property recoveryLimitSet = BOnyxxMonnitDevice.newProperty((int)0, (int)2, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)SfUtil.incl((String)"ed"), (BFacets)BFacets.make((String)"min", (int)0)), (BFacets)BFacets.make((String)"max", (int)10)));
    public static final Property heartbeatBufferOverride = BOnyxxMonnitDevice.newProperty((int)4, (BValue)BRelTime.make((long)0L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L)), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.make((long)60000L))));
    public static final Action pingWithForcedSyncOfReadPropertiesOnly = BOnyxxMonnitDevice.newAction((int)4, null);
    public static final Action pingWithForcedSync = BOnyxxMonnitDevice.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BOnyxxMonnitDevice.class);
    public static Log LOG = Log.getLog((String)Sys.getModuleForClass(BOnyxxMonnitNetwork.class).getModuleName());
    private static final String APN_RSSI_FILE_NAME = "ap_rssi";
    private static final String BATTERY_VOLTAGE_FILE_NAME = "battery_voltage";
    private static final String REGISTERED_WITH_APN_FILE_NAME = "registered_with_apn";
    protected static final String CONFIG_DIR_NAME = "config/";
    private static final String FIELD_RSSI_FILE_NAME = "field_rssi";
    private static final String HEARTBEAT_REPORTED_FILE_NAME = "heartbeat_interval_reported";
    private static final String HEARTBEAT_SET_FILE_NAME = "heartbeat_interval_set";
    private static final String PING_ALT_FILE_NAME = "last_update_time_sensor";
    private static final String PING_FILE_NAME = "last_update_time_os";
    private static final String SENSOR_TYPE_FILE_NAME = "type";
    private static final String SETTINGS_UPDATE_PENDING_FILE_NAME = "config_change_pending";
    private static final String AWARE_REPORTED_FILE_NAME = "aware_heartbeat_interval_reported";
    private static final String AWARE_SET_FILE_NAME = "aware_heartbeat_interval_set";
    private static final String REC_LIMIT_REPORTED_FILE_NAME = "recovery_limit_reported";
    private static final String REC_LIMIT_SET_FILE_NAME = "recovery_limit_set";
    private int oldDeviceId;

    public BOnyxxMonnitPointDeviceExt getPoints() {
        return (BOnyxxMonnitPointDeviceExt)this.get(points);
    }

    public void setPoints(BOnyxxMonnitPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    public int getDeviceId() {
        return this.getInt(deviceId);
    }

    public void setDeviceId(int v) {
        this.setInt(deviceId, v, null);
    }

    public String getSecurityCode() {
        return this.getString(securityCode);
    }

    public void setSecurityCode(String v) {
        this.setString(securityCode, v, null);
    }

    public String getDevicePath() {
        return this.getString(devicePath);
    }

    public void setDevicePath(String v) {
        this.setString(devicePath, v, null);
    }

    public BOnyxxMonnitSensorTypeEnum getExpectedSensorType() {
        return (BOnyxxMonnitSensorTypeEnum)this.get(expectedSensorType);
    }

    public void setExpectedSensorType(BOnyxxMonnitSensorTypeEnum v) {
        this.set(expectedSensorType, (BValue)v, null);
    }

    public int getExpectedApplicationId() {
        return this.getInt(expectedApplicationId);
    }

    public void setExpectedApplicationId(int v) {
        this.setInt(expectedApplicationId, v, null);
    }

    public BOnyxxMonnitSensorTypeEnum getReportedSensorType() {
        return (BOnyxxMonnitSensorTypeEnum)this.get(reportedSensorType);
    }

    public void setReportedSensorType(BOnyxxMonnitSensorTypeEnum v) {
        this.set(reportedSensorType, (BValue)v, null);
    }

    public int getReportedApplicationId() {
        return this.getInt(reportedApplicationId);
    }

    public void setReportedApplicationId(int v) {
        this.setInt(reportedApplicationId, v, null);
    }

    public boolean getRegisteredWithWirelessGateway() {
        return this.getBoolean(registeredWithWirelessGateway);
    }

    public void setRegisteredWithWirelessGateway(boolean v) {
        this.setBoolean(registeredWithWirelessGateway, v, null);
    }

    public float getBatteryVoltage() {
        return this.getFloat(batteryVoltage);
    }

    public void setBatteryVoltage(float v) {
        this.setFloat(batteryVoltage, v, null);
    }

    public int getSignalStrength() {
        return this.getInt(signalStrength);
    }

    public void setSignalStrength(int v) {
        this.setInt(signalStrength, v, null);
    }

    public int getApnRssi() {
        return this.getInt(apnRssi);
    }

    public void setApnRssi(int v) {
        this.setInt(apnRssi, v, null);
    }

    public int getFieldRssi() {
        return this.getInt(fieldRssi);
    }

    public void setFieldRssi(int v) {
        this.setInt(fieldRssi, v, null);
    }

    public BAbsTime getLastUpdateTimeReportedBySensor() {
        return (BAbsTime)this.get(lastUpdateTimeReportedBySensor);
    }

    public void setLastUpdateTimeReportedBySensor(BAbsTime v) {
        this.set(lastUpdateTimeReportedBySensor, (BValue)v, null);
    }

    public BAbsTime getLastUpdateTime() {
        return (BAbsTime)this.get(lastUpdateTime);
    }

    public void setLastUpdateTime(BAbsTime v) {
        this.set(lastUpdateTime, (BValue)v, null);
    }

    public BAbsTime getExpectedNextCheckIn() {
        return (BAbsTime)this.get(expectedNextCheckIn);
    }

    public void setExpectedNextCheckIn(BAbsTime v) {
        this.set(expectedNextCheckIn, (BValue)v, null);
    }

    public boolean getSettingsUpdatePending() {
        return this.getBoolean(settingsUpdatePending);
    }

    public void setSettingsUpdatePending(boolean v) {
        this.setBoolean(settingsUpdatePending, v, null);
    }

    public BRelTime getHeartbeatTimeReported() {
        return (BRelTime)this.get(heartbeatTimeReported);
    }

    public void setHeartbeatTimeReported(BRelTime v) {
        this.set(heartbeatTimeReported, (BValue)v, null);
    }

    public BRelTime getHeartbeatTimeSet() {
        return (BRelTime)this.get(heartbeatTimeSet);
    }

    public void setHeartbeatTimeSet(BRelTime v) {
        this.set(heartbeatTimeSet, (BValue)v, null);
    }

    public BRelTime getAwareHeartbeatTimeReported() {
        return (BRelTime)this.get(awareHeartbeatTimeReported);
    }

    public void setAwareHeartbeatTimeReported(BRelTime v) {
        this.set(awareHeartbeatTimeReported, (BValue)v, null);
    }

    public BRelTime getAwareHeartbeatTimeSet() {
        return (BRelTime)this.get(awareHeartbeatTimeSet);
    }

    public void setAwareHeartbeatTimeSet(BRelTime v) {
        this.set(awareHeartbeatTimeSet, (BValue)v, null);
    }

    public int getRecoveryLimitReported() {
        return this.getInt(recoveryLimitReported);
    }

    public void setRecoveryLimitReported(int v) {
        this.setInt(recoveryLimitReported, v, null);
    }

    public int getRecoveryLimitSet() {
        return this.getInt(recoveryLimitSet);
    }

    public void setRecoveryLimitSet(int v) {
        this.setInt(recoveryLimitSet, v, null);
    }

    public BRelTime getHeartbeatBufferOverride() {
        return (BRelTime)this.get(heartbeatBufferOverride);
    }

    public void setHeartbeatBufferOverride(BRelTime v) {
        this.set(heartbeatBufferOverride, (BValue)v, null);
    }

    public void pingWithForcedSyncOfReadPropertiesOnly() {
        this.invoke(pingWithForcedSyncOfReadPropertiesOnly, null, null);
    }

    public void pingWithForcedSync() {
        this.invoke(pingWithForcedSync, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected static String deviceIDToDevicePath(int deviceID) {
        return String.format("sensors/sensor_%06d/", deviceID);
    }

    public Type getNetworkType() {
        return BOnyxxMonnitNetwork.TYPE;
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        if (this.getDeviceId() != 0) {
            this.setDevicePath(BOnyxxMonnitDevice.deviceIDToDevicePath(this.getDeviceId()));
        }
        this.getOnyxxMonnitNetwork().deviceChanged(this);
        this.doPing(true, false);
    }

    public void started() throws Exception {
        String CONFIG_DIR_PATH = this.getFullDevicePath() + CONFIG_DIR_NAME;
        BValue displayNames = null;
        boolean lastMeasurementTimeDisplayNameAlreadySet = false;
        boolean lastMessageTimeDisplayNameAlreadySet = false;
        String fileName = null;
        Property prop = null;
        String textValue = null;
        super.started();
        displayNames = this.get("displayNames");
        if (displayNames instanceof BNameMap) {
            BNameMap displayNamesMap = (BNameMap)displayNames;
            if (displayNamesMap.get("lastUpdateTimeReportedBySensor") != null) {
                lastMeasurementTimeDisplayNameAlreadySet = true;
            }
            if (displayNamesMap.get("lastUpdateTime") != null) {
                lastMessageTimeDisplayNameAlreadySet = true;
            }
        }
        if (!lastMeasurementTimeDisplayNameAlreadySet) {
            this.setDisplayName(this.getProperty("lastUpdateTimeReportedBySensor"), BFormat.make((String)"Last Measurement Time"), Context.NULL);
        }
        if (!lastMessageTimeDisplayNameAlreadySet) {
            this.setDisplayName(this.getProperty("lastUpdateTime"), BFormat.make((String)"Last Message Time"), Context.NULL);
        }
        if (Sys.getStation().isRunning()) {
            if (this.getDeviceId() != 0) {
                this.setDevicePath(BOnyxxMonnitDevice.deviceIDToDevicePath(this.getDeviceId()));
            }
            this.addDevToSystem(this.getDeviceId(), this.getSecurityCode());
        }
        try {
            prop = heartbeatTimeSet;
            fileName = HEARTBEAT_SET_FILE_NAME;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, "", false);
            if (this.getHeartbeatTimeSet().getSeconds() != new Integer(textValue).intValue()) {
                OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, Integer.toString(this.getHeartbeatTimeSet().getSeconds()), true);
            }
            prop = awareHeartbeatTimeSet;
            fileName = AWARE_SET_FILE_NAME;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, "", false);
            if (this.getAwareHeartbeatTimeSet().getSeconds() != new Integer(textValue).intValue()) {
                OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, Integer.toString(this.getAwareHeartbeatTimeSet().getSeconds()), true);
            }
            prop = recoveryLimitSet;
            fileName = REC_LIMIT_SET_FILE_NAME;
            textValue = OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, "", false);
            if (this.getRecoveryLimitSet() != new Integer(textValue).intValue()) {
                OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, fileName, Integer.toString(this.getRecoveryLimitSet()), true);
            }
        }
        catch (Exception e) {
            BOnyxxMonnitNetwork.COMM_LOG.error("Error when accessing file for " + prop.getName() + ": ", (Throwable)e);
            this.configFail("Error when accessing file for " + prop.getName() + ": " + e);
            return;
        }
        this.writeTypeFile();
    }

    public void stopped() throws Exception {
        super.stopped();
        if (Sys.getStation().isRunning()) {
            this.getOnyxxMonnitNetwork().removeDevice(this.getDeviceId());
        }
    }

    private void writeTypeFile() {
        BAbsTime startTime = BAbsTime.now();
        while (BAbsTime.now().getMillis() - startTime.getMillis() < 1000L) {
            try {
                String textValue = OnyxxFileAccess.FileIO(this.getFullDevicePath(), PING_FILE_NAME, "", false);
                if (0 != new Integer(textValue)) break;
                OnyxxFileAccess.FileIO(this.getFullDevicePath(), SENSOR_TYPE_FILE_NAME, Integer.toString(this.getExpectedSensorType().getOrdinal()), true);
                break;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void addDevToSystem(int devId) {
        this.addDevToSystem(devId, null);
    }

    private void addDevToSystem(int devId, String securityCode) {
        if (!this.getOnyxxMonnitNetwork().addDevice(devId, securityCode)) {
            this.configFail("Device " + devId + " failed to add to system." + (devId == 0 ? "" : "See application director for more details."));
        } else if (devId != 0) {
            this.writeTypeFile();
        }
        this.oldDeviceId = devId;
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (this.isRunning()) {
            String CONFIG_DIR_PATH = this.getFullDevicePath() + CONFIG_DIR_NAME;
            try {
                if (prop == heartbeatTimeSet) {
                    OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, HEARTBEAT_SET_FILE_NAME, Integer.toString(this.getHeartbeatTimeSet().getSeconds()), true);
                } else if (prop == awareHeartbeatTimeSet) {
                    OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, AWARE_SET_FILE_NAME, Integer.toString(this.getAwareHeartbeatTimeSet().getSeconds()), true);
                } else if (prop == recoveryLimitSet) {
                    OnyxxFileAccess.FileIO(CONFIG_DIR_PATH, REC_LIMIT_SET_FILE_NAME, Integer.toString(this.getRecoveryLimitSet()), true);
                }
            }
            catch (Exception e) {
                BOnyxxMonnitNetwork.COMM_LOG.error("Error when accessing file for " + prop.getName() + ": ", (Throwable)e);
                this.configFail("Error when accessing file for " + prop.getName() + ": " + e);
                return;
            }
            if (prop == deviceId && this.getDeviceId() != this.oldDeviceId || prop == securityCode && this.getDeviceId() != 0) {
                this.setDevicePath(BOnyxxMonnitDevice.deviceIDToDevicePath(this.getDeviceId()));
                this.getOnyxxMonnitNetwork().deviceChanged(this);
                if (!this.isConfigFault()) {
                    if (this.oldDeviceId == 0 || this.getOnyxxMonnitNetwork().removeDevice(this.oldDeviceId) || prop == securityCode) {
                        if (this.getDeviceId() != 0 && !this.getSecurityCode().isEmpty()) {
                            this.addDevToSystem(this.getDeviceId(), this.getSecurityCode());
                        }
                    } else {
                        this.setDeviceId(this.oldDeviceId);
                    }
                    try {
                        this.doPing(true, false);
                    }
                    catch (Exception e) {
                        LOG.error("deviceChanged: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (prop == lastUpdateTime || prop == heartbeatTimeReported) {
                this.setExpectedNextCheckIn(this.getLastUpdateTime().add(this.getHeartbeatTimeReported()));
            }
            if (prop == apnRssi) {
                int rssi = this.getApnRssi();
                int rssiPercent = 0;
                rssiPercent = rssi > -90 ? rssi + 90 + 60 : (int)((double)(rssi + 115) * 2.4);
                if (rssiPercent <= 0) {
                    this.setSignalStrength(0);
                } else if (rssiPercent <= 10) {
                    this.setSignalStrength(1);
                } else if (rssiPercent <= 25) {
                    this.setSignalStrength(2);
                } else if (rssiPercent <= 50) {
                    this.setSignalStrength(3);
                } else if (rssiPercent <= 75) {
                    this.setSignalStrength(4);
                } else {
                    this.setSignalStrength(5);
                }
            }
        }
    }

    public boolean isConfigFault() {
        return this.isFault() && !this.isFatalFault() && !this.getNetwork().isFault();
    }

    public void doPing() {
        this.doPing(false, false);
    }

    public void doPing(boolean forceReadAllReportedProperties, boolean readSetValues) {
        boolean deviceIsDown = false;
        BAbsTime oldUpdateTime = null;
        String textValue = null;
        boolean typeMismatch = false;
        this.setExpectedApplicationId(this.getExpectedSensorType().getOrdinal());
        if (this.getDeviceId() == 0 || this.getSecurityCode().isEmpty()) {
            String errorString = String.format("Device ID must be nonzero and security code must not be empty", new Object[0]);
            BOnyxxMonnitNetwork.COMM_LOG.warning(errorString);
            BOnyxxMonnitNetwork.COMM_LOG.warning(String.format("(Device ID = %06d & security code = \"%s\")", this.getDeviceId(), this.getSecurityCode()));
            this.configFail(errorString);
            return;
        }
        if (!new File(this.getFullDevicePath()).exists()) {
            String errorString = String.format("Device %06d is not present in file system", this.getDeviceId());
            BOnyxxMonnitNetwork.COMM_LOG.error(errorString);
            this.configFail(errorString);
            this.setRegisteredWithWirelessGateway(false);
            return;
        }
        try {
            oldUpdateTime = this.getLastUpdateTime();
            textValue = OnyxxFileAccess.FileIO(this.getFullDevicePath(), PING_FILE_NAME, "", false);
            this.setLastUpdateTime(BAbsTime.make((long)(new Long(textValue) * 1000L)));
        }
        catch (Exception e) {
            BOnyxxMonnitNetwork.COMM_LOG.error("Error when reading ping file: ", (Throwable)e);
            if (e instanceof IOException) {
                this.configFail("Error when reading ping file: " + e);
            }
            return;
        }
        deviceIsDown = this.isOverdueForCheckIn();
        if (this.getLastUpdateTime().isAfter(oldUpdateTime) || BAbsTime.make().isBefore(this.getLastUpdateTime().add(BRelTime.make((long)10000L))) || deviceIsDown || this.getStatus().isFault() || this.getStatus().isDown() || forceReadAllReportedProperties) {
            try {
                textValue = OnyxxFileAccess.FileIO(this.getFullDevicePath(), SENSOR_TYPE_FILE_NAME, "", false);
                this.setReportedApplicationId(new Integer(textValue));
                this.setReportedSensorType(BOnyxxMonnitSensorTypeEnum.make(new Integer(textValue)));
            }
            catch (InvalidEnumException e) {
                String logString = String.format("Device %06d has unknown sensor type: Application ID %d", this.getDeviceId(), new Integer(textValue));
                BOnyxxMonnitNetwork.LOG.message(logString);
            }
            catch (Exception e) {
                BOnyxxMonnitNetwork.COMM_LOG.error("Error when reading sensor type file: ", (Throwable)e);
                if (e instanceof IOException) {
                    this.configFail("Error when reading sensor type file: " + e);
                }
                return;
            }
            try {
                textValue = OnyxxFileAccess.FileIO(this.getFullDevicePath(), REGISTERED_WITH_APN_FILE_NAME, "", false);
                this.setRegisteredWithWirelessGateway(textValue.equals("1"));
            }
            catch (Exception e) {
                BOnyxxMonnitNetwork.COMM_LOG.error("Error when reading gateway registration file: ", (Throwable)e);
                if (e instanceof IOException) {
                    this.configFail("Error when reading gateway registration file: " + e);
                }
                return;
            }
            try {
                textValue = OnyxxFileAccess.FileIO(this.getFullDevicePath() + CONFIG_DIR_NAME, HEARTBEAT_REPORTED_FILE_NAME, "", false);
                this.setHeartbeatTimeReported(BRelTime.make((long)(new Long(textValue) * 1000L)));
            }
            catch (Exception e) {
                BOnyxxMonnitNetwork.COMM_LOG.error("Error when reading reported heartbeat file: ", (Throwable)e);
                if (e instanceof IOException) {
                    this.configFail("Error when reading reported heartbeat file: " + e);
                }
                return;
            }
            typeMismatch = !this.getExpectedSensorType().equals((Object)this.getReportedSensorType());
            deviceIsDown = this.isOverdueForCheckIn();
            if (!typeMismatch && this.getRegisteredWithWirelessGateway() && !deviceIsDown || forceReadAllReportedProperties) {
                try {
                    textValue = OnyxxFileAccess.FileIO(this.getFullDevicePath() + CONFIG_DIR_NAME, AWARE_REPORTED_FILE_NAME, "", false);
                    this.setAwareHeartbeatTimeReported(BRelTime.make((long)(new Long(textValue) * 1000L)));
                }
                catch (Exception e) {
                    BOnyxxMonnitNetwork.COMM_LOG.error("Error when reading reported aware heartbeat file: ", (Throwable)e);
                    if (e instanceof IOException) {
                        this.configFail("Error when reading reported aware heartbeat file: " + e);
                    }
                    return;
                }
                try {
                    textValue = OnyxxFileAccess.FileIO(this.getFullDevicePath() + CONFIG_DIR_NAME, REC_LIMIT_REPORTED_FILE_NAME, "", false);
                    this.setRecoveryLimitReported(Integer.parseInt(textValue));
                }
                catch (Exception e) {
                    BOnyxxMonnitNetwork.COMM_LOG.error("Error when reading reported recovery limit file: ", (Throwable)e);
                    if (e instanceof IOException) {
                        this.configFail("Error when reading reported recovery limit file: " + e);
                    }
                    return;
                }
                try {
                    textValue = OnyxxFileAccess.FileIO(this.getFullDevicePath(), PING_ALT_FILE_NAME, "", false);
                    this.setLastUpdateTimeReportedBySensor(BAbsTime.make((long)(new Long(textValue) * 1000L)));
                }
                catch (Exception e) {
                    BOnyxxMonnitNetwork.COMM_LOG.error("Error when reading sensor time file: ", (Throwable)e);
                    if (e instanceof IOException) {
                        this.configFail("Error when reading sensor time file: " + e);
                    }
                    return;
                }
                try {
                    textValue = OnyxxFileAccess.FileIO(this.getFullDevicePath(), BATTERY_VOLTAGE_FILE_NAME, "", false);
                    this.setBatteryVoltage(new Float(textValue).floatValue());
                }
                catch (Exception e) {
                    BOnyxxMonnitNetwork.COMM_LOG.error("Error when reading battery voltage file: ", (Throwable)e);
                    if (e instanceof IOException) {
                        this.configFail("Error when reading battery voltage file: " + e);
                    }
                    return;
                }
                try {
                    textValue = OnyxxFileAccess.FileIO(this.getFullDevicePath(), APN_RSSI_FILE_NAME, "", false);
                    this.setApnRssi(new Integer(textValue));
                }
                catch (Exception e) {
                    BOnyxxMonnitNetwork.COMM_LOG.error("Error when reading APN RSSI file: ", (Throwable)e);
                    if (e instanceof IOException) {
                        this.configFail("Error when reading APN RSSI file: " + e);
                    }
                    return;
                }
                try {
                    textValue = OnyxxFileAccess.FileIO(this.getFullDevicePath(), FIELD_RSSI_FILE_NAME, "", false);
                    this.setFieldRssi(new Integer(textValue));
                }
                catch (Exception e) {
                    BOnyxxMonnitNetwork.COMM_LOG.error("Error when reading field RSSI file: ", (Throwable)e);
                    if (e instanceof IOException) {
                        this.configFail("Error when reading field RSSI file: " + e);
                    }
                    return;
                }
                if (!this.pingUniqueProperties(readSetValues)) {
                    return;
                }
            }
        }
        try {
            textValue = OnyxxFileAccess.FileIO(this.getFullDevicePath(), SETTINGS_UPDATE_PENDING_FILE_NAME, "", false);
            this.setSettingsUpdatePending(textValue.equals("1"));
        }
        catch (Exception e) {
            BOnyxxMonnitNetwork.COMM_LOG.error("Error when reported heartbeat file: ", (Throwable)e);
            if (e instanceof IOException) {
                this.configFail("Error when reading reported heartbeat file: " + e);
            }
            return;
        }
        if (readSetValues) {
            try {
                textValue = OnyxxFileAccess.FileIO(this.getFullDevicePath() + CONFIG_DIR_NAME, HEARTBEAT_SET_FILE_NAME, "", false);
                this.setHeartbeatTimeSet(BRelTime.make((long)(new Long(textValue) * 1000L)));
            }
            catch (Exception e) {
                BOnyxxMonnitNetwork.COMM_LOG.error("Error when reading set heartbeat file: ", (Throwable)e);
                if (e instanceof IOException) {
                    this.configFail("Error when reading set heartbeat file: " + e);
                }
                return;
            }
            try {
                textValue = OnyxxFileAccess.FileIO(this.getFullDevicePath() + CONFIG_DIR_NAME, AWARE_SET_FILE_NAME, "", false);
                this.setAwareHeartbeatTimeSet(BRelTime.make((long)(new Long(textValue) * 1000L)));
            }
            catch (Exception e) {
                BOnyxxMonnitNetwork.COMM_LOG.error("Error when reading set aware heartbeat file: ", (Throwable)e);
                if (e instanceof IOException) {
                    this.configFail("Error when reading set aware heartbeat file: " + e);
                }
                return;
            }
            try {
                textValue = OnyxxFileAccess.FileIO(this.getFullDevicePath() + CONFIG_DIR_NAME, REC_LIMIT_SET_FILE_NAME, "", false);
                this.setRecoveryLimitSet(Integer.parseInt(textValue));
            }
            catch (Exception e) {
                BOnyxxMonnitNetwork.COMM_LOG.error("Error when reading set recovery limit file: ", (Throwable)e);
                if (e instanceof IOException) {
                    this.configFail("Error when reading set recovery limit file: " + e);
                }
                return;
            }
        }
        if (typeMismatch) {
            BOnyxxMonnitNetwork.COMM_LOG.error(String.format("Error: Sensor %06d is wrong type; expected %s, got %s.", this.getDeviceId(), this.getExpectedSensorType().toString(), this.getReportedSensorType().toString()));
            this.configFail(String.format("Sensor type mismatch: Expected %s, sensor reports %s", this.getExpectedSensorType().toString(), this.getReportedSensorType().toString()));
            return;
        }
        if (!this.getRegisteredWithWirelessGateway()) {
            this.configFail("Device is not registered with wireless gateway; check security code");
            return;
        }
        this.configOk();
        if (deviceIsDown) {
            this.pingFail("Device is overdue for check-in");
            return;
        }
        this.pingOk();
    }

    public void doPingWithForcedSyncOfReadPropertiesOnly() {
        this.doPing(true, false);
    }

    public void doPingWithForcedSync() {
        this.doPing(true, true);
    }

    public BRelTime getCurrentHeartbeatBuffer() {
        BRelTime heartbeatBuffer = null;
        heartbeatBuffer = this.getHeartbeatBufferOverride();
        if (heartbeatBuffer.getMillis() == 0L) {
            heartbeatBuffer = this.getOnyxxMonnitNetwork().getSensorHeartbeatBuffer();
        }
        return heartbeatBuffer;
    }

    public String getFullDevicePath() {
        String networkPath = this.getOnyxxMonnitNetwork().getNetworkPath();
        String devicePath = this.getDevicePath();
        return networkPath + devicePath;
    }

    public final BOnyxxMonnitNetwork getOnyxxMonnitNetwork() {
        return (BOnyxxMonnitNetwork)this.getNetwork();
    }

    public boolean isOverdueForCheckIn() {
        return BAbsTime.make().isAfter(this.getExpectedNextCheckIn().add(this.getCurrentHeartbeatBuffer()));
    }

    protected boolean pingUniqueProperties(boolean readSetValues) {
        return true;
    }
}

