/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.point;

import com.lynxspring.onyxxDriver.enums.BPointTypeEnum;
import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.lynxspring.onyxxDriver.point.BIOnyxxWritable;
import com.lynxspring.onyxxDriver.point.BOnyxxProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxVoltageInputProxyExt;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BNull;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

@NiagaraType
public class BOnyxxVoltageOutputProxyExt
extends BOnyxxProxyExt
implements BIOnyxxWritable {
    public static final Type TYPE = Sys.loadType(BOnyxxVoltageOutputProxyExt.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BOnyxxVoltageOutputProxyExt() {
        if (this.getDeviceFacets().get("units", (BObject)BNull.DEFAULT) != BUnit.getUnit((String)"volt")) {
            this.setDeviceFacets(BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt")));
        }
        if (this.getPointType().equals((Object)BPointTypeEnum.DEFAULT)) {
            this.setPointType(BPointTypeEnum.voltageOutput);
        }
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.writeFile();
    }

    @Override
    public String getOutputFilename() {
        return "value";
    }

    @Override
    public String getStringValue() {
        String strValue = "" + ((BStatusNumeric)this.getWriteValue()).getNumeric();
        if (!strValue.equals("null")) {
            double currentValue = Math.max(Math.min(Double.parseDouble(strValue), 10.0), 0.0);
            int rawValue = (int)(currentValue * 409.5);
            strValue = "" + rawValue;
        }
        return strValue;
    }

    @Override
    public void readFile() {
        try {
            this.variableSleep();
            String valueFileValue = "";
            valueFileValue = OnyxxFileAccess.FileIO(this.getFullPointPath(), "value", "", false);
            float raw = Float.parseFloat(valueFileValue);
            this.setRaw(raw);
            this.readOk((BStatusValue)new BStatusNumeric(BOnyxxVoltageInputProxyExt.convert(this.getRaw())));
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                BOnyxxNetwork.COMM_LOG.error("Voltage Output Read Error\n\t\tSlot Path: " + this.getSlotPath() + "\n\t\tPoint Path: " + this.getFullPointPath(), (Throwable)e);
                this.readFail(e.getMessage());
                this.getOnyxxDevice().checkDevice();
            }
            BOnyxxNetwork.COMM_LOG.trace(e.getMessage());
        }
    }
}

