/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.point;

import com.lynxspring.onyxxDriver.enums.BPointTypeEnum;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.lynxspring.onyxxDriver.point.BIOnyxxConvertedInput;
import com.lynxspring.onyxxDriver.point.BOnyxxUniversalInputProxyExt;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BNull;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

@NiagaraType
public class BOnyxxVoltageInputProxyExt
extends BOnyxxUniversalInputProxyExt
implements BIOnyxxConvertedInput {
    public static final Type TYPE = Sys.loadType(BOnyxxVoltageInputProxyExt.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BOnyxxVoltageInputProxyExt() {
        if (this.getDeviceFacets().get("units", (BObject)BNull.DEFAULT) != BUnit.getUnit((String)"volt")) {
            this.setDeviceFacets(BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"volt")));
        }
        if (this.getPointType().equals((Object)BPointTypeEnum.DEFAULT)) {
            this.setPointType(BPointTypeEnum.voltageInput);
        }
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (!this.getPointType().equals((Object)BPointTypeEnum.voltageInput)) {
            String msg = "Point Type is not voltage input";
            BOnyxxNetwork.LOG.warning(msg);
        }
    }

    @Override
    public double convertReadValue() {
        if (this.getHysteresis()) {
            return BOnyxxVoltageInputProxyExt.convert(this.getHysteresisValue());
        }
        return BOnyxxVoltageInputProxyExt.convert(this.getRaw());
    }

    static double convert(double value) {
        return (float)value / 409.5f;
    }
}

