/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.point;

import com.lynxspring.onyxxDriver.conv.BCfmAtOneInchWcConversion;
import com.lynxspring.onyxxDriver.conv.BKFactorConversion;
import com.lynxspring.onyxxDriver.conv.BVavConversion;
import com.lynxspring.onyxxDriver.enums.BPointTypeEnum;
import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.lynxspring.onyxxDriver.point.BOnyxxProxyExt;
import com.lynxspring.onyxxDriver.point.BResetPoint;
import com.lynxspring.platOnyxx.BOnyxxPlatformService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.baja.alarm.ext.fault.BOutOfRangeFaultAlgorithm;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BNull;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="diffPressureLowerLimit", type="double", defaultValue="0.03", flags=12, facets={@Facet(value="BFacets.makeInt(UnitDatabase.getUnit(\"inches of water\"))"), @Facet(value="BFacets.make(\"min\", BDouble.make(0.015), \"max\", BDouble.make(0.03))"), @Facet(value="BFacets.make(\"precision\", BInteger.make(3))")}), @NiagaraProperty(name="minMeasurableCfm", type="double", defaultValue="0.00", flags=1, facets={@Facet(value="BFacets.makeInt(UnitDatabase.getUnit(\"cubic feet per minute\"))"), @Facet(value="BFacets.make(\"min\", BDouble.NEGATIVE_INFINITY, \"max\", BDouble.POSITIVE_INFINITY)"), @Facet(value="BFacets.make(\"precision\", BInteger.make(2))")}), @NiagaraProperty(name="expectedRawValueAtDiffPressureLowerLimit", type="double", defaultValue="0.00", flags=1), @NiagaraProperty(name="differentialPressure", type="double", defaultValue="0", flags=1, facets={@Facet(value="BFacets.makeInt(UnitDatabase.getUnit(\"inches of water\"))"), @Facet(value="BFacets.make(\"min\", BDouble.NEGATIVE_INFINITY, \"max\", BDouble.POSITIVE_INFINITY)"), @Facet(value="BFacets.make(\"precision\", BInteger.make(3))")}), @NiagaraProperty(name="hysteresis", type="boolean", defaultValue="false", flags=4, facets={@Facet(value="BFacets.makeBoolean(\"Enabled\", \"Disabled\")")}), @NiagaraProperty(name="hysteresisSize", type="int", defaultValue="10", flags=4), @NiagaraProperty(name="cfm_1inch", type="double", defaultValue="0", flags=4), @NiagaraProperty(name="divisionsAboveMinimumMeasurablePressure", type="int", defaultValue="0", flags=5), @NiagaraProperty(name="divisionsBelowMinimumMeasurablePressure", type="int", defaultValue="2", flags=4), @NiagaraProperty(name="cfmStepSize", type="int", defaultValue="1", flags=4, facets={@Facet(value="BFacets.makeInt(UnitDatabase.getUnit(\"cubic feet per minute\"))")}), @NiagaraProperty(name="startTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=5), @NiagaraProperty(name="lastReset", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=5), @NiagaraProperty(name="lastCalibration", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=5), @NiagaraProperty(name="lastDamperPositionChange", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=5), @NiagaraProperty(name="lastFeedbackPositionChange", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=5), @NiagaraProperty(name="damperPosition", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=5), @NiagaraProperty(name="feedbackPosition", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=5), @NiagaraProperty(name="previousDamperPosition", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=5), @NiagaraProperty(name="previousFeedbackPosition", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=5), @NiagaraProperty(name="commandedDamperPosition", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=5), @NiagaraProperty(name="continueResetAfterLimit", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="numberOfResets", type="BResetPoint", defaultValue="new BResetPoint()", flags=5)})
@NiagaraAction(name="recalibrate", flags=4)
public class BOnyxxVavPressureInputProxyExt
extends BOnyxxProxyExt {
    public static final Property diffPressureLowerLimit = BOnyxxVavPressureInputProxyExt.newProperty((int)12, (double)0.03, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"inches of water")), (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)0.015), (String)"max", (BIDataValue)BDouble.make((double)0.03))), (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)3))));
    public static final Property minMeasurableCfm = BOnyxxVavPressureInputProxyExt.newProperty((int)1, (double)0.0, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"cubic feet per minute")), (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.NEGATIVE_INFINITY, (String)"max", (BIDataValue)BDouble.POSITIVE_INFINITY)), (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)2))));
    public static final Property expectedRawValueAtDiffPressureLowerLimit = BOnyxxVavPressureInputProxyExt.newProperty((int)1, (double)0.0, null);
    public static final Property differentialPressure = BOnyxxVavPressureInputProxyExt.newProperty((int)1, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"inches of water")), (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.NEGATIVE_INFINITY, (String)"max", (BIDataValue)BDouble.POSITIVE_INFINITY)), (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)3))));
    public static final Property hysteresis = BOnyxxVavPressureInputProxyExt.newProperty((int)4, (boolean)false, (BFacets)BFacets.makeBoolean((String)"Enabled", (String)"Disabled"));
    public static final Property hysteresisSize = BOnyxxVavPressureInputProxyExt.newProperty((int)4, (int)10, null);
    public static final Property cfm_1inch = BOnyxxVavPressureInputProxyExt.newProperty((int)4, (int)0, null);
    public static final Property divisionsAboveMinimumMeasurablePressure = BOnyxxVavPressureInputProxyExt.newProperty((int)5, (int)0, null);
    public static final Property divisionsBelowMinimumMeasurablePressure = BOnyxxVavPressureInputProxyExt.newProperty((int)4, (int)2, null);
    public static final Property cfmStepSize = BOnyxxVavPressureInputProxyExt.newProperty((int)4, (int)1, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"cubic feet per minute")));
    public static final Property startTime = BOnyxxVavPressureInputProxyExt.newProperty((int)5, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastReset = BOnyxxVavPressureInputProxyExt.newProperty((int)5, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastCalibration = BOnyxxVavPressureInputProxyExt.newProperty((int)5, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastDamperPositionChange = BOnyxxVavPressureInputProxyExt.newProperty((int)5, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastFeedbackPositionChange = BOnyxxVavPressureInputProxyExt.newProperty((int)5, (BValue)BAbsTime.DEFAULT, null);
    public static final Property damperPosition = BOnyxxVavPressureInputProxyExt.newProperty((int)5, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property feedbackPosition = BOnyxxVavPressureInputProxyExt.newProperty((int)5, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property previousDamperPosition = BOnyxxVavPressureInputProxyExt.newProperty((int)5, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property previousFeedbackPosition = BOnyxxVavPressureInputProxyExt.newProperty((int)5, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property commandedDamperPosition = BOnyxxVavPressureInputProxyExt.newProperty((int)5, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property continueResetAfterLimit = BOnyxxVavPressureInputProxyExt.newProperty((int)4, (boolean)true, null);
    public static final Property numberOfResets = BOnyxxVavPressureInputProxyExt.newProperty((int)5, (BValue)new BResetPoint(), null);
    public static final Action recalibrate = BOnyxxVavPressureInputProxyExt.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BOnyxxVavPressureInputProxyExt.class);
    Thread thread;
    protected Float[] hysteresisArray = null;
    protected int currentHysteresisIndex;
    private int calibrationFactor = 0;
    private double lastReading = 0.0;
    private int numberOfReadingsAtCurrentStep = 0;
    protected static final int ZERO_DELTA_PRESSURE = 8191;
    protected static final float MAX_WATER_COLUMN = 2.0f;
    public static final float EQUATION_CONSTANT = 4005.0f;
    public static final int MAX_READINGS_AT_CURRENT_STEP = 3;
    public static Log COMM_LOG = Log.getLog((String)(Sys.getModuleForClass(BOnyxxNetwork.class).getModuleName() + "Comm"));

    public double getDiffPressureLowerLimit() {
        return this.getDouble(diffPressureLowerLimit);
    }

    public void setDiffPressureLowerLimit(double v) {
        this.setDouble(diffPressureLowerLimit, v, null);
    }

    public double getMinMeasurableCfm() {
        return this.getDouble(minMeasurableCfm);
    }

    public void setMinMeasurableCfm(double v) {
        this.setDouble(minMeasurableCfm, v, null);
    }

    public double getExpectedRawValueAtDiffPressureLowerLimit() {
        return this.getDouble(expectedRawValueAtDiffPressureLowerLimit);
    }

    public void setExpectedRawValueAtDiffPressureLowerLimit(double v) {
        this.setDouble(expectedRawValueAtDiffPressureLowerLimit, v, null);
    }

    public double getDifferentialPressure() {
        return this.getDouble(differentialPressure);
    }

    public void setDifferentialPressure(double v) {
        this.setDouble(differentialPressure, v, null);
    }

    public boolean getHysteresis() {
        return this.getBoolean(hysteresis);
    }

    public void setHysteresis(boolean v) {
        this.setBoolean(hysteresis, v, null);
    }

    public int getHysteresisSize() {
        return this.getInt(hysteresisSize);
    }

    public void setHysteresisSize(int v) {
        this.setInt(hysteresisSize, v, null);
    }

    public double getCfm_1inch() {
        return this.getDouble(cfm_1inch);
    }

    public void setCfm_1inch(double v) {
        this.setDouble(cfm_1inch, v, null);
    }

    public int getDivisionsAboveMinimumMeasurablePressure() {
        return this.getInt(divisionsAboveMinimumMeasurablePressure);
    }

    public void setDivisionsAboveMinimumMeasurablePressure(int v) {
        this.setInt(divisionsAboveMinimumMeasurablePressure, v, null);
    }

    public int getDivisionsBelowMinimumMeasurablePressure() {
        return this.getInt(divisionsBelowMinimumMeasurablePressure);
    }

    public void setDivisionsBelowMinimumMeasurablePressure(int v) {
        this.setInt(divisionsBelowMinimumMeasurablePressure, v, null);
    }

    public int getCfmStepSize() {
        return this.getInt(cfmStepSize);
    }

    public void setCfmStepSize(int v) {
        this.setInt(cfmStepSize, v, null);
    }

    public BAbsTime getStartTime() {
        return (BAbsTime)this.get(startTime);
    }

    public void setStartTime(BAbsTime v) {
        this.set(startTime, (BValue)v, null);
    }

    public BAbsTime getLastReset() {
        return (BAbsTime)this.get(lastReset);
    }

    public void setLastReset(BAbsTime v) {
        this.set(lastReset, (BValue)v, null);
    }

    public BAbsTime getLastCalibration() {
        return (BAbsTime)this.get(lastCalibration);
    }

    public void setLastCalibration(BAbsTime v) {
        this.set(lastCalibration, (BValue)v, null);
    }

    public BAbsTime getLastDamperPositionChange() {
        return (BAbsTime)this.get(lastDamperPositionChange);
    }

    public void setLastDamperPositionChange(BAbsTime v) {
        this.set(lastDamperPositionChange, (BValue)v, null);
    }

    public BAbsTime getLastFeedbackPositionChange() {
        return (BAbsTime)this.get(lastFeedbackPositionChange);
    }

    public void setLastFeedbackPositionChange(BAbsTime v) {
        this.set(lastFeedbackPositionChange, (BValue)v, null);
    }

    public BStatusNumeric getDamperPosition() {
        return (BStatusNumeric)this.get(damperPosition);
    }

    public void setDamperPosition(BStatusNumeric v) {
        this.set(damperPosition, (BValue)v, null);
    }

    public BStatusNumeric getFeedbackPosition() {
        return (BStatusNumeric)this.get(feedbackPosition);
    }

    public void setFeedbackPosition(BStatusNumeric v) {
        this.set(feedbackPosition, (BValue)v, null);
    }

    public BStatusNumeric getPreviousDamperPosition() {
        return (BStatusNumeric)this.get(previousDamperPosition);
    }

    public void setPreviousDamperPosition(BStatusNumeric v) {
        this.set(previousDamperPosition, (BValue)v, null);
    }

    public BStatusNumeric getPreviousFeedbackPosition() {
        return (BStatusNumeric)this.get(previousFeedbackPosition);
    }

    public void setPreviousFeedbackPosition(BStatusNumeric v) {
        this.set(previousFeedbackPosition, (BValue)v, null);
    }

    public BStatusNumeric getCommandedDamperPosition() {
        return (BStatusNumeric)this.get(commandedDamperPosition);
    }

    public void setCommandedDamperPosition(BStatusNumeric v) {
        this.set(commandedDamperPosition, (BValue)v, null);
    }

    public boolean getContinueResetAfterLimit() {
        return this.getBoolean(continueResetAfterLimit);
    }

    public void setContinueResetAfterLimit(boolean v) {
        this.setBoolean(continueResetAfterLimit, v, null);
    }

    public BResetPoint getNumberOfResets() {
        return (BResetPoint)this.get(numberOfResets);
    }

    public void setNumberOfResets(BResetPoint v) {
        this.set(numberOfResets, (BValue)v, null);
    }

    public void recalibrate() {
        this.invoke(recalibrate, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BOnyxxVavPressureInputProxyExt() {
        if (this.getDeviceFacets().get("units", (BObject)BNull.DEFAULT) != BUnit.getUnit((String)"inches of water")) {
            this.setDeviceFacets(BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"inches of water")));
        }
        if (this.getPointType().equals((Object)BPointTypeEnum.DEFAULT)) {
            this.setPointType(BPointTypeEnum.pressureInput);
        }
    }

    @Override
    public void started() throws Exception {
        this.instantiateHysteresisArray();
        super.started();
        if (this.getParentPoint().getFacets().get("units", (BObject)BNull.DEFAULT) != BUnit.getUnit((String)"cubic feet per minute")) {
            this.getParentPoint().setFacets(BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"cubic feet per minute")));
        }
        this.calculateExpectedRawValue();
        this.calculateMinMeasurableCFM();
        this.calculateCfmStepProperties();
        this.setStartTime(BAbsTime.now());
        this.setLastReset(BAbsTime.now());
        this.getNumberOfResets().set(BDouble.make((double)0.0));
    }

    @Override
    public void changed(Property p, Context cx) {
        BProxyConversion pc;
        if (!this.isRunning() || cx == Context.decoding) {
            return;
        }
        if (p == hysteresisSize) {
            this.hysteresisArray = null;
            this.instantiateHysteresisArray();
            BOnyxxNetwork.LOG.trace("Hysteresis array size was changed to " + this.getHysteresisSize() + " for point " + this.getParent().getDisplayName(null) + ".");
        }
        if (p == cfm_1inch && (pc = this.getConversion()).getType().is(BCfmAtOneInchWcConversion.TYPE)) {
            BCfmAtOneInchWcConversion conv = (BCfmAtOneInchWcConversion)pc;
            conv.setcfm1inch(this.getCfm_1inch());
        }
        this.calculateExpectedRawValue();
        this.calculateMinMeasurableCFM();
        this.calculateCfmStepProperties();
    }

    public void doRecalibrate() throws Exception {
        COMM_LOG.trace("Device Path " + this.getDevicePath());
        Calibrate_Thread t = new Calibrate_Thread();
        t.setDevicePath(this.getDevicePath());
        this.thread = new Thread((Runnable)t, "Calibrate");
        this.thread.start();
    }

    @Override
    public void readFile() {
        BVavConversion conv;
        BProxyConversion pc = this.getConversion();
        if (pc instanceof BCfmAtOneInchWcConversion) {
            conv = (BCfmAtOneInchWcConversion)pc;
            if (((BCfmAtOneInchWcConversion)conv).getcfm1inch() == 0.0) {
                this.readFail("CFM Value needs set in conversion!  Currently set at 0");
                return;
            }
        } else if (pc instanceof BKFactorConversion) {
            conv = (BKFactorConversion)pc;
            if (((BKFactorConversion)conv).getK_factor() == 0.0 || ((BKFactorConversion)conv).getCrossSectional() == 0.0) {
                this.readFail("K-Factor or Cross-Sectional Area values need set in conversion!  Currently one or both are set at 0");
                return;
            }
        } else {
            this.readFail("Incorrect Conversion Used!");
            return;
        }
        float raw = 0.0f;
        try {
            String valueFileValue = "";
            valueFileValue = OnyxxFileAccess.FileIO(this.getFullPointPath(), "value", "", false);
            raw = Float.parseFloat(valueFileValue);
            raw = this.checkRawValuePressure(raw);
            this.setRaw(raw);
            this.addHysteresisValue(raw);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                BOnyxxNetwork.COMM_LOG.error("VAV Pressure Input Read Error\n\t\tSlot Path: " + this.getSlotPath() + "\n\t\tPoint Path:  " + this.getFullPointPath(), (Throwable)e);
                this.readFail(e.getMessage());
                this.getOnyxxDevice().checkDevice();
            }
            BOnyxxNetwork.COMM_LOG.trace(e.getMessage());
        }
        this.readOk((BStatusValue)new BStatusNumeric(this.convertReadValue()));
        this.checkPressureSensor();
    }

    private float checkRawValuePressure(float x) {
        if (x > 16383.0f) {
            x = 0.0f;
        }
        return x;
    }

    public static String removeSpace(String s) {
        String withoutspaces = "";
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == ' ') continue;
            withoutspaces = withoutspaces + s.charAt(i);
        }
        return withoutspaces;
    }

    public double convertReadValue() {
        float value = (float)this.getRaw();
        float diffPressure = 0.0f;
        if (this.getHysteresis()) {
            value = (float)this.getHysteresisValue();
        }
        if ((value += (float)this.calibrationFactor) > 16383.0f) {
            value = 16383.0f;
        }
        if (value < 0.0f) {
            value = 0.0f;
        }
        if ((diffPressure = (value - 8191.0f) * 2.4417043E-4f) < 0.0f) {
            diffPressure = 0.0f;
        }
        this.setDifferentialPressure(diffPressure);
        return diffPressure;
    }

    public double calculateExpectedRawValue() {
        double expectedRawValue = this.getDiffPressureLowerLimit() / 2.441704273223877E-4 + 8191.0;
        this.setExpectedRawValueAtDiffPressureLowerLimit(expectedRawValue);
        return expectedRawValue;
    }

    public double calculateMinMeasurableCFM() {
        double minMeasurableCFM = this.calculateSpecificCFM(this.getDiffPressureLowerLimit() / 2.0);
        this.setMinMeasurableCfm(minMeasurableCFM);
        return minMeasurableCFM;
    }

    public double calculateSpecificCFM(double differentialPressure) {
        BProxyConversion pc = this.getConversion();
        double calculatedCFM = 0.0;
        if (pc instanceof BVavConversion) {
            BVavConversion conv = (BVavConversion)pc;
            calculatedCFM = conv.convertValue(differentialPressure, true);
        }
        return calculatedCFM;
    }

    public int calculateCfmStepProperties() {
        int cfmStepCount = 0;
        double maxCfm = 0.0;
        maxCfm = this.calculateSpecificCFM(2.0);
        cfmStepCount = (int)Math.ceil((maxCfm - this.getCfmForMinimumMeasurablePressure()) / (double)this.getCfmStepSize());
        this.setDivisionsAboveMinimumMeasurablePressure(cfmStepCount);
        return cfmStepCount;
    }

    public double getCfmForMinimumMeasurablePressure() {
        return this.calculateSpecificCFM(this.getDiffPressureLowerLimit());
    }

    protected void instantiateHysteresisArray() {
        if (this.hysteresisArray != null) {
            return;
        }
        this.hysteresisArray = new Float[this.getHysteresisSize()];
        for (int x = 0; x < this.getHysteresisSize(); ++x) {
            this.hysteresisArray[x] = null;
        }
        this.currentHysteresisIndex = 0;
    }

    protected double getHysteresisValue() {
        int x;
        double totalSum = 0.0;
        for (x = 0; x < this.getHysteresisSize() && this.hysteresisArray[x] != null; ++x) {
            totalSum += this.hysteresisArray[x].doubleValue();
        }
        return x == 0 ? totalSum : totalSum / (double)x;
    }

    protected void addHysteresisValue(float value) {
        this.hysteresisArray[this.currentHysteresisIndex] = new Float(value);
        ++this.currentHysteresisIndex;
        if (this.currentHysteresisIndex >= this.getHysteresisSize()) {
            this.currentHysteresisIndex = 0;
        }
    }

    public double getLastReading() {
        return this.lastReading;
    }

    public void setLastReading(double newReading) {
        this.lastReading = newReading;
    }

    public int getNumberOfReadingsAtCurrentStep() {
        return this.numberOfReadingsAtCurrentStep;
    }

    public void setNumberOfReadingsAtCurrentStep(int newNumber) {
        if (newNumber < 0) {
            newNumber = 0;
        }
        if (newNumber > 3) {
            newNumber = 3;
        }
        this.numberOfReadingsAtCurrentStep = newNumber;
    }

    public void checkPressureSensor() {
        if (this.getNumberOfResets().getNumeric() > ((BOutOfRangeFaultAlgorithm)this.getNumberOfResets().getResetAlarm().getFaultAlgorithm()).getHighLimit() && !this.getContinueResetAfterLimit()) {
            return;
        }
        double pressure_raw = this.getRaw();
        if (pressure_raw > 3500.0 && pressure_raw < 4100.0) {
            COMM_LOG.trace("raw value is  " + pressure_raw + " - Resetting - " + BAbsTime.now());
            this.cycle_pressure_sensor();
            this.setLastReset(BAbsTime.now());
            double numResetVal = 0.0;
            numResetVal = BRelTime.make((long)(this.getLastReset().getMillis() - this.getStartTime().getMillis())).getHours() >= 24 ? 1.0 : this.getNumberOfResets().getNumeric() + 1.0;
            this.getNumberOfResets().set(BDouble.make((double)numResetVal));
        }
        double feedback_position = this.getFeedbackPosition().getNumeric();
        double damper_position = this.getDamperPosition().getNumeric();
        double last_feedback_position = this.getPreviousFeedbackPosition().getNumeric();
        double last_damper_position = this.getPreviousDamperPosition().getNumeric();
        if (damper_position > last_damper_position + 2.0 || damper_position < last_damper_position - 2.0) {
            COMM_LOG.trace("damper postion changed");
            this.setPreviousDamperPosition(new BStatusNumeric(this.getDamperPosition().getValue(), this.getDamperPosition().getStatus()));
            this.setLastDamperPositionChange(BAbsTime.now());
        }
        if (feedback_position > last_feedback_position + 2.0 || feedback_position < last_feedback_position - 2.0) {
            COMM_LOG.trace("feedback position changed");
            this.setPreviousFeedbackPosition(new BStatusNumeric(this.getFeedbackPosition().getValue(), this.getFeedbackPosition().getStatus()));
            this.setLastFeedbackPositionChange(BAbsTime.now());
        }
        COMM_LOG.trace("feedback position " + feedback_position);
        if (feedback_position < -2.0) {
            COMM_LOG.trace("Feedback position is less than zero, actuator is not plugged in");
            return;
        }
        if (damper_position > feedback_position) {
            if (damper_position - feedback_position < 10.0) {
                COMM_LOG.trace("Difference is less than 10 don't reset");
                return;
            }
        } else if (damper_position < feedback_position) {
            if (feedback_position - damper_position < 10.0) {
                COMM_LOG.trace("difference is less than 10 don't reset");
                return;
            }
        } else {
            if (damper_position >= 95.0) {
                COMM_LOG.trace("damper position is greater than 95% don't reset");
                return;
            }
            if (damper_position <= 5.0) {
                COMM_LOG.trace("Damper position is less than 5 % don't reset");
                return;
            }
        }
        if (this.getLastFeedbackPositionChange().add(BRelTime.make((long)60000L)).isBefore(BAbsTime.now())) {
            COMM_LOG.trace("More than a minute since last significant change");
            if ((feedback_position <= 10.0 || feedback_position >= 90.0) && damper_position > 10.0 && damper_position < 90.0 && this.getNumberOfResets().getNumeric() < 10.0 && this.getLastReset().add(BRelTime.make((long)300000L)).isBefore(BAbsTime.now())) {
                COMM_LOG.trace("Feedback is " + feedback_position + " and Damper Position is greater than 10 and less than 90 - Resetting - " + BAbsTime.now());
                this.cycle_pressure_sensor();
                this.setLastReset(BAbsTime.now());
                this.getNumberOfResets().set(BDouble.make((double)(this.getNumberOfResets().getNumeric() + 1.0)));
            }
        }
        if (this.getLastFeedbackPositionChange().add(BRelTime.make((long)60000L)).isBefore(BAbsTime.now()) && this.getLastDamperPositionChange().add(BRelTime.make((long)60000L)).isBefore(BAbsTime.now())) {
            COMM_LOG.trace("More than a minute since last significant change damper and feedback");
            if (damper_position > feedback_position) {
                if (damper_position - feedback_position > 20.0 && this.getNumberOfResets().getNumeric() < 1000.0 && this.getLastReset().add(BRelTime.make((long)300000L)).isBefore(BAbsTime.now())) {
                    COMM_LOG.trace("Feedback and Damper Position are more than 10% apart for more than a min - Resetting - " + BAbsTime.now());
                    this.cycle_pressure_sensor();
                    this.setLastReset(BAbsTime.now());
                    this.getNumberOfResets().set(BDouble.make((double)(this.getNumberOfResets().getNumeric() + 1.0)));
                }
            } else if (damper_position < feedback_position && feedback_position - damper_position > 20.0 && this.getNumberOfResets().getNumeric() < 1000.0 && this.getLastReset().add(BRelTime.make((long)300000L)).isBefore(BAbsTime.now())) {
                COMM_LOG.trace("Feedback and Damper Position are more than 10% apart for more than a min - Resetting - " + BAbsTime.now());
                this.cycle_pressure_sensor();
                this.setLastReset(BAbsTime.now());
                this.getNumberOfResets().set(BDouble.make((double)(this.getNumberOfResets().getNumeric() + 1.0)));
            }
        }
    }

    public void cycle_pressure_sensor() {
        this.reset_dac();
        COMM_LOG.trace("Resetting DAC");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.turn_off_pressure_sensor();
        COMM_LOG.trace("Turning off pressure sensor");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.turn_on_pressure_sensor();
        COMM_LOG.trace("Turning on pressure sensor");
    }

    public void reset_dac() {
        this.write_to_can("55", "AA", "04");
    }

    public void turn_on_pressure_sensor() {
        this.write_to_can("33", "10", "01");
    }

    public void turn_off_pressure_sensor() {
        this.write_to_can("33", "10", "00");
    }

    public String getDevicePath() {
        BDevice device = this.getDevice();
        if (device != null) {
            COMM_LOG.trace("property " + device.getProperty("devicePath"));
            String device_path = ((BString)device.get(device.getProperty("devicePath"))).toString();
            COMM_LOG.trace("Device Found " + device_path);
            return device_path;
        }
        return "";
    }

    public void turn_off_config_mode() {
        this.write_to_can("35", "1e", "00");
    }

    public void turn_on_config_mode() {
        this.write_to_can("35", "1e", "01");
    }

    public void turn_off_rolling_average() {
        this.write_to_can("35", "17", "00");
    }

    public void turn_on_rolling_average() {
        this.write_to_can("35", "17", "01");
    }

    public String generate_offset_payload(int value) {
        String formatted_lower_byte;
        String formatted_upper_byte;
        String payload = "";
        if (value >= 256) {
            int upper_byte = value / 256;
            int lower_byte = value - 256 * upper_byte;
            formatted_upper_byte = String.format("%02X", upper_byte);
            formatted_lower_byte = String.format("%02X", lower_byte);
        } else {
            int lower_byte = value;
            formatted_upper_byte = "00";
            formatted_lower_byte = String.format("%02X", lower_byte);
        }
        payload = formatted_upper_byte + formatted_lower_byte;
        return payload;
    }

    public String generate_calibration_payload(int value) {
        String formatted_byte_0;
        String string;
        String formatted_byte_1;
        String formatted_byte_2;
        String formatted_byte_3;
        String payload = "";
        boolean negative = false;
        int t_value = 0;
        int byte_3 = 0;
        int byte_2 = 0;
        int byte_1 = 0;
        int byte_0 = 0;
        String formatted_negative = "00";
        if (value < 0) {
            negative = true;
            t_value = value * -1;
            formatted_negative = "01";
        }
        if (value >= 256 && t_value <= 65535) {
            byte_1 = t_value / 256;
            byte_0 = t_value - 256 * byte_1;
            formatted_byte_3 = "00";
            formatted_byte_2 = "00";
            formatted_byte_1 = String.format("%02X", byte_1);
            string = String.format("%02X", byte_0);
        }
        if (value >= 65535 && t_value <= 0xFFFFFF) {
            byte_2 = t_value / 65535;
            byte_1 = (t_value -= byte_2 * 65535) / 256;
            byte_0 = t_value - 256 * byte_1;
            formatted_byte_3 = "00";
            formatted_byte_2 = String.format("%02X", byte_2);
            formatted_byte_1 = String.format("%02X", byte_1);
            string = String.format("%02X", byte_0);
        }
        if (value >= 0x1000000) {
            byte_3 = t_value / 0x1000000;
            byte_2 = (t_value -= byte_3 * 0x1000000) / 65535;
            byte_1 = (t_value -= byte_2 * 65535) / 256;
            byte_0 = t_value - 256 * byte_1;
            formatted_byte_3 = String.format("%02X", byte_3);
            formatted_byte_2 = String.format("%02X", byte_2);
            formatted_byte_1 = String.format("%02X", byte_1);
            formatted_byte_0 = String.format("%02X", byte_0);
        } else {
            byte_0 = t_value;
            formatted_byte_3 = "00";
            formatted_byte_2 = "00";
            formatted_byte_1 = "00";
            formatted_byte_0 = String.format("%02X", byte_0);
        }
        payload = formatted_byte_3 + formatted_byte_2 + formatted_byte_1 + formatted_byte_0 + formatted_negative;
        return payload;
    }

    public void write_to_can(String canService, String command, String payload) {
        String address = "000001";
        try {
            BOnyxxPlatformService service = (BOnyxxPlatformService)Sys.getService((Type)BOnyxxPlatformService.TYPE);
            service.doSendOnyxxMessage(address, canService, command, payload);
            COMM_LOG.trace("Sending Can Message Address " + address + " Service " + canService + " command " + command + " Payload " + payload);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void write_offset_to_can(int value) {
        String address = "000001";
        String canService = "35";
        String command = "18";
        String payload = this.generate_offset_payload(value);
        try {
            BOnyxxPlatformService service = (BOnyxxPlatformService)Sys.getService((Type)BOnyxxPlatformService.TYPE);
            service.doSendOnyxxMessage(address, canService, command, payload);
            COMM_LOG.trace("Sending Can Message Address " + address + " Service " + canService + " command " + command + " Payload " + payload);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void write_calibration_to_can(int value) {
        String address = "000001";
        String canService = "35";
        String command = "14";
        String payload = this.generate_calibration_payload(value);
        try {
            BOnyxxPlatformService service = (BOnyxxPlatformService)Sys.getService((Type)BOnyxxPlatformService.TYPE);
            service.doSendOnyxxMessage(address, canService, command, payload);
            COMM_LOG.trace("Sending Can Message Address " + address + " Service " + canService + " command " + command + " Payload " + payload);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getTempReading() {
        String dp = this.getDevicePath();
        File file = new File("/home/niagara/shared/mp/" + dp + "vav/t.0/", "value");
        String temp = "";
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            temp = br.readLine().trim();
            COMM_LOG.trace("Temp Read " + temp);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return temp;
    }

    public String getTempReading(String dp) {
        File file = new File("/home/niagara/shared/mp/" + dp + "vav/t.0/", "value");
        String temp = "";
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            temp = br.readLine().trim();
            COMM_LOG.trace("Temp Read " + temp);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return temp;
    }

    public String getPressureReading() {
        String dp = this.getDevicePath();
        COMM_LOG.trace(dp);
        File file = new File("/home/niagara/shared/mp/" + dp + "vav/p.0/", "value");
        String temp = "";
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            temp = br.readLine().trim();
            COMM_LOG.trace("Temp Read " + temp);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return temp;
    }

    public String getPressureReading(String dp) {
        COMM_LOG.trace(dp);
        File file = new File("/home/niagara/shared/mp/" + dp + "vav/p.0/", "value");
        String temp = "";
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            temp = br.readLine().trim();
            COMM_LOG.trace("Temp Read " + temp);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return temp;
    }

    private class Calibrate_Thread
    implements Runnable {
        String device_path;

        private Calibrate_Thread() {
        }

        public void setDevicePath(String d) {
            this.device_path = d;
        }

        @Override
        public void run() {
            double average_reading = 0.0;
            double average_temp = 0.0;
            double calibration = 0.0;
            double temp_comp = 0.0;
            double reading_total = 0.0;
            double temp_total = 0.0;
            COMM_LOG.trace("Calibrate Thread " + this.device_path);
            BOnyxxVavPressureInputProxyExt.this.setLastCalibration(BAbsTime.now());
            String first_pres_read = BOnyxxVavPressureInputProxyExt.this.getPressureReading();
            double dfirst_pres_read = Double.parseDouble(first_pres_read);
            if (dfirst_pres_read > 3300.0 && dfirst_pres_read < 4000.0) {
                BOnyxxVavPressureInputProxyExt.this.cycle_pressure_sensor();
            }
            BOnyxxVavPressureInputProxyExt.this.turn_off_rolling_average();
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            BOnyxxVavPressureInputProxyExt.this.turn_on_config_mode();
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            BOnyxxVavPressureInputProxyExt.this.setCommandedDamperPosition(new BStatusNumeric(0.0, BStatus.ok));
            try {
                Thread.sleep(90000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            reading_total = 0.0;
            for (int i = 0; i < 6; ++i) {
                double dpres_read = 0.0;
                double dtemp_read = 0.0;
                String pres_read = BOnyxxVavPressureInputProxyExt.this.getPressureReading();
                String temp_read = BOnyxxVavPressureInputProxyExt.this.getTempReading();
                dpres_read = Double.parseDouble(pres_read);
                dtemp_read = Double.parseDouble(temp_read);
                COMM_LOG.trace("Reading Value " + pres_read);
                COMM_LOG.trace("Temp Value " + temp_read);
                reading_total += dpres_read;
                temp_total += dtemp_read;
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            average_reading = reading_total / 6.0;
            average_temp = temp_total / 6.0;
            temp_comp = (average_temp - 770.0) / 3.24;
            COMM_LOG.trace("Temperature Compensation Factor - " + temp_comp);
            calibration = 8192.0 - (average_reading + temp_comp);
            COMM_LOG.trace("calibration value " + calibration);
            BOnyxxVavPressureInputProxyExt.this.write_calibration_to_can((int)Math.round(calibration));
            BOnyxxVavPressureInputProxyExt.this.write_offset_to_can(10);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            BOnyxxVavPressureInputProxyExt.this.turn_on_rolling_average();
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            BOnyxxVavPressureInputProxyExt.this.turn_off_config_mode();
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            BOnyxxVavPressureInputProxyExt.this.turn_off_config_mode();
            BOnyxxVavPressureInputProxyExt.this.setCommandedDamperPosition(new BStatusNumeric(0.0, BStatus.nullStatus));
        }
    }
}

