/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.point;

import com.lynxspring.onyxxDriver.enums.BPointTypeEnum;
import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.lynxspring.onyxxDriver.point.BIOnyxxConvertedInput;
import com.lynxspring.onyxxDriver.point.BIOnyxxWritable;
import com.lynxspring.onyxxDriver.point.BOnyxxBooleanInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxCounterInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxDigitalBooleanInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxProxyExt;
import java.io.IOException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="hysteresis", type="boolean", defaultValue="false", flags=4, facets={@Facet(value="BFacets.makeBoolean(\"Enabled\", \"Disabled\")")}), @NiagaraProperty(name="hysteresisSize", type="int", defaultValue="10", flags=4)})
public abstract class BOnyxxUniversalInputProxyExt
extends BOnyxxProxyExt
implements BIOnyxxWritable {
    public static final Property hysteresis = BOnyxxUniversalInputProxyExt.newProperty((int)4, (boolean)false, (BFacets)BFacets.makeBoolean((String)"Enabled", (String)"Disabled"));
    public static final Property hysteresisSize = BOnyxxUniversalInputProxyExt.newProperty((int)4, (int)10, null);
    public static final Type TYPE = Sys.loadType(BOnyxxUniversalInputProxyExt.class);
    protected Float[] hysteresisArray = null;
    protected int currentHysteresisIndex;

    public boolean getHysteresis() {
        return this.getBoolean(hysteresis);
    }

    public void setHysteresis(boolean v) {
        this.setBoolean(hysteresis, v, null);
    }

    public int getHysteresisSize() {
        return this.getInt(hysteresisSize);
    }

    public void setHysteresisSize(int v) {
        this.setInt(hysteresisSize, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        this.instantiateHysteresisArray();
        super.started();
        this.writeFile();
    }

    @Override
    public void changed(Property p, Context cx) {
        if (!this.isRunning() || cx == Context.decoding) {
            return;
        }
        if (p == hysteresisSize) {
            this.hysteresisArray = null;
            this.instantiateHysteresisArray();
            BOnyxxNetwork.LOG.trace("Hysteresis array size was changed to " + this.getHysteresisSize() + " for point " + this.getParent().getDisplayName(null) + ".");
        }
        if (p == status) {
            if (this.getStatus().equals((Object)BStatus.ok)) {
                this.writeFile();
            }
            BOnyxxNetwork.LOG.trace("Re-wrote Mode file for point " + this.getParent().getDisplayName(null) + ".");
        }
    }

    @Override
    public String getOutputFilename() {
        return "mode";
    }

    @Override
    public String getStringValue() {
        String mode = this.getPointType().getUniversalMode().toString().toLowerCase();
        mode = BOnyxxUniversalInputProxyExt.removeSpace(mode);
        return mode;
    }

    @Override
    public void readFile() {
        float raw = 0.0f;
        try {
            String valueFileValue = "";
            valueFileValue = OnyxxFileAccess.FileIO(this.getFullPointPath(), "value", "", false);
            raw = Float.parseFloat(valueFileValue);
            if (!this.getPointType().equals((Object)BPointTypeEnum.resistivePulseInput)) {
                raw = this.checkRawValue(raw);
            }
            this.setRaw(raw);
            this.addHysteresisValue(raw);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                BOnyxxNetwork.COMM_LOG.error("Universal Input Read Error\n\t\tSlot Path: " + this.getSlotPath() + "\n\t\tPoint Path:  " + this.getFullPointPath(), (Throwable)e);
                this.readFail(e.getMessage());
                this.getOnyxxDevice().checkDevice();
            }
            BOnyxxNetwork.COMM_LOG.trace(e.getMessage());
        }
        float valueToUtilize = raw;
        if (this.getHysteresis()) {
            valueToUtilize = (float)this.getHysteresisValue();
        }
        if (this instanceof BOnyxxBooleanInputProxyExt) {
            if (this.getPointType().toString().indexOf("Resistive") > 0) {
                this.readOk((BStatusValue)new BStatusBoolean(valueToUtilize < (float)((BOnyxxBooleanInputProxyExt)this).getBooleanThreshold()));
            } else {
                this.readOk((BStatusValue)new BStatusBoolean(valueToUtilize > (float)((BOnyxxBooleanInputProxyExt)this).getBooleanThreshold()));
            }
        }
        if (this instanceof BOnyxxDigitalBooleanInputProxyExt) {
            if (valueToUtilize == 1.0f) {
                this.readOk((BStatusValue)new BStatusBoolean(false));
            } else {
                this.readOk((BStatusValue)new BStatusBoolean(true));
            }
        } else if (this instanceof BOnyxxCounterInputProxyExt) {
            this.readOk((BStatusValue)new BStatusNumeric(this.getRaw()));
        } else {
            this.readOk((BStatusValue)new BStatusNumeric(((BIOnyxxConvertedInput)((Object)this)).convertReadValue()));
        }
    }

    private float checkRawValue(float x) {
        if (x > 4095.0f) {
            x = 0.0f;
        }
        return x;
    }

    private float checkRawValuePressure(float x) {
        if (x > 16383.0f) {
            x = 0.0f;
        }
        return x;
    }

    public static String removeSpace(String s) {
        String withoutspaces = "";
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == ' ') continue;
            withoutspaces = withoutspaces + s.charAt(i);
        }
        return withoutspaces;
    }

    protected void instantiateHysteresisArray() {
        if (this.hysteresisArray != null) {
            return;
        }
        this.hysteresisArray = new Float[this.getHysteresisSize()];
        for (int x = 0; x < this.getHysteresisSize(); ++x) {
            this.hysteresisArray[x] = null;
        }
        this.currentHysteresisIndex = 0;
    }

    protected double getHysteresisValue() {
        int x;
        double totalSum = 0.0;
        for (x = 0; x < this.getHysteresisSize() && this.hysteresisArray[x] != null; ++x) {
            totalSum += this.hysteresisArray[x].doubleValue();
        }
        return x == 0 ? totalSum : totalSum / (double)x;
    }

    protected void addHysteresisValue(float value) {
        this.hysteresisArray[this.currentHysteresisIndex] = new Float(value);
        ++this.currentHysteresisIndex;
        if (this.currentHysteresisIndex >= this.getHysteresisSize()) {
            this.currentHysteresisIndex = 0;
        }
    }

    private void runModeCanMsg() {
        String address = "";
        String service = "";
        String command = "";
        String payload = "";
        String CAN_CHIP5_SERVICE = "05";
        String CAN_CHIP6_SERVICE = "06";
        String CAN_MODE_COMMAND = "02";
        String CAN_RESISTANCE_VALUE = "00";
        String CAN_NONRESISTANCE_VALUE = "01";
        if (this.getPortAddress() < 1 || this.getPortAddress() > 16) {
            BOnyxxNetwork.COMM_LOG.trace("Unable to set the canbus mode value.  Invalid Port Address number.\nPort Address value: " + this.getPortAddress());
            return;
        }
        address = this.getOnyxxDevice().getCanbusID();
        service = this.getPortAddress() <= 8 ? "05" : "06";
        command = "02";
        String xx = this.getCanChannelAsString();
        String yy = "";
        if (this.getPointType().toString().toLowerCase().indexOf("resistive") >= 0) {
            yy = "00";
            BOnyxxNetwork.COMM_LOG.trace("Can message built for resistive point");
        } else if (this.getPointType().toString().toLowerCase().indexOf("digital") >= 0) {
            yy = "00";
            BOnyxxNetwork.COMM_LOG.trace("Can message built for digit point");
        } else {
            yy = "01";
            BOnyxxNetwork.COMM_LOG.trace("Can message built for non-resistive point");
        }
        payload = xx + yy;
        BOnyxxNetwork.COMM_LOG.trace("Can message sent based off mode type");
        this.getOnyxxNetwork().doSendOnyxxMessage(address, service, command, payload);
    }

    private String getCanChannelAsString() {
        String channel = "";
        if (this.getPortAddress() < 1 || this.getPortAddress() > 16) {
            BOnyxxNetwork.COMM_LOG.trace("Unable to set the canbus mode value.  Invalid Port Address number.\nPort Address value: " + this.getPortAddress());
            return "";
        }
        channel = this.getPortAddress() < 16 ? "0" + Integer.toHexString(this.getPortAddress()) : Integer.toHexString(this.getPortAddress());
        return channel;
    }
}

