/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.point;

import com.lynxspring.onyxxDriver.enums.BPointTypeEnum;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.lynxspring.onyxxDriver.point.BIOnyxxConvertedInput;
import com.lynxspring.onyxxDriver.point.BOnyxxUniversalInputProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BNull;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

@NiagaraType
@NiagaraProperty(name="correctionFactor", type="double", defaultValue="0", facets={@Facet(value="BFacets.makeInt(UnitDatabase.getUnit(\"ohm\"))"), @Facet(value="BFacets.make(\"min\", BDouble.make(-100000), \"max\", BDouble.make(100000))")})
public class BOnyxxResistiveInputProxyExt
extends BOnyxxUniversalInputProxyExt
implements BIOnyxxConvertedInput {
    public static final Property correctionFactor = BOnyxxResistiveInputProxyExt.newProperty((int)0, (int)0, (BFacets)BFacets.make((BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"ohm")), (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)-100000.0), (String)"max", (BIDataValue)BDouble.make((double)100000.0))));
    public static final Type TYPE = Sys.loadType(BOnyxxResistiveInputProxyExt.class);

    public double getCorrectionFactor() {
        return this.getDouble(correctionFactor);
    }

    public void setCorrectionFactor(double v) {
        this.setDouble(correctionFactor, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BOnyxxResistiveInputProxyExt() {
        if (this.getDeviceFacets().get("units", (BObject)BNull.DEFAULT) != BUnit.getUnit((String)"ohm")) {
            this.setDeviceFacets(BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"ohm")));
        }
        if (this.getPointType().equals((Object)BPointTypeEnum.DEFAULT)) {
            this.setPointType(BPointTypeEnum.resistiveInput);
        }
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (!this.getPointType().equals((Object)BPointTypeEnum.resistiveInput) && !this.getPointType().equals((Object)BPointTypeEnum.resistivePulseInput)) {
            String msg = "Point Type is not resistance input";
            BOnyxxNetwork.LOG.warning(msg);
        }
    }

    @Override
    public double convertReadValue() {
        float conValue;
        float value = (float)this.getRaw();
        if (this.getHysteresis()) {
            value = (float)this.getHysteresisValue();
        }
        if (value < 4095.0f) {
            conValue = value * 10000.0f / (4095.0f - value) + (float)this.getCorrectionFactor();
            if (conValue < 0.0f) {
                conValue = 0.0f;
            }
            if (conValue > 100000.0f) {
                conValue = 100000.0f;
            }
        } else {
            conValue = 100000.0f;
        }
        return conValue;
    }
}

