/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.point;

import com.lynxspring.onyxxDriver.devices.BOnyxx634Device;
import com.lynxspring.onyxxDriver.devices.BOnyxxDevice;
import com.lynxspring.onyxxDriver.enums.BPointTypeEnum;
import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxDriver.message.BOnyxxDriverPointReadRequest;
import com.lynxspring.onyxxDriver.message.BOnyxxDriverPointWriteRequest;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.lynxspring.onyxxDriver.point.BINOnyxxPollable;
import com.lynxspring.onyxxDriver.point.BIOnyxxWritable;
import com.lynxspring.onyxxDriver.point.BOnyxxPointDeviceExt;
import com.tridium.driver.util.DrUtil;
import java.io.IOException;
import javax.baja.control.BControlPoint;
import javax.baja.control.BIWritablePoint;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="conversion", type="BProxyConversion", defaultValue="BDefaultProxyConversion.DEFAULT", facets={@Facet(value="BFacets.make(\"fieldEditor\", \"onyxxDriver:OnyxxProxyConversionFE\")")}), @NiagaraProperty(name="pointType", type="BPointTypeEnum", defaultValue="BPointTypeEnum.DEFAULT", flags=1), @NiagaraProperty(name="portAddress", type="int", defaultValue="0"), @NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal"), @NiagaraProperty(name="raw", type="double", defaultValue="0.00", flags=1)})
public abstract class BOnyxxProxyExt
extends BProxyExt
implements BINOnyxxPollable {
    public static final Property conversion = BOnyxxProxyExt.newProperty((int)0, (BValue)BDefaultProxyConversion.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (String)"onyxxDriver:OnyxxProxyConversionFE"));
    public static final Property pointType = BOnyxxProxyExt.newProperty((int)1, (BValue)BPointTypeEnum.DEFAULT, null);
    public static final Property portAddress = BOnyxxProxyExt.newProperty((int)0, (int)0, null);
    public static final Property pollFrequency = BOnyxxProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property raw = BOnyxxProxyExt.newProperty((int)1, (double)0.0, null);
    public static final Type TYPE = Sys.loadType(BOnyxxProxyExt.class);
    public static final String MODE_FILENAME = "mode";
    public static final String VALUE_FILENAME = "value";
    private boolean configFault;

    public BProxyConversion getConversion() {
        return (BProxyConversion)this.get(conversion);
    }

    public void setConversion(BProxyConversion v) {
        this.set(conversion, (BValue)v, null);
    }

    public BPointTypeEnum getPointType() {
        return (BPointTypeEnum)this.get(pointType);
    }

    public void setPointType(BPointTypeEnum v) {
        this.set(pointType, (BValue)v, null);
    }

    public int getPortAddress() {
        return this.getInt(portAddress);
    }

    public void setPortAddress(int v) {
        this.setInt(portAddress, v, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public double getRaw() {
        return this.getDouble(raw);
    }

    public void setRaw(double v) {
        this.setDouble(raw, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.getParentPoint() != null) {
            this.getOnyxxPointDeviceExt().pointChanged(this.getParentPoint());
        }
    }

    public void stopped() throws Exception {
        if (!this.getPointType().toString().contains("Input")) {
            this.writeFile("0");
        }
        super.stopped();
        if (!this.is634Point()) {
            this.getOnyxxNetwork().getPollScheduler().unsubscribe((BIPollable)this);
        } else {
            this.getOnyxxNetwork().getAltPollScheduler().unsubscribe((BIPollable)this);
        }
    }

    public final BOnyxxNetwork getOnyxxNetwork() {
        return (BOnyxxNetwork)this.getNetwork();
    }

    public final BOnyxxDevice getOnyxxDevice() {
        return (BOnyxxDevice)DrUtil.getParent((BComplex)this, (Type)BOnyxxDevice.TYPE);
    }

    public final BOnyxxPointDeviceExt getOnyxxPointDeviceExt() {
        return (BOnyxxPointDeviceExt)this.getDeviceExt();
    }

    public void readSubscribed(Context cx) throws Exception {
        if (!this.is634Point()) {
            this.getOnyxxNetwork().getPollScheduler().subscribe((BIPollable)this);
        } else {
            this.getOnyxxNetwork().getAltPollScheduler().subscribe((BIPollable)this);
        }
    }

    public void readUnsubscribed(Context cx) throws Exception {
        if (!this.is634Point()) {
            this.getOnyxxNetwork().getPollScheduler().unsubscribe((BIPollable)this);
        } else {
            this.getOnyxxNetwork().getAltPollScheduler().unsubscribe((BIPollable)this);
        }
    }

    public boolean read(Context cx) throws Exception {
        BOnyxxDriverPointReadRequest.READ(this);
        return true;
    }

    public Type getDeviceExtType() {
        return BOnyxxPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        if (this.getParentPoint() instanceof BIWritablePoint) {
            return BReadWriteMode.readWrite;
        }
        return BReadWriteMode.readonly;
    }

    public boolean isBoolean() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusBoolean;
    }

    public boolean isNumeric() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusNumeric;
    }

    public boolean isString() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusString;
    }

    public boolean isEnum() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusEnum;
    }

    public boolean is634Point() {
        return this.getOnyxxDevice().getType().is(BOnyxx634Device.TYPE);
    }

    public boolean write(Context cx) throws Exception {
        if (this.getOnyxxDevice().isDisabled() || this.getNetwork().isDisabled()) {
            return true;
        }
        BOnyxxDriverPointWriteRequest.WRITE((BIOnyxxWritable)((Object)this));
        return true;
    }

    public void configOk() {
        this.configFault = false;
        this.readReset();
    }

    public void configFail(String msg) {
        this.configFault = true;
        this.readFail(msg);
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (p == enabled && this.isRunning() && this.getEnabled()) {
            this.writeFile();
        }
        if (p == status) {
            if (this.getStatus().equals((Object)BStatus.disabled) || this.getStatus().equals((Object)BStatus.fault) || this.getStatus().equals((Object)BStatus.down)) {
                if (this.getStatus().equals((Object)BStatus.disabled)) {
                    this.writeFile("0");
                }
                BOnyxxNetwork.COMM_LOG.message("Status Value: " + this.getStatus() + "\n\t\tSlot Path: " + this.getSlotPath() + "\n\t\tPoint Path:  " + this.getFullPointPath());
            }
            if (this.getStatus().equals((Object)BStatus.stale)) {
                BOnyxxNetwork.COMM_LOG.trace("Status Value: " + this.getStatus() + "\n\t\tSlot Path: " + this.getSlotPath() + "\n\t\tPoint Path:  " + this.getFullPointPath());
            }
        }
        if (this.isRunning() && p == portAddress && this.getParentPoint() != null) {
            this.getOnyxxPointDeviceExt().pointChanged(this.getParentPoint());
        }
    }

    public boolean isConfigFault() {
        return this.configFault;
    }

    public void writeFile() {
        this.writeFile("");
    }

    public void writeFile(String writeValue) {
        if (!(this instanceof BIOnyxxWritable)) {
            return;
        }
        String strValue = writeValue;
        if (strValue.equals("")) {
            strValue = ((BIOnyxxWritable)((Object)this)).getStringValue();
        }
        if (strValue != "null") {
            try {
                this.variableSleep();
                OnyxxFileAccess.FileIO(this.getFullPointPath(), ((BIOnyxxWritable)((Object)this)).getOutputFilename(), strValue, true);
                this.writeOk(this.getWriteValue());
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    BOnyxxNetwork.COMM_LOG.error("Write Error \n\t\tSlot Path: " + this.getSlotPath() + "\n\t\tPoint Path:  " + this.getFullPointPath(), (Throwable)e);
                    this.writeFail(e.getMessage());
                }
                BOnyxxNetwork.COMM_LOG.trace(e.getMessage());
            }
        }
    }

    public void variableSleep() throws Exception {
        String pointPath = this.getFullPointPath();
        int directoryAddress = this.getDirectoryAddress();
        int sleeplen = 0;
        if (directoryAddress < 0) {
            return;
        }
        if (pointPath.indexOf("a.") >= 0) {
            switch (directoryAddress) {
                case 0: {
                    sleeplen = 0;
                    break;
                }
                case 1: {
                    sleeplen = 60;
                    break;
                }
                case 2: {
                    sleeplen = 120;
                    break;
                }
                case 3: {
                    sleeplen = 180;
                    break;
                }
                case 4: {
                    sleeplen = 240;
                    break;
                }
                case 5: {
                    sleeplen = 300;
                    break;
                }
                case 6: {
                    sleeplen = 360;
                    break;
                }
                case 7: {
                    sleeplen = 420;
                }
            }
        }
        if (pointPath.indexOf("d.") >= 0) {
            switch (directoryAddress) {
                case 0: {
                    sleeplen = 0;
                    break;
                }
                case 1: {
                    sleeplen = 10;
                    break;
                }
                case 2: {
                    sleeplen = 20;
                    break;
                }
                case 3: {
                    sleeplen = 30;
                    break;
                }
                case 4: {
                    sleeplen = 40;
                    break;
                }
                case 5: {
                    sleeplen = 50;
                    break;
                }
                case 6: {
                    sleeplen = 60;
                    break;
                }
                case 7: {
                    sleeplen = 70;
                    break;
                }
                case 8: {
                    sleeplen = 80;
                    break;
                }
                case 9: {
                    sleeplen = 90;
                }
            }
        }
        if (sleeplen > 0) {
            Thread.sleep(sleeplen);
        }
    }

    public String getFullPointPath() {
        String networkPath = this.getOnyxxDevice().getOnyxxNetwork().getNetworkPath();
        String devicePath = this.getOnyxxDevice().getDevicePath();
        String pointPath = this.getPointType().getPathPart();
        if (!this.getPointType().isInternalInput()) {
            pointPath = pointPath + this.getDirectoryAddress();
        }
        networkPath = BOnyxxDevice.checkTrailSlash(networkPath);
        devicePath = BOnyxxDevice.checkTrailSlash(devicePath);
        return networkPath + devicePath + pointPath;
    }

    public void executePoint() {
        if (this.isRunning() && this.is634Point()) {
            BControlPoint point = this.getParentPoint();
            if (point != null) {
                point.doExecute();
            }
        } else {
            super.executePoint();
        }
    }

    public void doPoll() {
        try {
            if (this.getOnyxxDevice().getStatus().isDown() || this.getOnyxxDevice().getStatus().isFault() || this.getOnyxxDevice().getStatus().isDisabled()) {
                this.getOnyxxDevice().checkDevice();
                this.setStatus(this.getDevice().getStatus());
                return;
            }
            this.read(Context.NULL);
        }
        catch (Exception e) {
            this.readFail(e.getMessage());
        }
    }

    public abstract void readFile();

    public int getDirectoryAddress() {
        return this.getPortAddress() - 1;
    }

    public String getValueFilename() {
        return VALUE_FILENAME;
    }

    @Override
    public BOnyxxProxyExt getOnyxxProxyExt() {
        return this;
    }
}

