/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.point;

import com.lynxspring.onyxxDriver.devices.BOnyxxDevice;
import com.lynxspring.onyxxDriver.jobs.BOnyxxPointDiscoveryJob;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.lynxspring.onyxxDriver.point.BOnyxxPointFolder;
import com.lynxspring.onyxxDriver.point.BOnyxxProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraAction(name="submitDiscoveryJob", returnType="BOrd", flags=4)
public class BOnyxxPointDeviceExt
extends BPointDeviceExt {
    public static final Action submitDiscoveryJob = BOnyxxPointDeviceExt.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BOnyxxPointDeviceExt.class);
    public static Log LOG = Log.getLog((String)Sys.getModuleForClass(BOnyxxNetwork.class).getModuleName());

    public BOrd submitDiscoveryJob() {
        return (BOrd)this.invoke(submitDiscoveryJob, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BOnyxxNetwork getOnyxxNetwork() {
        return (BOnyxxNetwork)this.getNetwork();
    }

    public final BOnyxxDevice getOnyxxDevice() {
        return (BOnyxxDevice)this.getDevice();
    }

    public Type getDeviceType() {
        return BOnyxxDevice.TYPE;
    }

    public Type getPointFolderType() {
        return BOnyxxPointFolder.TYPE;
    }

    public Type getProxyExtType() {
        return BOnyxxProxyExt.TYPE;
    }

    public BOrd doSubmitDiscoveryJob(Context cx) throws Exception {
        return new BOnyxxPointDiscoveryJob(this).submit(cx);
    }

    public void pointChanged(BControlPoint point) {
        LOG.trace("point was changed for " + point.getName());
        BOnyxxProxyExt pext = (BOnyxxProxyExt)point.getProxyExt();
        if (!this.isDupPoint(point, pext.getFullPointPath())) {
            pext.configOk();
        }
    }

    private final boolean isDupPoint(BControlPoint point, String fullPointPath) {
        boolean isDuplicate = false;
        BOnyxxProxyExt proxy = (BOnyxxProxyExt)point.getProxyExt();
        BControlPoint[] points = this.getDeviceExt().getPoints();
        for (int i = 0; i < points.length; ++i) {
            BOnyxxProxyExt pext = (BOnyxxProxyExt)points[i].getProxyExt();
            if (pext == proxy || !pext.getFullPointPath().equals(proxy.getFullPointPath()) || !pext.getValueFilename().equals(proxy.getValueFilename())) continue;
            isDuplicate = true;
        }
        if (isDuplicate) {
            proxy.setEnabled(false);
            proxy.configFail("duplicate Point: Point port addresses must be unique or point type must be unique");
            return true;
        }
        return false;
    }
}

