/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.point;

import com.lynxspring.onyxxDriver.enums.BPointTypeEnum;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.lynxspring.onyxxDriver.point.BIOnyxxConvertedInput;
import com.lynxspring.onyxxDriver.point.BOnyxxUniversalInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxVoltageInputProxyExt;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BNull;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

@NiagaraType
public class BOnyxxCurrentInputProxyExt
extends BOnyxxUniversalInputProxyExt
implements BIOnyxxConvertedInput {
    public static final Type TYPE = Sys.loadType(BOnyxxCurrentInputProxyExt.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BOnyxxCurrentInputProxyExt() {
        if (this.getDeviceFacets().get("units", (BObject)BNull.DEFAULT) != BUnit.getUnit((String)"milliampere")) {
            this.setDeviceFacets(BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"milliampere")));
        }
        if (this.getPointType().equals((Object)BPointTypeEnum.DEFAULT)) {
            this.setPointType(BPointTypeEnum.currentInput);
        }
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (!this.getPointType().equals((Object)BPointTypeEnum.currentInput)) {
            String msg = "Point Type is not current input";
            BOnyxxNetwork.LOG.warning(msg);
        }
    }

    @Override
    public double convertReadValue() {
        double parallelResistanceOffset = 1.035;
        double value = this.getRaw();
        if (this.getHysteresis()) {
            value = this.getHysteresisValue();
        }
        return BOnyxxVoltageInputProxyExt.convert(value) * 2.0 * parallelResistanceOffset;
    }
}

