/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.point;

import com.lynxspring.onyxxDriver.enums.BPointTypeEnum;
import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.lynxspring.onyxxDriver.point.BOnyxxUniversalInputProxyExt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enableRollover", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.makeBoolean(\"enabled\", \"disabled\")")}), @NiagaraProperty(name="maxValueForRollover", type="int", defaultValue="5000")})
@NiagaraAction(name="resetCounter")
public class BOnyxxCounterInputProxyExt
extends BOnyxxUniversalInputProxyExt {
    public static final Property enableRollover = BOnyxxCounterInputProxyExt.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    public static final Property maxValueForRollover = BOnyxxCounterInputProxyExt.newProperty((int)0, (int)5000, null);
    public static final Action resetCounter = BOnyxxCounterInputProxyExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BOnyxxCounterInputProxyExt.class);
    private float baseCounterValue;
    private static final int ROLLOVER_VALUE = 65536;
    private int rolloverCount = 0;
    private float prevRaw = 0.0f;
    private double startValue = 0.0;

    public boolean getEnableRollover() {
        return this.getBoolean(enableRollover);
    }

    public void setEnableRollover(boolean v) {
        this.setBoolean(enableRollover, v, null);
    }

    public int getMaxValueForRollover() {
        return this.getInt(maxValueForRollover);
    }

    public void setMaxValueForRollover(int v) {
        this.setInt(maxValueForRollover, v, null);
    }

    public void resetCounter() {
        this.invoke(resetCounter, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BOnyxxCounterInputProxyExt() {
        if (this.getPointType().equals((Object)BPointTypeEnum.DEFAULT)) {
            this.setPointType(BPointTypeEnum.resistivePulseInput);
        }
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (!this.getPointType().equals((Object)BPointTypeEnum.resistivePulseInput)) {
            String msg = "Point Type is not pulse input";
            BOnyxxNetwork.LOG.warning(msg);
        }
        this.baseCounterValue = this.readValueFileToSetInitialValue();
        this.startValue = this.getRaw();
    }

    @Override
    public void changed(Property p, Context cx) {
        if (this.getEnableRollover() && p == raw) {
            if (this.startValue + this.getRaw() > (double)this.getMaxValueForRollover()) {
                BOnyxxNetwork.LOG.trace("Rollover value achieved.  Resetting the Counter Point");
                this.doResetCounter();
                this.baseCounterValue -= 1.0f;
            }
        } else if (p == enabled && this.getEnabled()) {
            this.startValue = this.getRaw();
            this.rolloverCount = 0;
            this.prevRaw = 0.0f;
            this.baseCounterValue = this.readValueFileToSetInitialValue();
        }
    }

    public void doResetCounter() {
        BOnyxxNetwork.LOG.trace("Counter Point is being reset");
        this.rolloverCount = 0;
        this.prevRaw = 0.0f;
        this.startValue = 0.0;
        this.baseCounterValue = this.readValueFileToSetInitialValue();
        BOnyxxNetwork.LOG.trace("Counter Point reset has finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float readValueFileToSetInitialValue() {
        float raw = 0.0f;
        BufferedReader buf = null;
        try {
            File valueFile = new File(this.getFullPointPath(), "value");
            buf = new BufferedReader(new FileReader(valueFile));
            String valueFileValue = buf.readLine().trim();
            raw = Float.parseFloat(valueFileValue);
        }
        catch (Exception e) {
            BOnyxxNetwork.COMM_LOG.error("Universal Input Read Error during value reset\n\t\tSlot Path: " + this.getSlotPath() + "\n\t\tPoint Path:  " + this.getFullPointPath(), (Throwable)e);
            this.readFail(e.getMessage());
            this.getOnyxxDevice().checkDevice();
        }
        finally {
            try {
                if (buf != null) {
                    buf.close();
                }
            }
            catch (IOException e) {
                BOnyxxNetwork.COMM_LOG.trace("Read UI Numeric point errored during it's close method\n\t\tSlot Path: " + this.getSlotPath() + "\n\t\tPoint Path:  " + this.getFullPointPath());
            }
        }
        return raw;
    }

    @Override
    public void readFile() {
        float raw = 0.0f;
        try {
            String valueFileValue = "";
            valueFileValue = OnyxxFileAccess.FileIO(this.getFullPointPath(), "value", "", false);
            raw = Float.parseFloat(valueFileValue);
            if (this.startValue + (double)raw < (double)this.prevRaw) {
                BOnyxxNetwork.LOG.trace("Counter Point rollover has occured");
                ++this.rolloverCount;
            }
            this.setRaw(this.startValue + (double)(raw - this.baseCounterValue) + (double)(this.rolloverCount * 65536));
            this.prevRaw = raw;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                BOnyxxNetwork.COMM_LOG.error("Counter Input Read Error\n\t\tSlot Path: " + this.getSlotPath() + "\n\t\tPoint Path:  " + this.getFullPointPath(), (Throwable)e);
                this.readFail(e.getMessage());
                this.getOnyxxDevice().checkDevice();
            }
            BOnyxxNetwork.COMM_LOG.trace(e.getMessage());
        }
        this.readOk((BStatusValue)new BStatusNumeric(this.getRaw()));
    }

    public double processReadValue(float rawValue) {
        double rawOutput = 0.0;
        if (this.startValue + (double)rawValue < (double)this.prevRaw) {
            BOnyxxNetwork.LOG.trace("Counter Point rollover has occured");
            ++this.rolloverCount;
        }
        rawOutput = this.startValue + (double)(rawValue - this.baseCounterValue) + (double)(this.rolloverCount * 65536);
        this.prevRaw = rawValue;
        return rawOutput;
    }
}

