/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.point;

import com.lynxspring.onyxxDriver.enums.BPointTypeEnum;
import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.lynxspring.onyxxDriver.point.BIOnyxxWritable;
import com.lynxspring.onyxxDriver.point.BOnyxxProxyExt;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="raw", type="double", defaultValue="0.00", flags=5)
public class BOnyxxBooleanOutputProxyExt
extends BOnyxxProxyExt
implements BIOnyxxWritable {
    public static final Property raw = BOnyxxBooleanOutputProxyExt.newProperty((int)5, (double)0.0, null);
    public static final Type TYPE = Sys.loadType(BOnyxxBooleanOutputProxyExt.class);

    @Override
    public double getRaw() {
        return this.getDouble(raw);
    }

    @Override
    public void setRaw(double v) {
        this.setDouble(raw, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BOnyxxBooleanOutputProxyExt() {
        if (this.getPointType().equals((Object)BPointTypeEnum.DEFAULT)) {
            this.setPointType(BPointTypeEnum.booleanOutput);
        }
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.writeFile();
    }

    @Override
    public String getOutputFilename() {
        return "value";
    }

    @Override
    public String getStringValue() {
        return ((BStatusBoolean)this.getWriteValue()).getBoolean() ? "1" : "0";
    }

    @Override
    public void readFile() {
        try {
            this.variableSleep();
            String valueFileValue = "";
            valueFileValue = OnyxxFileAccess.FileIO(this.getFullPointPath(), "value", "", false);
            int raw = Integer.parseInt(valueFileValue);
            this.setRaw(raw);
            this.readOk((BStatusValue)new BStatusBoolean(raw == 1));
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                BOnyxxNetwork.COMM_LOG.error("Boolean Output Read Error\n\t\tSlot Path: " + this.getSlotPath() + "\n\t\tPoint Path: " + this.getFullPointPath(), (Throwable)e);
                this.readFail(e.getMessage());
                this.getOnyxxDevice().checkDevice();
            }
            BOnyxxNetwork.COMM_LOG.trace(e.getMessage());
        }
    }
}

