/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.point;

import javax.baja.control.BNumericPoint;
import javax.baja.control.BPointExtension;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="scale", type="float", defaultValue="1.0F", facets={@Facet(value="BFacets.make(\"precision\", BInteger.make(5))")}), @NiagaraProperty(name="offset", type="float", defaultValue="0.0F", facets={@Facet(value="BFacets.make(\"precision\", BInteger.make(5))")}), @NiagaraProperty(name="units", type="BUnit", defaultValue="BUnit.DEFAULT"), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3)})
public class BLinearCalibrationExt
extends BPointExtension {
    public static final Property scale = BLinearCalibrationExt.newProperty((int)0, (float)1.0f, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)5)));
    public static final Property offset = BLinearCalibrationExt.newProperty((int)0, (float)0.0f, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)5)));
    public static final Property units = BLinearCalibrationExt.newProperty((int)0, (BValue)BUnit.DEFAULT, null);
    public static final Property faultCause = BLinearCalibrationExt.newProperty((int)3, (String)"", null);
    public static final Type TYPE = Sys.loadType(BLinearCalibrationExt.class);

    public float getScale() {
        return this.getFloat(scale);
    }

    public void setScale(float v) {
        this.setFloat(scale, v, null);
    }

    public float getOffset() {
        return this.getFloat(offset);
    }

    public void setOffset(float v) {
        this.setFloat(offset, v, null);
    }

    public BUnit getUnits() {
        return (BUnit)this.get(units);
    }

    public void setUnits(BUnit v) {
        this.set(units, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BLinearCalibrationExt() {
    }

    public BLinearCalibrationExt(BUnit paramBUnit) {
        this.setUnits(paramBUnit);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNumericPoint;
    }

    public void onExecute(BStatusValue outValue, Context cx) {
        BStatusNumeric outNumeric = (BStatusNumeric)outValue;
        BUnit unit = (BUnit)this.getPointFacets().get("units", (BObject)BUnit.NULL);
        if (unit.isConvertible(this.getUnits())) {
            double value1 = outNumeric.getValue();
            double value2 = unit.convertTo(this.getUnits(), value1);
            value2 = (double)this.getFloat(scale) * value2 + (double)this.getFloat(offset);
            value1 = this.getUnits().convertTo(unit, value2);
            outValue.setValueValue((BValue)BDouble.make((double)value1));
            this.setFaultCause("");
        } else if (unit.isNull() || this.getUnits().isNull()) {
            double value1 = outNumeric.getValue();
            value1 = (double)this.getFloat(scale) * value1 + (double)this.getFloat(offset);
            outValue.setValueValue((BValue)BDouble.make((double)value1));
            this.setFaultCause("");
        } else {
            outValue.setStatusFault(true);
            this.setFaultCause("Units between point and extension are not convertible.");
        }
    }
}

