/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.network;

import com.lynxspring.onyxxConverter.jobs.BOnyxxConverterDeviceDiscoveryJob;
import com.lynxspring.onyxxConverter.jobs.BOnyxxConverterImportJob;
import com.lynxspring.onyxxConverter.util.BOnyxxConverterParameters;
import com.lynxspring.onyxxDriver.devices.BOnyxx414Device;
import com.lynxspring.onyxxDriver.devices.BOnyxx434Device;
import com.lynxspring.onyxxDriver.devices.BOnyxx514Device;
import com.lynxspring.onyxxDriver.devices.BOnyxx534Device;
import com.lynxspring.onyxxDriver.devices.BOnyxx634Device;
import com.lynxspring.onyxxDriver.devices.BOnyxxDevice;
import com.lynxspring.onyxxDriver.devices.BOnyxxDeviceFolder;
import com.lynxspring.onyxxDriver.devices.BOnyxxXm14Device;
import com.lynxspring.onyxxDriver.devices.BOnyxxXm34Device;
import com.lynxspring.onyxxDriver.fileIO.BOnyxxCollisionArbitrationFeatures;
import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxDriver.jobs.BOnyxxChipFirmwareUpdateJob;
import com.lynxspring.onyxxDriver.jobs.BOnyxxFileSystemUpdateJob;
import com.lynxspring.onyxxDriver.jobs.BOnyxxSwapFileJob;
import com.lynxspring.onyxxDriver.learn.BOnyxxDriverDeviceDiscoveryLeaf;
import com.lynxspring.onyxxDriver.learn.BOnyxxDriverDeviceDiscoveryPreferences;
import com.lynxspring.onyxxDriver.network.BOnyxxAltPollScheduler;
import com.lynxspring.onyxxDriver.network.BOnyxxPingMonitor;
import com.lynxspring.onyxxDriver.network.BOnyxxPollScheduler;
import com.lynxspring.onyxxDriver.update.UpdateParams;
import com.lynxspring.platOnyxx.BOnyxxPlatformService;
import com.tridium.ndriver.BNNetwork;
import com.tridium.ndriver.discover.BINDiscoveryHost;
import com.tridium.ndriver.discover.BINDiscoveryObject;
import com.tridium.ndriver.discover.BNDiscoveryJob;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridium.ndriver.poll.BNPollScheduler;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.BPlatformServiceContainer;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.sys.transfer.CompToComp;
import com.tridium.sys.transfer.TransferResult;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.file.BIFile;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.Mark;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="monitor", type="BPingMonitor", defaultValue="new BOnyxxPingMonitor()"), @NiagaraProperty(name="failSafe", type="boolean", defaultValue="true", flags=4, facets={@Facet(value="BFacets.makeBoolean(\"enabled\", \"disabled\")")}), @NiagaraProperty(name="AutoUpdateOnyxxSystem", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.makeBoolean(\"enabled\", \"disabled\")")}), @NiagaraProperty(name="AutoUpdateOnyxxFirmware", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.makeBoolean(\"enabled\", \"disabled\")")}), @NiagaraProperty(name="pollScheduler", type="BNPollScheduler", defaultValue="new BOnyxxPollScheduler()"), @NiagaraProperty(name="altPollScheduler", type="BNPollScheduler", defaultValue="new BOnyxxAltPollScheduler()"), @NiagaraProperty(name="collisionArbitrationFeatures", type="BOnyxxCollisionArbitrationFeatures", defaultValue="new BOnyxxCollisionArbitrationFeatures()"), @NiagaraProperty(name="discoveryPreferences", type="BNDiscoveryPreferences", defaultValue="new BOnyxxDriverDeviceDiscoveryPreferences()", flags=4), @NiagaraProperty(name="networkPath", type="String", defaultValue="/home/niagara/shared/mp/"), @NiagaraProperty(name="oversampleTuning", type="int", defaultValue="255", facets={@Facet(value="BFacets.make(\"min\", BInteger.make(5), \"max\",  BInteger.make(255))")}), @NiagaraProperty(name="onyxxSystemVersion", type="String", defaultValue="0.0.0", flags=1), @NiagaraProperty(name="processorType", type="String", defaultValue="", flags=3), @NiagaraProperty(name="swapFileEnabled", type="BBoolean", defaultValue="BBoolean.make(false)", flags=6)})
@NiagaraActions(value={@NiagaraAction(name="submitDiscoveryJob", parameterType="BNDiscoveryPreferences", defaultValue="new BOnyxxDriverDeviceDiscoveryPreferences()", returnType="BOrd", flags=4), @NiagaraAction(name="submitIoDeviceDiscoveryJob", returnType="BOrd", flags=4), @NiagaraAction(name="submitIoDeviceImportJob", parameterType="BOnyxxConverterParameters", defaultValue="new BOnyxxConverterParameters()", returnType="BOrd", flags=4), @NiagaraAction(name="resetNetwork", flags=4), @NiagaraAction(name="runOnyxxUpdates", flags=20), @NiagaraAction(name="syncDevId", flags=20)})
public final class BOnyxxNetwork
extends BNNetwork
implements BINDiscoveryHost {
    public static final Property monitor = BOnyxxNetwork.newProperty((int)0, (BValue)new BOnyxxPingMonitor(), null);
    public static final Property failSafe = BOnyxxNetwork.newProperty((int)4, (boolean)true, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    public static final Property AutoUpdateOnyxxSystem = BOnyxxNetwork.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    public static final Property AutoUpdateOnyxxFirmware = BOnyxxNetwork.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    public static final Property pollScheduler = BOnyxxNetwork.newProperty((int)0, (BValue)new BOnyxxPollScheduler(), null);
    public static final Property altPollScheduler = BOnyxxNetwork.newProperty((int)0, (BValue)new BOnyxxAltPollScheduler(), null);
    public static final Property collisionArbitrationFeatures = BOnyxxNetwork.newProperty((int)0, (BValue)new BOnyxxCollisionArbitrationFeatures(), null);
    public static final Property discoveryPreferences = BOnyxxNetwork.newProperty((int)4, (BValue)new BOnyxxDriverDeviceDiscoveryPreferences(), null);
    public static final Property networkPath = BOnyxxNetwork.newProperty((int)0, (String)"/home/niagara/shared/mp/", null);
    public static final Property oversampleTuning = BOnyxxNetwork.newProperty((int)0, (int)255, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)5), (String)"max", (BIDataValue)BInteger.make((int)255)));
    public static final Property onyxxSystemVersion = BOnyxxNetwork.newProperty((int)1, (String)"0.0.0", null);
    public static final Property processorType = BOnyxxNetwork.newProperty((int)3, (String)"", null);
    public static final Property swapFileEnabled = BOnyxxNetwork.newProperty((int)6, (boolean)BBoolean.make((boolean)false).getBoolean(), null);
    public static final Action submitDiscoveryJob = BOnyxxNetwork.newAction((int)4, (BValue)new BOnyxxDriverDeviceDiscoveryPreferences(), null);
    public static final Action submitIoDeviceDiscoveryJob = BOnyxxNetwork.newAction((int)4, null);
    public static final Action submitIoDeviceImportJob = BOnyxxNetwork.newAction((int)4, (BValue)new BOnyxxConverterParameters(), null);
    public static final Action resetNetwork = BOnyxxNetwork.newAction((int)4, null);
    public static final Action runOnyxxUpdates = BOnyxxNetwork.newAction((int)20, null);
    public static final Action syncDevId = BOnyxxNetwork.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BOnyxxNetwork.class);
    public static boolean update_running = false;
    public static boolean networkResetIsEnabled = true;
    private int pingCounter = 0;
    private static boolean initialRebootMsg = false;
    public static Log LOG = Log.getLog((String)Sys.getModuleForClass(BOnyxxNetwork.class).getModuleName());
    public static Log COMM_LOG = Log.getLog((String)(Sys.getModuleForClass(BOnyxxNetwork.class).getModuleName() + "Comm"));
    public static Lexicon LEX = Lexicon.make(BOnyxxNetwork.class);
    private static final String GLOBAL = "000001";
    private static final String BROADCAST = "ffffff";
    private static final String SRV_SPECIAL = "55";
    private static final String CMD_SPECIAL = "AA";
    private static final String CMD_SPECIAL_B1 = "CC";
    private static final String CMD_SPECIAL_B2 = "DD";
    private static final String ALL_OFF = "1B";
    private static final String CMD_PGM_MAC = "09";
    public static final String ONYXX_414_STRING = "414";
    public static final String ONYXX_514_STRING = "514";
    public static final String ONYXX_434_STRING = "434";
    public static final String ONYXX_534_STRING = "534";
    public static final String ONYXX_634_STRING = "634";
    public static final String DRIVER_FS_VERSION_414 = "2.1.3";
    public static final String DRIVER_FS_VERSION_514 = "2.1.3";
    public static final String DRIVER_FS_VERSION_434 = "2.1.3";
    public static final String DRIVER_FS_VERSION_534 = "2.1.3";
    public static final String DRIVER_FS_VERSION_634 = "2.1.3";

    public BPingMonitor getMonitor() {
        return (BPingMonitor)this.get(monitor);
    }

    public void setMonitor(BPingMonitor v) {
        this.set(monitor, (BValue)v, null);
    }

    public boolean getFailSafe() {
        return this.getBoolean(failSafe);
    }

    public void setFailSafe(boolean v) {
        this.setBoolean(failSafe, v, null);
    }

    public boolean getAutoUpdateOnyxxSystem() {
        return this.getBoolean(AutoUpdateOnyxxSystem);
    }

    public void setAutoUpdateOnyxxSystem(boolean v) {
        this.setBoolean(AutoUpdateOnyxxSystem, v, null);
    }

    public boolean getAutoUpdateOnyxxFirmware() {
        return this.getBoolean(AutoUpdateOnyxxFirmware);
    }

    public void setAutoUpdateOnyxxFirmware(boolean v) {
        this.setBoolean(AutoUpdateOnyxxFirmware, v, null);
    }

    public BNPollScheduler getPollScheduler() {
        return (BNPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BNPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    public BNPollScheduler getAltPollScheduler() {
        return (BNPollScheduler)this.get(altPollScheduler);
    }

    public void setAltPollScheduler(BNPollScheduler v) {
        this.set(altPollScheduler, (BValue)v, null);
    }

    public BOnyxxCollisionArbitrationFeatures getCollisionArbitrationFeatures() {
        return (BOnyxxCollisionArbitrationFeatures)this.get(collisionArbitrationFeatures);
    }

    public void setCollisionArbitrationFeatures(BOnyxxCollisionArbitrationFeatures v) {
        this.set(collisionArbitrationFeatures, (BValue)v, null);
    }

    public BNDiscoveryPreferences getDiscoveryPreferences() {
        return (BNDiscoveryPreferences)this.get(discoveryPreferences);
    }

    public void setDiscoveryPreferences(BNDiscoveryPreferences v) {
        this.set(discoveryPreferences, (BValue)v, null);
    }

    public String getNetworkPath() {
        return this.getString(networkPath);
    }

    public void setNetworkPath(String v) {
        this.setString(networkPath, v, null);
    }

    public int getOversampleTuning() {
        return this.getInt(oversampleTuning);
    }

    public void setOversampleTuning(int v) {
        this.setInt(oversampleTuning, v, null);
    }

    public String getOnyxxSystemVersion() {
        return this.getString(onyxxSystemVersion);
    }

    public void setOnyxxSystemVersion(String v) {
        this.setString(onyxxSystemVersion, v, null);
    }

    public String getProcessorType() {
        return this.getString(processorType);
    }

    public void setProcessorType(String v) {
        this.setString(processorType, v, null);
    }

    public boolean getSwapFileEnabled() {
        return this.getBoolean(swapFileEnabled);
    }

    public void setSwapFileEnabled(boolean v) {
        this.setBoolean(swapFileEnabled, v, null);
    }

    public BOrd submitDiscoveryJob(BNDiscoveryPreferences parameter) {
        return (BOrd)this.invoke(submitDiscoveryJob, (BValue)parameter, null);
    }

    public BOrd submitIoDeviceDiscoveryJob() {
        return (BOrd)this.invoke(submitIoDeviceDiscoveryJob, null, null);
    }

    public BOrd submitIoDeviceImportJob(BOnyxxConverterParameters parameter) {
        return (BOrd)this.invoke(submitIoDeviceImportJob, (BValue)parameter, null);
    }

    public void resetNetwork() {
        this.invoke(resetNetwork, null, null);
    }

    public void runOnyxxUpdates() {
        this.invoke(runOnyxxUpdates, null, null);
    }

    public void syncDevId() {
        this.invoke(syncDevId, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        AccessController.doPrivileged(() -> {
            try {
                System.loadLibrary("onyxxdriver");
            }
            catch (Throwable e) {
                System.out.println("Unable to load npsdkjni native library");
                e.printStackTrace();
            }
            return null;
        });
        this.failSafeDevicesToOn();
        this.sendOversamplingMessage();
        this.populateOnyxxSystemVersion();
        this.addLocalDeviceToDB();
        this.getCorrectPingMonitor();
        try {
            this.setSwapFileEnabled(this.swapFileIsEnabledInOS());
        }
        catch (Exception e) {
            String errorString = "Could not set swap-file status";
            LOG.error(errorString + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public AgentList getAgents(Context cx) {
        AgentList agentList = super.getAgents(cx);
        if (agentList.get(0).getAgentType().getTypeName().equals("OnyxxConverterDeviceManager")) {
            agentList.swap(0, 1);
        }
        return agentList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atSteadyState() throws Exception {
        super.atSteadyState();
        this.correctDeviceTypes();
        String productStr = BOnyxxNetwork.getProductStr();
        if (BOnyxxNetwork.checkVersion(this.getOnyxxSystemVersion(), "2.1.3") == -1 && productStr.contains(ONYXX_414_STRING) || BOnyxxNetwork.checkVersion(this.getOnyxxSystemVersion(), "2.1.3") == -1 && productStr.contains(ONYXX_514_STRING) || BOnyxxNetwork.checkVersion(this.getOnyxxSystemVersion(), "2.1.3") == -1 && productStr.contains(ONYXX_434_STRING) || BOnyxxNetwork.checkVersion(this.getOnyxxSystemVersion(), "2.1.3") == -1 && productStr.contains(ONYXX_534_STRING)) {
            if (this.getAutoUpdateOnyxxSystem()) {
                BJobService.getService().submit((BJob)new BOnyxxFileSystemUpdateJob(this), this.getSession().getSessionContext());
            } else {
                LOG.message("");
                LOG.message("---------------------------------------------------------------------------------");
                LOG.message("--                   !! FILE SYSTEM UPDATE NEED DETECTED !!                    --");
                LOG.message("--     The File System or one of its attributes was found to need an update.   --");
                LOG.message("--                 Run Onyxx Updates to start the update process.              --");
                LOG.message("---------------------------------------------------------------------------------");
            }
        }
        if (BOnyxxNetwork.checkVersion(this.getOnyxxSystemVersion(), "2.1.3") == 1 && productStr.contains(ONYXX_414_STRING) || BOnyxxNetwork.checkVersion(this.getOnyxxSystemVersion(), "2.1.3") == 1 && productStr.contains(ONYXX_514_STRING) || BOnyxxNetwork.checkVersion(this.getOnyxxSystemVersion(), "2.1.3") == 1 && productStr.contains(ONYXX_434_STRING) || BOnyxxNetwork.checkVersion(this.getOnyxxSystemVersion(), "2.1.3") == 1 && productStr.contains(ONYXX_534_STRING)) {
            LOG.message("");
            LOG.message("---------------------------------------------------------------------------------");
            LOG.message("--                    !! FILE SYSTEM VERSION NOTICE !!                         --");
            LOG.message("--       The File System's version is higher than the available version.       --");
            LOG.message("--      To avoid unintentional downgrading, Auto Update has been stopped.      --");
            LOG.message("---------------------------------------------------------------------------------");
        }
        BOnyxxDevice[] od = this.getOnyxxDevices();
        ArrayList<UpdateParams> devParamList = new ArrayList<UpdateParams>();
        boolean isAutoUpdate = true;
        for (int i = 0; i < od.length; ++i) {
            BOnyxxDevice device;
            if (od[i] instanceof BOnyxx414Device) {
                device = (BOnyxx414Device)od[i];
                ((BOnyxx414Device)device).check414UpdateNeed(devParamList, isAutoUpdate);
                continue;
            }
            if (od[i] instanceof BOnyxx514Device) {
                device = (BOnyxx514Device)od[i];
                ((BOnyxx514Device)device).check514UpdateNeed(devParamList, isAutoUpdate);
                continue;
            }
            if (od[i] instanceof BOnyxx434Device) {
                device = (BOnyxx434Device)od[i];
                ((BOnyxx434Device)device).check434UpdateNeed(devParamList, isAutoUpdate);
                continue;
            }
            if (od[i] instanceof BOnyxx534Device) {
                device = (BOnyxx534Device)od[i];
                ((BOnyxx534Device)device).check534UpdateNeed(devParamList, isAutoUpdate);
                continue;
            }
            if (od[i] instanceof BOnyxx634Device) {
                device = (BOnyxx634Device)od[i];
                ((BOnyxx634Device)device).check634UpdateNeed(devParamList, isAutoUpdate);
                continue;
            }
            if (od[i] instanceof BOnyxxXm34Device) {
                device = (BOnyxxXm34Device)od[i];
                ((BOnyxxXm34Device)device).checkXMUpdateNeed(devParamList, isAutoUpdate);
                continue;
            }
            if (!(od[i] instanceof BOnyxxXm14Device)) continue;
            device = (BOnyxxXm14Device)od[i];
            ((BOnyxxXm14Device)device).checkXM14UpdateNeed(devParamList, isAutoUpdate);
        }
        if (!devParamList.isEmpty()) {
            if (this.getAutoUpdateOnyxxFirmware()) {
                BJobService.getService().submit((BJob)new BOnyxxChipFirmwareUpdateJob(this, devParamList), this.getSession().getSessionContext());
            } else {
                LOG.message("");
                LOG.message("---------------------------------------------------------------------------------");
                LOG.message("--                     !! FIRMWARE UPDATE NEED DETECTED !!                     --");
                LOG.message("--         One or more Onyxx devices was found to need a firmware update.      --");
                LOG.message("--                 Run Onyxx Updates to start the update process.              --");
                LOG.message("---------------------------------------------------------------------------------");
            }
        }
        networkResetIsEnabled = true;
        BOnyxxPlatformService tempService = null;
        try {
            tempService = (BOnyxxPlatformService)Sys.getService((Type)BOnyxxPlatformService.TYPE);
            if (tempService == null) {
                tempService = new BOnyxxPlatformService();
            }
            tempService.atSteadyState();
        }
        catch (ServiceNotFoundException e) {
            tempService = new BOnyxxPlatformService();
            tempService.atSteadyState();
        }
        finally {
            this.setProcessorType(tempService.getProcessorType());
        }
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning() || cx == Context.decoding) {
            return;
        }
        if (p == networkPath) {
            File f;
            if (!this.getNetworkPath().endsWith("/")) {
                this.setNetworkPath(this.getNetworkPath() + "/");
            }
            if (!(f = new File(this.getNetworkPath())).exists() || !f.isDirectory()) {
                this.configFail("Network path " + (f.exists() ? "is not a directory" : "does not exist"));
            }
        }
        if (p == enabled) {
            if (this.getEnabled()) {
                this.getCollisionArbitrationFeatures().setEnabled(true);
                this.getPollScheduler().setPollEnabled(true);
                this.getAltPollScheduler().setPollEnabled(true);
            } else {
                this.getPollScheduler().setPollEnabled(false);
                this.getAltPollScheduler().setPollEnabled(false);
                this.getCollisionArbitrationFeatures().setEnabled(false);
                this.sendAllOff();
            }
        }
        if (p == failSafe) {
            if (this.getFailSafe()) {
                this.failSafeDevicesToOn();
            } else {
                this.failSafeDevicesToOff();
            }
        }
        if (p == oversampleTuning) {
            this.sendOversamplingMessage();
        }
        if (p == swapFileEnabled) {
            boolean swapFileEnabledPropertyValue = false;
            boolean swapFileEnabledInOS = false;
            try {
                swapFileEnabledPropertyValue = this.getSwapFileEnabled();
                swapFileEnabledInOS = this.swapFileIsEnabledInOS();
                if (swapFileEnabledPropertyValue != swapFileEnabledInOS) {
                    BJobService.getService().submit((BJob)new BOnyxxSwapFileJob(this, swapFileEnabledPropertyValue), this.getSession().getSessionContext());
                }
            }
            catch (Exception e) {
                String errorString = "Could not change swap-file status";
                LOG.error(errorString + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void stopped() throws Exception {
        this.sendAllOff();
        super.stopped();
    }

    public BOnyxxDevice[] getOnyxxDevices() {
        BDevice[] devices = this.getDevices();
        BOnyxxDevice[] onyxxDevices = new BOnyxxDevice[devices.length];
        System.arraycopy(devices, 0, onyxxDevices, 0, devices.length);
        return onyxxDevices;
    }

    private final boolean isDupDevice(BOnyxxDevice device, String devicePath) {
        boolean isDuplicate = false;
        BOnyxxDevice[] devices = this.getOnyxxDevices();
        for (int i = 0; i < devices.length; ++i) {
            devicePath = BOnyxxDevice.checkTrailSlash(devicePath);
            if (devices[i] == device || !devices[i].getDevicePath().equals(device.getDevicePath())) continue;
            isDuplicate = true;
        }
        if (isDuplicate) {
            device.setEnabled(false);
            device.configFail("duplicate device: Device Paths must be unique.");
            return true;
        }
        return false;
    }

    public void deviceChanged(BOnyxxDevice device) {
        LOG.trace("device was changed for " + device.getName());
        String devicePath = device.getDevicePath();
        devicePath = BOnyxxDevice.checkTrailSlash(devicePath);
        if (!this.isDupDevice(device, devicePath)) {
            device.configOk();
        }
    }

    public void deviceAdded(BOnyxxDevice device) {
        LOG.trace("device " + device.getName() + " was added.");
        String devicePath = device.getDevicePath();
        devicePath = BOnyxxDevice.checkTrailSlash(devicePath);
        if (!this.isDupDevice(device, devicePath)) {
            device.configOk();
        }
    }

    public static int checkVersion(String systemVer, String currentVer) {
        String[] systemVersion = systemVer.split("\\.");
        String[] currentVersion = currentVer.split("\\.");
        for (int i = 0; i < systemVersion.length || i < currentVersion.length; ++i) {
            if (i < systemVersion.length && i < currentVersion.length) {
                if (Integer.parseInt(systemVersion[i]) < Integer.parseInt(currentVersion[i])) {
                    return -1;
                }
                if (Integer.parseInt(systemVersion[i]) <= Integer.parseInt(currentVersion[i])) continue;
                return 1;
            }
            if (i < systemVersion.length) {
                if (Integer.parseInt(systemVersion[i]) == 0) continue;
                return 1;
            }
            if (i >= currentVersion.length || Integer.parseInt(currentVersion[i]) == 0) continue;
            return -1;
        }
        return 0;
    }

    public String getNetworkName() {
        return "OnyxxDeviceNetwork";
    }

    public Type getDeviceFolderType() {
        return BOnyxxDeviceFolder.TYPE;
    }

    public Type getDeviceType() {
        return BOnyxxDevice.TYPE;
    }

    public BINDiscoveryObject[] getDiscoveryObjects(BNDiscoveryPreferences prefs) throws Exception {
        if (prefs.getJob().isCanceled()) {
            return null;
        }
        ArrayList<BOnyxxDriverDeviceDiscoveryLeaf> al = new ArrayList<BOnyxxDriverDeviceDiscoveryLeaf>();
        File file = new File(this.getNetworkPath());
        if (!file.exists() || !file.isDirectory()) {
            String msg = "The Net Path has not been set!!  Cannot discover devices.";
            LOG.trace(msg);
            return null;
        }
        String[] dirNames = file.list();
        for (int i = 0; i < dirNames.length; ++i) {
            String dirID;
            long pingTime;
            String currPath;
            int id;
            if (!dirNames[i].startsWith("onyxx_") || dirNames[i].endsWith("0000") || (id = this.readChipId(currPath = this.getNetworkPath() + '/' + dirNames[i])) == 9 || !new File(currPath).isDirectory() || (pingTime = this.readPingFile(currPath)) == -1L || pingTime > 60000L) continue;
            BOnyxxDriverDeviceDiscoveryLeaf dev = new BOnyxxDriverDeviceDiscoveryLeaf();
            String hostID = this.parseHostID();
            if (hostID.equals(dirID = this.parseDirectoryID(dirNames[i]))) {
                dev.setDeviceName(dirNames[i] + " ( local device )");
            } else {
                dev.setDeviceName(dirNames[i]);
            }
            al.add(dev);
        }
        BINDiscoveryObject[] disObjs = new BINDiscoveryObject[al.size()];
        al.toArray(disObjs);
        return disObjs;
    }

    public String parseHostID() {
        String hostID = this.getOnyxxHostID();
        hostID = hostID.substring(hostID.length() - 7);
        char[] charArray = hostID.toCharArray();
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] == '-') continue;
            str.append(charArray[i]);
        }
        hostID = str.toString();
        return hostID;
    }

    public String getOnyxxHostID() {
        String hostID = Sys.getHostId();
        return hostID;
    }

    public String getDevTypeFromHost() {
        String devType = this.getOnyxxHostID();
        devType = devType.substring(0, 8);
        return devType;
    }

    public String parseDirectoryID(String dirName) {
        dirName = dirName.substring(dirName.length() - 6);
        return dirName;
    }

    private long readPingFile(String currPath) {
        long value = 60001L;
        try {
            File pingFile = new File(currPath, "ping_status");
            if (!pingFile.exists()) {
                String msg = "Ping File not found in discovery";
                LOG.trace(msg);
                return -1L;
            }
            String textValue = OnyxxFileAccess.FileIO(currPath, "ping_status", "", false);
            textValue = textValue.substring(textValue.indexOf(",") + 1);
            value = Long.parseLong(textValue);
        }
        catch (Exception e) {
            COMM_LOG.trace("Ping status read error", (Throwable)e);
        }
        return value;
    }

    private int readChipId(String currPath) {
        int ret = -1;
        try {
            File idFile = new File(currPath, "chip_id");
            if (!idFile.exists()) {
                String msg = "Chip ID File not found in discovery";
                COMM_LOG.trace(msg);
                return -1;
            }
            String textValue = OnyxxFileAccess.FileIO(currPath, "chip_id", "", false);
            ret = Integer.parseInt(textValue);
        }
        catch (Exception e) {
            COMM_LOG.trace("Chip ID read error", (Throwable)e);
        }
        return ret;
    }

    public BOrd doSubmitDiscoveryJob(BNDiscoveryPreferences preferences) {
        this.setDiscoveryPreferences((BOnyxxDriverDeviceDiscoveryPreferences)preferences.newCopy());
        BNDiscoveryJob job = new BNDiscoveryJob((BINDiscoveryHost)this);
        job.setDiscoveryPreferences(preferences);
        return job.submit(null);
    }

    public void doPing() {
        if (update_running) {
            COMM_LOG.trace("Update Running... Ping OK");
            this.setStatus(BStatus.ok);
            this.pingOk();
        } else {
            int netStatus = this.getNetworkStatus();
            if (netStatus == 0) {
                this.pingFail("NO ONYXX DEVICES!!  Minimum of 1 device needed.  Do discovery and add local device.");
                COMM_LOG.trace("Network Level Ping... No Onyxx devices in Database");
            } else if (netStatus == 2) {
                this.pingFail("All devices are down!!");
                COMM_LOG.trace("Network Level Ping... Onyxx Network is down");
            } else {
                COMM_LOG.trace("Network Level Ping... Onyxx Network is up");
                this.setStatus(BStatus.ok);
                this.pingOk();
            }
            this.populateOnyxxSystemVersion();
            COMM_LOG.trace("Onyxx System Version Property has been updated");
            ++this.pingCounter;
            if (BOnyxxFileSystemUpdateJob.reboot_needed && (!initialRebootMsg || this.pingCounter == 10)) {
                LOG.message("---------------------------------------------------------------------------------");
                LOG.message("---                  !!!!!!!!!  REBOOT NEEDED  !!!!!!!!!!                     ---");
                LOG.message("---  An Update Process requires a reboot of the Main device.  When safe to    ---");
                LOG.message("---  do so, please reboot or powercycle the main Onyxx device.                ---");
                LOG.message("---------------------------------------------------------------------------------");
                this.pingCounter = 0;
                initialRebootMsg = true;
            }
        }
    }

    public int getNetworkStatus() {
        long pingValue;
        int i;
        int NET_DOWN;
        int NO_DEVICES = 0;
        int NET_UP = 1;
        int netStatus = NET_DOWN = 2;
        BOnyxxDevice[] devices = this.getOnyxxDevices();
        if (devices.length == 0) {
            netStatus = NO_DEVICES;
            return netStatus;
        }
        for (i = 0; i < devices.length; ++i) {
            pingValue = devices[i].readPingFile();
            if (pingValue >= devices[i].getPingMax()) continue;
            netStatus = NET_UP;
            COMM_LOG.trace("Onyxx Network Check:  Network is up.");
            break;
        }
        if (netStatus == NET_DOWN) {
            COMM_LOG.trace("Onyxx Network Check:  Network is down.");
            this.doResetNetwork();
            for (i = 0; i < devices.length; ++i) {
                pingValue = devices[i].readPingFile();
                if (pingValue >= devices[i].getPingMax()) continue;
                netStatus = NET_UP;
                COMM_LOG.trace("OnyxxNetwork Hang, Graceful reset executed and fixed issue");
                break;
            }
        }
        return netStatus;
    }

    public synchronized boolean runningOnDebian() throws IOException {
        File fileToRead = null;
        String line = null;
        boolean returnValue = false;
        fileToRead = new File("/tmp/" + ((Object)((Object)this)).getClass().getSimpleName() + "_os_release.txt");
        if (!fileToRead.exists()) {
            this.runCommand("cp /etc/os-release " + fileToRead);
        }
        try (FileReader fr = new FileReader(fileToRead);
             BufferedReader br = new BufferedReader(fr);){
            line = br.readLine();
            while (line != null) {
                if (line.indexOf("Debian GNU/Linux") > -1) {
                    returnValue = true;
                    break;
                }
                line = br.readLine();
            }
        }
        catch (IOException ioe) {
            String errorString = "Error reading OS definition file";
            LOG.error(errorString + ": " + ioe.getMessage());
            throw new IOException(errorString, ioe);
        }
        return returnValue;
    }

    public boolean swapFileIsEnabledInOS() throws Exception {
        String SWAP_FILE_ENABLED_DIR = "/tmp/";
        String SWAP_FILE_ENABLED_FILE_NAME = "swapFileEnabled";
        String fileContents = null;
        boolean swapFileIsEnabled = false;
        this.runCommand("grep -c swapfile /proc/swaps > /tmp/swapFileEnabled");
        try {
            fileContents = OnyxxFileAccess.FileIO("/tmp/", "swapFileEnabled", null, false);
            swapFileIsEnabled = Integer.parseInt(fileContents) > 0;
        }
        catch (Exception e) {
            String errorString = "Could not get swap-file status";
            LOG.error(errorString + ": " + e.getMessage());
            e.printStackTrace();
            throw new Exception(errorString, e);
        }
        return swapFileIsEnabled;
    }

    public void doResetNetwork() {
        networkResetIsEnabled = false;
        if (false) {
            LOG.message("Unable to reset Onyxx Network.  Flag to do so was disabled");
            LOG.message("Try again later if issue doesn't resolve itself.");
            return;
        }
        try {
            BPlatformService service = (BPlatformService)Sys.getService((Type)BOnyxxPlatformService.TYPE);
            Action action = service.getAction("resetOnyxxNetwork");
            service.invoke(action, null);
        }
        catch (Exception e) {
            COMM_LOG.trace("Error when running doResetNetwork", (Throwable)e);
        }
    }

    public void doSendOnyxxMessage(String address, String canService, String command, String payload) {
        try {
            BOnyxxPlatformService service = (BOnyxxPlatformService)Sys.getService((Type)BOnyxxPlatformService.TYPE);
            service.doSendOnyxxMessage(address, canService, command, payload);
        }
        catch (Exception e) {
            COMM_LOG.trace("Error when running doSendOnyxxMessage", (Throwable)e);
        }
    }

    public void doRunOnyxxUpdates() {
        String productStr = BOnyxxNetwork.getProductStr();
        boolean update_needed = false;
        BOnyxxDevice[] od = this.getOnyxxDevices();
        ArrayList<UpdateParams> devParamList = new ArrayList<UpdateParams>();
        boolean isAutoUpdate = false;
        for (int i = 0; i < od.length; ++i) {
            BOnyxxDevice device;
            if (od[i].isDisabled()) {
                LOG.message("------   ONYXX UPDATE: Skipping device " + od[i].getCanbusID() + "; device is disabled.");
                continue;
            }
            if (!od[i].getStatus().isOk()) {
                LOG.message("------   ONYXX UPDATE: Skipping device " + od[i].getCanbusID() + "; device status is " + od[i].getStatus() + ".");
                continue;
            }
            if (od[i] instanceof BOnyxx414Device) {
                device = (BOnyxx414Device)od[i];
                ((BOnyxx414Device)device).check414UpdateNeed(devParamList, isAutoUpdate);
                continue;
            }
            if (od[i] instanceof BOnyxx514Device) {
                device = (BOnyxx514Device)od[i];
                ((BOnyxx514Device)device).check514UpdateNeed(devParamList, isAutoUpdate);
                continue;
            }
            if (od[i] instanceof BOnyxx434Device) {
                device = (BOnyxx434Device)od[i];
                ((BOnyxx434Device)device).check434UpdateNeed(devParamList, isAutoUpdate);
                continue;
            }
            if (od[i] instanceof BOnyxx534Device) {
                device = (BOnyxx534Device)od[i];
                ((BOnyxx534Device)device).check534UpdateNeed(devParamList, isAutoUpdate);
                continue;
            }
            if (od[i] instanceof BOnyxx634Device) {
                device = (BOnyxx634Device)od[i];
                ((BOnyxx634Device)device).check634UpdateNeed(devParamList, isAutoUpdate);
                continue;
            }
            if (od[i] instanceof BOnyxxXm34Device) {
                device = (BOnyxxXm34Device)od[i];
                ((BOnyxxXm34Device)device).checkXMUpdateNeed(devParamList, isAutoUpdate);
                continue;
            }
            if (!(od[i] instanceof BOnyxxXm14Device)) continue;
            device = (BOnyxxXm14Device)od[i];
            ((BOnyxxXm14Device)device).checkXM14UpdateNeed(devParamList, isAutoUpdate);
        }
        if (!devParamList.isEmpty()) {
            update_needed = true;
            BJobService.getService().submit((BJob)new BOnyxxChipFirmwareUpdateJob(this, devParamList), this.getSession().getSessionContext());
        }
        if (!this.getOnyxxSystemVersion().equals("2.1.3") && productStr.contains(ONYXX_414_STRING) || !this.getOnyxxSystemVersion().equals("2.1.3") && productStr.contains(ONYXX_514_STRING) || !this.getOnyxxSystemVersion().equals("2.1.3") && productStr.contains(ONYXX_434_STRING) || !this.getOnyxxSystemVersion().equals("2.1.3") && productStr.contains(ONYXX_534_STRING)) {
            update_needed = true;
            BJobService.getService().submit((BJob)new BOnyxxFileSystemUpdateJob(this), this.getSession().getSessionContext());
        }
        if (!update_needed) {
            LOG.message(" ");
            LOG.message("------------------------------------------------------------------------------------------");
            LOG.message("            >>>>>>>>>  No Onyxx Updates Needed At This Time  <<<<<<<<<");
            LOG.message("------------------------------------------------------------------------------------------");
            LOG.message(" ");
        }
    }

    public BOrd doSubmitIoDeviceDiscoveryJob(Context cx) {
        return new BOnyxxConverterDeviceDiscoveryJob(this).submit(cx);
    }

    public BOrd doSubmitIoDeviceImportJob(BOnyxxConverterParameters deviceParams) {
        return new BOnyxxConverterImportJob(this, deviceParams).submit(null);
    }

    private void transferZipToFile(BIFile file, String outputPath) {
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            String line;
            InputStream is = file.getInputStream();
            FileOutputStream os = new FileOutputStream(outputPath);
            br = new BufferedReader(new InputStreamReader(is));
            bw = new BufferedWriter(new OutputStreamWriter(os));
            while ((line = br.readLine()) != null) {
                bw.write(line + "\n");
            }
            bw.close();
        }
        catch (IOException e) {
            COMM_LOG.trace("Error transfering Onyxx Upgrade file:  ", (Throwable)e);
        }
    }

    private void failSafeDevicesToOn() {
        String address = GLOBAL;
        String service = SRV_SPECIAL;
        String command = "aa";
        String payload = "2101";
        this.doSendOnyxxMessage(address, service, command, payload);
    }

    private void failSafeDevicesToOff() {
        String address = GLOBAL;
        String service = SRV_SPECIAL;
        String command = "aa";
        String payload = "2100";
        this.doSendOnyxxMessage(address, service, command, payload);
    }

    public void sleepTime(int x) {
        try {
            Thread.sleep(x);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendOversamplingMessage() {
        String address = GLOBAL;
        String service = "04";
        String command = "18";
        String payload = this.getOversampleTuning() < 16 ? "0" + Integer.toHexString(this.getOversampleTuning()) : Integer.toHexString(this.getOversampleTuning());
        this.doSendOnyxxMessage(address, service, command, payload);
    }

    private void runCommand(String cmd) {
        try {
            this.processStringInput0(cmd);
        }
        catch (UnsatisfiedLinkError ule) {
            try {
                BOnyxxPlatformService service = (BOnyxxPlatformService)Sys.getService((Type)BOnyxxPlatformService.TYPE);
                service.getClass().getMethod("doFwSndCmd", String.class).invoke((Object)service, cmd);
            }
            catch (Exception e) {
                COMM_LOG.trace("Error when trying to run Linux command", (Throwable)e);
            }
        }
        catch (Exception e) {
            COMM_LOG.trace("Error when trying to run Linux command", (Throwable)e);
        }
    }

    private void populateOnyxxSystemVersion() {
        String version = "";
        try {
            version = OnyxxFileAccess.FileIO(this.getNetworkPath() + "platform/", "version", "", false);
        }
        catch (Exception e) {
            version = "0.0.9";
        }
        finally {
            this.setOnyxxSystemVersion(version);
        }
    }

    public long numericConvertFirmwareVersion(String version) {
        long numericRepresentation = 0L;
        String hexRepresentation = "";
        String[] tokens = new String[3];
        StringTokenizer st = new StringTokenizer(version, ".");
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = st.nextToken();
            if (Integer.parseInt(tokens[i]) >= 10) continue;
            tokens[i] = "0" + tokens[i];
        }
        hexRepresentation = tokens[0] + tokens[1] + tokens[2];
        numericRepresentation = Long.parseLong(hexRepresentation, 16);
        return numericRepresentation;
    }

    private void sendAllOff() {
        String address = GLOBAL;
        String service = SRV_SPECIAL;
        String command = CMD_SPECIAL;
        String payload = ALL_OFF;
        String cmd = "cansend can0 00" + address + "#" + service + command + payload;
        this.runCommand(cmd);
        this.sleepTime(500);
        this.runCommand(cmd);
    }

    public void doSyncDevId() {
        String ledChipID = "01";
        String address = BROADCAST;
        String payload = CMD_PGM_MAC;
        String commandB1 = CMD_SPECIAL_B1;
        String commandB2 = CMD_SPECIAL_B2;
        String cmd = "cansend can0 00" + address + "#" + commandB1 + commandB2 + ledChipID + payload + this.parseHostID();
        this.runCommand(cmd);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        String service = SRV_SPECIAL;
        String command = CMD_SPECIAL;
        cmd = "cansend can0 00" + address + "#" + service + command + payload + this.parseHostID();
        this.runCommand(cmd);
    }

    private void addLocalDeviceToDB() {
        BDevice[] devices = this.getDevices();
        String path = "onyxx_" + this.parseHostID() + "/";
        if (devices.length == 0) {
            BOnyxxDevice d = this.getOnyxxDeviceType();
            d.setDevicePath(path);
            this.add("MainOnyxxDevice", (BValue)d);
            return;
        }
        boolean isPresent = false;
        for (int i = 0; i < devices.length; ++i) {
            BOnyxxDevice dev = (BOnyxxDevice)devices[i];
            if (dev.getLocalDevice()) {
                dev.setDevicePath(path);
                LOG.trace("Main Onyxx Device already present. Device addition skipped");
                isPresent = true;
                return;
            }
            if (!dev.getCanbusID().equals(this.parseHostID())) continue;
            LOG.trace("Main Onyxx Device found. Device addition skipped");
            isPresent = true;
        }
        if (!isPresent) {
            BOnyxxDevice d = this.getOnyxxDeviceType();
            d.setDevicePath(path);
            this.add("MainOnyxxDevice", (BValue)d);
        }
    }

    private void getCorrectPingMonitor() {
        if (!(this.getMonitor() instanceof BOnyxxPingMonitor)) {
            BOnyxxPingMonitor bpm = new BOnyxxPingMonitor();
            bpm.setPingEnabled(this.getMonitor().getPingEnabled());
            bpm.setAlarmOnFailure(this.getMonitor().getAlarmOnFailure());
            bpm.setStartupAlarmDelay(this.getMonitor().getStartupAlarmDelay());
            bpm.setPingFrequency(BRelTime.makeSeconds((int)10));
            this.setMonitor(bpm);
            String msg = "Old Ping Monitor found.  Updating to new Onyxx Ping Monitor.";
            LOG.trace("msg");
        }
    }

    private void correctDeviceTypes() {
        int i;
        BOnyxxDevice[] onyxxDevices = this.getOnyxxDevices();
        String productStr = BOnyxxNetwork.getProductStr();
        boolean msgDisplay = false;
        boolean conversion_running = false;
        for (i = 0; i < onyxxDevices.length; ++i) {
            if (onyxxDevices[i].getType().equals(BOnyxxDevice.TYPE)) {
                conversion_running = true;
                LOG.message(" ");
                LOG.message(" ");
                LOG.message(" ");
                LOG.message("=======================================================================================");
                LOG.message("Found deprecated device type \"Onyxx Device\"... ");
                if (!msgDisplay) {
                    LOG.message("This driver will convert these type devices to a 414, 514, 534, or XM.");
                    LOG.message("If this station was created using an onyxxDriver version");
                    LOG.message("before 4.2.36.0.24.2.7, you will need to delete the NEW device");
                    LOG.message("created named \"MainOnyxxDevice\".  Additionally, to ensure");
                    LOG.message("your device type is correct, you will need to do a discovery");
                    LOG.message("then do a match for the local device to correct the device");
                    LOG.message("path.  Once this is done, re-start the station and the device");
                    LOG.message("type will be corrected.");
                    LOG.message(" ");
                    LOG.message("Due to timing issues, you may see a few \"fault\" messages or similar.");
                    LOG.message("output messages while devices and points are being converted. ");
                    LOG.message(" ");
                    msgDisplay = true;
                }
                LOG.message("=======================================================================================");
                this.sleepTime(3000);
                LOG.message(" ");
                LOG.message(" ");
                LOG.message(" ");
            }
            if (!onyxxDevices[i].getCanbusID().equals(this.parseHostID())) continue;
            String controllerTypeStr = null;
            if (onyxxDevices[i].getType().equals(BOnyxx414Device.TYPE) && productStr.contains(ONYXX_414_STRING) || onyxxDevices[i].getType().equals(BOnyxx514Device.TYPE) && productStr.contains(ONYXX_514_STRING) || onyxxDevices[i].getType().equals(BOnyxx434Device.TYPE) && productStr.contains(ONYXX_434_STRING) || onyxxDevices[i].getType().equals(BOnyxx534Device.TYPE) && productStr.contains(ONYXX_534_STRING) || onyxxDevices[i].getType().equals(BOnyxx634Device.TYPE) && productStr.contains(ONYXX_634_STRING)) break;
            if (productStr.contains(ONYXX_414_STRING)) {
                controllerTypeStr = ONYXX_414_STRING;
            } else if (productStr.contains(ONYXX_514_STRING)) {
                controllerTypeStr = ONYXX_514_STRING;
            } else if (productStr.contains(ONYXX_434_STRING)) {
                controllerTypeStr = ONYXX_434_STRING;
            } else if (productStr.contains(ONYXX_634_STRING)) {
                controllerTypeStr = ONYXX_634_STRING;
            } else if (productStr.contains(ONYXX_534_STRING)) {
                controllerTypeStr = ONYXX_534_STRING;
            }
            if (controllerTypeStr == null) continue;
            LOG.message("=======================================================================================");
            LOG.message("Device Found is a " + controllerTypeStr + "... Converting device to correct device type.");
            String deviceName = onyxxDevices[i].getDisplayName(null);
            String devicePath = onyxxDevices[i].getDevicePath();
            devicePath = BOnyxxDevice.checkTrailSlash(devicePath);
            LOG.message("Converting " + deviceName + "...");
            onyxxDevices[i].setEnabled(false);
            BOnyxxDevice newOnyxxDevice = null;
            switch (controllerTypeStr) {
                case "414": {
                    newOnyxxDevice = new BOnyxx414Device();
                    break;
                }
                case "514": {
                    newOnyxxDevice = new BOnyxx514Device();
                    break;
                }
                case "434": {
                    newOnyxxDevice = new BOnyxx434Device();
                    break;
                }
                case "634": {
                    newOnyxxDevice = new BOnyxx634Device();
                    break;
                }
                default: {
                    newOnyxxDevice = new BOnyxx534Device();
                }
            }
            newOnyxxDevice.setDevicePath(devicePath);
            this.add("tempOnyxxDevice", (BValue)newOnyxxDevice);
            BComponent[] containers = onyxxDevices[i].getChildComponents();
            for (int g = 0; g < containers.length; ++g) {
                if (containers[g].getName().equals("alarmSourceInfo") || containers[g].getName().equals("points") || containers[g].getName().equalsIgnoreCase("versioning")) continue;
                LOG.message("    >>> Moving " + containers[g].getName() + " to new device");
                Mark mark = new Mark((BObject)containers[g]);
                CompToComp ctc = (CompToComp)CompToComp.make((int)32, (Mark)mark, (BObject)newOnyxxDevice, null, null);
                try {
                    ctc.transfer();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            BComponent[] componentList = onyxxDevices[i].getPoints().getChildComponents();
            LOG.message("Moving Points from old \"onyxx device\" to converted device...");
            for (int j = 0; j < componentList.length; ++j) {
                Mark mark = new Mark((BObject)componentList[j]);
                CompToComp ctc = (CompToComp)CompToComp.make((int)32, (Mark)mark, (BObject)newOnyxxDevice.getPoints(), null, null);
                try {
                    ctc.transfer();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                newOnyxxDevice.setDisplayName(newOnyxxDevice.getSlot("Display Name").asProperty(), onyxxDevices[i].getDisplayNameFormat(onyxxDevices[i].getSlot("Display Name").asProperty()), null);
            }
            catch (Exception e) {
                if (e instanceof NullPointerException) {
                    // empty if block
                }
            }
            newOnyxxDevice.setLocalDevice(true);
            this.remove((BComplex)onyxxDevices[i]);
            this.rename(newOnyxxDevice.getPropertyInParent(), SlotPath.escape((String)deviceName));
            LOG.message("Conversion of " + deviceName + " is complete!!");
            LOG.message("=======================================================================================");
            newOnyxxDevice.setEnabled(true);
            newOnyxxDevice.ping();
            break;
        }
        onyxxDevices = this.getOnyxxDevices();
        for (i = 0; i < onyxxDevices.length; ++i) {
            BOnyxxDevice odXM;
            if (onyxxDevices[i].getCanbusID().equals(this.parseHostID()) || onyxxDevices[i] instanceof BOnyxxXm34Device || onyxxDevices[i] instanceof BOnyxxXm14Device) continue;
            LOG.message("=======================================================================================");
            LOG.message("Found Onyxx Device needing converted to an XM... ");
            LOG.message("Device Name is " + onyxxDevices[i].getDisplayName(null) + ".");
            LOG.message("Converting... ");
            String deviceName = onyxxDevices[i].getDisplayName(null);
            String devicePath = onyxxDevices[i].getDevicePath();
            String inputsPath = onyxxDevices[i].getFullDevicePath() + "/ui";
            devicePath = BOnyxxDevice.checkTrailSlash(devicePath);
            LOG.message("Converting " + deviceName + "...");
            onyxxDevices[i].setEnabled(false);
            boolean isXm14 = false;
            try {
                OnyxxFileAccess.FileIO(inputsPath, "u.15/value", "", false);
            }
            catch (Exception e) {
                isXm14 = true;
            }
            if (isXm14) {
                odXM = new BOnyxxXm14Device();
                this.convertXM(odXM, onyxxDevices, i, devicePath, deviceName);
                continue;
            }
            odXM = new BOnyxxXm34Device();
            this.convertXM(odXM, onyxxDevices, i, devicePath, deviceName);
        }
        this.getCollisionArbitrationFeatures().reStartThread();
        if (conversion_running) {
            LOG.message("");
            LOG.message("");
            LOG.message("=======================================================================================");
            LOG.message("                  ----->   Conversion Process has Finished   <------                   ");
            LOG.message("=======================================================================================");
            LOG.message("");
            LOG.message("");
            conversion_running = false;
        }
    }

    private void convertXM(BOnyxxDevice odXM, BOnyxxDevice[] onyxxDevices, int i, String devicePath, String deviceName) {
        odXM.setDevicePath(devicePath);
        this.add("tempXMDevice", (BValue)odXM);
        BComponent[] containers = onyxxDevices[i].getChildComponents();
        for (int g = 0; g < containers.length; ++g) {
            if (containers[g].getName().equals("alarmSourceInfo") || containers[g].getName().equals("points") || containers[g].getName().equals("versioning")) continue;
            LOG.message("    >>> Moving " + containers[g].getName() + " to new device");
            Mark mark = new Mark((BObject)containers[g]);
            CompToComp ctc = (CompToComp)CompToComp.make((int)32, (Mark)mark, (BObject)odXM, null, null);
            try {
                ctc.transfer();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BComponent[] componentList = onyxxDevices[i].getPoints().getChildComponents();
        LOG.message("Moving Points from old device to converted device...");
        for (int j = 0; j < componentList.length; ++j) {
            Mark mark = new Mark((BObject)componentList[j]);
            CompToComp ctc = (CompToComp)CompToComp.make((int)32, (Mark)mark, (BObject)odXM.getPoints(), null, null);
            try {
                TransferResult transferResult = ctc.transfer();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            odXM.setDisplayName(odXM.getSlot("Display Name").asProperty(), onyxxDevices[i].getDisplayNameFormat(onyxxDevices[i].getSlot("Display Name").asProperty()), null);
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                // empty if block
            }
        }
        odXM.setLocalDevice(false);
        this.remove((BComplex)onyxxDevices[i]);
        this.rename(odXM.getPropertyInParent(), SlotPath.escape((String)deviceName));
        LOG.message("Conversion of " + deviceName + " is complete!!");
        LOG.message("=======================================================================================");
        odXM.setEnabled(true);
        odXM.ping();
    }

    private BOnyxxDevice getOnyxxDeviceType() {
        BOnyxxDevice device = null;
        String productStr = BOnyxxNetwork.getProductStr();
        if (productStr.contains(ONYXX_414_STRING)) {
            device = new BOnyxx414Device();
        } else if (productStr.contains(ONYXX_514_STRING)) {
            device = new BOnyxx514Device();
        } else if (productStr.contains(ONYXX_434_STRING)) {
            device = new BOnyxx434Device();
        } else if (productStr.contains(ONYXX_634_STRING)) {
            device = new BOnyxx634Device();
        } else if (productStr.contains(ONYXX_534_STRING)) {
            device = new BOnyxx534Device();
        } else {
            device = new BOnyxxXm34Device();
            LOG.warning("Device Found was not in list of Onyxx Devices!!  This should be checked.");
            LOG.warning("If this station was copied from another device, restart the station to fix.");
            LOG.warning("XM Device was created!!");
        }
        return device;
    }

    public static String getProductStr() {
        BSystemPlatformService sps;
        BPlatformServiceContainer psc;
        String productStr = "";
        if (productStr.isEmpty() && (psc = (BPlatformServiceContainer)Sys.getService((Type)BPlatformServiceContainer.TYPE)) != null && (sps = (BSystemPlatformService)psc.get("SystemService")) != null) {
            productStr = sps.getModel();
        }
        return productStr;
    }

    private native int processStringInput0(String var1);
}

