/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.network;

import com.lynxspring.onyxxDriver.devices.BOnyxxDevice;
import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.lynxspring.onyxxDriver.point.BIOnyxxConvertedInput;
import com.lynxspring.onyxxDriver.point.BOnyxxBooleanInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxBooleanOutputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxCounterInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxCurrentInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxDigitalBooleanInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxInternalInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxResistiveInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxVoltageInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxVoltageOutputProxyExt;
import com.tridium.ndriver.poll.BINPollable;
import com.tridium.ndriver.poll.BNPollScheduler;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BIPollable;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="slowRate", type="BRelTime", defaultValue="BRelTime.make(30000)", facets={@Facet(value="BFacets.make(\"min\", BRelTime.make(100), \"showMilliseconds\", BBoolean.make(true))")}), @NiagaraProperty(name="normalRate", type="BRelTime", defaultValue="BRelTime.make(1000)", facets={@Facet(value="BFacets.make(\"min\", BRelTime.make(100), \"showMilliseconds\", BBoolean.make(true))")}), @NiagaraProperty(name="fastRate", type="BRelTime", defaultValue="BRelTime.make(333)", facets={@Facet(value="BFacets.make(\"min\", BRelTime.make(100), \"showMilliseconds\", BBoolean.make(true))")}), @NiagaraProperty(name="pollDelay", type="long", defaultValue="500")})
public class BOnyxxAltPollScheduler
extends BNPollScheduler {
    public static final Property slowRate = BOnyxxAltPollScheduler.newProperty((int)0, (BValue)BRelTime.make((long)30000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)100L), (String)"showMilliseconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property normalRate = BOnyxxAltPollScheduler.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)100L), (String)"showMilliseconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property fastRate = BOnyxxAltPollScheduler.newProperty((int)0, (BValue)BRelTime.make((long)333L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)100L), (String)"showMilliseconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property pollDelay = BOnyxxAltPollScheduler.newProperty((int)0, (int)500, null);
    public static final Type TYPE = Sys.loadType(BOnyxxAltPollScheduler.class);
    boolean isAlive;
    Thread thread;
    long start;

    public BRelTime getSlowRate() {
        return (BRelTime)this.get(slowRate);
    }

    public void setSlowRate(BRelTime v) {
        this.set(slowRate, (BValue)v, null);
    }

    public BRelTime getNormalRate() {
        return (BRelTime)this.get(normalRate);
    }

    public void setNormalRate(BRelTime v) {
        this.set(normalRate, (BValue)v, null);
    }

    public BRelTime getFastRate() {
        return (BRelTime)this.get(fastRate);
    }

    public void setFastRate(BRelTime v) {
        this.set(fastRate, (BValue)v, null);
    }

    public long getPollDelay() {
        return this.getLong(pollDelay);
    }

    public void setPollDelay(long v) {
        this.setLong(pollDelay, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void startThread() {
        this.doResetStatistics();
        this.stopThread();
        this.isAlive = true;
        this.thread = new Thread((Runnable)((Object)this), "Poll:" + this.getParent().getName());
        this.thread.start();
    }

    public void stopThread() {
        this.isAlive = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public void subscribe(BIPollable p) {
        if (!(p instanceof BINPollable)) {
            throw new BajaRuntimeException(p.getClass().getName() + " must be a implement BINPollable");
        }
        BOnyxxDevice d = ((BOnyxxProxyExt)p).getOnyxxDevice();
        d.addSubscription((BOnyxxProxyExt)p);
    }

    public boolean unsubscribe(BIPollable p) {
        BOnyxxDevice d = ((BOnyxxProxyExt)p).getOnyxxDevice();
        d.removeSubscription((BOnyxxProxyExt)p);
        return super.unsubscribe(p);
    }

    public void run() {
        Float raw = Float.valueOf(0.0f);
        while (this.isAlive) {
            try {
                if (!this.getPollEnabled()) {
                    Thread.sleep(1000L);
                    continue;
                }
                BOnyxxNetwork network = (BOnyxxNetwork)this.getParent();
                BOnyxxDevice[] devices = network.getOnyxxDevices();
                Thread.sleep(this.getPollDelay());
                for (int i = 0; i < devices.length; ++i) {
                    String device_id = devices[i].getCanbusID();
                    String io_dump = OnyxxFileAccess.FileIO("/home/niagara/shared/mp/onyxx_" + device_id + "/", "io_dump", null, false);
                    Object[] subs = devices[i].getSubscriptions();
                    for (int x = 0; x < subs.length; ++x) {
                        String readValue;
                        if (subs[x] == null) continue;
                        if ((BOnyxxProxyExt)subs[x] instanceof BOnyxxInternalInputProxyExt) {
                            readValue = this.getInternalValue(io_dump, ((BOnyxxInternalInputProxyExt)subs[x]).getIODumpElement());
                            raw = Float.valueOf(this.checkRawValue(Float.parseFloat(readValue)));
                            ((BOnyxxProxyExt)subs[x]).setRaw(raw.floatValue());
                            ((BOnyxxProxyExt)subs[x]).readOk((BStatusValue)new BStatusNumeric((double)raw.floatValue()));
                            continue;
                        }
                        readValue = this.getIOValue(io_dump, ((BOnyxxProxyExt)subs[x]).getFullPointPath());
                        if ((BOnyxxProxyExt)subs[x] instanceof BOnyxxDigitalBooleanInputProxyExt) {
                            if (readValue.equals("0")) {
                                ((BOnyxxProxyExt)subs[x]).readOk((BStatusValue)new BStatusBoolean(true));
                                continue;
                            }
                            ((BOnyxxProxyExt)subs[x]).readOk((BStatusValue)new BStatusBoolean(false));
                            continue;
                        }
                        if ((BOnyxxProxyExt)subs[x] instanceof BOnyxxBooleanInputProxyExt) {
                            raw = Float.valueOf(Float.parseFloat(readValue));
                            raw = Float.valueOf(this.checkRawValue(Float.parseFloat(readValue)));
                            ((BOnyxxProxyExt)subs[x]).setRaw(raw.floatValue());
                            float valueToUtilize = raw.floatValue();
                            if (((BOnyxxProxyExt)subs[x]).getPointType().toString().indexOf("Resistive") > 0) {
                                ((BOnyxxProxyExt)subs[x]).readOk((BStatusValue)new BStatusBoolean(valueToUtilize < (float)((BOnyxxBooleanInputProxyExt)((BOnyxxProxyExt)subs[x])).getBooleanThreshold()));
                                continue;
                            }
                            ((BOnyxxProxyExt)subs[x]).readOk((BStatusValue)new BStatusBoolean(valueToUtilize > (float)((BOnyxxBooleanInputProxyExt)((BOnyxxProxyExt)subs[x])).getBooleanThreshold()));
                            continue;
                        }
                        if ((BOnyxxProxyExt)subs[x] instanceof BOnyxxResistiveInputProxyExt || (BOnyxxProxyExt)subs[x] instanceof BOnyxxVoltageInputProxyExt) {
                            raw = Float.valueOf(this.checkRawValue(Float.parseFloat(readValue)));
                            ((BOnyxxProxyExt)subs[x]).setRaw(raw.floatValue());
                            ((BOnyxxProxyExt)subs[x]).readOk((BStatusValue)new BStatusNumeric(((BIOnyxxConvertedInput)((Object)((BOnyxxProxyExt)subs[x]))).convertReadValue()));
                            continue;
                        }
                        if ((BOnyxxProxyExt)subs[x] instanceof BOnyxxCurrentInputProxyExt) {
                            raw = Float.valueOf(this.checkRawValue(Float.parseFloat(readValue)));
                            ((BOnyxxProxyExt)subs[x]).setRaw(raw.floatValue());
                            ((BOnyxxProxyExt)subs[x]).readOk((BStatusValue)new BStatusNumeric(((BIOnyxxConvertedInput)((Object)((BOnyxxProxyExt)subs[x]))).convertReadValue()));
                            continue;
                        }
                        if ((BOnyxxProxyExt)subs[x] instanceof BOnyxxCounterInputProxyExt) {
                            raw = Float.valueOf(Float.parseFloat(readValue));
                            double processedRaw = ((BOnyxxCounterInputProxyExt)subs[x]).processReadValue(raw.floatValue());
                            ((BOnyxxProxyExt)subs[x]).setRaw(processedRaw);
                            ((BOnyxxProxyExt)subs[x]).readOk((BStatusValue)new BStatusNumeric(((BOnyxxProxyExt)subs[x]).getRaw()));
                            continue;
                        }
                        if ((BOnyxxProxyExt)subs[x] instanceof BOnyxxBooleanOutputProxyExt) {
                            ((BOnyxxProxyExt)subs[x]).readOk((BStatusValue)new BStatusBoolean(Double.parseDouble(readValue) == 1.0));
                            continue;
                        }
                        if (!((BOnyxxProxyExt)subs[x] instanceof BOnyxxVoltageOutputProxyExt)) continue;
                        raw = Float.valueOf(Float.parseFloat(readValue));
                        ((BOnyxxProxyExt)subs[x]).setRaw(raw.floatValue());
                        ((BOnyxxProxyExt)subs[x]).readOk((BStatusValue)new BStatusNumeric(((BOnyxxProxyExt)subs[x]).getRaw() / 409.5));
                    }
                }
            }
            catch (InterruptedException network) {
            }
            catch (Throwable var6) {
                var6.printStackTrace();
            }
        }
    }

    private float checkRawValue(float x) {
        if (x > 4095.0f) {
            x = 0.0f;
        }
        return x;
    }

    private String getIOValue(String io_dump, String fullPointPath) {
        int lastSlash = fullPointPath.lastIndexOf(47);
        String pointName = fullPointPath.substring(lastSlash + 1);
        int io_name_index = io_dump.indexOf(pointName);
        int open_quotes_index = io_dump.indexOf(34, io_name_index);
        int close_quotes_index = io_dump.indexOf(34, open_quotes_index + 1);
        String value = io_dump.substring(open_quotes_index + 1, close_quotes_index);
        return value;
    }

    private String getInternalValue(String io_dump, String dumpElement) {
        int io_name_index = io_dump.indexOf("<" + dumpElement + ">");
        int open_quotes_index = io_dump.indexOf("v=\"", io_name_index);
        int close_quotes_index = io_dump.indexOf(34, open_quotes_index + 3);
        String value = io_dump.substring(open_quotes_index + 3, close_quotes_index);
        return value;
    }
}

