/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.jobs;

import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxDriver.jobs.OnyxxJobsUtil;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import java.io.IOException;
import javax.baja.job.BSimpleJob;
import javax.baja.log.Log;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BOnyxxSwapFileJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BOnyxxSwapFileJob.class);
    private boolean enablingSwapFile = false;
    private BOnyxxNetwork net = null;
    public static final Log log = BOnyxxNetwork.LOG;

    public Type getType() {
        return TYPE;
    }

    public BOnyxxSwapFileJob() {
    }

    public BOnyxxSwapFileJob(BOnyxxNetwork network, boolean enable) {
        this.enablingSwapFile = enable;
        this.net = network;
    }

    public void doCancel(Context context) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(Context context) throws Exception {
        String FALLOCATE_RESULT_FILE_NAME = "fallocate_result";
        String FSTAB_COPY_NAME = "fstab_copy";
        String SWAP_FILE_NAME = "swapfile";
        String SWAP_FILE_CHANGED_TEMP_DIR = "/tmp/" + ((Object)((Object)this)).getClass().getSimpleName() + "_changed_tmp/";
        boolean runningOnDebian = false;
        String swapFileDir = null;
        boolean swapFileEnabledInOS = false;
        log.message((this.enablingSwapFile ? "Enabling" : "Disabling") + " swap file...");
        swapFileEnabledInOS = this.net.swapFileIsEnabledInOS();
        if (swapFileEnabledInOS == this.enablingSwapFile) {
            String messageString = null;
            messageString = this.enablingSwapFile ? "Cannot enable swap file. Swap file is already in use." : "Cannot disable swap file. No swap file is in use.";
            log.message(messageString);
            this.net.setSwapFileEnabled(!this.enablingSwapFile);
            this.log().failed(messageString);
            throw new Exception(messageString);
        }
        this.log().success("Verified swap file state");
        this.setProgress(25);
        try {
            runningOnDebian = this.net.runningOnDebian();
        }
        catch (IOException e) {
            String messageString = "Unable to determine operating system";
            log.error(messageString);
            this.log().failed(messageString);
            this.net.setSwapFileEnabled(!this.enablingSwapFile);
            throw new Exception(messageString, e);
        }
        swapFileDir = runningOnDebian ? "/" : "/home/";
        OnyxxJobsUtil.runCommand("rm -rf " + SWAP_FILE_CHANGED_TEMP_DIR);
        OnyxxJobsUtil.runCommand("mkdir -p " + SWAP_FILE_CHANGED_TEMP_DIR);
        if (this.enablingSwapFile) {
            Exception fallocateException = null;
            boolean fallocateSuccess = true;
            OnyxxJobsUtil.runCommand("fallocate -l 512M " + swapFileDir + "swapfile" + " 2> /dev/null; echo $? > " + SWAP_FILE_CHANGED_TEMP_DIR + "fallocate_result");
            try {
                fallocateSuccess = OnyxxFileAccess.FileIO(SWAP_FILE_CHANGED_TEMP_DIR, "fallocate_result", null, false).equals("0");
            }
            catch (Exception e) {
                log.error("Error during creation of swap file: " + e);
                e.printStackTrace();
                fallocateException = e;
                fallocateSuccess = false;
            }
            if (!fallocateSuccess) {
                String messageString = "Creation of swap file failed. Make sure at least 512 MB of disk space are available.";
                log.message(messageString);
                this.log().failed(messageString);
                OnyxxJobsUtil.runCommand("rm -f " + swapFileDir + "swapfile");
                this.net.setSwapFileEnabled(false);
                throw new Exception(messageString, fallocateException);
            }
            OnyxxJobsUtil.runCommand("chown root:root " + swapFileDir + "swapfile");
            OnyxxJobsUtil.runCommand("chmod 600 " + swapFileDir + "swapfile");
            OnyxxJobsUtil.runCommand("mkswap " + swapFileDir + "swapfile" + " > /dev/null");
            this.log().success("Swap file created and formatted");
            this.setProgress(50);
            OnyxxJobsUtil.runCommand("swapon " + swapFileDir + "swapfile");
            this.log().success("Swap file enabled");
            this.setProgress(75);
            OnyxxJobsUtil.runCommand("echo \"" + swapFileDir + "swapfile" + "  swap        swap     defaults  0  0\" >> /etc/fstab");
            this.log().success("File system table updated");
            this.setProgress(100);
        } else {
            OnyxxJobsUtil.runCommand("cat /etc/fstab | grep -v \"" + swapFileDir + "swapfile" + "\" > " + SWAP_FILE_CHANGED_TEMP_DIR + "fstab_copy");
            OnyxxJobsUtil.runCommand("cat " + SWAP_FILE_CHANGED_TEMP_DIR + "fstab_copy" + " > /etc/fstab");
            this.log().success("File system table updated");
            this.setProgress(50);
            OnyxxJobsUtil.runCommand("swapoff " + swapFileDir + "swapfile");
            this.log().success("Swap file disabled");
            this.setProgress(75);
            OnyxxJobsUtil.runCommand("rm " + swapFileDir + "swapfile");
            this.log().success("Swap file deleted");
            this.setProgress(100);
        }
        log.message("Swap file " + (this.enablingSwapFile ? "enabled" : "disabled") + ".");
        this.net.setSwapFileEnabled(this.enablingSwapFile);
    }
}

