/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.jobs;

import com.lynxspring.onyxxDriver.enums.BIoTypeEnum;
import com.lynxspring.onyxxDriver.learn.BOnyxxPointEntry;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.lynxspring.onyxxDriver.point.BOnyxxPointDeviceExt;
import java.io.File;
import java.util.Comparator;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BOnyxxPointDiscoveryJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BOnyxxPointDiscoveryJob.class);
    private BOnyxxPointDeviceExt ext = null;

    public Type getType() {
        return TYPE;
    }

    public BOnyxxPointDiscoveryJob() {
    }

    public BOnyxxPointDiscoveryJob(BOnyxxPointDeviceExt ext) {
        this.ext = ext;
    }

    public void run(Context cx) {
        if (this.ext == null) {
            throw new IllegalStateException("Must submit thru OnyxxPointDeviceExt.submitDiscoveryJob()");
        }
        this.log().start("Point discovery");
        this.removeAll();
        this.progress(0);
        BOnyxxPointEntry point = null;
        String networkPath = this.ext.getOnyxxNetwork().getNetworkPath();
        String devicePath = this.ext.getOnyxxDevice().getDevicePath();
        File deviceDirectory = new File(networkPath + devicePath);
        if (!deviceDirectory.exists() || !deviceDirectory.isDirectory()) {
            String msg = "The Device Path has not been set";
            BOnyxxNetwork.LOG.trace(msg);
            this.log().failed(msg);
            return;
        }
        String[] subDirectoryNames = deviceDirectory.list();
        Array points = new Array();
        String VERSION_WITH_ISSUE = "1.0.3";
        String currentVersion = this.ext.getOnyxxNetwork().getOnyxxSystemVersion();
        long numVerWithIssue = this.ext.getOnyxxNetwork().numericConvertFirmwareVersion(VERSION_WITH_ISSUE);
        long numCurVersion = this.ext.getOnyxxNetwork().numericConvertFirmwareVersion(currentVersion);
        for (int dirCount = 0; dirCount < subDirectoryNames.length; ++dirCount) {
            if (subDirectoryNames[dirCount].equals("internal_temp_conv") || subDirectoryNames[dirCount].equals("regulator_3_3v_conv") || subDirectoryNames[dirCount].equals("regulator_5v_conv") || subDirectoryNames[dirCount].equals("regulator_15v_conv")) {
                point = new BOnyxxPointEntry();
                switch (subDirectoryNames[dirCount]) {
                    case "internal_temp_conv": {
                        point.setPointType(BIoTypeEnum.internalTemperatureInput);
                        break;
                    }
                    case "regulator_3_3v_conv": {
                        point.setPointType(BIoTypeEnum.internalVoltageRegulator3_3VInput);
                        break;
                    }
                    case "regulator_5v_conv": {
                        point.setPointType(BIoTypeEnum.internalVoltageRegulator5VInput);
                        break;
                    }
                    case "regulator_15v_conv": {
                        point.setPointType(BIoTypeEnum.internalVoltageRegulator15VInput);
                    }
                }
                point.setPortAddress(0);
                this.log().success("identified " + point.getPointType().toString().toLowerCase());
                points.add((Object)point);
                continue;
            }
            if (!new File(networkPath + devicePath + '/' + subDirectoryNames[dirCount]).isDirectory()) continue;
            File pointDirectory = new File(networkPath + devicePath + '/' + subDirectoryNames[dirCount]);
            if (!pointDirectory.exists() || !pointDirectory.isDirectory()) {
                String msg = "There was an error with the point directory path";
                BOnyxxNetwork.LOG.trace(msg);
                this.log().failed(msg);
                return;
            }
            String[] pointDirectoryNames = pointDirectory.list();
            block19: for (int pointCount = 0; pointCount < pointDirectoryNames.length; ++pointCount) {
                if (!pointDirectory.getName().equals("a0") && !pointDirectory.getName().equals("d0") && !pointDirectory.getName().equals("ui") && !pointDirectory.getName().equals("vav")) continue;
                if (numCurVersion == numVerWithIssue && pointDirectory.getName().equals("ui")) {
                    point = new BOnyxxPointEntry();
                    int address = pointCount;
                    point.setPortAddress(address);
                    point.setPointType(BIoTypeEnum.universalInput);
                    this.log().success("Identified universal input @ " + (pointCount + 1));
                    points.add((Object)point);
                    continue;
                }
                if (!new File(networkPath + devicePath + '/' + subDirectoryNames[dirCount] + '/' + pointDirectoryNames[pointCount]).isDirectory()) continue;
                point = new BOnyxxPointEntry();
                String[] ptInfo = TextUtil.split((String)pointDirectoryNames[pointCount], (char)'.');
                int address = Integer.parseInt(ptInfo[1], 10);
                point.setPortAddress(address);
                if (pointDirectory.getName().equals("vav") && ptInfo[0].charAt(0) == 't') continue;
                switch (ptInfo[0].charAt(0)) {
                    case 'u': {
                        point.setPointType(BIoTypeEnum.universalInput);
                        this.log().success("Identified universal input @ " + (address + 1));
                        break;
                    }
                    case 'a': {
                        point.setPointType(BIoTypeEnum.analogOutput);
                        this.log().success("Identified analog output @ " + (address + 1));
                        break;
                    }
                    case 'd': {
                        point.setPointType(BIoTypeEnum.booleanOutput);
                        this.log().success("Identified boolean output @ " + (address + 1));
                        break;
                    }
                    case 'p': {
                        String productStr = BOnyxxNetwork.getProductStr();
                        if (!this.ext.getOnyxxDevice().getLocalDevice() || !productStr.contains("VAV") && !productStr.contains("APC-DP")) continue block19;
                        point.setPointType(BIoTypeEnum.pressureInput);
                        this.log().success("Identified pressure input @ " + (address + 1));
                        break;
                    }
                    default: {
                        throw new BajaRuntimeException("Invalid path char found : " + ptInfo[0]);
                    }
                }
                points.add((Object)point);
            }
        }
        points = points.sort(new Comparator(){

            public int compare(Object o1, Object o2) {
                BOnyxxPointEntry p1 = (BOnyxxPointEntry)((Object)o1);
                BOnyxxPointEntry p2 = (BOnyxxPointEntry)((Object)o2);
                if (p1.getPointType().equals((Object)p2.getPointType())) {
                    return p1.getAddress() < p2.getAddress() ? -1 : 1;
                }
                return p1.getPointType().compareTo((Object)p2.getPointType());
            }
        });
        for (int i = 0; i < points.size(); ++i) {
            this.add(null, (BValue)((BOnyxxPointEntry)((Object)points.get(i))));
        }
        this.log().success("Discovery done");
    }
}

