/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.jobs;

import com.lynxspring.onyxxDriver.devices.BOnyxxDevice;
import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxDriver.jobs.OnyxxJobsUtil;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BOnyxxIdentifyDeviceJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BOnyxxIdentifyDeviceJob.class);
    private BOnyxxDevice onyxxDevice;
    private static final String PAYLOAD_LEDS_ON = "0100;";
    private static final String PAYLOAD_LEDS_OFF = "0000;";

    public Type getType() {
        return TYPE;
    }

    public BOnyxxIdentifyDeviceJob(BOnyxxDevice onyxxDevice) {
        this.onyxxDevice = onyxxDevice;
    }

    public BOnyxxIdentifyDeviceJob() {
    }

    public void run(Context cx) throws Exception {
        int i;
        boolean is534orXM34;
        String canID = this.onyxxDevice.getCanbusID();
        String devPath = this.onyxxDevice.getFullDevicePath();
        boolean isLocalDev = this.onyxxDevice.getOnyxxNetwork().parseHostID().equals(canID);
        boolean LEDSon = false;
        String devTypeName = this.onyxxDevice.getType().getTypeName();
        if (devTypeName.endsWith("14Device")) {
            is534orXM34 = false;
            String LEDs_1_4_on = BOnyxxIdentifyDeviceJob.buildLEDsCmd(canID, PAYLOAD_LEDS_ON, 1, 4);
            String LEDs_1_4_off = BOnyxxIdentifyDeviceJob.buildLEDsCmd(canID, PAYLOAD_LEDS_OFF, 1, 4);
            for (i = 0; i < 14; ++i) {
                if (!LEDSon) {
                    OnyxxJobsUtil.runCommand(LEDs_1_4_on);
                    LEDSon = true;
                    continue;
                }
                OnyxxJobsUtil.runCommand(LEDs_1_4_off);
                LEDSon = false;
            }
        } else {
            is534orXM34 = true;
            String LEDs_1_5_on = BOnyxxIdentifyDeviceJob.buildLEDsCmd(canID, PAYLOAD_LEDS_ON, 1, 5);
            String LEDs_1_5_off = BOnyxxIdentifyDeviceJob.buildLEDsCmd(canID, PAYLOAD_LEDS_OFF, 1, 5);
            String LEDs_6_10_on = BOnyxxIdentifyDeviceJob.buildLEDsCmd(canID, PAYLOAD_LEDS_ON, 6, 10);
            String LEDs_6_10_off = BOnyxxIdentifyDeviceJob.buildLEDsCmd(canID, PAYLOAD_LEDS_OFF, 6, 10);
            for (int i2 = 0; i2 < 7; ++i2) {
                if (!LEDSon) {
                    OnyxxJobsUtil.runCommand(LEDs_1_5_on);
                    OnyxxJobsUtil.runCommand(LEDs_6_10_on);
                    LEDSon = true;
                    continue;
                }
                OnyxxJobsUtil.runCommand(LEDs_1_5_off);
                OnyxxJobsUtil.runCommand(LEDs_6_10_off);
                LEDSon = false;
            }
        }
        StringBuilder cmdStr = new StringBuilder();
        for (int i3 = 1; i3 <= 4; ++i3) {
            BOnyxxIdentifyDeviceJob.buildPrevStateCmd(i3, cmdStr, devPath, canID);
        }
        if (is534orXM34) {
            BOnyxxIdentifyDeviceJob.buildPrevStateCmd(5, cmdStr, devPath, canID);
        }
        OnyxxJobsUtil.runCommand(cmdStr.toString());
        if (is534orXM34) {
            StringBuilder secondCmdStr = new StringBuilder();
            for (i = 6; i <= 10; ++i) {
                BOnyxxIdentifyDeviceJob.buildPrevStateCmd(i, secondCmdStr, devPath, canID);
            }
            OnyxxJobsUtil.runCommand(secondCmdStr.toString());
        }
    }

    private static String buildLEDsCmd(String canbusID, String LEDstatus, int firstLED, int lastLED) {
        StringBuilder cmdStr = new StringBuilder();
        for (int i = firstLED; i <= lastLED; ++i) {
            String d0 = "0" + i;
            if (i == 10) {
                d0 = "0a";
            }
            cmdStr.append("cansend can0 00" + canbusID + "#0102" + d0 + LEDstatus);
        }
        return cmdStr.toString();
    }

    private static StringBuilder buildPrevStateCmd(int i, StringBuilder cmdStr, String devicePath, String canbusID) {
        String payload = "";
        String d0 = "0" + i;
        if (i == 10) {
            d0 = "0a";
        }
        String directory = "d." + (i - 1);
        String filePath = devicePath + "d0/" + directory + "/";
        try {
            String valueFile = OnyxxFileAccess.FileIO(filePath, "value", "", false);
            payload = valueFile.contains("1") ? PAYLOAD_LEDS_ON : PAYLOAD_LEDS_OFF;
        }
        catch (Exception e) {
            BOnyxxNetwork.LOG.error("Error reading d0 value file", (Throwable)e);
        }
        return cmdStr.append("cansend can0 00" + canbusID + "#0102" + d0 + payload);
    }
}

