/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.jobs;

import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxDriver.jobs.OnyxxJobsUtil;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import java.io.File;
import java.io.IOException;
import javax.baja.job.BSimpleJob;
import javax.baja.log.Log;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;

@NiagaraType
public class BOnyxxFileSystemUpdateJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BOnyxxFileSystemUpdateJob.class);
    private BOnyxxNetwork net = null;
    public static boolean reboot_needed = false;
    public static final Log log = BOnyxxNetwork.LOG;
    private static final int MAX_ATTEMPTS = 8;

    public Type getType() {
        return TYPE;
    }

    public BOnyxxFileSystemUpdateJob() {
    }

    public BOnyxxFileSystemUpdateJob(BOnyxxNetwork network) {
        this.net = network;
    }

    public int getProgress() {
        return super.getProgress();
    }

    public void setProgress(int i) {
        super.setProgress(i);
    }

    public boolean isAlive() {
        return super.isAlive();
    }

    public void doRun(Context context) {
        super.doRun(context);
    }

    public void doCancel(Context context) {
    }

    private void message(String msg) {
        this.log().message(msg);
        log.message(msg);
    }

    private void message(String msg, String detail) {
        this.log().message(msg, detail);
        log.message(msg);
    }

    public void run(Context context) throws Exception {
        File f;
        boolean isFile;
        int attempts = 0;
        int stepNumber = 0;
        int numSteps = 0;
        int numberOfTries = 0;
        this.setProgress(0);
        String cmd = "";
        String tarFileName = "";
        String scriptName = "";
        String logName = "";
        String checkFilename = "";
        String scriptCheck = "";
        boolean originalNetworkEnabledState = false;
        ++numSteps;
        ++numSteps;
        ++numSteps;
        ++numSteps;
        ++numSteps;
        ++numSteps;
        ++numSteps;
        ++numSteps;
        ++numSteps;
        log.message("");
        log.message("---------------------------------------------------------------------------------");
        log.message(">>>>>>                  !! FILE SYSTEM UPDATE NEED DETECTED !!                 --");
        log.message(">>>>>>   The File System or one of its attributes was found to need an update. --");
        log.message(">>>>>>   Job progress will be displayed below and output lines are             --");
        log.message(">>>>>>   signified by \">>>>>>\".                                                --");
        log.message("---------------------------------------------------------------------------------");
        while (BOnyxxNetwork.update_running && attempts <= 8) {
            if (attempts == 8) {
                log.message(">>>>>>    ---> File System Update:  Max Attempts reached.  Exiting upgrade!! ...");
                log.message(">>>>>>    ---> File System Update:  Will try again at next Station Start");
                return;
            }
            this.net.sleepTime(30000);
            log.message(">>>>>>    ---> File System Update:  Waiting for another Upgrade to finish -- Pausing 30 sec...");
        }
        BOnyxxNetwork.update_running = true;
        originalNetworkEnabledState = this.net.getEnabled();
        this.net.setEnabled(false);
        this.setProgress(5);
        log.message(">>>>>>   ---> File System Update Progress:  " + this.getProgress() + "%   --  File System Upgrade Started...");
        ++stepNumber;
        this.transferTarBall();
        cmd = "rm -fr /var/log/updateLogs/FileSystem";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "mkdir -p /var/log/updateLogs/FileSystem";
        OnyxxJobsUtil.runCommand(cmd);
        this.setProgress(100 / numSteps * stepNumber);
        log.message(">>>>>>   ---> File System Update Progress (" + stepNumber + "/" + numSteps + "):  " + this.getProgress() + "%  --  Needed Files have been Unzipped...");
        this.log().success("Needed Files have been unzipped.");
        ++stepNumber;
        scriptCheck = "";
        boolean updateNeed = false;
        tarFileName = "ImagePartitions_N4.tar.gz";
        scriptName = "OnyxxUpdate_N4_ImagePartitions.bash";
        logName = "ImagePartition.log";
        checkFilename = "ImagePartitionProcess.txt";
        if (this.fs_version_less_than("1.0.17") && this.net.runningOnDebian()) {
            updateNeed = true;
            reboot_needed = true;
        }
        if (updateNeed) {
            cmd = "tar xf /tmp/resources/FileSystem/" + tarFileName + " -C /tmp/resources/FileSystem";
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "chmod 777 /tmp/resources/FileSystem/" + scriptName;
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "nohup /bin/bash /tmp/resources/FileSystem/" + scriptName + " &";
            OnyxxJobsUtil.runCommand(cmd);
        }
        if (updateNeed) {
            isFile = false;
            numberOfTries = 0;
            while (!isFile) {
                log.message(">>>>>>     Checking for Completion...");
                f = new File("/tmp/resources/FileSystem/" + checkFilename);
                if (f.exists()) {
                    isFile = true;
                    scriptCheck = OnyxxFileAccess.FileIO("/tmp/resources/FileSystem", checkFilename, null, false);
                    continue;
                }
                if (numberOfTries >= 15) {
                    log.message(">>>>>>   #### ERROR:  IMAGE PARTITION UPDATE FAILED!!! ####");
                    log.message(">>>>>>   #### Exiting Update Job... ####");
                    BOnyxxNetwork.update_running = false;
                    this.net.setEnabled(originalNetworkEnabledState);
                    return;
                }
                log.message(">>>>>>     Still running, checking again in 2 seconds!");
                this.net.sleepTime(2000);
                ++numberOfTries;
            }
        }
        this.setProgress(100 / numSteps * stepNumber);
        if (!scriptCheck.equals("complete") && updateNeed) {
            log.message(">>>>>>   #### ERROR:  IMAGE PARTITION UPDATE FAILED!!! ####");
            log.message(">>>>>>   #### Exiting Update Job... ####");
            BOnyxxNetwork.update_running = false;
            this.net.setEnabled(originalNetworkEnabledState);
            return;
        }
        log.message(">>>>>>   ---> File System Update Progress (" + stepNumber + "/" + numSteps + "):  " + this.getProgress() + "%  --  Image Partitions Authenticated...");
        this.log().success("Image Partitions Updated");
        ++stepNumber;
        scriptCheck = "";
        updateNeed = false;
        tarFileName = "NreProperties_N4.tar.gz";
        scriptName = "OnyxxUpdate_N4_NreProperties.bash";
        logName = "NreProperties.log";
        checkFilename = "NrePropertiesProcess.txt";
        if (this.fs_version_less_than("1.0.17")) {
            updateNeed = true;
            reboot_needed = true;
        }
        if (updateNeed) {
            cmd = "tar xf /tmp/resources/FileSystem/" + tarFileName + " -C /tmp/resources/FileSystem";
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "chmod 777 /tmp/resources/FileSystem/" + scriptName;
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "nohup /bin/bash /tmp/resources/FileSystem/" + scriptName + " &";
            OnyxxJobsUtil.runCommand(cmd);
        }
        if (updateNeed) {
            isFile = false;
            numberOfTries = 0;
            while (!isFile) {
                log.message(">>>>>>     Checking for Completion...");
                f = new File("/tmp/resources/FileSystem/" + checkFilename);
                if (f.exists()) {
                    isFile = true;
                    scriptCheck = OnyxxFileAccess.FileIO("/tmp/resources/FileSystem", checkFilename, null, false);
                    continue;
                }
                if (numberOfTries >= 15) {
                    log.message(">>>>>>   #### ERROR:  NRE PROPERTIES FILE UPDATE FAILED!!! ####");
                    log.message(">>>>>>   #### Exiting Update Job... ####");
                    BOnyxxNetwork.update_running = false;
                    this.net.setEnabled(originalNetworkEnabledState);
                    return;
                }
                log.message(">>>>>>     Still running, checking again in 2 seconds!");
                this.net.sleepTime(2000);
                ++numberOfTries;
            }
        }
        this.setProgress(100 / numSteps * stepNumber);
        if (!scriptCheck.equals("complete") && updateNeed) {
            log.message(">>>>>>   #### ERROR:  NRE PROPERTIES FILE UPDATE FAILED!!! ####");
            log.message(">>>>>>   #### Exiting Update Job... ####");
            BOnyxxNetwork.update_running = false;
            this.net.setEnabled(originalNetworkEnabledState);
            return;
        }
        log.message(">>>>>>   ---> File System Update Progress (" + stepNumber + "/" + numSteps + "):  " + this.getProgress() + "%  --  Nre Properties file checked...");
        this.log().success("nre.properties file updated");
        ++stepNumber;
        scriptCheck = "";
        updateNeed = false;
        tarFileName = "SymbolicLinks_N4.tar.gz";
        scriptName = "OnyxxUpdate_N4_SymbolicLinks.bash";
        logName = "SymbolicLinks.log";
        checkFilename = "SymbolicLinksProcess.txt";
        if (this.fs_version_less_than("1.0.17") && this.net.runningOnDebian()) {
            updateNeed = true;
        }
        if (updateNeed) {
            cmd = "tar xf /tmp/resources/FileSystem/" + tarFileName + " -C /tmp/resources/FileSystem";
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "chmod 777 /tmp/resources/FileSystem/" + scriptName;
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "nohup /bin/bash /tmp/resources/FileSystem/" + scriptName + " &";
            OnyxxJobsUtil.runCommand(cmd);
        }
        if (updateNeed) {
            isFile = false;
            numberOfTries = 0;
            while (!isFile) {
                log.message(">>>>>>     Checking for Completion...");
                f = new File("/tmp/resources/FileSystem/" + checkFilename);
                if (f.exists()) {
                    isFile = true;
                    scriptCheck = OnyxxFileAccess.FileIO("/tmp/resources/FileSystem", checkFilename, null, false);
                    continue;
                }
                if (numberOfTries >= 15) {
                    log.message(">>>>>>   #### ERROR:  SYMBOLIC LINK VERIFICATION FAILED!!! ####");
                    log.message(">>>>>>   #### Exiting Update Job... ####");
                    BOnyxxNetwork.update_running = false;
                    this.net.setEnabled(originalNetworkEnabledState);
                    return;
                }
                log.message(">>>>>>     Still running, checking again in 2 seconds!");
                this.net.sleepTime(2000);
                ++numberOfTries;
            }
        }
        this.setProgress(100 / numSteps * stepNumber);
        if (!scriptCheck.equals("complete") && updateNeed) {
            log.message(">>>>>>   #### ERROR:  SYMBOLIC LINK VERIFICATION FAILED!!! ####");
            log.message(">>>>>>   #### Exiting Update Job... ####");
            BOnyxxNetwork.update_running = false;
            this.net.setEnabled(originalNetworkEnabledState);
            return;
        }
        log.message(">>>>>>   ---> File System Update Progress (" + stepNumber + "/" + numSteps + "):  " + this.getProgress() + "%  --  Symbolic Links verified...");
        this.log().success("Symbolic Links have been verified");
        ++stepNumber;
        scriptCheck = "";
        updateNeed = false;
        tarFileName = "FilePermissions_N4.tar.gz";
        scriptName = "OnyxxUpdate_N4_FilePermissions.bash";
        logName = "FilePermissions.log";
        checkFilename = "FilePermissionsProcess.txt";
        updateNeed = true;
        if (updateNeed) {
            cmd = "tar xf /tmp/resources/FileSystem/" + tarFileName + " -C /tmp/resources/FileSystem";
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "chmod 777 /tmp/resources/FileSystem/" + scriptName;
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "nohup /bin/bash /tmp/resources/FileSystem/" + scriptName + " &";
            OnyxxJobsUtil.runCommand(cmd);
        }
        if (updateNeed) {
            isFile = false;
            numberOfTries = 0;
            while (!isFile) {
                log.message(">>>>>>     Checking for Completion...");
                f = new File("/tmp/resources/FileSystem/" + checkFilename);
                if (f.exists()) {
                    isFile = true;
                    scriptCheck = OnyxxFileAccess.FileIO("/tmp/resources/FileSystem", checkFilename, null, false);
                    continue;
                }
                if (numberOfTries >= 15) {
                    log.message(">>>>>>   #### ERROR:  FILE PERMISSIONS CONFIRMATION FAILED!!! ####");
                    log.message(">>>>>>   #### Exiting Update Job... ####");
                    BOnyxxNetwork.update_running = false;
                    this.net.setEnabled(originalNetworkEnabledState);
                    return;
                }
                log.message(">>>>>>     Still running, checking again in 2 seconds!");
                this.net.sleepTime(2000);
                ++numberOfTries;
            }
        }
        this.setProgress(100 / numSteps * stepNumber);
        if (!scriptCheck.equals("complete") && updateNeed) {
            log.message(">>>>>>   #### ERROR:  FILE PERMISSIONS CONFIRMATION FAILED!!! ####");
            log.message(">>>>>>   #### Exiting Update Job... ####");
            BOnyxxNetwork.update_running = false;
            this.net.setEnabled(originalNetworkEnabledState);
            return;
        }
        log.message(">>>>>>   ---> File System Update Progress (" + stepNumber + "/" + numSteps + "):  " + this.getProgress() + "%  --  File Permissions Confirmed...");
        this.log().success("File Permissions Confirmed.");
        ++stepNumber;
        scriptCheck = "";
        updateNeed = false;
        tarFileName = "CanStartScript_N4.tar.gz";
        scriptName = "OnyxxUpdate_N4_CanStartScript.bash";
        logName = "CanStartScript.log";
        checkFilename = "CanStartScriptProcess.txt";
        if (this.fs_version_less_than("1.0.17")) {
            updateNeed = true;
            reboot_needed = true;
        }
        if (updateNeed) {
            cmd = "tar xf /tmp/resources/FileSystem/" + tarFileName + " -C /tmp/resources/FileSystem";
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "chmod 777 /tmp/resources/FileSystem/" + scriptName;
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "nohup /bin/bash /tmp/resources/FileSystem/" + scriptName + " &";
            OnyxxJobsUtil.runCommand(cmd);
        }
        if (updateNeed) {
            isFile = false;
            while (!isFile) {
                log.message(">>>>>>     Checking for Completion...");
                f = new File("/tmp/resources/FileSystem/" + checkFilename);
                if (f.exists()) {
                    isFile = true;
                    scriptCheck = OnyxxFileAccess.FileIO("/tmp/resources/FileSystem", checkFilename, null, false);
                    continue;
                }
                if (numberOfTries >= 15) {
                    log.message(">>>>>>   #### ERROR:  CAN INITIALIATION VALIDATION CHECK FAILED!!! ####");
                    log.message(">>>>>>   #### Exiting Update Job... ####");
                    BOnyxxNetwork.update_running = false;
                    this.net.setEnabled(originalNetworkEnabledState);
                    return;
                }
                log.message(">>>>>>     Still running, checking again in 2 seconds!");
                this.net.sleepTime(2000);
                ++numberOfTries;
            }
        }
        this.setProgress(100 / numSteps * stepNumber);
        if (!scriptCheck.equals("complete") && updateNeed) {
            log.message(">>>>>>   #### ERROR:  CAN INITIALIATION VALIDATION CHECK FAILED!!! ####");
            log.message(">>>>>>   #### Exiting Update Job... ####");
            BOnyxxNetwork.update_running = false;
            this.net.setEnabled(originalNetworkEnabledState);
            return;
        }
        log.message(">>>>>>   ---> File System Update Progress (" + stepNumber + "/" + numSteps + "):  " + this.getProgress() + "%  --  CAN Initialization File Validated...");
        this.log().success("CANbus Initialization File Validated.");
        ++stepNumber;
        scriptCheck = "";
        updateNeed = false;
        tarFileName = "OsConfiguration_N4.tar.gz";
        scriptName = "OnyxxUpdate_N4_OsConfiguration.bash";
        logName = "OsConfiguration.log";
        checkFilename = "OsConfigurationProcess.txt";
        if (this.fs_version_less_than("1.0.26") && this.net.runningOnDebian()) {
            updateNeed = true;
            reboot_needed = true;
        }
        if (updateNeed) {
            cmd = "tar xf /tmp/resources/FileSystem/" + tarFileName + " -C /tmp/resources/FileSystem";
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "chmod 777 /tmp/resources/FileSystem/" + scriptName;
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "nohup /bin/bash /tmp/resources/FileSystem/" + scriptName + " &";
            OnyxxJobsUtil.runCommand(cmd);
        }
        if (updateNeed) {
            isFile = false;
            numberOfTries = 0;
            while (!isFile) {
                log.message(">>>>>>     Checking for Completion...");
                f = new File("/tmp/resources/FileSystem/" + checkFilename);
                if (f.exists()) {
                    isFile = true;
                    scriptCheck = OnyxxFileAccess.FileIO("/tmp/resources/FileSystem", checkFilename, null, false);
                    continue;
                }
                if (numberOfTries >= 15) {
                    log.message(">>>>>>   #### ERROR:  SYSTEM FILE UPDATE FAILED!!! ####");
                    log.message(">>>>>>   #### Exiting Update Job... ####");
                    BOnyxxNetwork.update_running = false;
                    this.net.setEnabled(originalNetworkEnabledState);
                    return;
                }
                log.message(">>>>>>     Still running, checking again in 2 seconds!");
                this.net.sleepTime(2000);
                ++numberOfTries;
            }
        }
        this.setProgress(100 / numSteps * stepNumber);
        if (!scriptCheck.equals("complete") && updateNeed) {
            log.message(">>>>>>   #### ERROR:  SYSTEM FILE UPDATE FAILED!!! ####");
            log.message(">>>>>>   #### Exiting Update Job... ####");
            BOnyxxNetwork.update_running = false;
            this.net.setEnabled(originalNetworkEnabledState);
            return;
        }
        log.message(">>>>>>   ---> File System Update Progress (" + stepNumber + "/" + numSteps + "):  " + this.getProgress() + "%  --  OS Configuration Up to Date...");
        this.log().success("OS Configuration Up to Date.");
        ++stepNumber;
        scriptCheck = "";
        updateNeed = false;
        tarFileName = "FileSystem_N4.tar.gz";
        scriptName = "OnyxxUpdate_N4_FileSystem.bash";
        logName = "FileSystemStructure.log";
        checkFilename = "FileSystemProcess.txt";
        updateNeed = true;
        reboot_needed |= this.fs_version_less_than("1.0.25");
        if (updateNeed) {
            cmd = "tar xf /tmp/resources/FileSystem/" + tarFileName + " -C /tmp/resources/FileSystem";
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "chmod 777 /tmp/resources/FileSystem/" + scriptName;
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "nohup /bin/bash /tmp/resources/FileSystem/" + scriptName + " &";
            OnyxxJobsUtil.runCommand(cmd);
        }
        if (updateNeed) {
            isFile = false;
            numberOfTries = 0;
            while (!isFile) {
                log.message(">>>>>>     Checking for Completion...");
                f = new File("/tmp/resources/FileSystem/" + checkFilename);
                if (f.exists()) {
                    isFile = true;
                    scriptCheck = OnyxxFileAccess.FileIO("/tmp/resources/FileSystem", checkFilename, null, false);
                    continue;
                }
                if (numberOfTries >= 15) {
                    log.message(">>>>>>   #### ERROR:  FILE SYSTEM STRUCTURE UPDATE FAILED!!! ####");
                    log.message(">>>>>>   #### Exiting Update Job... ####");
                    BOnyxxNetwork.update_running = false;
                    this.net.setEnabled(originalNetworkEnabledState);
                    return;
                }
                log.message(">>>>>>     Still running, checking again in 2 seconds!");
                this.net.sleepTime(2000);
                ++numberOfTries;
            }
        }
        this.setProgress(100 / numSteps * stepNumber);
        if (!scriptCheck.equals("complete") && updateNeed) {
            log.message(">>>>>>   #### ERROR:  FILE SYSTEM STRUCTURE UPDATE FAILED!!! ####");
            log.message(">>>>>>   #### Exiting Update Job... ####");
            BOnyxxNetwork.update_running = false;
            this.net.setEnabled(originalNetworkEnabledState);
            return;
        }
        log.message(">>>>>>   ---> File System Update Progress (" + stepNumber + "/" + numSteps + "):  " + this.getProgress() + "%  --  File System Structure Updated...");
        this.log().success("File System Structure Updated.");
        cmd = "rm -rf /tmp/resources/FileSystem";
        OnyxxJobsUtil.runCommand(cmd);
        this.setProgress(100);
        log.message(">>>>>>   ---> File System Update Progress (" + ++stepNumber + "/" + numSteps + "):  " + this.getProgress() + "%");
        log.message("--------------------------------------------------------------------------------------");
        log.message(">>>>>>                    ~~ FILE SYSTEM UPDATE HAS FINISHED ~~                     --");
        log.message("--------------------------------------------------------------------------------------");
        log.message("");
        log.message("");
        this.log().success("Un-needed files have been removed");
        BOnyxxNetwork.update_running = false;
        this.net.setEnabled(originalNetworkEnabledState);
    }

    private void transferTarBall() throws IOException {
        String cmd = null;
        Object helixxEnvironmentVariableContents = null;
        String jarPath = "/opt/niagara/modules/onyxxDriver-rt.jar";
        String resourcesPath = "/home/niagara/stations/" + Sys.getStation().getStationName() + "/resources";
        cmd = "rm -rf /tmp/resources";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "mkdir -p /tmp/resources/FileSystem";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = this.net.runningOnDebian() ? "/usr/lib/jvm/jdk1.8.0_101/bin/jar xf " + jarPath + " resources/" : "unzip -q -d . " + jarPath + " resources/*";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "mv " + resourcesPath + "/* /tmp/resources/";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "tar xfz /tmp/resources/OnyxxUpdate_N4_FileSystemJob.tar.gz -C /tmp/resources/FileSystem";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "rm -rf /var/log/updateLogs/FileSystem";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "mkdir -p /var/log/updateLogs/FileSystem";
        OnyxxJobsUtil.runCommand(cmd);
    }

    private boolean check_FS_Version_To_Base() {
        Version currVersion = new Version(this.net.getOnyxxSystemVersion());
        boolean isLower = false;
        String productStr = BOnyxxNetwork.getProductStr();
        Version baseVersion = productStr.contains("414") ? new Version("2.1.3") : (productStr.contains("514") ? new Version("2.1.3") : new Version("2.1.3"));
        if (currVersion.major() < baseVersion.major()) {
            isLower = true;
            return true;
        }
        if (currVersion.minor() < baseVersion.minor()) {
            isLower = true;
            return true;
        }
        if (currVersion.build() < baseVersion.build()) {
            isLower = true;
            return true;
        }
        if (currVersion.patch() < baseVersion.patch()) {
            isLower = true;
            return true;
        }
        return isLower;
    }

    private boolean fs_version_less_than(String version) {
        boolean isLower = false;
        Version currVersion = new Version(this.net.getOnyxxSystemVersion());
        Version specifiedVersion = new Version(version);
        if (currVersion.major() < specifiedVersion.major()) {
            isLower = true;
            return true;
        }
        if (currVersion.minor() < specifiedVersion.minor()) {
            isLower = true;
            return true;
        }
        if (currVersion.build() < specifiedVersion.build()) {
            isLower = true;
            return true;
        }
        if (currVersion.patch() < specifiedVersion.patch()) {
            isLower = true;
            return true;
        }
        return isLower;
    }
}

