/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.jobs;

import com.lynxspring.onyxxDriver.jobs.OnyxxJobsUtil;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.baja.job.BSimpleJob;
import javax.baja.log.Log;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BOnyxxFactoryResetCheckJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BOnyxxFactoryResetCheckJob.class);
    private BOnyxxNetwork net = null;
    public static final Log log = BOnyxxNetwork.LOG;

    public Type getType() {
        return TYPE;
    }

    public BOnyxxFactoryResetCheckJob() {
    }

    public BOnyxxFactoryResetCheckJob(BOnyxxNetwork network) {
        this.net = network;
    }

    public int getProgress() {
        return super.getProgress();
    }

    public void setProgress(int i) {
        super.setProgress(i);
    }

    public boolean isAlive() {
        return super.isAlive();
    }

    public void doRun(Context context) {
        super.doRun(context);
    }

    public void doCancel(Context context) {
    }

    private void message(String msg) {
        this.log().message(msg);
        log.message(msg);
    }

    private void message(String msg, String detail) {
        this.log().message(msg, detail);
        log.message(msg);
    }

    public void run(Context context) throws Exception {
        if (this.check_factory_reset()) {
            log.message("\n\n");
            log.message("====================================================================================");
            log.message("=                  DEVICE DOES NOT HAVE FACTORY RESET CAPABILITY!                  =");
            log.message("=           Download and install onyxxSupport module to add this feature.          =");
            log.message("====================================================================================");
            log.message("\n\n");
            Exception exception = new Exception("Factory reset capability is not currently installed.");
            throw exception;
        }
    }

    private boolean check_factory_reset() {
        String dev_type = "";
        File bckup_archive = new File("/opt/lynxspring/factory_reset/etc_niagara.tar.gz");
        boolean return_value = false;
        String cmd = "";
        BufferedReader br = null;
        String line = "";
        BOnyxxFactoryResetCheckJob bOnyxxFactoryResetCheckJob = this;
        dev_type = bOnyxxFactoryResetCheckJob.net.getProductStr();
        cmd = "rm -fR /tmp/resources/";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "mkdir /tmp/resources/";
        OnyxxJobsUtil.runCommand(cmd);
        this.net.sleepTime(3000);
        if (dev_type.contains("534")) {
            return_value = true;
        }
        if (return_value) {
            return_value = this.running_on_Debian();
        }
        if (return_value) {
            cmd = "if [ ! -f " + bckup_archive + " ] ; then echo true > /tmp/resources/bckup_sts ; else echo false > /tmp/resources/bckup_sts ; fi";
            OnyxxJobsUtil.runCommand(cmd);
            try {
                br = new BufferedReader(new FileReader("/tmp/resources/bckup_sts"));
                line = br.readLine();
                return_value = line.indexOf("true") > -1;
            }
            catch (IOException e) {
                log.error("Error reading backup status file");
            }
        }
        return return_value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean running_on_Debian() {
        boolean returnValue = false;
        String line = "";
        BufferedReader br = null;
        String cmd = "";
        try {
            cmd = "mkdir -p /tmp/resources";
            OnyxxJobsUtil.runCommand(cmd);
        }
        catch (Exception e) {
            log.error("Unable to create /tmp/resources directory.");
        }
        cmd = "cat /etc/os-release > /tmp/resources/os_release.txt";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "chmod 777 /tmp/resources/os_release.txt";
        OnyxxJobsUtil.runCommand(cmd);
        try {
            br = new BufferedReader(new FileReader("/tmp/resources/os_release.txt"));
            line = br.readLine();
            while (line != null) {
                if (line.indexOf("Debian GNU/Linux") > -1) {
                    returnValue = true;
                    break;
                }
                line = br.readLine();
            }
        }
        catch (IOException e) {
            log.error("Error reading OS Definition file");
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {
                log.error("Error occurred during buffered reader close method for OS definition file", (Throwable)e);
            }
        }
        return returnValue;
    }
}

