/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.jobs;

import com.lynxspring.onyxxDriver.devices.BOnyxxDevice;
import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxDriver.jobs.OnyxxJobsUtil;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.lynxspring.onyxxDriver.update.UpdateParams;
import com.lynxspring.onyxxMonnitDriver.BOnyxxMonnitNetwork;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import javax.baja.job.BSimpleJob;
import javax.baja.log.Log;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BOnyxxChipFirmwareUpdateJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BOnyxxChipFirmwareUpdateJob.class);
    private BOnyxxNetwork net = null;
    private ArrayList<UpdateParams> devChipList = null;
    public static final Log log = BOnyxxNetwork.LOG;
    private static final int MAX_ATTEMPTS = 16;

    public Type getType() {
        return TYPE;
    }

    public BOnyxxChipFirmwareUpdateJob() {
    }

    public BOnyxxChipFirmwareUpdateJob(BOnyxxNetwork network, ArrayList<UpdateParams> al) {
        this.net = network;
        this.devChipList = al;
    }

    public int getProgress() {
        return super.getProgress();
    }

    public void setProgress(int i) {
        super.setProgress(i);
    }

    public boolean isAlive() {
        return super.isAlive();
    }

    public void doRun(Context context) {
        super.doRun(context);
    }

    public void doCancel(Context context) {
    }

    private void message(String msg) {
        this.log().message(msg);
        log.message(msg);
    }

    private void message(String msg, String detail) {
        this.log().message(msg, detail);
        log.message(msg);
    }

    public void run(Context context) throws Exception {
        BOnyxxMonnitNetwork onyxxMonnitNetwork;
        int stepNumber = 0;
        int numSteps = 0;
        boolean isFile = false;
        int numberOfTries = 0;
        this.setProgress(0);
        String cmd = "";
        String tarFileName = "Firmware_N4.tar.gz";
        String scriptName = "OnyxxUpdate_N4_Firmware.bash";
        boolean originalOnyxxMonnitNetworkEnabledState = false;
        boolean originalOnyxxNetworkEnabledState = false;
        ++numSteps;
        numSteps += this.devChipList.size();
        ++numSteps;
        log.message("");
        log.message("---------------------------------------------------------------------------------");
        log.message("------                   !! FIRMWARE UPDATE NEED DETECTED !!                   --");
        log.message("------   One or more Onyxx devices was found to need a firmware update.        --");
        log.message("------   Job progress will be displayed below and output lines are             --");
        log.message("------   signified by \"------\".                                                --");
        log.message("---------------------------------------------------------------------------------");
        for (int attempts = 0; BOnyxxNetwork.update_running && attempts <= 16; ++attempts) {
            if (attempts == 16) {
                log.message("------   ---> Firmware Update: Max Attempts reached.  Exiting upgrade!! ...");
                log.message("------   ---> Firmware Update: Will try again at next Station Start");
                return;
            }
            this.net.sleepTime(30000);
            log.message("------   ---> Firmware Update:  Other Upgrade Running (File System) -- Pausing 30 sec...");
        }
        BOnyxxNetwork.update_running = true;
        BOnyxxNetwork.networkResetIsEnabled = false;
        originalOnyxxNetworkEnabledState = this.net.getEnabled();
        this.net.setEnabled(false);
        log.trace("Original OnyxxNetwork state: enabled = " + originalOnyxxNetworkEnabledState + "; now disabled.");
        try {
            onyxxMonnitNetwork = (BOnyxxMonnitNetwork)Sys.getService((Type)BOnyxxMonnitNetwork.TYPE);
            originalOnyxxMonnitNetworkEnabledState = onyxxMonnitNetwork.getEnabled();
            onyxxMonnitNetwork.setEnabled(false);
            log.trace("Original OnyxxMonnitNetwork state: enabled = " + originalOnyxxMonnitNetworkEnabledState + "; now disabled.");
        }
        catch (ServiceNotFoundException snfe) {
            log.trace("No OnyxxMonnitNetwork found in station; not disabling.");
        }
        this.setProgress(5);
        log.message("------   ---> Firmware Update Progress:  " + this.getProgress() + "%   --  Firmware Upgrade Started...");
        ++stepNumber;
        this.transferTarBall();
        cmd = "rm -fr /var/log/updateLogs/Firmware";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "mkdir -p /var/log/updateLogs/Firmware";
        OnyxxJobsUtil.runCommand(cmd);
        this.setProgress(100 / numSteps * stepNumber);
        log.message("------   ---> Firmware Update Progress (" + stepNumber + "/" + numSteps + "):  " + this.getProgress() + "%  --  Needed Files have been Unzipped...");
        this.log().success("Needed Files have been unzipped for Firmware Upgrade Process");
        scriptName = "OnyxxUpdate_N4_Firmware.bash";
        cmd = "tar xf /tmp/resources/Firmware/" + tarFileName + " -C /tmp/resources/Firmware";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "chmod 777 /tmp/resources/Firmware/" + scriptName;
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "chmod 777 /tmp/resources/Firmware/Kuro_LSM1";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "chmod 777 /tmp/resources/Firmware/Kuro_LSM2";
        OnyxxJobsUtil.runCommand(cmd);
        for (UpdateParams up : this.devChipList) {
            ++stepNumber;
            String scriptCheck = "";
            String devType = up.getDeviceType();
            String devName = "";
            String canID = up.getCanID();
            String chipID = up.getChipID().toString();
            if (devType.contains("414")) {
                devName = "Onyxx_414";
            }
            if (devType.contains("514")) {
                devName = "Onyxx_514";
            }
            if (devType.contains("434")) {
                devName = "Onyxx_434";
            }
            if (devType.contains("534")) {
                devName = "Onyxx_534";
            }
            if (devType.contains("634")) {
                devName = "Onyxx_634";
            }
            if (devType.contains("Xm14")) {
                devName = "Onyxx_Xm14";
            }
            if (devType.contains("Xm34")) {
                devName = "Onyxx_Xm34";
            }
            cmd = "echo DeviceName:" + devName + " > /tmp/resources/Firmware/parameters.txt";
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "echo CanID:" + canID + " >> /tmp/resources/Firmware/parameters.txt";
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "echo ChipID:" + chipID + " >> /tmp/resources/Firmware/parameters.txt";
            OnyxxJobsUtil.runCommand(cmd);
            String logName = "FirmwareUpdate_" + devName + "_" + canID + "_" + chipID + ".log";
            String checkFilename = "" + devName + "_" + canID + "_" + chipID + '_' + "Process.txt";
            cmd = "echo LogName: " + logName + " >> /tmp/resources/Firmware/parameters.txt";
            OnyxxJobsUtil.runCommand(cmd);
            log.message("------ <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            log.message("------   Running Firmware upgrade for device " + devName + " -- " + canID);
            log.message("------     -- Updating Chip Number " + chipID + ".");
            log.message("------ <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            cmd = "/bin/bash /tmp/resources/Firmware/" + scriptName + " >> /var/log/updateLogs/Firmware/DriverLevel_FW.log 2>&1 &";
            OnyxxJobsUtil.runCommand(cmd);
            isFile = false;
            numberOfTries = 0;
            while (!isFile) {
                log.message("------     Checking for Completion...");
                File f = new File("/tmp/resources/Firmware/" + checkFilename);
                if (f.exists()) {
                    isFile = true;
                    scriptCheck = OnyxxFileAccess.FileIO("/tmp/resources/Firmware", checkFilename, null, false);
                    continue;
                }
                if (numberOfTries >= 15) {
                    TimeoutException exception = new TimeoutException("Update of device " + canID + " chip " + chipID + " exceeded allotted time.");
                    log.message("------   #### ERROR:  FIRMWARE UPDATE FAILED!!! ####");
                    log.message("------   #### Exiting Update Job... ####");
                    this.log().failed("Update of device " + canID + " chip " + chipID + " did not complete in the expected time", (Throwable)exception);
                    BOnyxxNetwork.update_running = false;
                    this.net.setEnabled(originalOnyxxNetworkEnabledState);
                    log.trace("Restored OnyxxNetwork state: enabled = " + this.net.getEnabled() + ".");
                    try {
                        BOnyxxMonnitNetwork onyxxMonnitNetwork2 = (BOnyxxMonnitNetwork)Sys.getService((Type)BOnyxxMonnitNetwork.TYPE);
                        onyxxMonnitNetwork2.setEnabled(originalOnyxxMonnitNetworkEnabledState);
                        log.trace("Restored OnyxxMonnitNetwork state: enabled = " + onyxxMonnitNetwork2.getEnabled() + ".");
                    }
                    catch (ServiceNotFoundException snfe) {
                        log.trace("No OnyxxMonnitNetwork found in station; not enabling/disabling.");
                    }
                    throw exception;
                }
                log.message("------     Still running, checking again in 5 seconds!");
                this.net.sleepTime(5000);
                ++numberOfTries;
            }
            this.setProgress(100 / numSteps * stepNumber);
            BOnyxxDevice[] devices = this.net.getOnyxxDevices();
            String devDisName = "";
            for (BOnyxxDevice dev : devices) {
                if (!dev.getCanbusID().equals(canID)) continue;
                devDisName = dev.getDisplayName(null);
            }
            if (scriptCheck.equals("complete")) {
                log.message("------   ---> Firmware Update Progress (" + stepNumber + "/" + numSteps + "):  " + this.getProgress() + "%  --  Chip " + chipID + " Firmware updated on device " + devDisName + "...");
                this.log().success("Firmware Update Complete for chip " + chipID + " on device " + devDisName + ".");
                if (up.getChipID() != 1) continue;
                try {
                    OnyxxFileAccess.FileIO(this.net.getNetworkPath() + "platform/", "heartbeat", "running", true);
                }
                catch (Exception e) {
                    log.error("Error when resetting heartbeat LED's state: " + e.getMessage());
                }
                continue;
            }
            Exception exception = new Exception("An error occurred while updating device " + canID + " chip " + chipID + ".");
            log.message("------   #### ERROR:  FIRMWARE UPDATE FAILED!!! ####");
            log.message("------   #### Exiting Update Job... ####");
            this.log().failed("Update of device " + canID + " chip " + chipID + " encountered an error", (Throwable)exception);
            BOnyxxNetwork.update_running = false;
            this.net.setEnabled(originalOnyxxNetworkEnabledState);
            log.trace("Restored OnyxxNetwork state: enabled = " + this.net.getEnabled() + ".");
            try {
                BOnyxxMonnitNetwork onyxxMonnitNetwork3 = (BOnyxxMonnitNetwork)Sys.getService((Type)BOnyxxMonnitNetwork.TYPE);
                onyxxMonnitNetwork3.setEnabled(originalOnyxxMonnitNetworkEnabledState);
                log.trace("Restored OnyxxMonnitNetwork state: enabled = " + onyxxMonnitNetwork3.getEnabled() + ".");
            }
            catch (ServiceNotFoundException snfe) {
                log.trace("No OnyxxMonnitNetwork found in station; not enabling/disabling.");
            }
            throw exception;
        }
        cmd = "rm -rf /tmp/resources/Firmware";
        this.setProgress(100);
        log.message("------   ---> Firmware Update Progress (" + ++stepNumber + "/" + numSteps + "):  " + this.getProgress() + "%");
        log.message("--------------------------------------------------------------------------------------");
        log.message("------   ~~ FIRMWARE UPDATE HAS FINISHED FOR ALL DEVICES ON THE ONYXX NETWORK ~~    --");
        log.message("--------------------------------------------------------------------------------------");
        log.message("");
        log.message("");
        BOnyxxNetwork.update_running = false;
        BOnyxxNetwork.networkResetIsEnabled = true;
        this.net.setEnabled(originalOnyxxNetworkEnabledState);
        log.trace("Restored OnyxxNetwork state: enabled = " + this.net.getEnabled() + ".");
        try {
            onyxxMonnitNetwork = (BOnyxxMonnitNetwork)Sys.getService((Type)BOnyxxMonnitNetwork.TYPE);
            onyxxMonnitNetwork.setEnabled(originalOnyxxMonnitNetworkEnabledState);
            log.trace("Restored OnyxxMonnitNetwork state: enabled = " + onyxxMonnitNetwork.getEnabled() + ".");
        }
        catch (ServiceNotFoundException snfe) {
            log.trace("No OnyxxMonnitNetwork found in station; not enabling/disabling.");
        }
        this.log().success("Un-needed Files have been removed.");
    }

    private void transferTarBall() {
        String cmd = null;
        Object helixxEnvironmentVariableContents = null;
        String jarPath = "/opt/niagara/modules/onyxxDriver-rt.jar";
        String resourcesPath = "/home/niagara/stations/" + Sys.getStation().getStationName() + "/resources";
        cmd = "rm -rf /tmp/resources";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "mkdir -p /tmp/resources/Firmware";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "cat /etc/os-release > /tmp/resources/Firmware/os_release.txt";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "chmod 777 /tmp/resources/Firmware/os_release.txt";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = this.running_on_Debian() ? "/usr/lib/jvm/jdk1.8.0_101/bin/jar xf " + jarPath + " resources/" : "unzip -q -d . " + jarPath + " resources/*";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "mv " + resourcesPath + "/* /tmp/resources/";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "tar xfz /tmp/resources/OnyxxUpdate_N4_ChipFirmwareJob.tar.gz -C /tmp/resources/Firmware";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "rm -rf /var/log/updateLogs/Firmware";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "mkdir -p /var/log/updateLogs/Firmware";
        OnyxxJobsUtil.runCommand(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean running_on_Debian() {
        boolean returnValue = false;
        String line = "";
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader("/tmp/resources/Firmware/os_release.txt"));
            line = br.readLine();
            while (line != null) {
                if (line.indexOf("Debian GNU/Linux") > -1) {
                    returnValue = true;
                    break;
                }
                line = br.readLine();
            }
        }
        catch (IOException e) {
            log.error("Error reading OS Definition file");
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {
                log.error("Error occurred during buffered reader close method for OS definition file", (Throwable)e);
            }
        }
        return returnValue;
    }
}

