/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.fileIO;

import com.lynxspring.onyxxDriver.devices.BOnyxxDevice;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.lynxspring.onyxxDriver.point.BIOnyxxWritable;
import com.lynxspring.onyxxDriver.point.BOnyxxProxyExt;
import com.tridium.util.ArrayUtil;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true", flags=5, facets={@Facet(value="BFacets.makeBoolean(\"True\", \"False\")")}), @NiagaraProperty(name="resendInterval", type="BRelTime", defaultValue="BRelTime.makeSeconds(10)", facets={@Facet(value="BFacets.make(\"min\", BRelTime.makeSeconds(10))")}), @NiagaraProperty(name="interPointDelay", type="BRelTime", defaultValue="BRelTime.makeSeconds(10)", facets={@Facet(value="BFacets.make(\"min\", BRelTime.makeSeconds(1))")})})
public class BOnyxxCollisionArbitrationFeatures
extends BComponent
implements Runnable {
    public static final Property enabled = BOnyxxCollisionArbitrationFeatures.newProperty((int)5, (boolean)true, (BFacets)BFacets.makeBoolean((String)"True", (String)"False"));
    public static final Property resendInterval = BOnyxxCollisionArbitrationFeatures.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)10), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)10)));
    public static final Property interPointDelay = BOnyxxCollisionArbitrationFeatures.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)10), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Type TYPE = Sys.loadType(BOnyxxCollisionArbitrationFeatures.class);
    private Thread writeThread = null;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BRelTime getResendInterval() {
        return (BRelTime)this.get(resendInterval);
    }

    public void setResendInterval(BRelTime v) {
        this.set(resendInterval, (BValue)v, null);
    }

    public BRelTime getInterPointDelay() {
        return (BRelTime)this.get(interPointDelay);
    }

    public void setInterPointDelay(BRelTime v) {
        this.set(interPointDelay, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (Sys.isStationStarted()) {
            this.startThread();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property.equals(resendInterval)) {
            this.startThread();
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.startThread();
            } else {
                this.stopThread();
            }
        }
    }

    private void writeAll() throws InterruptedException {
        BOnyxxProxyExt[] proxyArray = this.getWritableProxies();
        int x = 0;
        long pointDelay = this.getInterPointDelay().getMillis();
        for (x = 0; x < proxyArray.length; ++x) {
            try {
                proxyArray[x].write(null);
            }
            catch (Exception e) {
                BOnyxxNetwork.LOG.error("Write Failed for Proxy " + proxyArray[x].getParent().getName(), (Throwable)e);
            }
            Thread.sleep(pointDelay);
        }
    }

    private BOnyxxProxyExt[] getWritableProxies() {
        BOnyxxNetwork network = (BOnyxxNetwork)this.getParent();
        BOnyxxDevice[] deviceArray = network.getOnyxxDevices();
        Object[] proxyArray = new BOnyxxProxyExt[]{};
        int x = 0;
        for (x = 0; x < deviceArray.length; ++x) {
            BOnyxxDevice device = deviceArray[x];
            BControlPoint[] pointArray = device.getPoints().getPoints();
            int y = 0;
            for (y = 0; y < pointArray.length; ++y) {
                BControlPoint point = pointArray[y];
                BOnyxxProxyExt proxy = (BOnyxxProxyExt)point.getProxyExt();
                if (proxy == null || !proxy.getType().is(BIOnyxxWritable.TYPE)) continue;
                proxyArray = (BOnyxxProxyExt[])ArrayUtil.addOne((Object[])proxyArray, (Object)proxy);
            }
        }
        return proxyArray;
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
        this.startThread();
    }

    public void stopped() {
        this.stopThread();
    }

    public void startThread() {
        this.stopThread();
        this.writeThread = new Thread((Runnable)this, "Write All:" + this.getParent().getName());
        this.writeThread.start();
    }

    public void stopThread() {
        if (this.writeThread != null) {
            this.writeThread.interrupt();
        }
    }

    public void reStartThread() {
        this.startThread();
    }

    @Override
    public void run() {
        long interval = this.getResendInterval().getMillis();
        BOnyxxNetwork network = (BOnyxxNetwork)this.getParent();
        try {
            while (true) {
                if (!(network.isDown() || network.isFault() || network.isFatalFault())) {
                    this.writeAll();
                }
                Thread.sleep(interval);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            BOnyxxNetwork.LOG.error("Write All Failed.", (Throwable)e);
        }
    }
}

