/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.devices;

import com.lynxspring.onyxxDriver.devices.BOnyxxXm34Device;
import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxDriver.jobs.BOnyxxIdentifyDeviceJob;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.lynxspring.onyxxDriver.point.BOnyxxPointDeviceExt;
import com.lynxspring.onyxxDriver.point.BOnyxxProxyExt;
import com.tridium.ndriver.BNDevice;
import com.tridium.ndriver.util.SfUtil;
import java.io.File;
import java.util.ArrayList;
import javax.baja.control.BControlPoint;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="points", type="BOnyxxPointDeviceExt", defaultValue="new BOnyxxPointDeviceExt()"), @NiagaraProperty(name="devicePath", type="String", defaultValue="", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}), @NiagaraProperty(name="LocalDevice", type="boolean", defaultValue="false", flags=5, facets={@Facet(value="BFacets.makeBoolean(\"True\", \"False\")")}), @NiagaraProperty(name="regulatorValue5V", type="String", defaultValue="", flags=5), @NiagaraProperty(name="regulatorValue15V", type="String", defaultValue="", flags=5), @NiagaraProperty(name="regulatorValue3_3V", type="String", defaultValue="", flags=5), @NiagaraProperty(name="deviceTempValue", type="String", defaultValue="", flags=5)})
@NiagaraAction(name="identifyDevice", returnType="BOrd")
public class BOnyxxDevice
extends BNDevice {
    public static final Property status = BOnyxxDevice.newProperty((int)75, (BValue)BStatus.ok, (BFacets)SfUtil.incl((String)"ed.ro"));
    public static final Property points = BOnyxxDevice.newProperty((int)0, (BValue)new BOnyxxPointDeviceExt(), null);
    public static final Property devicePath = BOnyxxDevice.newProperty((int)0, (String)"", (BFacets)SfUtil.incl((String)"ed"));
    public static final Property LocalDevice = BOnyxxDevice.newProperty((int)5, (boolean)false, (BFacets)BFacets.makeBoolean((String)"True", (String)"False"));
    public static final Property regulatorValue5V = BOnyxxDevice.newProperty((int)5, (String)"", null);
    public static final Property regulatorValue15V = BOnyxxDevice.newProperty((int)5, (String)"", null);
    public static final Property regulatorValue3_3V = BOnyxxDevice.newProperty((int)5, (String)"", null);
    public static final Property deviceTempValue = BOnyxxDevice.newProperty((int)5, (String)"", null);
    public static final Action identifyDevice = BOnyxxDevice.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BOnyxxDevice.class);
    public static Log LOG = Log.getLog((String)Sys.getModuleForClass(BOnyxxNetwork.class).getModuleName());
    private static final String PING_FILE_NAME = "ping_status";
    private static final long PING_MAX = 5000L;
    private long devicePingStatusRuntime = -1L;
    ArrayList<BOnyxxProxyExt> subscribed_points = new ArrayList();
    private int readFaultCount = 0;

    public BOnyxxPointDeviceExt getPoints() {
        return (BOnyxxPointDeviceExt)this.get(points);
    }

    public void setPoints(BOnyxxPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    public String getDevicePath() {
        return this.getString(devicePath);
    }

    public void setDevicePath(String v) {
        this.setString(devicePath, v, null);
    }

    public boolean getLocalDevice() {
        return this.getBoolean(LocalDevice);
    }

    public void setLocalDevice(boolean v) {
        this.setBoolean(LocalDevice, v, null);
    }

    public String getRegulatorValue5V() {
        return this.getString(regulatorValue5V);
    }

    public void setRegulatorValue5V(String v) {
        this.setString(regulatorValue5V, v, null);
    }

    public String getRegulatorValue15V() {
        return this.getString(regulatorValue15V);
    }

    public void setRegulatorValue15V(String v) {
        this.setString(regulatorValue15V, v, null);
    }

    public String getRegulatorValue3_3V() {
        return this.getString(regulatorValue3_3V);
    }

    public void setRegulatorValue3_3V(String v) {
        this.setString(regulatorValue3_3V, v, null);
    }

    public String getDeviceTempValue() {
        return this.getString(deviceTempValue);
    }

    public void setDeviceTempValue(String v) {
        this.setString(deviceTempValue, v, null);
    }

    public BOrd identifyDevice() {
        return (BOrd)this.invoke(identifyDevice, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getNetworkType() {
        return BOnyxxNetwork.TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.getOnyxxNetwork().deviceChanged(this);
        if (this.getOnyxxNetwork().parseHostID().equals(this.getCanbusID())) {
            this.setLocalDevice(true);
        }
        this.doPing();
        this.setTempValue();
        this.setRegulatorValues();
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (this.isRunning() && prop == devicePath) {
            this.getOnyxxNetwork().deviceChanged(this);
            this.validateDevicePath();
            this.setTempValue();
            this.setRegulatorValues();
            if (this.getOnyxxNetwork().parseHostID().equals(this.getCanbusID()) && !this.getType().equals(BOnyxxXm34Device.TYPE)) {
                this.setLocalDevice(true);
            } else {
                this.setLocalDevice(false);
            }
            if (!this.isConfigFault()) {
                try {
                    this.doPing();
                }
                catch (Exception e) {
                    LOG.error("deviceChanged: " + e.getMessage(), (Throwable)e);
                }
            }
            BOnyxxPointDeviceExt pde = this.getPoints();
            BComponent[] c = pde.getChildComponents();
            for (int i = 0; i < c.length; ++i) {
                if (!(c[i] instanceof BControlPoint) || !(((BControlPoint)c[i]).getProxyExt() instanceof BOnyxxProxyExt)) continue;
                BOnyxxProxyExt pext = (BOnyxxProxyExt)((BControlPoint)c[i]).getProxyExt();
                pext.writeFile();
            }
        }
    }

    public void validateDevicePath() {
        String devicePath = this.getDevicePath();
        if (!devicePath.endsWith("/")) {
            LOG.warning("Device path " + devicePath + " is missing trailing slash.");
        }
    }

    public static String checkTrailSlash(String pathStr) {
        if (!pathStr.endsWith("/")) {
            pathStr = pathStr + "/";
        }
        return pathStr;
    }

    public boolean isConfigFault() {
        boolean isFault = false;
        if (this.isFault() && !this.isFatalFault() && !this.getNetwork().isFault()) {
            isFault = true;
        }
        return isFault;
    }

    public void doPing() {
        long previousRuntime = this.devicePingStatusRuntime;
        long pingTime = this.readPingFile();
        if (pingTime == -1L) {
            BOnyxxNetwork.COMM_LOG.trace("System Error.  No Ping File found!");
            this.pingFail("Ping File Not Found");
        } else if (pingTime < 5000L && previousRuntime != this.devicePingStatusRuntime) {
            BOnyxxNetwork.COMM_LOG.trace("Onyxx Device Ping:  " + this.getDisplayName(null) + " is up");
            this.setStatus(BStatus.ok);
            this.pingOk();
        } else if (this.getOnyxxNetwork().getNetworkStatus() == 1) {
            pingTime = this.readPingFile();
            if (pingTime != -1L && pingTime < 5000L) {
                BOnyxxNetwork.COMM_LOG.trace("Onyxx Device Ping:  " + this.getDisplayName(null) + " is up");
                this.setStatus(BStatus.ok);
                this.pingOk();
            } else {
                this.pingFail("No Communication with device.  Was device removed from network?  Unpowered?");
                BOnyxxNetwork.COMM_LOG.trace(this.getDisplayName(null) + " has stopped communicating.\n\t\tEnsure device is powered and gray network cable is plugged in to all devices.\n\t\tIssue is not with Onyxx Network");
            }
        } else {
            this.pingFail("Onyxx Network is Down");
        }
        this.setTempValue();
        this.setRegulatorValues();
    }

    public long readPingFile() {
        String textValue = "";
        long currentPingValue = 0L;
        Object br = null;
        try {
            textValue = OnyxxFileAccess.FileIO(this.getFullDevicePath(), this.getPingFileName(), "", false);
        }
        catch (Exception e) {
            BOnyxxNetwork.COMM_LOG.trace("Error when reading Ping file: ", (Throwable)e);
            return -1L;
        }
        String VERSION_WITH_CHANGE = "1.0.2";
        String currentVersion = this.getOnyxxNetwork().getOnyxxSystemVersion();
        long numVerWithCorrection = this.getOnyxxNetwork().numericConvertFirmwareVersion(VERSION_WITH_CHANGE);
        long numCurVersion = this.getOnyxxNetwork().numericConvertFirmwareVersion(currentVersion);
        this.devicePingStatusRuntime = numCurVersion >= numVerWithCorrection ? Long.parseLong(textValue.substring(0, textValue.indexOf(","))) : Long.parseLong(textValue.substring(textValue.indexOf(",") - 9, textValue.indexOf(",")));
        currentPingValue = Long.parseLong(textValue.substring(textValue.indexOf(",") + 1));
        return currentPingValue;
    }

    public String getFullDevicePath() {
        String devicePath = this.getDevicePath();
        String networkPath = this.getOnyxxNetwork().getNetworkPath();
        devicePath = BOnyxxDevice.checkTrailSlash(devicePath);
        networkPath = BOnyxxDevice.checkTrailSlash(networkPath);
        return networkPath + devicePath;
    }

    public String getPingFileName() {
        return PING_FILE_NAME;
    }

    public void checkDevice() {
        try {
            File devDir = new File(this.getOnyxxNetwork().getNetworkPath(), this.getDevicePath());
            if (!devDir.exists() && !devDir.isDirectory()) {
                LOG.trace("Device Check: Device Directory not Found.  readFaultCount incremented");
                ++this.readFaultCount;
            } else {
                LOG.trace("Device Check:  Device Directory Found.  readFaultCount reset to 0.");
                this.readFaultCount = 0;
            }
            if (this.readFaultCount >= 2) {
                BOnyxxNetwork.COMM_LOG.trace("Device Check:  failed 2 or more times.  Putting device in Fault");
                this.setStatus(BStatus.fault);
            } else {
                this.setStatus(this.getStatus());
            }
        }
        catch (Exception e) {
            BOnyxxNetwork.COMM_LOG.trace("Checking Device failed", (Throwable)e);
        }
    }

    public String getCanbusID() {
        String devicePath = this.getDevicePath();
        devicePath = BOnyxxDevice.checkTrailSlash(devicePath);
        String strCanId = devicePath.substring(devicePath.indexOf("_") + 1, devicePath.length() - 1);
        return strCanId;
    }

    public long getPingMax() {
        return 5000L;
    }

    public final BOnyxxNetwork getOnyxxNetwork() {
        return (BOnyxxNetwork)this.getNetwork();
    }

    public void setRegulatorValues() {
        String value3_3V;
        String value15V;
        String value5V;
        try {
            value5V = OnyxxFileAccess.FileIO(this.getFullDevicePath(), "regulator_5v_conv", "", false) + " V";
        }
        catch (Exception e) {
            value5V = "Cannot read \"regulator_5v_conv\" file. Hardware or firmware may be out of date.";
        }
        this.setRegulatorValue5V(value5V);
        try {
            value15V = OnyxxFileAccess.FileIO(this.getFullDevicePath(), "regulator_15v_conv", "", false) + " V";
        }
        catch (Exception e) {
            value15V = "Cannot read \"regulator_15v_conv\" file. Hardware or firmware may be out of date.";
        }
        this.setRegulatorValue15V(value15V);
        try {
            value3_3V = OnyxxFileAccess.FileIO(this.getFullDevicePath(), "regulator_3_3v_conv", "", false) + " V";
        }
        catch (Exception e) {
            value3_3V = "Cannot read \"regulator_3_3v_conv\" file. Hardware or firmware may be out of date.";
        }
        this.setRegulatorValue3_3V(value3_3V);
    }

    public void setTempValue() {
        String tempValue;
        try {
            tempValue = OnyxxFileAccess.FileIO(this.getFullDevicePath(), "internal_temp_conv", "", false) + " \u00b0F";
        }
        catch (Exception e) {
            tempValue = "Cannot read \"internal_temp_conv\" file. Hardware or firmware may be out of date.";
        }
        this.setDeviceTempValue(tempValue);
    }

    public BOrd doIdentifyDevice(Context cx) {
        return new BOnyxxIdentifyDeviceJob(this).submit(cx);
    }

    public void addSubscription(BOnyxxProxyExt ext) {
        this.subscribed_points.add(ext);
    }

    public void removeSubscription(BOnyxxProxyExt ext) {
        this.subscribed_points.remove(ext);
    }

    public Object[] getSubscriptions() {
        return this.subscribed_points.toArray();
    }
}

