/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.devices;

import com.lynxspring.onyxxDriver.devices.BOnyxxDevice;
import com.lynxspring.onyxxDriver.devices.versioning.BOnyxx434FirmwareVersion;
import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.lynxspring.onyxxDriver.update.UpdateParams;
import com.tridium.ndriver.util.SfUtil;
import java.util.ArrayList;
import javax.baja.log.Log;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="Versioning", type="BOnyxx434FirmwareVersion", defaultValue="new BOnyxx434FirmwareVersion()")
public class BOnyxx434Device
extends BOnyxxDevice {
    public static final Property status = BOnyxx434Device.newProperty((int)75, (BValue)BStatus.ok, (BFacets)SfUtil.incl((String)"ed.ro"));
    public static final Property Versioning = BOnyxx434Device.newProperty((int)0, (BValue)new BOnyxx434FirmwareVersion(), null);
    public static final Type TYPE = Sys.loadType(BOnyxx434Device.class);
    public static Log LOG = Log.getLog((String)Sys.getModuleForClass(BOnyxxNetwork.class).getModuleName());
    private static final String LED_SUBSYSTEM_PATH = "ld_subsystem/";
    private static final String AO_SUBSYSTEM_PATH = "ao_subsystem/";
    private static final String DO_SUBSYSTEM_PATH = "do_subsystem/";
    private static final String UI18_SUBSYSTEM_PATH = "u1_subsystem/";
    private static final String UI916_SUBSYSTEM_PATH = "u9_subsystem/";
    private static final int LED_CHIP = 1;
    private static final int DO_CHIP = 2;
    private static final int AO_CHIP = 3;
    private static final int UI18_CHIP = 5;
    private static final int UI916_CHIP = 6;
    public static final String LED_FIRMWARE_434 = "2.0.1";
    public static final String AO_FIRMWARE_434 = "1.0.13";
    public static final String DO_FIRMWARE_434 = "1.0.3";
    public static final String UI1_FIRMWARE_434 = "1.0.6";
    public static final String UI9_FIRMWARE_434 = "1.0.6";

    public BOnyxx434FirmwareVersion getVersioning() {
        return (BOnyxx434FirmwareVersion)this.get(Versioning);
    }

    public void setVersioning(BOnyxx434FirmwareVersion v) {
        this.set(Versioning, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.doPing();
    }

    @Override
    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
    }

    @Override
    public void doPing() {
        this.populateFirmwareVersion(1);
        this.populateFirmwareVersion(2);
        this.populateFirmwareVersion(3);
        this.populateFirmwareVersion(5);
        this.populateFirmwareVersion(6);
        super.doPing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void populateFirmwareVersion(int chip) {
        String fw_version = "0.0.9";
        String devicePath = this.getDevicePath();
        String networkPath = this.getOnyxxNetwork().getNetworkPath();
        devicePath = BOnyxx434Device.checkTrailSlash(devicePath);
        networkPath = BOnyxx434Device.checkTrailSlash(networkPath);
        try {
            switch (chip) {
                case 1: {
                    fw_version = OnyxxFileAccess.FileIO(networkPath + devicePath + LED_SUBSYSTEM_PATH, "version", "", false);
                    return;
                }
                case 2: {
                    fw_version = OnyxxFileAccess.FileIO(networkPath + devicePath + AO_SUBSYSTEM_PATH, "version", "", false);
                    return;
                }
                case 3: {
                    fw_version = OnyxxFileAccess.FileIO(networkPath + devicePath + DO_SUBSYSTEM_PATH, "version", "", false);
                    return;
                }
                case 5: {
                    fw_version = OnyxxFileAccess.FileIO(networkPath + devicePath + UI18_SUBSYSTEM_PATH, "version", "", false);
                    return;
                }
                case 6: {
                    fw_version = OnyxxFileAccess.FileIO(networkPath + devicePath + UI916_SUBSYSTEM_PATH, "version", "", false);
                    return;
                }
                default: {
                    this.getLog().trace("Could not retrieve Device Firmware Versioning for " + chip + ".  Unknown chip type!");
                    return;
                }
            }
        }
        catch (Exception e) {
            fw_version = "0.0.9";
            return;
        }
        finally {
            switch (chip) {
                case 1: {
                    this.getVersioning().setLedFirmwareVersion(fw_version);
                    break;
                }
                case 2: {
                    this.getVersioning().setAnalogOutputFirmwareVersion(fw_version);
                    break;
                }
                case 3: {
                    this.getVersioning().setDigitalOutputFirmwareVersion(fw_version);
                    break;
                }
                case 5: {
                    this.getVersioning().setUniversalInputFirmwareVersion_LowerPorts(fw_version);
                    break;
                }
                case 6: {
                    this.getVersioning().setUniversalInputFirmwareVersion_HigherPorts(fw_version);
                    break;
                }
            }
        }
    }

    public void check434UpdateNeed(ArrayList<UpdateParams> al, boolean autoUpdate) {
        boolean downgradeAttempt = false;
        if (BOnyxxNetwork.checkVersion(this.getVersioning().getLedFirmwareVersion(), LED_FIRMWARE_434) == 1 || BOnyxxNetwork.checkVersion(this.getVersioning().getDigitalOutputFirmwareVersion(), DO_FIRMWARE_434) == 1 || BOnyxxNetwork.checkVersion(this.getVersioning().getAnalogOutputFirmwareVersion(), AO_FIRMWARE_434) == 1 || BOnyxxNetwork.checkVersion(this.getVersioning().getUniversalInputFirmwareVersion_LowerPorts(), "1.0.6") == 1 || BOnyxxNetwork.checkVersion(this.getVersioning().getUniversalInputFirmwareVersion_HigherPorts(), "1.0.6") == 1) {
            downgradeAttempt = true;
        }
        if (!autoUpdate) {
            UpdateParams up;
            if (!this.getVersioning().getLedFirmwareVersion().equals(LED_FIRMWARE_434)) {
                up = new UpdateParams(TYPE.toString(), this.getCanbusID(), 1);
                al.add(up);
            }
            if (!this.getVersioning().getDigitalOutputFirmwareVersion().equals(DO_FIRMWARE_434)) {
                up = new UpdateParams(TYPE.toString(), this.getCanbusID(), 2);
                al.add(up);
            }
            if (!this.getVersioning().getAnalogOutputFirmwareVersion().equals(AO_FIRMWARE_434)) {
                up = new UpdateParams(TYPE.toString(), this.getCanbusID(), 3);
                al.add(up);
            }
            if (!this.getVersioning().getUniversalInputFirmwareVersion_LowerPorts().equals("1.0.6")) {
                up = new UpdateParams(TYPE.toString(), this.getCanbusID(), 5);
                al.add(up);
            }
            if (!this.getVersioning().getUniversalInputFirmwareVersion_HigherPorts().equals("1.0.6")) {
                up = new UpdateParams(TYPE.toString(), this.getCanbusID(), 6);
                al.add(up);
            }
            if (downgradeAttempt) {
                LOG.message("");
                LOG.message("---------------------------------------------------------------------------------");
                LOG.message("--                      !! FIRMWARE VERSION NOTICE !!                          --");
                LOG.message("--     One or more firmware versions are higher than the available version.    --");
                LOG.message("--            Downgrading those chips during this upgrade process.             --");
                LOG.message("---------------------------------------------------------------------------------");
            }
        } else {
            UpdateParams up;
            if (BOnyxxNetwork.checkVersion(this.getVersioning().getLedFirmwareVersion(), LED_FIRMWARE_434) == -1) {
                up = new UpdateParams(TYPE.toString(), this.getCanbusID(), 1);
                al.add(up);
            }
            if (BOnyxxNetwork.checkVersion(this.getVersioning().getDigitalOutputFirmwareVersion(), DO_FIRMWARE_434) == -1) {
                up = new UpdateParams(TYPE.toString(), this.getCanbusID(), 2);
                al.add(up);
            }
            if (BOnyxxNetwork.checkVersion(this.getVersioning().getAnalogOutputFirmwareVersion(), AO_FIRMWARE_434) == -1) {
                up = new UpdateParams(TYPE.toString(), this.getCanbusID(), 3);
                al.add(up);
            }
            if (BOnyxxNetwork.checkVersion(this.getVersioning().getUniversalInputFirmwareVersion_LowerPorts(), "1.0.6") == -1) {
                up = new UpdateParams(TYPE.toString(), this.getCanbusID(), 5);
                al.add(up);
            }
            if (BOnyxxNetwork.checkVersion(this.getVersioning().getUniversalInputFirmwareVersion_HigherPorts(), "1.0.6") == -1) {
                up = new UpdateParams(TYPE.toString(), this.getCanbusID(), 6);
                al.add(up);
            }
            if (downgradeAttempt) {
                LOG.message("---------------------------------------------------------------------------------");
                LOG.message("--                      !! FIRMWARE VERSION NOTICE !!                          --");
                LOG.message("--     One or more firmware versions are higher than the available version.    --");
                LOG.message("--                     To avoid unintentional downgrading,                     --");
                LOG.message("--              Automatic Update has been stopped for those chips.             --");
                LOG.message("---------------------------------------------------------------------------------");
            }
        }
    }
}

