/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.devices;

import com.lynxspring.onyxxDriver.devices.BOnyxxDevice;
import com.lynxspring.onyxxDriver.devices.versioning.BOnyxx414FirmwareVersion;
import com.lynxspring.onyxxDriver.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.lynxspring.onyxxDriver.update.UpdateParams;
import com.tridium.ndriver.util.SfUtil;
import java.util.ArrayList;
import javax.baja.log.Log;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="versioning", type="BOnyxx414FirmwareVersion", defaultValue="new BOnyxx414FirmwareVersion()")
public class BOnyxx414Device
extends BOnyxxDevice {
    public static final Property status = BOnyxx414Device.newProperty((int)75, (BValue)BStatus.ok, (BFacets)SfUtil.incl((String)"ed.ro"));
    public static final Property versioning = BOnyxx414Device.newProperty((int)0, (BValue)new BOnyxx414FirmwareVersion(), null);
    public static final Type TYPE = Sys.loadType(BOnyxx414Device.class);
    public static Log LOG = Log.getLog((String)Sys.getModuleForClass(BOnyxxNetwork.class).getModuleName());
    private static final String PING_FILE_NAME = "ping_status";
    private static final long PING_MAX = 5000L;
    private long devicePingStatusRuntime = -1L;
    private static final String LED_SUBSYSTEM_PATH = "ld_subsystem/";
    private static final String OUTPUTS_SUBSYSTEM_PATH = "ao_subsystem/";
    private static final String INPUTS_SUBSYSTEM_PATH = "u1_subsystem/";
    private static final int LED_CHIP = 1;
    private static final int OUTPUTS_CHIP = 3;
    private static final int INPUTS_CHIP = 5;
    public static final String LED_FIRMWARE_414 = "2.0.1";
    public static final String OUTPUTS_FIRMWARE_414 = "1.1.21";
    public static final String INPUTS_FIRMWARE_414 = "1.1.8";
    private int readFaultCount = 0;

    public BOnyxx414FirmwareVersion getVersioning() {
        return (BOnyxx414FirmwareVersion)this.get(versioning);
    }

    public void setVersioning(BOnyxx414FirmwareVersion v) {
        this.set(versioning, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.doPing();
    }

    @Override
    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
    }

    @Override
    public void doPing() {
        this.populateFirmwareVersion(1);
        this.populateFirmwareVersion(3);
        this.populateFirmwareVersion(5);
        super.doPing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void populateFirmwareVersion(int chip) {
        String fw_version = "0.0.9";
        String devicePath = this.getDevicePath();
        String networkPath = this.getOnyxxNetwork().getNetworkPath();
        devicePath = BOnyxx414Device.checkTrailSlash(devicePath);
        networkPath = BOnyxx414Device.checkTrailSlash(networkPath);
        try {
            switch (chip) {
                case 1: {
                    fw_version = OnyxxFileAccess.FileIO(networkPath + devicePath + LED_SUBSYSTEM_PATH, "version", "", false);
                    return;
                }
                case 3: {
                    fw_version = OnyxxFileAccess.FileIO(networkPath + devicePath + OUTPUTS_SUBSYSTEM_PATH, "version", "", false);
                    return;
                }
                case 5: {
                    fw_version = OnyxxFileAccess.FileIO(networkPath + devicePath + INPUTS_SUBSYSTEM_PATH, "version", "", false);
                    return;
                }
                default: {
                    this.getLog().trace("Could not retrieve Device Firmware Versioning for " + chip + ".  Unknown chip type!");
                    return;
                }
            }
        }
        catch (Exception e) {
            fw_version = "0.0.9";
            return;
        }
        finally {
            switch (chip) {
                case 1: {
                    this.getVersioning().setLedFirmwareVersion(fw_version);
                    break;
                }
                case 3: {
                    this.getVersioning().setOutputsFirmwareVersion(fw_version);
                    break;
                }
                case 5: {
                    this.getVersioning().setInputsFirmwareVersion(fw_version);
                    break;
                }
            }
        }
    }

    public void check414UpdateNeed(ArrayList<UpdateParams> al, boolean autoUpdate) {
        boolean downgradeAttempt = false;
        if (BOnyxxNetwork.checkVersion(this.getVersioning().getLedFirmwareVersion(), LED_FIRMWARE_414) == 1 || BOnyxxNetwork.checkVersion(this.getVersioning().getOutputsFirmwareVersion(), OUTPUTS_FIRMWARE_414) == 1 || BOnyxxNetwork.checkVersion(this.getVersioning().getInputsFirmwareVersion(), INPUTS_FIRMWARE_414) == 1) {
            downgradeAttempt = true;
        }
        if (!autoUpdate) {
            UpdateParams up;
            if (!this.getVersioning().getLedFirmwareVersion().equals(LED_FIRMWARE_414)) {
                up = new UpdateParams(TYPE.toString(), this.getCanbusID(), 1);
                al.add(up);
            }
            if (!this.getVersioning().getOutputsFirmwareVersion().equals(OUTPUTS_FIRMWARE_414)) {
                up = new UpdateParams(TYPE.toString(), this.getCanbusID(), 3);
                al.add(up);
            }
            if (!this.getVersioning().getInputsFirmwareVersion().equals(INPUTS_FIRMWARE_414)) {
                up = new UpdateParams(TYPE.toString(), this.getCanbusID(), 5);
                al.add(up);
            }
            if (downgradeAttempt) {
                LOG.message("");
                LOG.message("---------------------------------------------------------------------------------");
                LOG.message("--                      !! FIRMWARE VERSION NOTICE !!                          --");
                LOG.message("--     One or more firmware versions are higher than the available version.    --");
                LOG.message("--            Downgrading those chips during this upgrade process.             --");
                LOG.message("---------------------------------------------------------------------------------");
            }
        } else {
            UpdateParams up;
            if (BOnyxxNetwork.checkVersion(this.getVersioning().getLedFirmwareVersion(), LED_FIRMWARE_414) == -1) {
                up = new UpdateParams(TYPE.toString(), this.getCanbusID(), 1);
                al.add(up);
            }
            if (BOnyxxNetwork.checkVersion(this.getVersioning().getInputsFirmwareVersion(), INPUTS_FIRMWARE_414) == -1) {
                up = new UpdateParams(TYPE.toString(), this.getCanbusID(), 5);
                al.add(up);
            }
            if (BOnyxxNetwork.checkVersion(this.getVersioning().getOutputsFirmwareVersion(), OUTPUTS_FIRMWARE_414) == -1) {
                up = new UpdateParams(TYPE.toString(), this.getCanbusID(), 3);
                al.add(up);
            }
            if (downgradeAttempt) {
                LOG.message("---------------------------------------------------------------------------------");
                LOG.message("--                      !! FIRMWARE VERSION NOTICE !!                          --");
                LOG.message("--     One or more firmware versions are higher than the available version.    --");
                LOG.message("--                     To avoid unintentional downgrading,                     --");
                LOG.message("--              Automatic Update has been stopped for those chips.             --");
                LOG.message("---------------------------------------------------------------------------------");
            }
        }
    }
}

