/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.conv;

import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.lynxspring.onyxxDriver.point.BOnyxxVavPressureInputProxyExt;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BNumber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BVavConversion
extends BProxyConversion {
    public static final Type TYPE = Sys.loadType(BVavConversion.class);

    public Type getType() {
        return TYPE;
    }

    public final void convertDeviceToProxy(BProxyExt ext, BStatusValue deviceValue, BStatusValue proxyValue) throws Exception {
        if (deviceValue instanceof BStatusNumeric) {
            this.convert(ext, (BStatusNumeric)deviceValue, (BStatusNumeric)proxyValue, true);
        } else {
            proxyValue.copyFrom((BComplex)deviceValue);
        }
    }

    public final void convertProxyToDevice(BProxyExt ext, BStatusValue proxyValue, BStatusValue deviceValue) throws Exception {
        if (proxyValue instanceof BStatusNumeric) {
            this.convert(ext, (BStatusNumeric)proxyValue, (BStatusNumeric)deviceValue, false);
        } else {
            deviceValue.copyFrom((BComplex)proxyValue);
        }
    }

    public abstract double convertValue(double var1, boolean var3);

    private void convert(BProxyExt ext, BStatusNumeric from, BStatusNumeric to, boolean deviceToProxy) {
        double fromValue = from.getValue();
        double lastReading = 0.0;
        double oldToValue = 0.0;
        double toValue = 0.0;
        boolean valueShouldBeUpdated = false;
        BOnyxxVavPressureInputProxyExt vavProxyExt = null;
        vavProxyExt = (BOnyxxVavPressureInputProxyExt)ext;
        lastReading = vavProxyExt.getLastReading();
        oldToValue = ((BNumber)vavProxyExt.getParentPoint().getOutStatusValue().getValueValue()).getDouble();
        toValue = this.convertValue(fromValue, deviceToProxy);
        BOnyxxNetwork.LOG.trace("Calculated output value: " + toValue + " (pressure: " + fromValue + ")");
        if (!deviceToProxy) {
            BOnyxxNetwork.LOG.trace("- Converting from proxy to device. Will update output value.");
            valueShouldBeUpdated = true;
        } else {
            double cfmAtMinimumMeasurablePressure = 0.0;
            int cfmStepSize = 0;
            cfmAtMinimumMeasurablePressure = vavProxyExt.getCfmForMinimumMeasurablePressure();
            BOnyxxNetwork.LOG.trace("- CFM @ min. meas. pressure: " + cfmAtMinimumMeasurablePressure);
            if (toValue >= cfmAtMinimumMeasurablePressure) {
                BOnyxxNetwork.LOG.trace("- CFM is at or above that for minimum measurable pressure. Converting to steps.");
                cfmStepSize = vavProxyExt.getCfmStepSize();
                toValue = Math.floor((toValue - cfmAtMinimumMeasurablePressure) / (double)cfmStepSize) * (double)cfmStepSize + cfmAtMinimumMeasurablePressure;
                valueShouldBeUpdated = true;
            } else {
                double cfmAtHalfwayPoint = 0.0;
                int numberOfSteps = 0;
                double stepNumber = 0.0;
                BOnyxxNetwork.LOG.trace("- CFM is below that for minimum measurable pressure.");
                cfmAtHalfwayPoint = this.convertValue(vavProxyExt.getDiffPressureLowerLimit() / 2.0, true);
                BOnyxxNetwork.LOG.trace("- CFM @ pressure halfway point: " + cfmAtHalfwayPoint);
                if (toValue < cfmAtHalfwayPoint) {
                    BOnyxxNetwork.LOG.trace("- CFM is below that for halfway point. Using zero.");
                    toValue = 0.0;
                } else {
                    BOnyxxNetwork.LOG.trace("- CFM is at or above that for halfway point. Using steps.");
                    numberOfSteps = vavProxyExt.getDivisionsBelowMinimumMeasurablePressure();
                    BOnyxxNetwork.LOG.trace("  - Step count: " + numberOfSteps);
                    stepNumber = Math.floor((double)numberOfSteps * ((toValue - cfmAtHalfwayPoint) / (cfmAtMinimumMeasurablePressure - cfmAtHalfwayPoint)));
                    BOnyxxNetwork.LOG.trace("  - Step number: " + stepNumber);
                    toValue = (cfmAtMinimumMeasurablePressure - cfmAtHalfwayPoint) * (stepNumber / (double)numberOfSteps) + cfmAtHalfwayPoint;
                }
                BOnyxxNetwork.LOG.trace("- New CFM: " + toValue);
            }
            BOnyxxNetwork.LOG.trace("- Last reading: " + lastReading);
            if (toValue == lastReading) {
                BOnyxxNetwork.LOG.trace("- New CFM equals last reading. Incrementing counter.");
                vavProxyExt.setNumberOfReadingsAtCurrentStep(vavProxyExt.getNumberOfReadingsAtCurrentStep() + 1);
            } else {
                BOnyxxNetwork.LOG.trace("- New CFM is different from last reading. Resetting counter.");
                vavProxyExt.setNumberOfReadingsAtCurrentStep(1);
            }
            BOnyxxNetwork.LOG.trace("- New counter value: " + vavProxyExt.getNumberOfReadingsAtCurrentStep());
            if (oldToValue >= cfmAtMinimumMeasurablePressure || toValue >= cfmAtMinimumMeasurablePressure) {
                BOnyxxNetwork.LOG.trace("- New or old CFM is at or above that for minimum measurable pressure. Will update output value.");
                valueShouldBeUpdated = true;
            } else {
                BOnyxxNetwork.LOG.trace("- Number of reads required for output-value update: 3");
                boolean bl = valueShouldBeUpdated = vavProxyExt.getNumberOfReadingsAtCurrentStep() >= 3;
                if (valueShouldBeUpdated) {
                    BOnyxxNetwork.LOG.trace("- Number reached. Will update output value.");
                } else {
                    BOnyxxNetwork.LOG.trace("- Number not reached. Will not update output value.");
                }
            }
        }
        to.setStatus(from.getStatus());
        if (deviceToProxy) {
            vavProxyExt.setLastReading(toValue);
        }
        if (valueShouldBeUpdated) {
            BOnyxxNetwork.LOG.trace("- Updating output value.");
            BOnyxxNetwork.LOG.trace("  - Old value: " + oldToValue);
            BOnyxxNetwork.LOG.trace("  - New value: " + toValue);
            to.setValue(toValue);
        } else {
            BOnyxxNetwork.LOG.trace("- Not updating output value.");
            to.setValue(oldToValue);
        }
    }
}

