/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxDriver.conv;

import com.lynxspring.onyxxDriver.conv.BVavConversion;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BKFactorConversion
extends BVavConversion {
    public static final BKFactorConversion DEFAULT = new BKFactorConversion(0.0, 0.0);
    private double k_factor;
    private double crossSectional;
    private int hashCode = -1;
    public static final Type TYPE = Sys.loadType(BKFactorConversion.class);

    public static BKFactorConversion make(double k_factor, double crossSectional) {
        return k_factor == 0.0 && crossSectional == 0.0 ? DEFAULT : (BKFactorConversion)new BKFactorConversion(k_factor, crossSectional).intern();
    }

    private BKFactorConversion(double k_factor, double crossSectional) {
        this.k_factor = k_factor;
        this.crossSectional = crossSectional;
    }

    public double getK_factor() {
        return this.k_factor;
    }

    public double getCrossSectional() {
        return this.crossSectional;
    }

    @Override
    public double convertValue(double fromValue, boolean deviceToProxy) {
        float airVelocity = 0.0f;
        double toValue = 0.0;
        if (deviceToProxy) {
            airVelocity = 4005.0f * (float)Math.sqrt(fromValue / this.k_factor);
            toValue = (float)this.crossSectional * airVelocity;
        } else {
            double denom = this.crossSectional * 4005.0;
            toValue = Math.pow(fromValue / denom, 2.0) * this.k_factor;
        }
        return toValue;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BKFactorConversion)) {
            return false;
        }
        BKFactorConversion convObj = (BKFactorConversion)((Object)obj);
        return this.k_factor == convObj.k_factor && this.crossSectional == convObj.crossSectional;
    }

    public String toString(Context context) {
        StringBuffer s = new StringBuffer();
        s.append(TYPE.getDisplayName(context));
        s.append(" K-Factor: ").append(BDouble.toString((double)this.k_factor, (Context)context));
        s.append(" Cross Sectional: ").append(BDouble.toString((double)this.crossSectional, (Context)context));
        return s.toString();
    }

    public void encode(DataOutput out) throws IOException {
        out.writeDouble(this.k_factor);
        out.writeDouble(this.crossSectional);
    }

    public BObject decode(DataInput in) throws IOException {
        return BKFactorConversion.make(in.readDouble(), in.readDouble());
    }

    public String encodeToString() {
        return BDouble.encode((double)this.k_factor) + ";" + BDouble.encode((double)this.crossSectional);
    }

    public BObject decodeFromString(String s) throws IOException {
        int semi = s.indexOf(59);
        return BKFactorConversion.make(BDouble.decode((String)s.substring(0, semi)), BDouble.decode((String)s.substring(semi + 1)));
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            long hash = 23L + Double.doubleToRawLongBits(this.k_factor);
            hash = hash * 37L + Double.doubleToRawLongBits(this.crossSectional);
            this.hashCode = (int)(hash >>> 32) ^ (int)hash;
        }
        return this.hashCode;
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

