/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxConverter.jobs;

import com.lynxspring.onyxxConverter.util.BOnyxxConverterParameters;
import com.lynxspring.onyxxConverter.util.ConversionImportUtil;
import com.lynxspring.onyxxDriver.devices.BOnyxxDevice;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.lynxspring.onyxxDriver.point.BLinearCalibrationExt;
import com.lynxspring.onyxxDriver.point.BOnyxxBooleanInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxBooleanOutputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxCounterInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxPointFolder;
import com.lynxspring.onyxxDriver.point.BOnyxxProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxResistiveInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxVoltageInputProxyExt;
import com.lynxspring.onyxxDriver.point.BOnyxxVoltageOutputProxyExt;
import com.tridium.ndio.point.BNdioBooleanInputProxyExt;
import com.tridium.ndio.point.BNdioBooleanOutputProxyExt;
import com.tridium.ndio.point.BNdioCounterInputProxyExt;
import com.tridium.ndio.point.BNdioProxyExt;
import com.tridium.ndio.point.BNdioResistiveInputProxyExt;
import com.tridium.ndio.point.BNdioVoltageInputProxyExt;
import com.tridium.ndio.point.BNdioVoltageOutputProxyExt;
import com.tridium.nrio.points.BNrio16ProxyExt;
import com.tridium.nrio.points.BNrio16WriteProxyExt;
import com.tridium.nrio.points.BNrioBooleanInputProxyExt;
import com.tridium.nrio.points.BNrioCounterInputProxyExt;
import com.tridium.nrio.points.BNrioProxyExt;
import com.tridium.nrio.points.BNrioRelayOutputProxyExt;
import com.tridium.nrio.points.BNrioResistiveInputProxyExt;
import com.tridium.nrio.points.BNrioVoltageInputProxyExt;
import com.tridium.nrio.points.BNrioVoltageOutputProxyExt;
import com.tridium.nrio.points.BUiProxyExt;
import com.tridium.sys.transfer.TransferStrategy;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BPointExtension;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.BDevice;
import javax.baja.driver.point.BPointFolder;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BFolder;

@NiagaraType
public class BOnyxxConverterImportJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BOnyxxConverterImportJob.class);
    public static BIcon icon = BIcon.std((String)"find.png");
    BOnyxxNetwork network;
    BDevice ioDeviceForImport;
    BOnyxxDevice onyxxDeviceForImport;
    int totalPoints = 0;
    int processedPoints = 0;
    private final String TAG_PROP_LABEL = "ioImportTag";
    public static final String INDEX_LABEL = "ioImportRowIndex";
    public static final String IMPORTED_VALUE_LABEL = "ioImportedValue";

    public Type getType() {
        return TYPE;
    }

    public BOnyxxConverterImportJob(BOnyxxNetwork network, BOnyxxConverterParameters deviceParameters) {
        this.network = network;
        if (deviceParameters != null && deviceParameters.getImportHandle() != BOrd.NULL && deviceParameters.getOnyxxHandle() != BOrd.NULL) {
            this.ioDeviceForImport = (BDevice)deviceParameters.getImportHandle().get((BObject)network);
            this.add(INDEX_LABEL, (BValue)BInteger.make((int)deviceParameters.getImportRowIndex()));
            this.onyxxDeviceForImport = (BOnyxxDevice)deviceParameters.getOnyxxHandle().get((BObject)network);
        } else {
            this.ioDeviceForImport = null;
            this.onyxxDeviceForImport = null;
        }
    }

    public BOnyxxConverterImportJob(BOnyxxNetwork network) {
        this.network = network;
        this.ioDeviceForImport = null;
        this.onyxxDeviceForImport = null;
    }

    public BOnyxxConverterImportJob() {
        this.network = null;
        this.ioDeviceForImport = null;
        this.onyxxDeviceForImport = null;
    }

    public void run(Context cx) throws Exception {
        if (this.network == null) {
            throw new IllegalStateException("Must submit through submitDiscoveryJob()");
        }
        if (this.ioDeviceForImport == null || this.onyxxDeviceForImport == null) {
            throw new IllegalStateException("Must have devices submitted with Job");
        }
        this.log().start("Importing Points from " + this.ioDeviceForImport.getName() + " to " + this.onyxxDeviceForImport.getName() + ".");
        this.ioDeviceForImport.lease(2);
        this.onyxxDeviceForImport.lease(2);
        BComponent[] componentList = ((BComponent)this.ioDeviceForImport.get("points")).getChildComponents();
        this.importPoints(componentList, (BComponent)this.onyxxDeviceForImport.getPoints());
        if (this.ioDeviceForImport.get("ioImportTag") == null) {
            this.ioDeviceForImport.add("ioImportTag", (BValue)BString.make((String)this.onyxxDeviceForImport.getName()), 5);
        } else {
            this.ioDeviceForImport.set("ioImportTag", (BValue)BString.make((String)(this.onyxxDeviceForImport.getName() + ";" + this.ioDeviceForImport.get("ioImportTag").toString())));
        }
        this.add(IMPORTED_VALUE_LABEL, (BValue)BString.make((String)this.ioDeviceForImport.get("ioImportTag").toString()));
        if (this.onyxxDeviceForImport.get("ioImportTag") == null) {
            this.onyxxDeviceForImport.add("ioImportTag", (BValue)BString.make((String)this.ioDeviceForImport.getHandleOrd().toString()), 5);
        } else {
            this.onyxxDeviceForImport.set("ioImportTag", (BValue)BString.make((String)(this.ioDeviceForImport.getHandleOrd().toString() + ";" + this.onyxxDeviceForImport.get("ioImportTag").toString())));
        }
        this.log().success("Completed Import.");
    }

    public int getIoDeviceForImportRowIndex() {
        return this.get(INDEX_LABEL) != null ? ((BInteger)this.get(INDEX_LABEL)).getInt() : -1;
    }

    public String getImportedStringValue() {
        return this.get(IMPORTED_VALUE_LABEL) != null ? ((BString)this.get(IMPORTED_VALUE_LABEL)).toString() : "";
    }

    public void setProcessedProgress() {
        this.progress(this.processedPoints / this.totalPoints);
    }

    private boolean isIOProxyExt(BAbstractProxyExt proxy) {
        return proxy instanceof BNdioProxyExt || proxy instanceof BNrio16ProxyExt || proxy instanceof BNrioProxyExt;
    }

    public void importPoints(BComponent[] componentList, BComponent container) throws Exception {
        container.lease();
        this.totalPoints += componentList.length;
        this.log().success("Found: " + componentList.length + " Components to import.");
        for (int j = 0; j < componentList.length; ++j) {
            componentList[j].lease();
            if (componentList[j] instanceof BControlPoint && this.isIOProxyExt(((BControlPoint)componentList[j]).getProxyExt())) {
                BControlPoint controlPoint = (BControlPoint)componentList[j];
                this.addIOPointFromPoint(controlPoint, container);
                this.setProcessedProgress();
            } else if (componentList[j] instanceof BFolder) {
                BOnyxxPointFolder foldercopy = componentList[j] instanceof BPointFolder ? new BOnyxxPointFolder() : (BFolder)componentList[j].getType().getTypeClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                container.add(componentList[j].getName(), (BValue)foldercopy);
                BComponent[] folderComponentList = componentList[j].getChildComponents();
                BFolder addedcopy = (BFolder)container.get(componentList[j].getName());
                this.importPoints(folderComponentList, (BComponent)addedcopy);
            } else {
                this.moveNonProxyComponent((BObject)componentList[j], container);
            }
            ++this.processedPoints;
            this.log().success("Imported: " + componentList[j].getName());
        }
    }

    private void moveNonProxyComponent(BObject comp, BComponent container) {
        Mark mark = new Mark(comp);
        TransferStrategy ctc = TransferStrategy.make((int)32, (Mark)mark, (BObject)container, null, null);
        try {
            ctc.transfer();
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addIOPointFromPoint(BControlPoint controlPoint, BComponent destination) throws Exception {
        BOnyxxProxyExt newProx;
        BNdioVoltageInputProxyExt origProx;
        BControlPoint cpt = (BControlPoint)controlPoint.getType().getTypeClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        BNumericPoint importedPoint = null;
        if (controlPoint.getProxyExt() instanceof BNdioProxyExt) {
            Type ndioPointType = controlPoint.getProxyExt().getType();
            if (ndioPointType.is(BNdioVoltageInputProxyExt.TYPE)) {
                importedPoint = new BNumericPoint();
                origProx = (BNdioVoltageInputProxyExt)controlPoint.getProxyExt();
                newProx = new BOnyxxVoltageInputProxyExt();
                newProx.setDeviceFacets(BFacets.make((BFacets)origProx.getDeviceFacets()));
                BProxyConversion conv = ConversionImportUtil.getMatchingOnyxxConversion(origProx.getConversion());
                if (conv != null) {
                    newProx.setConversion(conv);
                }
                newProx.setPortAddress(origProx.getAddress());
                importedPoint.setProxyExt((BAbstractProxyExt)newProx);
            } else if (ndioPointType.is(BNdioResistiveInputProxyExt.TYPE)) {
                importedPoint = new BNumericPoint();
                origProx = (BNdioResistiveInputProxyExt)controlPoint.getProxyExt();
                newProx = new BOnyxxResistiveInputProxyExt();
                newProx.setDeviceFacets(BFacets.make((BFacets)origProx.getDeviceFacets()));
                BProxyConversion conv = ConversionImportUtil.getMatchingOnyxxConversion(origProx.getConversion());
                if (conv != null) {
                    newProx.setConversion(conv);
                }
                newProx.setPortAddress(origProx.getAddress());
                importedPoint.setProxyExt((BAbstractProxyExt)newProx);
            } else if (ndioPointType.is(BNdioCounterInputProxyExt.TYPE)) {
                importedPoint = new BNumericPoint();
                origProx = (BNdioCounterInputProxyExt)controlPoint.getProxyExt();
                newProx = new BOnyxxCounterInputProxyExt();
                newProx.setDeviceFacets(BFacets.make((BFacets)origProx.getDeviceFacets()));
                BProxyConversion conv = ConversionImportUtil.getMatchingOnyxxConversion(origProx.getConversion());
                if (conv != null) {
                    newProx.setConversion(conv);
                }
                newProx.setPortAddress(origProx.getAddress());
                importedPoint.setProxyExt((BAbstractProxyExt)newProx);
            } else if (ndioPointType.is(BNdioBooleanInputProxyExt.TYPE)) {
                importedPoint = new BBooleanPoint();
                origProx = (BNdioBooleanInputProxyExt)controlPoint.getProxyExt();
                newProx = new BOnyxxBooleanInputProxyExt();
                newProx.setDeviceFacets(BFacets.make((BFacets)origProx.getDeviceFacets()));
                BProxyConversion conv = ConversionImportUtil.getMatchingOnyxxConversion(origProx.getConversion());
                if (conv != null) {
                    newProx.setConversion(conv);
                }
                newProx.setPortAddress(origProx.getAddress());
                importedPoint.setProxyExt((BAbstractProxyExt)newProx);
            } else if (ndioPointType.is(BNdioVoltageOutputProxyExt.TYPE)) {
                importedPoint = new BNumericWritable();
                origProx = (BNdioVoltageOutputProxyExt)controlPoint.getProxyExt();
                newProx = new BOnyxxVoltageOutputProxyExt();
                newProx.setDeviceFacets(BFacets.make((BFacets)origProx.getDeviceFacets()));
                BProxyConversion conv = ConversionImportUtil.getMatchingOnyxxConversion(origProx.getConversion());
                if (conv != null) {
                    newProx.setConversion(conv);
                }
                newProx.setPortAddress(origProx.getAddress());
                importedPoint.setProxyExt((BAbstractProxyExt)newProx);
            } else if (ndioPointType.is(BNdioBooleanOutputProxyExt.TYPE)) {
                importedPoint = new BBooleanWritable();
                origProx = (BNdioBooleanOutputProxyExt)controlPoint.getProxyExt();
                newProx = new BOnyxxBooleanOutputProxyExt();
                newProx.setDeviceFacets(BFacets.make((BFacets)origProx.getDeviceFacets()));
                BProxyConversion conv = ConversionImportUtil.getMatchingOnyxxConversion(origProx.getConversion());
                if (conv != null) {
                    newProx.setConversion(conv);
                }
                newProx.setPortAddress(origProx.getAddress());
                importedPoint.setProxyExt((BAbstractProxyExt)newProx);
            }
        } else if (controlPoint.getProxyExt() instanceof BNrio16ProxyExt) {
            Type nrioPointType = controlPoint.getProxyExt().getType();
            if (nrioPointType.is(BNrio16WriteProxyExt.TYPE)) {
                if (nrioPointType.is(BNrioRelayOutputProxyExt.TYPE)) {
                    importedPoint = new BBooleanWritable();
                    origProx = (BNrioRelayOutputProxyExt)controlPoint.getProxyExt();
                    newProx = new BOnyxxBooleanOutputProxyExt();
                    newProx.setDeviceFacets(BFacets.make((BFacets)origProx.getDeviceFacets()));
                    BProxyConversion conv = ConversionImportUtil.getMatchingOnyxxConversion(origProx.getConversion());
                    if (conv != null) {
                        newProx.setConversion(conv);
                    }
                    newProx.setPortAddress(origProx.getInstance());
                    importedPoint.setProxyExt((BAbstractProxyExt)newProx);
                } else if (nrioPointType.is(BNrioVoltageOutputProxyExt.TYPE)) {
                    importedPoint = new BNumericWritable();
                    origProx = (BNrioVoltageOutputProxyExt)controlPoint.getProxyExt();
                    newProx = new BOnyxxVoltageOutputProxyExt();
                    newProx.setDeviceFacets(BFacets.make((BFacets)origProx.getDeviceFacets()));
                    BProxyConversion conv = ConversionImportUtil.getMatchingOnyxxConversion(origProx.getConversion());
                    if (conv != null) {
                        newProx.setConversion(conv);
                    }
                    newProx.setPortAddress(origProx.getInstance());
                    importedPoint.setProxyExt((BAbstractProxyExt)newProx);
                }
            } else if (nrioPointType.is(BUiProxyExt.TYPE)) {
                if (nrioPointType.is(BNrioBooleanInputProxyExt.TYPE)) {
                    importedPoint = new BBooleanPoint();
                    origProx = (BNrioBooleanInputProxyExt)controlPoint.getProxyExt();
                    newProx = new BOnyxxBooleanInputProxyExt();
                    newProx.setDeviceFacets(BFacets.make((BFacets)origProx.getDeviceFacets()));
                    BProxyConversion conv = ConversionImportUtil.getMatchingOnyxxConversion(origProx.getConversion());
                    if (conv != null) {
                        newProx.setConversion(conv);
                    }
                    newProx.setPortAddress(origProx.getInstance());
                    importedPoint.setProxyExt((BAbstractProxyExt)newProx);
                } else if (nrioPointType.is(BNrioCounterInputProxyExt.TYPE)) {
                    importedPoint = new BNumericPoint();
                    origProx = (BNrioCounterInputProxyExt)controlPoint.getProxyExt();
                    newProx = new BOnyxxCounterInputProxyExt();
                    newProx.setDeviceFacets(BFacets.make((BFacets)origProx.getDeviceFacets()));
                    BProxyConversion conv = ConversionImportUtil.getMatchingOnyxxConversion(origProx.getConversion());
                    if (conv != null) {
                        newProx.setConversion(conv);
                    }
                    newProx.setPortAddress(origProx.getInstance());
                    importedPoint.setProxyExt((BAbstractProxyExt)newProx);
                } else if (nrioPointType.is(BNrioResistiveInputProxyExt.TYPE)) {
                    importedPoint = new BNumericPoint();
                    origProx = (BNrioResistiveInputProxyExt)controlPoint.getProxyExt();
                    newProx = new BOnyxxResistiveInputProxyExt();
                    newProx.setDeviceFacets(BFacets.make((BFacets)origProx.getDeviceFacets()));
                    BProxyConversion conv = ConversionImportUtil.getMatchingOnyxxConversion(origProx.getConversion());
                    if (conv != null) {
                        newProx.setConversion(conv);
                    }
                    newProx.setPortAddress(origProx.getInstance());
                    importedPoint.setProxyExt((BAbstractProxyExt)newProx);
                } else if (nrioPointType.is(BNrioVoltageInputProxyExt.TYPE)) {
                    importedPoint = new BNumericPoint();
                    origProx = (BNrioVoltageInputProxyExt)controlPoint.getProxyExt();
                    newProx = new BOnyxxVoltageInputProxyExt();
                    newProx.setDeviceFacets(BFacets.make((BFacets)origProx.getDeviceFacets()));
                    BProxyConversion conv = ConversionImportUtil.getMatchingOnyxxConversion(origProx.getConversion());
                    if (conv != null) {
                        newProx.setConversion(conv);
                    }
                    newProx.setPortAddress(origProx.getInstance());
                    importedPoint.setProxyExt((BAbstractProxyExt)newProx);
                }
            }
        } else if (controlPoint.getProxyExt() instanceof BNrioProxyExt) {
            // empty if block
        }
        if (importedPoint != null) {
            BPointExtension origLinearCalibration = (BPointExtension)controlPoint.get("linearCalibration");
            if (origLinearCalibration == null) {
                origLinearCalibration = (BPointExtension)controlPoint.get("LinearCalibrationExtension");
            }
            if (origLinearCalibration != null) {
                importedPoint.add("linearCalibration", (BValue)new BLinearCalibrationExt());
                BLinearCalibrationExt lce = (BLinearCalibrationExt)importedPoint.get("linearCalibration");
                lce.setOffset(origLinearCalibration.getFloat(origLinearCalibration.getProperty("offset")));
                lce.setScale(origLinearCalibration.getFloat(origLinearCalibration.getProperty("scale")));
                BUnit unitcpy = (BUnit)origLinearCalibration.get("units").newCopy();
                lce.setUnits(unitcpy);
            }
            destination.lease();
            destination.add(controlPoint.getName(), (BValue)importedPoint);
            BControlPoint addedPoint = (BControlPoint)destination.get(controlPoint.getName());
            addedPoint.lease();
            this.transferLinks(controlPoint, addedPoint);
            this.transferKnobs(controlPoint, addedPoint);
            this.transferDynamicProperties(controlPoint, addedPoint);
        }
    }

    private void transferLinks(BControlPoint ioPoint, BControlPoint onyxxPoint) {
        ioPoint.lease();
        onyxxPoint.lease();
        BLink[] linksToTransfer = ioPoint.getLinks();
        for (int i = 0; i < linksToTransfer.length; ++i) {
            BLink currentLink = linksToTransfer[i];
            BLink newLink = null;
            currentLink.activate();
            if (currentLink.getSourceComponent() == ioPoint) {
                newLink = new BLink(onyxxPoint.getHandleOrd(), currentLink.getSourceSlotName(), currentLink.getTargetSlot().getName(), true);
                currentLink.getTargetComponent().set(currentLink.getName(), (BValue)newLink);
                continue;
            }
            newLink = new BLink(currentLink.getSourceComponent().getHandleOrd(), currentLink.getSourceSlotName(), currentLink.getTargetSlotName(), true);
            onyxxPoint.add(currentLink.getName(), (BValue)newLink);
        }
    }

    private void transferKnobs(BControlPoint ioPoint, BControlPoint onyxxPoint) {
        ioPoint.lease();
        onyxxPoint.lease();
        Knob[] knobsToTransfer = ioPoint.getKnobs();
        for (int i = 0; i < knobsToTransfer.length; ++i) {
            Knob currentKnob = knobsToTransfer[i];
            BLink currentLink = currentKnob.getLink();
            BLink newLink = null;
            currentLink.activate();
            if (currentLink.getSourceComponent() == ioPoint) {
                newLink = new BLink(onyxxPoint.getHandleOrd(), currentLink.getSourceSlotName(), currentLink.getTargetSlot().getName(), true);
                currentLink.getTargetComponent().set(currentLink.getName(), (BValue)newLink);
                continue;
            }
            newLink = new BLink(currentLink.getSourceComponent().getHandleOrd(), currentLink.getSourceSlotName(), currentLink.getTargetSlotName(), true);
            onyxxPoint.add(currentLink.getName(), (BValue)newLink);
        }
    }

    private void transferDynamicProperties(BControlPoint ioPoint, BControlPoint onyxxPoint) {
        ioPoint.lease();
        onyxxPoint.lease();
        Property[] propsToTransfer = ioPoint.getDynamicPropertiesArray();
        for (int i = 0; i < propsToTransfer.length; ++i) {
            BValue val = ioPoint.get(propsToTransfer[i]);
            if (val.getType().is(BLinearCalibrationExt.TYPE)) continue;
            this.moveNonProxyComponent((BObject)val, (BComponent)onyxxPoint);
        }
    }

    public void completed(int percent) {
        this.progress(percent);
    }

    public BIcon getIcon() {
        return icon;
    }
}

