/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxConverter.jobs;

import com.lynxspring.onyxxConverter.BOnyxxImportDevice;
import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.tridium.util.ArrayUtil;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.driver.BDevice;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BOnyxxConverterDeviceDiscoveryJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BOnyxxConverterDeviceDiscoveryJob.class);
    public static BIcon icon = BIcon.std((String)"find.png");
    BOnyxxNetwork network;
    private final String TAG_PROP_LABEL = "ioImportTag";

    public Type getType() {
        return TYPE;
    }

    public BOnyxxConverterDeviceDiscoveryJob(BOnyxxNetwork network) {
        this.network = network;
    }

    public BOnyxxConverterDeviceDiscoveryJob() {
        this.network = null;
    }

    public void run(Context cx) throws Exception {
        if (this.network == null) {
            throw new IllegalStateException("Must submit through submitDiscoveryJob()");
        }
        this.log().start("Device discovery");
        this.removeAll();
        BOnyxxImportDevice[] importDeviceArray = this.getIoDeviceOrds();
        for (int i = 0; i < importDeviceArray.length; ++i) {
            BOnyxxImportDevice s = importDeviceArray[i];
            this.log().success("Found: " + s.getDeviceName() + " - " + s.getDeviceType());
            this.add("s" + i, (BValue)s, 1);
        }
        this.log().success("Discovered " + importDeviceArray.length + " IO Devices");
    }

    private BOnyxxImportDevice[] getIoDeviceOrds() {
        BOnyxxImportDevice[] importDeviceArray = new BOnyxxImportDevice[]{};
        BOrd ord = BOrd.make((String)"slot:/|bql:select handleOrd from nrio:NrioDevice, ndio:NdioBoard");
        BITable result = (BITable)ord.resolve((BObject)this.network).get();
        TableCursor c = result.cursor();
        boolean i = false;
        while (c.next()) {
            BDevice dev = (BDevice)c.get();
            BOnyxxImportDevice impDev = new BOnyxxImportDevice(dev.getName(), dev.getType().toString(), dev.getHandleOrd());
            if (dev.get("ioImportTag") != null) {
                impDev.setImported(dev.get("ioImportTag").toString());
            }
            importDeviceArray = (BOnyxxImportDevice[])ArrayUtil.addOne((Object[])importDeviceArray, (Object)((Object)impDev));
        }
        return importDeviceArray;
    }

    public void completed(int percent) {
        this.progress(percent);
    }

    public BIcon getIcon() {
        return icon;
    }
}

