/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.station;

import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioningNiagara.station.BStationProxy;
import javax.baja.gx.BImage;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class RebootCommand
extends AsyncCommand {
    private BStationProxy station;
    private static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");

    public RebootCommand(BWidget owner) {
        super(owner, lex, "ProvisioningStationDirector.command.reboot");
    }

    public void loadStation(BStationProxy value) {
        this.station = value;
        this.checkEnabled();
    }

    public void checkEnabled() {
        this.setEnabled(this.station.getIsRebootEnabled());
    }

    public void doInvokeAsync() {
        try {
            String title = lex.getText("ProvisioningStationDirector.command.reboot.dlgTitle");
            String message = lex.getText("ProvisioningStationDirector.command.reboot.dlgMessage");
            BWbShell shell = BWbShell.getWbShell((BWidget)this.getOwner());
            if (BDialog.open((BWidget)this.getOwner(), (String)title, (Object)message, (int)12, (BImage)BDialog.WARNING_ICON, (String)null) == 4) {
                this.station.rebootHost();
                BDialog.message((BWidget)shell, (String)lex.getText("ProvisioningStationDirector.command.reboot.notifyTitle", new Object[]{this.station.getStationDisplayName()}), (Object)lex.getText("ProvisioningStationDirector.command.reboot.notifyMessage", new Object[]{this.station.getNiagaraStation().getRemoteHost()}));
            }
        }
        catch (Throwable t) {
            CommandUtil.error((Command)this, (Throwable)t);
        }
    }
}

