/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.InstallScenario;
import com.tridium.install.PartSpec;
import com.tridium.install.SolutionParameters;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.part.BPart;
import com.tridium.nre.security.ModuleVerificationMode;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioningNiagara.ui.software.SoftwareTableModel;
import com.tridium.ui.theme.Theme;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.gx.BImage;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbShell;

public class InstallCommand
extends AsyncCommand {
    private SoftwareTableModel tableModel;
    private static Lexicon lex = Lexicon.make((String)"provisioningNiagara");

    public static InstallCommand makeInstall(BWidget owner, SoftwareTableModel tableModel) {
        return new InstallCommand(owner, tableModel, "StationSoftwareView.command.installSelected");
    }

    public static InstallCommand makeReinstall(BWidget owner, SoftwareTableModel tableModel) {
        return new InstallCommand(owner, tableModel, "StationSoftwareView.command.reinstallSelected");
    }

    public static InstallCommand makeUpgrade(BWidget owner, SoftwareTableModel tableModel) {
        return new InstallCommand(owner, tableModel, "StationSoftwareView.command.upgradeSelected");
    }

    public static InstallCommand makeDowngrade(BWidget owner, SoftwareTableModel tableModel) {
        return new InstallCommand(owner, tableModel, "StationSoftwareView.command.downgradeSelected");
    }

    protected InstallCommand(BWidget owner, SoftwareTableModel tableModel, String lexKey) {
        super(owner, lex, lexKey);
        this.tableModel = tableModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InstallScenario install(BWidget owner, SoftwareTableModel tableModel, int[] rows, boolean raiseDialogs) throws Exception {
        BWbShell shell = BWbShell.getWbShell((BWidget)owner);
        try {
            BInstallable[] inst;
            TreeMap<PartSpec, BInstallable> initialInstallablesByPartSpec = new TreeMap<PartSpec, BInstallable>();
            for (BInstallable anInst : inst = tableModel.getScenario().getToInstall()) {
                initialInstallablesByPartSpec.put(anInst.getPart().getPartSpec(), anInst);
            }
            for (int row : rows) {
                BDependency[] toAdd = tableModel.getInstallableAt(row);
                initialInstallablesByPartSpec.put(toAdd.getPart().getPartSpec(), (BInstallable)toAdd);
            }
            inst = initialInstallablesByPartSpec.values().toArray(new BInstallable[0]);
            InstallScenario installScenario = InstallScenario.solve((BDaemonPlatform)tableModel.getScenario().getTargetPlatform(), (String[])tableModel.getScenario().getModulesToUninstall(), null, (BInstallable[])inst, (SolutionParameters)tableModel.getScenario().getSolutionParameters(), null, (InstallableRegistry)tableModel.getInstallableRegistry(), (CertificateChainValidator)tableModel.getCertValidator());
            Map failed = installScenario.getSignatureFailures();
            if (!failed.isEmpty()) {
                if (raiseDialogs) {
                    BDialog.error((BWidget)owner, (String)lex.getText("InstallCommand.signingError.title"), (Object)com.tridium.platDaemon.ui.softwaremanager.InstallCommand.makeSigningErrorDialog((Map)failed, (ModuleVerificationMode)tableModel.getModuleVerificationMode()));
                }
            } else if (installScenario.getExcludedInstallables().length > 0) {
                if (raiseDialogs) {
                    BDialog.error((BWidget)owner, (String)lex.getText("InstallCommand.excluded.title"), (Object)lex.getText("InstallCommand.excluded.message"));
                }
            } else if (installScenario.getUnmetDependencies().length > 0) {
                BDependency[] unmet = installScenario.getUnmetDependencies();
                boolean anyNotAutoInstall = false;
                for (BDependency anUnmet : unmet) {
                    if (anUnmet.canSolveWith(installScenario.getSolutionParameters().solvers)) continue;
                    anyNotAutoInstall = true;
                }
                if (anyNotAutoInstall) {
                    if (raiseDialogs) {
                        BDialog.error((BWidget)owner, (String)lex.getText("InstallCommand.mustCommission.title"), (Object)lex.getText("InstallCommand.mustCommission.message"));
                    } else {
                        tableModel.setScenario(installScenario);
                    }
                } else if (raiseDialogs) {
                    BDialog.error((BWidget)owner, (String)lex.getText("InstallCommand.unmet.title"), (Object)InstallCommand.makeUnmetDialog(installScenario));
                }
            } else if (raiseDialogs) {
                boolean signatureWarningConfirmed = false;
                boolean alsoInstallConfirmed = false;
                BWidget widget = com.tridium.platDaemon.ui.softwaremanager.InstallCommand.makeSigningWarningDialog((InstallScenario)installScenario, (InstallScenario)tableModel.getScenario(), (CertificateChainValidator)tableModel.getCertValidator());
                boolean bl = signatureWarningConfirmed = widget == null || 1 == BDialog.open((BWidget)owner, (String)lex.getText("InstallCommand.signingWarning.title"), (Object)widget, (int)3, (BImage)BDialog.WARNING_ICON, (String)null);
                if (signatureWarningConfirmed) {
                    widget = InstallCommand.makeAlsoInstallDialog(initialInstallablesByPartSpec, installScenario);
                    boolean bl2 = alsoInstallConfirmed = widget == null || 1 == BDialog.confirm((BWidget)owner, (String)lex.getText("InstallCommand.alsoInstall.title"), (Object)widget, (int)3);
                }
                if (signatureWarningConfirmed && alsoInstallConfirmed) {
                    tableModel.setScenario(installScenario);
                }
            } else {
                tableModel.setScenario(installScenario);
            }
            InstallScenario installScenario2 = installScenario;
            return installScenario2;
        }
        finally {
            if (shell != null) {
                shell.exitBusy();
            }
        }
    }

    public void doInvokeAsync() {
        try {
            InstallCommand.install(this.getOwner(), this.tableModel, this.tableModel.getTable().getSelection().getRows(), true);
        }
        catch (Throwable t) {
            CommandUtil.error((Command)this, (Throwable)t);
        }
    }

    public static BWidget makeAlsoInstallDialog(Map<PartSpec, BInstallable> initialInstallablesByPartSpec, InstallScenario solution) {
        BIndentPane pane = null;
        for (BInstallable aToInstall : solution.getToInstall()) {
            BPart part = aToInstall.getPart();
            if (initialInstallablesByPartSpec.containsKey(part.getPartSpec())) continue;
            if (pane == null) {
                pane = new BIndentPane();
                pane.add(LexiconText.make((String)"provisioningNiagara", (String)"InstallCommand.alsoInstall.header"));
                pane.indent();
            }
            pane.add(aToInstall.getInstallableFileName());
        }
        if (pane == null) {
            return null;
        }
        pane.unindent();
        BScrollPane scroll = new BScrollPane((BWidget)new BBorderPane(pane, 5.0, 5.0, 5.0, 5.0));
        scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane cpane = new BConstrainedPane((BWidget)scroll);
        cpane.setFixedSize(275.0, 300.0);
        return new BEdgePane(null, null, null, null, (BWidget)cpane);
    }

    public static BWidget makeUnmetDialog(InstallScenario scenario) {
        BIndentPane result = new BIndentPane();
        result.add(LexiconText.make((String)"provisioningNiagara", (String)"InstallCommand.unmet.heading"));
        result.indent();
        for (BDependency anUnmet : scenario.getUnmetDependencies()) {
            if (!anUnmet.canSolveWith(scenario.getSolutionParameters().solvers)) continue;
            result.add(anUnmet.toString());
        }
        result.unindent();
        BScrollPane scroll = new BScrollPane((BWidget)new BBorderPane((BWidget)result, 5.0, 5.0, 5.0, 5.0));
        scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane cpane = new BConstrainedPane((BWidget)scroll);
        cpane.setFixedSize(275.0, 160.0);
        return new BEdgePane(null, null, null, null, (BWidget)cpane);
    }
}

