/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.program;

import com.tridium.nre.util.NiagaraFiles;
import com.tridium.program.BCode;
import com.tridium.program.BProgram;
import com.tridium.program.ui.Compiler;
import com.tridium.provisioningNiagara.program.BProvisioningRobot;
import com.tridium.provisioningNiagara.ui.program.BProvisioningRobotEditor;
import com.tridium.sys.Nre;
import com.tridium.workbench.console.BConsole;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.DependencyInfo;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.BBlob;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

public class ProvisioningCompiler
implements BConsole.ExecCallback {
    protected BCode tempCode = new BCode();
    protected BProvisioningRobotEditor editor;
    protected String className = null;
    protected boolean submitOnSuccess = false;
    protected File temp = null;
    protected File java = null;
    protected File classFile = null;
    protected File[] innerClassFiles;
    protected int checksum = 0;
    protected static Lexicon programLex = Lexicon.make((String)"program");

    public ProvisioningCompiler(BProvisioningRobotEditor editor) {
        this.editor = editor;
    }

    public void load(BProvisioningRobot robot) {
        this.className = robot.getRobotCode().getClassName();
        this.checksum = robot.getChecksum();
        this.tempCode.setClassName(robot.getRobotCode().getClassName());
        this.tempCode.setClassFile(robot.getRobotCode().getClassFile());
        this.tempCode.setSignature(robot.getRobotCode().getSignature());
        this.tempCode.setDependencies(robot.getRobotCode().getDependencies());
        SlotCursor c = robot.getRobotCode().getProperties();
        while (c.next(BBlob.class)) {
            if (!c.property().isDynamic()) continue;
            this.tempCode.add(c.property().getName(), c.get(), 1);
        }
    }

    public void compile(boolean submitOnSuccess) throws Exception {
        this.submitOnSuccess = submitOnSuccess;
        String source = this.editor.getSource();
        this.className = BCode.generateClassName();
        int x = source.indexOf("RobotImpl");
        if (x < 0) {
            throw new Exception("Class name must be RobotImpl");
        }
        source = TextUtil.replace((String)source, (String)"RobotImpl", (String)this.className);
        this.temp = new File(Sys.getNiagaraUserHome(), "temp");
        this.java = new File(this.temp, this.className + ".java");
        this.classFile = new File(this.temp, this.className + ".class");
        this.innerClassFiles = null;
        AccessController.doPrivileged(() -> {
            if (!this.temp.exists() && !this.temp.mkdirs()) {
                throw new Exception(String.format("Could not create directory %s", this.temp.getAbsolutePath()));
            }
            return null;
        });
        try (FileWriter out = new FileWriter(this.java);){
            this.writeSource(out, source);
        }
        String sep = File.separator;
        String pathSep = File.pathSeparator;
        StringBuilder cp = new StringBuilder();
        File binDir = new File(Nre.getNiagaraHome(), "bin");
        File binExtDir = new File(binDir, "ext");
        String binExtbase = pathSep + Nre.getNiagaraHome() + sep + "bin" + sep + "ext" + sep;
        String[] binJars = binExtDir.list((FilenameFilter)new Compiler.JarFilenameFilter());
        if (binJars != null) {
            for (String binJar : binJars) {
                cp.append(binExtbase).append(binJar).append(pathSep);
            }
        }
        cp.append(NiagaraFiles.getModulesPath()).append(sep).append("baja.jar");
        String[] depends = this.parseDependencies();
        String moduleBase = pathSep + NiagaraFiles.getModulesPath() + sep;
        for (String depend : depends) {
            if (depend.equals("baja")) continue;
            cp.append(moduleBase).append(depend).append(".jar");
        }
        String profile = Compiler.getCompactProfile((String[])depends);
        try {
            String cmd = Compiler.getCompileJavaCommand((String)profile, (String)cp.toString(), (String)this.temp.toString(), (String)this.java.toString());
            this.openConsole().exec(cmd, (BConsole.ExecCallback)this);
        }
        catch (Exception e) {
            System.out.println("[SEVERE] Problem loading 'javac' command.");
            e.printStackTrace();
        }
    }

    public String[] parseDependencies() throws Exception {
        HashSet<String> deps = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(this.editor.getDependencies(), ";");
        while (st.hasMoreTokens()) {
            String name = st.nextToken().trim();
            if (name.length() <= 0 || BProgram.isSpecialModule((String)name)) continue;
            this.accumDependencies(deps, name);
        }
        return deps.toArray(new String[0]);
    }

    protected void accumDependencies(Set<String> acc, String modulePartName) throws Exception {
        if (acc.contains(modulePartName)) {
            return;
        }
        ModuleInfo mi = Sys.getRegistry().moduleForDependency(modulePartName);
        acc.add(mi.getModulePartName());
        for (DependencyInfo dep : mi.getDependencies()) {
            this.accumDependencies(acc, dep.getModulePartName());
        }
    }

    public void writeSource(FileWriter out, String source) throws Exception {
        out.write(source);
    }

    public BConsole openConsole() {
        return ((BNiagaraWbShell)this.editor.getShell()).openConsole();
    }

    public void consoleExecDone(BConsole console, int exitCode) {
        try {
            if (exitCode == 0) {
                this.compileSuccess(console);
            } else {
                this.compileFailed(console);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.cleanup();
    }

    public void compileSuccess(BConsole console) throws Exception {
        this.editor.setModified();
        this.tempCode.setClassName(this.getClassName());
        this.tempCode.clearInnerClassFiles();
        byte[] buf = new byte[(int)this.classFile.length()];
        try (DataInputStream classIn = AccessController.doPrivileged(() -> new DataInputStream(new BufferedInputStream(new FileInputStream(this.classFile))));){
            classIn.readFully(buf);
        }
        this.tempCode.setClassFile(BBlob.make((byte[])buf));
        File[] tempFiles = this.classFile.getParentFile().listFiles();
        ArrayList<File> innerArray = new ArrayList<File>();
        assert (tempFiles != null);
        for (File tempFile : tempFiles) {
            if (!tempFile.getName().startsWith(this.className + '$')) continue;
            innerArray.add(tempFile);
            String innerClassName = tempFile.getName();
            innerClassName = innerClassName.substring(0, innerClassName.length() - 6);
            buf = new byte[(int)tempFile.length()];
            try (DataInputStream tempIn = AccessController.doPrivileged(() -> new DataInputStream(new BufferedInputStream(new FileInputStream(tempFile))));){
                tempIn.readFully(buf);
            }
            this.tempCode.addInnerClassFile(innerClassName, BBlob.make((byte[])buf));
        }
        this.innerClassFiles = innerArray.toArray(new File[0]);
        this.tempCode.setDependencies(this.editor.getDependencies());
        this.checksum = this.editor.computeChecksum();
        try {
            Compiler.signCode((BCode)this.tempCode, (BWidget)console);
        }
        catch (Exception e) {
            this.tempCode.clearInnerClassFiles();
            this.tempCode.setClassName("");
            this.tempCode.setClassFile(BBlob.DEFAULT);
            this.tempCode.setSignature(BBlob.DEFAULT);
            this.tempCode.setDependencies("");
            this.checksum = 0;
            this.editor.setModified();
            this.editor.updateStatusToSigningError();
            console.appendLine(programLex.getText("program.couldNotSign", new Object[]{e}));
            console.showLast();
            throw e;
        }
        this.editor.notifyCodeTextUpToDate();
        this.editor.updateStatus();
        this.editor.saveValue();
        if (this.submitOnSuccess) {
            this.editor.submitJob();
        }
    }

    public void compileFailed(BConsole console) throws Exception {
        this.tempCode.clearInnerClassFiles();
        this.tempCode.setClassName("");
        this.tempCode.setClassFile(BBlob.DEFAULT);
        this.tempCode.setSignature(BBlob.DEFAULT);
        this.tempCode.setDependencies("");
        this.checksum = 0;
        this.editor.setModified();
        this.editor.updateStatusToError();
    }

    public void cleanup() {
        this.classFile.delete();
        if (this.innerClassFiles != null) {
            for (File innerClassFile : this.innerClassFiles) {
                innerClassFile.delete();
            }
        }
        this.java.delete();
    }

    public String getClassName() {
        return this.className;
    }

    public void saveRobot(BProvisioningRobot robot, String source, String depends) throws Exception {
        robot.lease(Integer.MAX_VALUE);
        robot.setSource(source);
        robot.getRobotCode().setClassName(this.tempCode.getClassName());
        robot.getRobotCode().setClassFile(this.tempCode.getClassFile());
        robot.getRobotCode().setSignature(this.tempCode.getSignature());
        robot.getRobotCode().setDependencies(this.tempCode.getDependencies());
        robot.getRobotCode().clearInnerClassFiles();
        SlotCursor c = this.tempCode.getProperties();
        while (c.next(BBlob.class)) {
            if (!c.property().isDynamic()) continue;
            robot.getRobotCode().add(c.property().getName(), c.get(), 1);
        }
        robot.setChecksum(this.checksum);
    }
}

