/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.tls;

import com.tridium.crypto.core.io.CryptoSupport;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nre.util.Version;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.UpdateSSLSettingsMessage;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platform.RemoteStation;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebService;

@NiagaraType
@NiagaraProperty(name="tlsLevel", type="BSslTlsEnum", defaultValue="BSslTlsEnum.DEFAULT")
public class BSetTlsLevelJobStep
extends BDeviceJobStep {
    @Generated
    public static final Property tlsLevel = BSetTlsLevelJobStep.newProperty((int)0, (BValue)BSslTlsEnum.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSetTlsLevelJobStep.class);
    private static final Logger logger = Logger.getLogger("provisioningNiagara");

    @Generated
    public BSslTlsEnum getTlsLevel() {
        return (BSslTlsEnum)this.get(tlsLevel);
    }

    @Generated
    public void setTlsLevel(BSslTlsEnum v) {
        this.set(tlsLevel, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSetTlsLevelJobStep() {
    }

    public BSetTlsLevelJobStep(BSslTlsEnum tlsLevel) {
        this.setTlsLevel(tlsLevel);
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        try (ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);){
            BSslTlsEnum tlsLevelEnum;
            BDaemonSession session;
            block31: {
                session = util.getDaemonSession();
                if (!session.getHostProperties().isNiagara4()) {
                    details.failed("provisioningNiagara", "SetTlsLevelJobStep.error.notN4");
                    details.complete(BJobState.failed);
                    return;
                }
                tlsLevelEnum = this.getTlsLevel();
                try {
                    if (new Version(session.getHostProperties().getDaemonVersion()).compareTo((Object)CryptoSupport.MIN_TLS_1_3_NIAGARA_VERSION) < 0 && tlsLevelEnum == BSslTlsEnum.tlsv1_3) {
                        details.vaMessage("SetTlsLevelJobStep.notice.unsupportedTls", new String[]{device.getName(), BSslTlsEnum.tlsv1_3.toString(), BSslTlsEnum.tlsv1_2.toString()});
                        tlsLevelEnum = BSslTlsEnum.tlsv1_2;
                    }
                }
                catch (IllegalArgumentException e) {
                    if (tlsLevelEnum != BSslTlsEnum.tlsv1_3) break block31;
                    details.vaMessage("SetTlsLevelJobStep.notice.unknownVersion", new String[]{device.getName(), BSslTlsEnum.tlsv1_3.toString(), BSslTlsEnum.tlsv1_2.toString()});
                    tlsLevelEnum = BSslTlsEnum.tlsv1_2;
                }
            }
            boolean stationRunning = util.hasRunningStation();
            if (stationRunning) {
                BFoxSession foxSession = util.getEngagedFoxSession();
                try {
                    BWebService webService = (BWebService)BOrd.make((String)"service:web:WebService").get((BObject)foxSession);
                    webService.lease();
                    webService.setHttpsMinProtocol(tlsLevelEnum);
                    details.message("provisioningNiagara", "SetTlsLevelJobStep.webSet");
                }
                catch (Exception e) {
                    details.message("provisioningNiagara", "SetTlsLevelJobStep.error.webService");
                }
                try {
                    BFoxService foxService = (BFoxService)BOrd.make((String)"service:fox:FoxService").get((BObject)foxSession);
                    foxService.lease();
                    foxService.setFoxsMinProtocol(tlsLevelEnum);
                    details.message("provisioningNiagara", "SetTlsLevelJobStep.foxSet");
                }
                catch (Exception e) {
                    details.message("provisioningNiagara", "SetTlsLevelJobStep.error.foxService");
                }
                util.disengageFoxSession();
            } else {
                RemoteStation station = util.getRemoteStation(((BNiagaraStation)device).getStationName());
                try {
                    if (station == null) {
                        throw new IllegalStateException("Remote station unavailable");
                    }
                    station.updateStationTlsVersion(tlsLevelEnum.getTag());
                    details.message("provisioningNiagara", "SetTlsLevelJobStep.webSet");
                    details.message("provisioningNiagara", "SetTlsLevelJobStep.foxSet");
                }
                catch (Exception e) {
                    details.message("provisioningNiagara", "SetTlsLevelJobStep.error.remoteStation");
                }
            }
            BRemoteDaemonPlatform remoteDaemonPlatform = util.getRemoteDaemonPlatform();
            if (remoteDaemonPlatform == null) {
                throw new IllegalStateException("Remote daemon platform unavailable");
            }
            BPlatformSSLSettings current = remoteDaemonPlatform.getPlatformSSLSettings();
            current.setSslAlgType(tlsLevelEnum);
            UpdateSSLSettingsMessage message = new UpdateSSLSettingsMessage(current, true, session.generateSharedSecretKey("updateTlsSettings"));
            util.sendDaemonMessage((DaemonMessage)message);
            details.message("provisioningNiagara", "SetTlsLevelJobStep.platformSet");
            details.success();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, this.lexValue("unexpectedError", new Object[0]), e);
            throw e;
        }
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }

    public String toString(Context context) {
        return this.getLexicon().getText("SetTlsLevelJobStep.displayName", new Object[]{this.getTlsLevel()});
    }
}

