/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.tls;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.UpdateSSLSettingsMessage;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import java.security.AccessController;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platform.RemoteStation;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;
import javax.baja.web.BWebService;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="alias", type="String", defaultValue="BString.DEFAULT", deprecated=true), @NiagaraProperty(name="certAliasAndPassword", type="BCertificateAliasAndPassword", defaultValue="BCertificateAliasAndPassword.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")})})
public class BSetCertificateAliasJobStep
extends BDeviceJobStep {
    @Deprecated
    @Generated
    public static final Property alias = BSetCertificateAliasJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property certAliasAndPassword = BSetCertificateAliasJobStep.newProperty((int)0, (BValue)BCertificateAliasAndPassword.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Type TYPE = Sys.loadType(BSetCertificateAliasJobStep.class);
    private static final Logger logger = Logger.getLogger("provisioningNiagara");

    @Deprecated
    @Generated
    public String getAlias() {
        return this.getString(alias);
    }

    @Deprecated
    @Generated
    public void setAlias(String v) {
        this.setString(alias, v, null);
    }

    @Generated
    public BCertificateAliasAndPassword getCertAliasAndPassword() {
        return (BCertificateAliasAndPassword)this.get(certAliasAndPassword);
    }

    @Generated
    public void setCertAliasAndPassword(BCertificateAliasAndPassword v) {
        this.set(certAliasAndPassword, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSetCertificateAliasJobStep() {
    }

    public BSetCertificateAliasJobStep(String alias, BPassword certPassword) {
        this.setAlias(alias);
        this.getCertAliasAndPassword().setAlias(alias);
        if (certPassword != null) {
            this.getCertAliasAndPassword().setPassword(certPassword);
        }
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        try (ProvisioningConnectionUtil util = this.getConnectionUtil(details, device);){
            ICoreKeyStore keyStore;
            BDaemonSession session = util.getDaemonSession();
            String alias = this.getCertAliasAndPassword().getAlias();
            BPassword password = BPassword.DEFAULT;
            if (!this.getCertAliasAndPassword().getPassword().isDefault()) {
                password = BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)this.getCertAliasAndPassword().getPassword()).getValue()));
            }
            if (!BSetCertificateAliasJobStep.serverCertificateExists(keyStore = this.getKeyStore(session), alias)) {
                details.vaFailed("SetCertificateAliasJobStep.failed.missingAlias", new String[]{alias});
                details.complete(BJobState.failed);
                return;
            }
            boolean stationRunning = util.hasRunningStation();
            if (stationRunning) {
                BFoxSession foxSession = util.getEngagedFoxSession();
                try {
                    BWebService webService = (BWebService)BOrd.make((String)"service:web:WebService").get((BObject)foxSession);
                    webService.lease();
                    if (foxSession.getConnection().getRemoteVersion().compareTo(FoxSession.VERSION_4_13) >= 0) {
                        webService.getMainCertAliasAndPassword().setAlias(alias);
                        webService.getMainCertAliasAndPassword().setPassword(password);
                    } else {
                        webService.setHttpsCert(alias);
                    }
                    details.message("provisioningNiagara", "SetCertificateAliasJobStep.webSet");
                }
                catch (Exception e) {
                    details.message("provisioningNiagara", "SetCertificateAliasJobStep.error.webService");
                }
                try {
                    BFoxService foxService = (BFoxService)BOrd.make((String)"service:fox:FoxService").get((BObject)foxSession);
                    foxService.lease();
                    if (foxSession.getConnection().getRemoteVersion().compareTo(FoxSession.VERSION_4_13) >= 0) {
                        foxService.getCertAliasAndPassword().setAlias(alias);
                        foxService.getCertAliasAndPassword().setPassword(password);
                    } else {
                        foxService.setFoxsCert(alias);
                    }
                    details.message("provisioningNiagara", "SetCertificateAliasJobStep.foxSet");
                }
                catch (Exception e) {
                    details.message("provisioningNiagara", "SetCertificateAliasJobStep.error.foxService");
                }
                util.disengageFoxSession();
            } else {
                RemoteStation station = util.getRemoteStation(((BNiagaraStation)device).getStationName());
                try {
                    if (station == null) {
                        throw new IllegalStateException("Remote station unavailable");
                    }
                    station.updateStationCertAlias(alias);
                    details.message("provisioningNiagara", "SetCertificateAliasJobStep.webSet");
                    details.message("provisioningNiagara", "SetCertificateAliasJobStep.foxSet");
                }
                catch (Exception e) {
                    details.message("provisioningNiagara", "SetCertificateAliasJobStep.error.remoteStation");
                }
            }
            BRemoteDaemonPlatform remoteDaemonPlatform = util.getRemoteDaemonPlatform();
            if (remoteDaemonPlatform == null) {
                throw new IllegalStateException("Remote daemon platform unavailable");
            }
            BPlatformSSLSettings current = remoteDaemonPlatform.getPlatformSSLSettings();
            current.setKeyAlias(alias);
            if (new Version(remoteDaemonPlatform.getDaemonVersion()).compareTo(FoxSession.VERSION_4_13) >= 0) {
                current.setKeyPassphrase(password);
            }
            this.sendUpdateSSLSettingsMessage(current, session, util);
            details.message("provisioningNiagara", "SetCertificateAliasJobStep.platformSet");
            details.success();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, this.lexValue("unexpectedError", new Object[0]), e);
            throw e;
        }
    }

    protected void sendUpdateSSLSettingsMessage(BPlatformSSLSettings current, BDaemonSession session, ProvisioningConnectionUtil util) throws Exception {
        UpdateSSLSettingsMessage message = new UpdateSSLSettingsMessage(current, false, session.generateSharedSecretKey("updateTlsSettings"));
        util.sendDaemonMessage((DaemonMessage)message);
    }

    protected ProvisioningConnectionUtil getConnectionUtil(BDeviceStepDetails details, BDevice device) throws Exception {
        return new ProvisioningConnectionUtil(device, details);
    }

    protected ICoreKeyStore getKeyStore(BDaemonSession session) throws Exception {
        return new BPlatCryptoManager(session).getKeyStore();
    }

    public void started() throws Exception {
        super.started();
        if (!Flags.has((BComplex)this, (Slot)alias, (int)0x10000000)) {
            this.getCertAliasAndPassword().setAlias(this.getAlias());
            Flags.add((BComponent)this, (Slot)alias, null, (int[])new int[]{0x10000005});
        }
    }

    private static boolean serverCertificateExists(ICoreKeyStore store, String alias) throws Exception {
        return CertUtils.isValidServerCert((String)alias, (ICoreKeyStore)store);
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }

    public String toString(Context context) {
        return this.getLexicon().getText("SetCertificateAliasJobStep.display", new Object[]{this.getCertAliasAndPassword().getAlias()});
    }
}

