/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.software;

import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.provisioningNiagara.BProvisioningStationExt;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import javax.baja.data.BIDataValue;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509CertificateEntry;
import javax.baja.security.BX509Certificate;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:NiagaraStation"})})
@NiagaraProperties(value={@NiagaraProperty(name="lastUpdate", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="platformTrustStoreSnapshot", type="BVector", defaultValue="new BVector()", flags=5)})
@NiagaraActions(value={@NiagaraAction(name="getPlatformSnapshot", returnType="BDaemonPlatform", flags=4), @NiagaraAction(name="takeSnapshot", flags=20), @NiagaraAction(name="takeSnapshotWithNotify", parameterType="BString", defaultValue="BString.DEFAULT", flags=20, facets={@Facet(value="BFacets.make(NOTIFY_ACTION_COMPLETE, BBoolean.TRUE)")})})
public class BSoftwareStationExt
extends BProvisioningStationExt {
    @Generated
    public static final Property lastUpdate = BSoftwareStationExt.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property platformTrustStoreSnapshot = BSoftwareStationExt.newProperty((int)5, (BValue)new BVector(), null);
    @Generated
    public static final Action getPlatformSnapshot = BSoftwareStationExt.newAction((int)4, null);
    @Generated
    public static final Action takeSnapshot = BSoftwareStationExt.newAction((int)20, null);
    @Generated
    public static final Action takeSnapshotWithNotify = BSoftwareStationExt.newAction((int)20, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"notifyActionComplete", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Type TYPE = Sys.loadType(BSoftwareStationExt.class);
    private static final BIcon icon = BIcon.make((String)"module://provisioningNiagara/icons/software.png");

    @Generated
    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    @Generated
    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    @Generated
    public BVector getPlatformTrustStoreSnapshot() {
        return (BVector)this.get(platformTrustStoreSnapshot);
    }

    @Generated
    public void setPlatformTrustStoreSnapshot(BVector v) {
        this.set(platformTrustStoreSnapshot, (BValue)v, null);
    }

    @Generated
    public BDaemonPlatform getPlatformSnapshot() {
        return (BDaemonPlatform)this.invoke(getPlatformSnapshot, null, null);
    }

    @Generated
    public void takeSnapshot() {
        this.invoke(takeSnapshot, null, null);
    }

    @Generated
    public void takeSnapshotWithNotify(BString parameter) {
        this.invoke(takeSnapshotWithNotify, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public String getDisplayNameInParent(Context cx) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("SoftwareStationExt");
    }

    public void doTakeSnapshot(Context cx) throws Exception {
        this.doTakeSnapshotWithNotify(null, cx);
    }

    public void doTakeSnapshotWithNotify(BString invokeId, Context cx) throws Exception {
        BProvisioningStationExt.CanceledListener canceledListener = this.startAsyncAction(invokeId, cx);
        try {
            if (this.isUnoperational()) {
                this.asyncActionComplete(canceledListener, null, cx);
                return;
            }
            BDaemonSession session = this.getDaemonSession();
            if (session != null) {
                BRemoteDaemonPlatform platform = BRemoteDaemonPlatform.make((BDaemonSession)session, null, (boolean)false);
                platform.checkSession();
                platform.getModuleList().init();
                platform.loadPreferredVerificationMode();
                BIFile bogFile = BFileSystem.INSTANCE.makeFile(this.getBogFilePath());
                OutputStream out = bogFile.getOutputStream();
                ValueDocEncoder enc = new ValueDocEncoder(out);
                enc.setEncodeTransients(true);
                enc.setZipped(true);
                enc.encodeDocument((BValue)platform);
                enc.close();
                out.close();
                BVector trustStoreSnapshot = this.getPlatformTrustStoreSnapshot();
                trustStoreSnapshot.removeAll();
                BPlatCryptoManager manager = BPlatCryptoManager.make((BDaemonPlatform)platform);
                ICoreTrustStore userTrustStore = manager.getUserTrustStore();
                for (IX509CertificateEntry certificateEntry : userTrustStore.getCertificateEntries()) {
                    BX509Certificate cert = BX509Certificate.make((X509Certificate)certificateEntry.getCertificate(0).getCertificate());
                    trustStoreSnapshot.add(null, (BValue)cert);
                }
                this.setLastUpdate(BAbsTime.now());
            }
        }
        catch (Exception e) {
            this.asyncActionException(canceledListener, e, cx);
            return;
        }
        this.asyncActionComplete(canceledListener, null, cx);
    }

    public BDaemonPlatform doGetPlatformSnapshot() throws Exception {
        BIFile bogFile = BFileSystem.INSTANCE.findFile(this.getBogFilePath());
        if (bogFile == null) {
            return null;
        }
        ValueDocDecoder dec = new ValueDocDecoder(bogFile);
        return (BDaemonPlatform)dec.decodeDocument();
    }

    public FilePath getModulesFilePath() throws Exception {
        BDaemonSession session = this.getDaemonSession();
        if (session != null) {
            return SystemFilePaths.getModulesPath((boolean)session.getHostProperties().getIsNiagaraHomeReadonly());
        }
        return SystemFilePaths.getLocalModulesPath();
    }

    protected FilePath getBogFilePath() {
        return new FilePath("^^provisioningNiagara/stationData").merge(this.getNiagaraStation().getStationName()).merge("software/snapshot.bog");
    }

    @Override
    public void started() {
        Property property = this.getProperty("platformSnapshot");
        if (property != null) {
            this.remove(property, null);
            this.setLastUpdate(BAbsTime.NULL);
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

