/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.software;

import com.tridium.batchJob.driver.BIPrivilegedDeviceJobStep;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ExemptionStoreUtil;
import com.tridium.crypto.core.io.ICoreExemptionStore;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BInstallable;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.InitializeSessionMessage;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.NiagaraNetworkJobOp;
import com.tridium.provisioningNiagara.software.BAbstractSoftwareStep;
import com.tridium.provisioningNiagara.software.BInstallStep;
import java.security.AccessController;
import java.util.Optional;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.file.BIFile;
import javax.baja.job.BJobState;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platform.ICancelHint;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="defaultPlatformCredentials", type="BUsernameAndPassword", defaultValue="new BUsernameAndPassword()"), @NiagaraProperty(name="defaultStationCredentials", type="BUsernameAndPassword", defaultValue="new BUsernameAndPassword()")})
public class BInstallCleanDistStep
extends BInstallStep
implements BIPrivilegedDeviceJobStep {
    @Generated
    public static final Property defaultPlatformCredentials = BInstallCleanDistStep.newProperty((int)0, (BValue)new BUsernameAndPassword(), null);
    @Generated
    public static final Property defaultStationCredentials = BInstallCleanDistStep.newProperty((int)0, (BValue)new BUsernameAndPassword(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BInstallCleanDistStep.class);
    private static final String EDGE_DEVICES = "EDGE";
    private static final int CONNECT_TIMEOUT_OVERRIDE = 360000;
    private static final int SOCKET_TIMEOUT_OVERRIDE = 360000;

    @Generated
    public BUsernameAndPassword getDefaultPlatformCredentials() {
        return (BUsernameAndPassword)this.get(defaultPlatformCredentials);
    }

    @Generated
    public void setDefaultPlatformCredentials(BUsernameAndPassword v) {
        this.set(defaultPlatformCredentials, (BValue)v, null);
    }

    @Generated
    public BUsernameAndPassword getDefaultStationCredentials() {
        return (BUsernameAndPassword)this.get(defaultStationCredentials);
    }

    @Generated
    public void setDefaultStationCredentials(BUsernameAndPassword v) {
        this.set(defaultStationCredentials, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BInstallCleanDistStep() {
    }

    public BInstallCleanDistStep(BIFile toInstall, boolean shouldCleanUp) {
        super(toInstall, shouldCleanUp);
    }

    public BInstallCleanDistStep(BInstallable toInstall, BISession fileSession, boolean shouldCleanUp) {
        super(toInstall, fileSession, shouldCleanUp);
    }

    @Override
    protected void beforeReconnect(InstallScenario scenario, BNiagaraStation station, BPlatformConnection platformConn, BDaemonSession platformSession, BDeviceStepDetails details) throws Exception {
        BPassword platPassword = BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)this.getDefaultPlatformCredentials().getPassword()).getValue()));
        String platUsername = this.getDefaultPlatformCredentials().getUsername();
        platformConn.setCredentials(new BUsernameAndPassword(platUsername, platPassword));
        BPassword foxPassword = BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)this.getDefaultStationCredentials().getPassword()).getValue()));
        String foxUsername = this.getDefaultStationCredentials().getUsername();
        for (BInstallable solutionInstallable : scenario.getToInstall()) {
            Optional<String> distModel = this.getModelFromDist(solutionInstallable);
            if (distModel.isPresent() && distModel.get().contains(EDGE_DEVICES)) {
                BFoxClientConnection clientConnection = station.getClientConnection();
                clientConnection.setCredentials((BIUserCredentials)new BUsernameAndPassword(foxUsername, foxPassword));
            }
            String distName = solutionInstallable.getInstallableName();
            details.message("provisioningNiagara", "InstallCleanDistStep.installed", distName);
        }
        BHost host = platformSession.getHost();
        try {
            ISecurityInfoProvider provider = AccessController.doPrivileged(() -> SecurityInitializer.getInstance().getSecurityInfoProvider());
            ICoreExemptionStore exemptionStore = CoreCryptoManager.get((ISecurityInfoProvider)provider).getExemptionStore();
            if (host != null) {
                String hostName = station.getRemoteHost().getHostname();
                ExemptionStoreUtil exemptionStoreUtil = new ExemptionStoreUtil(exemptionStore);
                exemptionStoreUtil.deleteExemptionsForHostname(hostName, false);
                details.message("provisioningNiagara", "InstallCleanDistStep.certExemptions", hostName);
            }
        }
        catch (Exception e) {
            details.endFailed("provisioningNiagara", "InstallCleanDistStep.certExemptionError", new String[]{host != null ? host.getHostname() : "(null)"});
            details.complete(BJobState.failed);
        }
    }

    @Override
    protected void reconnect(BDaemonSession platformSession, String sessionTimestamp, ICancelHint hint, boolean mustRestartStation, BAppSurrogate[] runningApps, NiagaraNetworkJobOp op, BAbstractSoftwareStep.Listener listener, InstallScenario scenario, BNiagaraStation station, BDeviceStepDetails details) throws Exception {
        if (station.getBootstrap()) {
            details.message("provisioningNiagara", "InstallCleanDistStep.initSession");
            BPlatformConnection platformConnection = (BPlatformConnection)station.getMixIn(BPlatformConnection.TYPE);
            BDaemonSession daemonSession = platformConnection.getDaemonSession(360000, 360000, false);
            if (daemonSession == null) {
                details.failed("provisioningNiagara", "AbstractSoftwareStep.platformConnUnavailable", new String[]{station.getDisplayName(null)});
                details.complete(BJobState.failed);
                return;
            }
            daemonSession.sendMessage((DaemonMessage)new InitializeSessionMessage());
            for (BInstallable solutionInstallable : scenario.getToInstall()) {
                Optional<String> distModel = this.getModelFromDist(solutionInstallable);
                if (!distModel.isPresent() || !distModel.get().contains(EDGE_DEVICES) || !mustRestartStation || runningApps.length <= 0) continue;
                for (BAppSurrogate app : runningApps) {
                    details.message("provisioningNiagara", "InstallCleanDistStep.startStation", app.getAppName());
                }
                this.restartStation(daemonSession, details, op, listener);
            }
            details.endSuccess();
        } else {
            details.message("provisioningNiagara", "InstallCleanDistStep.noConnection");
            details.endSuccess();
        }
    }
}

