/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.saml;

import com.tridium.authn.BAuthenticationService;
import com.tridium.bql.filter.BEnumFilter;
import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.cert.NCertificateParameters;
import com.tridium.crypto.core.cert.NKeyPairGenerator;
import com.tridium.crypto.core.cert.NRsaKeyPairGenerator;
import com.tridium.crypto.core.cert.NX509CertificateBuilder;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.nre.security.SecretChars;
import com.tridium.platcrypto.core.BCertManagerService;
import com.tridium.platcrypto.fox.ChannelCryptoManager;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import com.tridium.saml.BAuthnContextClassRefType;
import com.tridium.saml.authnScheme.BRequestedAuthenticationTypeComparisonMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.firewall.BServerPort;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.security.BX509Certificate;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="loginButtonTextFormat", type="BFormat", defaultValue="BFormat.make(\"Log in with %displayName%\")"), @NiagaraProperty(name="samlSigningCertAlias", type="String", defaultValue="BString.DEFAULT", deprecated=true), @NiagaraProperty(name="samlSigningCert", type="BCertificateAliasAndPassword", defaultValue="BCertificateAliasAndPassword.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="samlEncryptionCertAlias", type="String", defaultValue="BString.DEFAULT", deprecated=true), @NiagaraProperty(name="samlEncryptionCert", type="BCertificateAliasAndPassword", defaultValue="BCertificateAliasAndPassword.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="useSAMLIdPServiceCertificateAlias", type="boolean", defaultValue="true"), @NiagaraProperty(name="idpCertificateAlias", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="generateSAMLSigningCertificate", type="boolean", defaultValue="false"), @NiagaraProperty(name="generateSAMLEncryptionCertificate", type="boolean", defaultValue="false"), @NiagaraProperty(name="commonName", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="encryptionCommonName", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="organizationalUnit", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="organization", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="locality", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="stateProvince", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="countryCode", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="notBefore", type="BAbsTime", defaultValue="BAbsTime.DEFAULT"), @NiagaraProperty(name="notAfter", type="BAbsTime", defaultValue="BAbsTime.DEFAULT"), @NiagaraProperty(name="keySize", type="int", defaultValue="2048"), @NiagaraProperty(name="alternateServerName", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="alternateServerUri", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="emailAddress", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="password", type="BPassword", defaultValue="BPassword.DEFAULT", deprecated=true), @NiagaraProperty(name="keyUsage", type="int", defaultValue="0"), @NiagaraProperty(name="requestedAuthenticationType", type="BEnumFilter", defaultValue="new BEnumFilter(BAuthnContextClassRefType.unspecified, new BEnum[] { BAuthnContextClassRefType.unspecified } )"), @NiagaraProperty(name="requestedAuthenticationComparisonMode", type="BRequestedAuthenticationTypeComparisonMode", defaultValue="BRequestedAuthenticationTypeComparisonMode.exact")})
public class BConfigureNiagaraIdPAndSAMLSchemeJobStep
extends BDeviceJobStep {
    @Generated
    public static final Property loginButtonTextFormat = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (BValue)BFormat.make((String)"Log in with %displayName%"), null);
    @Deprecated
    @Generated
    public static final Property samlSigningCertAlias = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property samlSigningCert = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (BValue)BCertificateAliasAndPassword.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Deprecated
    @Generated
    public static final Property samlEncryptionCertAlias = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property samlEncryptionCert = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (BValue)BCertificateAliasAndPassword.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property useSAMLIdPServiceCertificateAlias = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property idpCertificateAlias = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property generateSAMLSigningCertificate = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property generateSAMLEncryptionCertificate = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property commonName = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property encryptionCommonName = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property organizationalUnit = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property organization = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property locality = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property stateProvince = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property countryCode = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property notBefore = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property notAfter = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property keySize = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (int)2048, null);
    @Generated
    public static final Property alternateServerName = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property alternateServerUri = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property emailAddress = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Deprecated
    @Generated
    public static final Property password = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property keyUsage = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property requestedAuthenticationType = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (BValue)new BEnumFilter((BEnum)BAuthnContextClassRefType.unspecified, new BEnum[]{BAuthnContextClassRefType.unspecified}), null);
    @Generated
    public static final Property requestedAuthenticationComparisonMode = BConfigureNiagaraIdPAndSAMLSchemeJobStep.newProperty((int)0, (BValue)BRequestedAuthenticationTypeComparisonMode.exact, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BConfigureNiagaraIdPAndSAMLSchemeJobStep.class);
    private static final Lexicon LEX = Lexicon.make((String)"provisioningNiagara");
    private static final Logger SAML_PROV_LOG = Logger.getLogger("provisioningNiagara.saml");
    private static final String SAML_IDP_URL_START = "/saml/idp/auth/httpredirect/cot/";
    public static final String STATION_NOT_IN_COT_WARNING_MESSAGE = "At least one Circle of Trust must be configured to include remote station ";
    private static final String CLASS_SAML_ENCRYPTER = "com.tridium.samlEncryption.BSamlXmlEncrypter";
    private static final String CLASS_SAML_DECRYPTER = "com.tridium.samlEncryption.BSamlXmlDecrypter";
    private static final String TYPE_SAML_IDP_SERVICE = "saml:SAMLIdPService";
    private static final String TYPE_SAML_SCHEME = "saml:SAMLAuthenticationScheme";
    private static final String TYPE_SAML_DECRYPTER = "samlEncryption:SamlXmlDecrypter";
    private static final String TYPE_SAML_ENCRYPTER = "samlEncryption:SamlXmlEncrypter";
    private static final String PROP_IDP_SIGNING_CERT = "idpSigningCertAliasAndPassword";
    private static final String PROP_IDP_SIGNING_CERT_ALIAS = "alias";
    private static final String PROP_CIRCLE_OF_TRUST_FOLDER = "circleOfTrustFolder";
    private static final String PROP_CIRCLE_OF_TRUST_UID = "uniqueId";
    private static final String PROP_CIRCLE_OF_TRUST_ENDPOINT = "httpRedirectEndpoint";
    private static final String PROP_SERVICE_PROVIDERS_FOLDER = "serviceProviders";
    private static final String PROP_SIGNING_CERTIFICATE = "certificate";
    private static final String PROP_ENCRYPTION_CERTIFICATE = "encryptionCertificate";
    private static final String PROP_ISSUER_URL = "issuerUrl";
    private static final String PROP_USE_ENCRYPTION = "useEncryption";
    private static final String PROP_SSO_BUTTON = "loginButtonText";
    private static final String PROP_ENTITY_ID = "entityId";
    private static final String PROP_IDP_HOST_URL = "idpHostURL";
    private static final String PROP_IDP_HOST_PORT = "idpHostPort";
    private static final String PROP_IDP_LOGIN_PATH = "idpLoginPath";
    private static final String PROP_IDP_CERT = "idpCert";
    private static final String PROP_REQUESTED_AUTHENTICATION_TYPE = "requestedAuthenticationType";
    private static final String PROP_REQUESTED_AUTHENTICATION_C0MPARISON_MODE = "requestedAuthenticationComparisonMode";
    private static final String PROP_SAML_LEGACY_SIGNING_CERT = "samlServerCert";
    private static final String PROP_SAML_SIGNING_CERT = "samlServerCertAliasAndPassword";
    private static final String PROP_SAML_SIGNING_CERT_ALIAS = "alias";
    private static final String PROP_SAML_SIGNING_CERT_PASSWORD = "password";
    private static final String PROP_SAML_LEGACY_DECRYPTER = "samlServerEncryptionCert";
    private static final String PROP_SAML_ENCRYPTION_CERT_ALIAS_AND_PASSWORD = "samlServerEncryptionCertAliasAndPassword";
    private static final String PROP_SAML_ENCRYPTION_CERT_ALIAS = "alias";
    private static final String PROP_SAML_ENCRYPTION_CERT_PASSWORD = "password";
    private static final Object encrypterLock = new Object();

    @Generated
    public BFormat getLoginButtonTextFormat() {
        return (BFormat)this.get(loginButtonTextFormat);
    }

    @Generated
    public void setLoginButtonTextFormat(BFormat v) {
        this.set(loginButtonTextFormat, (BValue)v, null);
    }

    @Deprecated
    @Generated
    public String getSamlSigningCertAlias() {
        return this.getString(samlSigningCertAlias);
    }

    @Deprecated
    @Generated
    public void setSamlSigningCertAlias(String v) {
        this.setString(samlSigningCertAlias, v, null);
    }

    @Generated
    public BCertificateAliasAndPassword getSamlSigningCert() {
        return (BCertificateAliasAndPassword)this.get(samlSigningCert);
    }

    @Generated
    public void setSamlSigningCert(BCertificateAliasAndPassword v) {
        this.set(samlSigningCert, (BValue)v, null);
    }

    @Deprecated
    @Generated
    public String getSamlEncryptionCertAlias() {
        return this.getString(samlEncryptionCertAlias);
    }

    @Deprecated
    @Generated
    public void setSamlEncryptionCertAlias(String v) {
        this.setString(samlEncryptionCertAlias, v, null);
    }

    @Generated
    public BCertificateAliasAndPassword getSamlEncryptionCert() {
        return (BCertificateAliasAndPassword)this.get(samlEncryptionCert);
    }

    @Generated
    public void setSamlEncryptionCert(BCertificateAliasAndPassword v) {
        this.set(samlEncryptionCert, (BValue)v, null);
    }

    @Generated
    public boolean getUseSAMLIdPServiceCertificateAlias() {
        return this.getBoolean(useSAMLIdPServiceCertificateAlias);
    }

    @Generated
    public void setUseSAMLIdPServiceCertificateAlias(boolean v) {
        this.setBoolean(useSAMLIdPServiceCertificateAlias, v, null);
    }

    @Generated
    public String getIdpCertificateAlias() {
        return this.getString(idpCertificateAlias);
    }

    @Generated
    public void setIdpCertificateAlias(String v) {
        this.setString(idpCertificateAlias, v, null);
    }

    @Generated
    public boolean getGenerateSAMLSigningCertificate() {
        return this.getBoolean(generateSAMLSigningCertificate);
    }

    @Generated
    public void setGenerateSAMLSigningCertificate(boolean v) {
        this.setBoolean(generateSAMLSigningCertificate, v, null);
    }

    @Generated
    public boolean getGenerateSAMLEncryptionCertificate() {
        return this.getBoolean(generateSAMLEncryptionCertificate);
    }

    @Generated
    public void setGenerateSAMLEncryptionCertificate(boolean v) {
        this.setBoolean(generateSAMLEncryptionCertificate, v, null);
    }

    @Generated
    public String getCommonName() {
        return this.getString(commonName);
    }

    @Generated
    public void setCommonName(String v) {
        this.setString(commonName, v, null);
    }

    @Generated
    public String getEncryptionCommonName() {
        return this.getString(encryptionCommonName);
    }

    @Generated
    public void setEncryptionCommonName(String v) {
        this.setString(encryptionCommonName, v, null);
    }

    @Generated
    public String getOrganizationalUnit() {
        return this.getString(organizationalUnit);
    }

    @Generated
    public void setOrganizationalUnit(String v) {
        this.setString(organizationalUnit, v, null);
    }

    @Generated
    public String getOrganization() {
        return this.getString(organization);
    }

    @Generated
    public void setOrganization(String v) {
        this.setString(organization, v, null);
    }

    @Generated
    public String getLocality() {
        return this.getString(locality);
    }

    @Generated
    public void setLocality(String v) {
        this.setString(locality, v, null);
    }

    @Generated
    public String getStateProvince() {
        return this.getString(stateProvince);
    }

    @Generated
    public void setStateProvince(String v) {
        this.setString(stateProvince, v, null);
    }

    @Generated
    public String getCountryCode() {
        return this.getString(countryCode);
    }

    @Generated
    public void setCountryCode(String v) {
        this.setString(countryCode, v, null);
    }

    @Generated
    public BAbsTime getNotBefore() {
        return (BAbsTime)this.get(notBefore);
    }

    @Generated
    public void setNotBefore(BAbsTime v) {
        this.set(notBefore, (BValue)v, null);
    }

    @Generated
    public BAbsTime getNotAfter() {
        return (BAbsTime)this.get(notAfter);
    }

    @Generated
    public void setNotAfter(BAbsTime v) {
        this.set(notAfter, (BValue)v, null);
    }

    @Generated
    public int getKeySize() {
        return this.getInt(keySize);
    }

    @Generated
    public void setKeySize(int v) {
        this.setInt(keySize, v, null);
    }

    @Generated
    public String getAlternateServerName() {
        return this.getString(alternateServerName);
    }

    @Generated
    public void setAlternateServerName(String v) {
        this.setString(alternateServerName, v, null);
    }

    @Generated
    public String getAlternateServerUri() {
        return this.getString(alternateServerUri);
    }

    @Generated
    public void setAlternateServerUri(String v) {
        this.setString(alternateServerUri, v, null);
    }

    @Generated
    public String getEmailAddress() {
        return this.getString(emailAddress);
    }

    @Generated
    public void setEmailAddress(String v) {
        this.setString(emailAddress, v, null);
    }

    @Deprecated
    @Generated
    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    @Deprecated
    @Generated
    public void setPassword(BPassword v) {
        this.set(password, (BValue)v, null);
    }

    @Generated
    public int getKeyUsage() {
        return this.getInt(keyUsage);
    }

    @Generated
    public void setKeyUsage(int v) {
        this.setInt(keyUsage, v, null);
    }

    @Generated
    public BEnumFilter getRequestedAuthenticationType() {
        return (BEnumFilter)this.get(requestedAuthenticationType);
    }

    @Generated
    public void setRequestedAuthenticationType(BEnumFilter v) {
        this.set(requestedAuthenticationType, (BValue)v, null);
    }

    @Generated
    public BRequestedAuthenticationTypeComparisonMode getRequestedAuthenticationComparisonMode() {
        return (BRequestedAuthenticationTypeComparisonMode)this.get(requestedAuthenticationComparisonMode);
    }

    @Generated
    public void setRequestedAuthenticationComparisonMode(BRequestedAuthenticationTypeComparisonMode v) {
        this.set(requestedAuthenticationComparisonMode, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        BComponent idpService = Sys.getService((Type)Sys.getType((String)TYPE_SAML_IDP_SERVICE));
        String stationName = device.getName();
        Object object = encrypterLock;
        synchronized (object) {
            Class encrypterClass = Sys.loadClass((String)"samlEncryption", (String)CLASS_SAML_ENCRYPTER);
            if (idpService.getChildren(encrypterClass).length == 0) {
                BTypeSpec encrypterTypeSpec = BTypeSpec.make((String)TYPE_SAML_ENCRYPTER);
                idpService.add("xmlEncrypter?", (BValue)encrypterTypeSpec.getInstance());
            }
        }
        details.message("provisioningNiagara", "ConfigureNiagaraIdPAndSAMLSchemeJobStep.message.acquiringIdPCert");
        X509Certificate idpCertificate = this.getIdpCertFromService(idpService);
        Set<BComponent> activeCirclesOfTrust = BConfigureNiagaraIdPAndSAMLSchemeJobStep.getActiveCirclesOfTrust(idpService, stationName);
        if (activeCirclesOfTrust.isEmpty()) {
            details.vaFailed("ConfigureNiagaraIdPAndSAMLSchemeJobStep.message.localCircleOfTrustNotFoundForStation", new String[]{stationName});
            SAML_PROV_LOG.log(Level.WARNING, STATION_NOT_IN_COT_WARNING_MESSAGE + stationName + '.');
        }
        try (ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);){
            X509Certificate samlEncryptionCert;
            this.checkForConfigurationExceptions();
            BFoxSession foxSession = util.getEngagedFoxSession();
            details.message("provisioningNiagara", "ConfigureNiagaraIdPAndSAMLSchemeJobStep.message.importIdPCert");
            this.importIdPCertificate(foxSession, idpCertificate);
            if (this.getGenerateSAMLSigningCertificate()) {
                details.message("provisioningNiagara", "ConfigureNiagaraIdPAndSAMLSchemeJobStep.message.genServerCert");
                this.generateSAMLSigningCertificate(foxSession);
                details.message("provisioningNiagara", "ConfigureNiagaraIdPAndSAMLSchemeJobStep.message.genServerCert.success");
            }
            if (this.getGenerateSAMLEncryptionCertificate()) {
                details.message("provisioningNiagara", "ConfigureNiagaraIdPAndSAMLSchemeJobStep.message.genServerEncryptionCert");
                this.generateSAMLEncryptionCertificate(foxSession);
                details.message("provisioningNiagara", "ConfigureNiagaraIdPAndSAMLSchemeJobStep.message.genServerEncryptionCert.success");
            }
            details.message("provisioningNiagara", "ConfigureNiagaraIdPAndSAMLSchemeJobStep.message.getServerCert");
            X509Certificate samlSigningCert = this.getSamlSigningCert(foxSession);
            if (samlSigningCert == null) {
                details.vaMessage("ConfigureNiagaraIdPAndSAMLSchemeJobStep.message.getServerCert.not.found.warning", new String[]{this.getSamlSigningCert().getAlias()});
            }
            if ((samlEncryptionCert = this.getSamlEncryptionCert(foxSession)) == null) {
                details.vaMessage("ConfigureNiagaraIdPAndSAMLSchemeJobStep.message.getServerCert.not.found.warning", new String[]{this.getSamlEncryptionCert().getAlias()});
            }
            BAuthenticationService authnService = (BAuthenticationService)BOrd.make((String)"service:baja:AuthenticationService").get((BObject)foxSession);
            authnService.lease(2);
            for (BComponent circleOfTrust : activeCirclesOfTrust) {
                String remoteEntityId = BConfigureNiagaraIdPAndSAMLSchemeJobStep.getRemoteEntityId(foxSession, device);
                BComponent existingMatchingScheme = BConfigureNiagaraIdPAndSAMLSchemeJobStep.findExistingMatchingScheme(circleOfTrust, authnService);
                if (existingMatchingScheme != null) {
                    details.vaMessage("ConfigureNiagaraIdPAndSAMLSchemeJobStep.message.foundRemoteScheme", new String[]{circleOfTrust.getName(), existingMatchingScheme.getName()});
                }
                details.vaMessage("ConfigureNiagaraIdPAndSAMLSchemeJobStep.message.confRemoteScheme", new String[]{circleOfTrust.getName()});
                this.configureRemoteAuthenticationScheme(authnService, existingMatchingScheme, circleOfTrust, remoteEntityId);
                BComplex circleOfTrustFolder = (BComplex)circleOfTrust.get(PROP_SERVICE_PROVIDERS_FOLDER);
                BComplex stationServiceProvider = (BComplex)circleOfTrustFolder.get(stationName);
                stationServiceProvider.set(PROP_ISSUER_URL, (BValue)BString.make((String)remoteEntityId), (Context)op.getUser());
                stationServiceProvider.set(PROP_SIGNING_CERTIFICATE, (BValue)BX509Certificate.make((X509Certificate)samlSigningCert), (Context)op.getUser());
                stationServiceProvider.set(PROP_ENCRYPTION_CERTIFICATE, (BValue)BX509Certificate.make((X509Certificate)samlEncryptionCert), (Context)op.getUser());
                stationServiceProvider.set(PROP_USE_ENCRYPTION, (BValue)BBoolean.TRUE, (Context)op.getUser());
            }
        }
        catch (SAMLIdPConfigurationJobStepArgsException e) {
            details.vaFailed(e.getLexiconKey(), e.getArgs());
            details.complete(BJobState.failed);
            SAML_PROV_LOG.log(Level.FINE, LEX.get("ConfigureNiagaraIdPAndSAMLSchemeJobStep.failed", null), e);
        }
        catch (SAMLIdPConfigurationJobStepException e) {
            details.failed(e.getLexiconModule(), e.getLexiconKey());
            details.complete(BJobState.failed);
            SAML_PROV_LOG.log(Level.FINE, LEX.get("ConfigureNiagaraIdPAndSAMLSchemeJobStep.failed", null), e);
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "ConfigureNiagaraIdPAndSAMLSchemeJobStep.failed", (Throwable)e);
            details.complete(BJobState.failed);
        }
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }

    private X509Certificate getIdpCertFromService(BComponent idpService) throws SAMLIdPConfigurationJobStepException {
        String idpCertificateAlias = ((BStruct)idpService.get(PROP_IDP_SIGNING_CERT)).get("alias").toString(null);
        if (idpCertificateAlias == null || idpCertificateAlias.isEmpty()) {
            throw new SAMLIdPConfigurationJobStepException("ConfigureNiagaraIdPAndSAMLSchemeJobStep.failed.noIdPCertConfigured");
        }
        try {
            X509Certificate idpCertificate = CoreCryptoManager.get().getKeyStore().getCertificate(idpCertificateAlias);
            if (idpCertificate == null) {
                throw new SAMLIdPConfigurationJobStepArgsException("ConfigureNiagaraIdPAndSAMLSchemeJobStep.failed.couldNotRetrieveIdP", new String[]{idpCertificateAlias});
            }
            if (this.getUseSAMLIdPServiceCertificateAlias()) {
                this.setIdpCertificateAlias(idpCertificateAlias);
            }
            return idpCertificate;
        }
        catch (Exception e) {
            throw new SAMLIdPConfigurationJobStepArgsException("ConfigureNiagaraIdPAndSAMLSchemeJobStep.failed.couldNotRetrieveIdP", e, new String[]{idpCertificateAlias});
        }
    }

    private static Set<BComponent> getActiveCirclesOfTrust(BComponent idpService, String stationName) {
        BComponent[] circlesOfTrust;
        HashSet<BComponent> activeCirclesOfTrust = new HashSet<BComponent>();
        BComponent circleOfTrustFolder = (BComponent)idpService.get(PROP_CIRCLE_OF_TRUST_FOLDER);
        for (BComponent circleOfTrust : circlesOfTrust = circleOfTrustFolder.getChildComponents()) {
            BComponent stationServiceProviderFolder = (BComponent)circleOfTrust.get(PROP_SERVICE_PROVIDERS_FOLDER);
            if (stationServiceProviderFolder.get(stationName) == null) continue;
            activeCirclesOfTrust.add(circleOfTrust);
        }
        return activeCirclesOfTrust;
    }

    private void importIdPCertificate(BFoxSession foxSession, X509Certificate idpCertificate) throws SAMLIdPConfigurationJobStepException {
        try {
            BCertManagerService remoteCertService = (BCertManagerService)BOrd.make((String)"service:platCrypto:CertManagerService").get((BObject)foxSession);
            ChannelCryptoManager coreCryptoManager = new ChannelCryptoManager((BComponent)remoteCertService);
            ICoreTrustStore userTrustStore = coreCryptoManager.getUserTrustStore();
            userTrustStore.setCertificateEntry(this.getIdpCertificateAlias(), idpCertificate);
            userTrustStore.save();
        }
        catch (Exception e) {
            throw new SAMLIdPConfigurationJobStepException("ConfigureNiagaraIdPAndSAMLSchemeJobStep.failed.importIdP", e);
        }
    }

    private void generateSAMLSigningCertificate(BFoxSession foxSession) throws SAMLIdPConfigurationJobStepException {
        this.generateSAMLCertificate(foxSession, this.getCommonName(), this.getSamlSigningCert().getAlias(), this.getSamlSigningCert().getPassword());
    }

    private void generateSAMLEncryptionCertificate(BFoxSession foxSession) throws SAMLIdPConfigurationJobStepException {
        this.generateSAMLCertificate(foxSession, this.getEncryptionCommonName(), this.getSamlEncryptionCert().getAlias(), this.getSamlEncryptionCert().getPassword());
    }

    private void generateSAMLCertificate(BFoxSession foxSession, String commonName, String alias, BPassword password) throws SAMLIdPConfigurationJobStepException {
        try {
            String dn = CertUtils.assembleDN((String)commonName, (String)(this.getOrganizationalUnit().isEmpty() ? null : this.getOrganizationalUnit()), (String)(this.getOrganization().isEmpty() ? null : this.getOrganization()), (String)(this.getLocality().isEmpty() ? null : this.getLocality()), (String)(this.getStateProvince().isEmpty() ? null : this.getStateProvince()), (String)(this.getCountryCode().isEmpty() ? null : this.getCountryCode()));
            NCertificateParameters certParams = new NCertificateParameters(alias, dn, dn, new Date(this.getNotBefore().getMillis()), new Date(this.getNotAfter().getMillis()), this.getKeySize(), KeyPurpose.SERVER_CERT, this.getAlternateServerName().length() > 0 ? this.getAlternateServerName() : null, this.getAlternateServerUri().length() > 0 ? this.getAlternateServerUri() : null, this.getEmailAddress().length() > 0 ? this.getEmailAddress() : null, password != null && !password.isDefault() ? AccessController.doPrivileged(() -> ((BPassword)password).getValue()) : null, this.getKeyUsage());
            NX509CertificateBuilder builder = CertUtils.createCertBuilderFromParameters((NCertificateParameters)certParams);
            BCertManagerService remoteCertService = (BCertManagerService)BOrd.make((String)"service:platCrypto:CertManagerService").get((BObject)foxSession);
            ChannelCryptoManager coreCryptoManager = new ChannelCryptoManager((BComponent)remoteCertService);
            SecretChars passwordChar = password != null && !password.isDefault() ? new SecretChars(AccessController.doPrivileged(() -> ((BPassword)password).getValue()).toCharArray(), false) : null;
            int requestId = coreCryptoManager.generateSelfSignedCert(builder, (NKeyPairGenerator)new NRsaKeyPairGenerator(this.getKeySize()), passwordChar);
            while (true) {
                int status;
                if ((status = coreCryptoManager.getCertGenerationStatus(requestId)) == -1) {
                    throw new SAMLIdPConfigurationJobStepArgsException("ConfigureNiagaraIdPAndSAMLSchemeJobStep.failed.serverCertGen", new String[]{alias});
                }
                if (status != 2) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new SAMLIdPConfigurationJobStepArgsException("ConfigureNiagaraIdPAndSAMLSchemeJobStep.failed.serverCertGen", e, new String[]{alias});
        }
    }

    private X509Certificate getSamlSigningCert(BFoxSession foxSession) throws SAMLIdPConfigurationJobStepArgsException {
        return this.getSamlCert(foxSession, this.getSamlSigningCert().getAlias());
    }

    private X509Certificate getSamlEncryptionCert(BFoxSession foxSession) throws SAMLIdPConfigurationJobStepArgsException {
        return this.getSamlCert(foxSession, this.getSamlEncryptionCert().getAlias());
    }

    private X509Certificate getSamlCert(BFoxSession foxSession, String alias) throws SAMLIdPConfigurationJobStepArgsException {
        try {
            BCertManagerService remoteCertService = (BCertManagerService)BOrd.make((String)"service:platCrypto:CertManagerService").get((BObject)foxSession);
            ChannelCryptoManager coreCryptoManager = new ChannelCryptoManager((BComponent)remoteCertService);
            ICoreKeyStore remoteKeyStore = coreCryptoManager.getKeyStore();
            return remoteKeyStore.getCertificate(alias);
        }
        catch (Exception e) {
            throw new SAMLIdPConfigurationJobStepArgsException("ConfigureNiagaraIdPAndSAMLSchemeJobStep.failed.serverCertGet", e, new String[]{alias});
        }
    }

    private static String getRemoteEntityId(BFoxSession foxSession, BDevice device) {
        BComponent webService = (BComponent)BOrd.make((String)"service:web:WebService").get((BObject)foxSession);
        webService.lease(1);
        boolean useTls = ((BIBoolean)webService.get("httpsEnabled")).getBoolean();
        if (!useTls && !((BIBoolean)webService.get("httpEnabled")).getBoolean()) {
            useTls = true;
        }
        String protocol = useTls ? "https" : "http";
        String portPropertyName = String.format("%sPort", protocol);
        int port = ((BServerPort)webService.get(portPropertyName)).getPublicServerPort();
        String stationName = ((NiagaraStation)device).getRemoteHost().getHostname();
        String remoteStationEntityId = String.format("%s://%s:%s/saml/", protocol, stationName, port);
        SAML_PROV_LOG.fine("Built remote station station id: " + remoteStationEntityId);
        return remoteStationEntityId;
    }

    private static BComponent findExistingMatchingScheme(BComponent circleOfTrust, BAuthenticationService remoteAuthnService) {
        BComponent[] remoteAuthnSchemes;
        String circleOfTrustEndpointPath = SAML_IDP_URL_START + circleOfTrust.get(PROP_CIRCLE_OF_TRUST_UID).toString();
        for (BComponent authnScheme : remoteAuthnSchemes = remoteAuthnService.getAuthenticationSchemes().getChildComponents()) {
            if (!authnScheme.getType().is(Sys.getType((String)TYPE_SAML_SCHEME)) || !circleOfTrustEndpointPath.equals(authnScheme.get(PROP_IDP_LOGIN_PATH).toString(null))) continue;
            return authnScheme;
        }
        return null;
    }

    private void configureRemoteAuthenticationScheme(BAuthenticationService remoteAuthnService, BComponent existingAuthnScheme, BComponent circleOfTrust, String remoteStationEntityId) throws SAMLIdPConfigurationJobStepException {
        try {
            BPassword encryptionCertPassword;
            BComponent authnScheme = existingAuthnScheme;
            if (existingAuthnScheme == null) {
                BTypeSpec typeSpec = BTypeSpec.make((String)TYPE_SAML_SCHEME);
                authnScheme = (BComponent)typeSpec.getInstance();
            }
            String circleOfTrustEndpoint = circleOfTrust.get(PROP_CIRCLE_OF_TRUST_ENDPOINT).toString();
            URL endpointUrl = new URL(circleOfTrustEndpoint);
            authnScheme.set(PROP_SSO_BUTTON, (BValue)BString.make((String)this.getLoginButtonTextFormat().format((Object)circleOfTrust)));
            authnScheme.set(PROP_ENTITY_ID, (BValue)BString.make((String)remoteStationEntityId));
            authnScheme.set(PROP_IDP_HOST_URL, (BValue)BString.make((String)String.format("%s://%s", endpointUrl.getProtocol(), endpointUrl.getHost())));
            authnScheme.set(PROP_IDP_HOST_PORT, (BValue)BInteger.make((int)endpointUrl.getPort()));
            authnScheme.set(PROP_IDP_LOGIN_PATH, (BValue)BString.make((String)endpointUrl.getPath()));
            authnScheme.set(PROP_IDP_CERT, (BValue)BString.make((String)this.getIdpCertificateAlias()));
            authnScheme.set(PROP_REQUESTED_AUTHENTICATION_TYPE, (BValue)new BEnumFilter(this.getRequestedAuthenticationType().getEnumType(), (BEnum[])this.getRequestedAuthenticationType().getEnumValues().getChildren(BEnum.class)));
            authnScheme.set(PROP_REQUESTED_AUTHENTICATION_C0MPARISON_MODE, (BValue)BRequestedAuthenticationTypeComparisonMode.make((int)this.getRequestedAuthenticationComparisonMode().getOrdinal()));
            authnScheme.setFlags(authnScheme.getSlot(PROP_SAML_LEGACY_SIGNING_CERT), 0x10000005);
            ((BStruct)authnScheme.get(PROP_SAML_SIGNING_CERT)).set("alias", (BValue)BString.make((String)this.getSamlSigningCert().getAlias()));
            BPassword signCertPassword = this.getSamlSigningCert().getPassword() != null && !this.getSamlSigningCert().getPassword().isDefault() ? BPassword.make((char[])AccessController.doPrivileged(() -> ((BPassword)this.getSamlSigningCert().getPassword()).getValue()).toCharArray()) : BPassword.DEFAULT;
            ((BStruct)authnScheme.get(PROP_SAML_SIGNING_CERT)).set("password", (BValue)signCertPassword);
            BTypeSpec decrypterTypeSpec = BTypeSpec.make((String)TYPE_SAML_DECRYPTER);
            Class decrypterClass = Sys.loadClass((String)"samlEncryption", (String)CLASS_SAML_DECRYPTER);
            BComponent[] decrypters = (BComponent[])authnScheme.getChildren(decrypterClass);
            BPassword bPassword = this.getSamlEncryptionCert().getPassword() != null && !this.getSamlEncryptionCert().getPassword().isDefault() ? BPassword.make((char[])AccessController.doPrivileged(() -> ((BPassword)this.getSamlEncryptionCert().getPassword()).getValue()).toCharArray()) : (encryptionCertPassword = BPassword.DEFAULT);
            if (decrypters.length != 0) {
                authnScheme.remove((BComplex)decrypters[0]);
            }
            BComplex decrypter = (BComplex)decrypterTypeSpec.getInstance();
            decrypter.setFlags(decrypter.getSlot(PROP_SAML_LEGACY_DECRYPTER), 0x10000005);
            ((BStruct)decrypter.get(PROP_SAML_ENCRYPTION_CERT_ALIAS_AND_PASSWORD)).set("alias", (BValue)BString.make((String)this.getSamlEncryptionCert().getAlias()));
            ((BStruct)decrypter.get(PROP_SAML_ENCRYPTION_CERT_ALIAS_AND_PASSWORD)).set("password", (BValue)encryptionCertPassword);
            authnScheme.add("samlDecrypter", (BValue)decrypter);
            if (existingAuthnScheme == null) {
                String remoteSchemeName = String.format("NiagaraIdP_%s?", circleOfTrust.getName());
                remoteAuthnService.getAuthenticationSchemes().add(remoteSchemeName, (BValue)authnScheme);
            }
        }
        catch (MalformedURLException e) {
            throw new SAMLIdPConfigurationJobStepArgsException("ConfigureNiagaraIdPAndSAMLSchemeJobStep.failed.endpointURL", (Exception)e, new String[]{circleOfTrust.getName()});
        }
        catch (ClassNotFoundException e) {
            throw new SAMLIdPConfigurationJobStepArgsException("ConfigureNiagaraIdPAndSAMLSchemeJobStep.failed.decrypter", (Exception)e, new String[0]);
        }
    }

    private void checkForConfigurationExceptions() throws SAMLIdPConfigurationJobStepException {
        if (this.getGenerateSAMLSigningCertificate() && this.getGenerateSAMLEncryptionCertificate() && this.getSamlSigningCert().getAlias().trim().equals(this.getSamlEncryptionCert().getAlias().trim())) {
            throw new SAMLIdPConfigurationJobStepException("ConfigureNiagaraIdPAndSAMLSchemeDialog.samlCertAlias.warning");
        }
    }

    public String toString(Context context) {
        String samlSigningCertAlias = this.getSamlSigningCert().getAlias();
        String samlEncryptionCertAlias = this.getSamlEncryptionCert().getAlias();
        String idpCertificateAlias = this.getUseSAMLIdPServiceCertificateAlias() ? "<from service>" : this.getIdpCertificateAlias();
        Boolean generateSamlSigningCertificate = this.getGenerateSAMLSigningCertificate();
        Boolean generateSamlEncryptionCertificate = this.getGenerateSAMLEncryptionCertificate();
        String organization = this.getOrganization();
        return this.getLexicon().getText("ConfigureNiagaraIdPAndSAMLSchemeJobStep.display", new Object[]{samlSigningCertAlias, samlEncryptionCertAlias, idpCertificateAlias, generateSamlSigningCertificate, generateSamlEncryptionCertificate, organization});
    }

    private class SAMLIdPConfigurationJobStepArgsException
    extends SAMLIdPConfigurationJobStepException {
        private final String[] args;

        private SAMLIdPConfigurationJobStepArgsException(String lexiconKey, Exception e, String ... args) {
            super(lexiconKey, e);
            this.args = args;
        }

        private SAMLIdPConfigurationJobStepArgsException(String lexiconKey, String ... args) {
            super(lexiconKey);
            this.args = args;
        }

        String[] getArgs() {
            return (String[])this.args.clone();
        }
    }

    private static class SAMLIdPConfigurationJobStepException
    extends Exception {
        private final String lexiconKey;

        private SAMLIdPConfigurationJobStepException(String lexiconKey, Exception e) {
            super(e);
            this.lexiconKey = lexiconKey;
        }

        private SAMLIdPConfigurationJobStepException(String lexiconKey) {
            this.lexiconKey = lexiconKey;
        }

        String getLexiconModule() {
            return "provisioningNiagara";
        }

        String getLexiconKey() {
            return this.lexiconKey;
        }
    }
}

