/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.program;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.program.BProgramService;
import com.tridium.program.BRobotCode;
import com.tridium.program.BRobotResult;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import com.tridium.provisioningNiagara.program.BProvisioningRobot;
import com.tridium.provisioningNiagara.program.BRobotStepDetails;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.io.BIEncodable;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperty(name="robotOrd", type="BOrd", defaultValue="BOrd.NULL", flags=1)
public class BRobotJobStep
extends BDeviceJobStep
implements BIEncodable {
    @Generated
    public static final Property robotOrd = BRobotJobStep.newProperty((int)1, (BValue)BOrd.NULL, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRobotJobStep.class);
    private static final BIcon ICON = BIcon.std((String)"script.png");

    @Generated
    public BOrd getRobotOrd() {
        return (BOrd)this.get(robotOrd);
    }

    @Generated
    public void setRobotOrd(BOrd v) {
        this.set(robotOrd, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BRobotJobStep() {
    }

    public BRobotJobStep(BProvisioningRobot robot) {
        this.setRobotOrd(robot.getOrdInSpace());
    }

    protected BDeviceStepDetails makeDetails(BDevice device) {
        BNiagaraStation station = (BNiagaraStation)device;
        BRobotStepDetails result = new BRobotStepDetails(station, this);
        this.add(SlotPath.escape((String)station.getStationName()), (BValue)result, 4);
        return result;
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        BPlatformConnection platformConn = (BPlatformConnection)device.getMixIn(BPlatformConnection.TYPE);
        if (platformConn.isUnoperational()) {
            details.failed("provisioningNiagara", "AbstractSoftwareStep.platformConnUnoperational", new String[]{device.getDisplayName(null), BFormat.getEncodedPattern((BIEncodable)platformConn.getStatus())});
            details.complete(BJobState.failed);
            return;
        }
        BDaemonSession daemonSession = platformConn.getDaemonSession();
        if (daemonSession == null) {
            details.failed("provisioningNiagara", "AbstractSoftwareStep.platformConnUnavailable", new String[]{device.getDisplayName(null)});
            details.complete(BJobState.failed);
            return;
        }
        if (!daemonSession.getHostProperties().isNiagara4()) {
            details.failed("provisioningNiagara", "RobotJobStep.axStation", new String[]{device.getDisplayName(null)});
            details.complete(BJobState.failed);
            return;
        }
        BRobotCode code = this.getRobot((BObject)svc).getRobotCode();
        BRemoteDaemonPlatform platform = BRemoteDaemonPlatform.make((BDaemonSession)daemonSession, null, (boolean)false);
        platform.checkSession();
        for (String moduleName : code.parseDependencies()) {
            if (platform.meets(BDependency.forModule((String)moduleName))) continue;
            details.failed("provisioningNiagara", "RobotJobStep.unmetDependency", new String[]{device.getDisplayName(null), moduleName});
            details.complete(BJobState.failed);
            return;
        }
        try (ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);){
            BFoxSession session = util.getEngagedFoxSession();
            BProgramService programService = (BProgramService)BOrd.make((String)"service:program:ProgramService").get((BObject)session);
            programService.lease(1);
            BRobotResult result = programService.runRobot(code);
            ((BRobotStepDetails)details).setRobotResult(result);
            if (!result.getSuccess()) {
                details.failed("program", result.getFailCause());
                details.complete(BJobState.failed);
            }
        }
    }

    protected BProvisioningRobot getRobot(BObject base) {
        return (BProvisioningRobot)this.getRobotOrd().get(base);
    }

    public BIcon getIcon() {
        return ICON;
    }

    public String toString(Context cx) {
        return this.getLexicon().getText("RobotJobStep.display");
    }

    public void encode(DataOutput out) throws IOException {
        this.getRobotOrd().encode(out);
    }

    public BObject decode(DataInput in) throws IOException {
        BRobotJobStep result = new BRobotJobStep();
        result.setRobotOrd((BOrd)BOrd.DEFAULT.decode(in));
        return result;
    }

    public String encodeToString() throws IOException {
        return this.getRobotOrd().encodeToString();
    }

    public BObject decodeFromString(String s) throws IOException {
        BRobotJobStep result = new BRobotJobStep();
        result.setRobotOrd((BOrd)BOrd.DEFAULT.decodeFromString(s));
        return result;
    }
}

