/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.credentials;

import com.tridium.batchJob.driver.BIPrivilegedDeviceJobStep;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.user.BUserChannel;
import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import java.security.AccessController;
import java.util.Collections;
import java.util.Set;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BPasswordCache;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="username", type="String", defaultValue=""), @NiagaraProperty(name="currentPassword", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="newPassword", type="BPassword", defaultValue="BPassword.DEFAULT")})
public class BSetStationUserPasswordJobStep
extends BDeviceJobStep
implements BIPrivilegedDeviceJobStep {
    @Generated
    public static final Property username = BSetStationUserPasswordJobStep.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property currentPassword = BSetStationUserPasswordJobStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property newPassword = BSetStationUserPasswordJobStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSetStationUserPasswordJobStep.class);

    @Generated
    public String getUsername() {
        return this.getString(username);
    }

    @Generated
    public void setUsername(String v) {
        this.setString(username, v, null);
    }

    @Generated
    public BPassword getCurrentPassword() {
        return (BPassword)this.get(currentPassword);
    }

    @Generated
    public void setCurrentPassword(BPassword v) {
        this.set(currentPassword, (BValue)v, null);
    }

    @Generated
    public BPassword getNewPassword() {
        return (BPassword)this.get(newPassword);
    }

    @Generated
    public void setNewPassword(BPassword v) {
        this.set(newPassword, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        block37: {
            BFoxClientConnection clientConnection = ((BNiagaraStation)device).getClientConnection();
            BIUserCredentials credentials = clientConnection.getCredentials();
            String username = this.getUsername();
            String connectionUsername = credentials.getUsername();
            try (ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);){
                BUserService service;
                BFoxSession foxSession = util.getEngagedFoxSession();
                BPassword newPassword = BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)this.getNewPassword()).getValue()));
                if (username.isEmpty() || username.equals(connectionUsername)) {
                    if (credentials instanceof BUsernameAndPassword && !((BUsernameAndPassword)credentials).getPassword().validate(this.getCurrentPassword())) {
                        details.failed("provisioningNiagara", "SetStationUserPasswordJobStep.failed.incorrectCurrent");
                        details.complete(BJobState.failed);
                        return;
                    }
                    BUserChannel userChannel = foxSession.getConnection().getChannels().getUserChannel();
                    userChannel.fetchPrefs();
                    userChannel.setAuthenticator((BAbstractAuthenticator)new BPasswordCache(newPassword), true);
                    clientConnection.setCredentials((BIUserCredentials)new BUsernameAndPassword(clientConnection.getUsername(), newPassword));
                    foxSession.setCredentials((BICredentials)new BUsernameAndPassword(clientConnection.getUsername(), newPassword));
                    details.success();
                    break block37;
                }
                try {
                    service = (BUserService)BOrd.make((String)"service:baja:UserService").get((BObject)foxSession);
                }
                catch (UnresolvedException e) {
                    details.failed("provisioningNiagara", "SetStationUserPasswordJobStep.failed.cannotResolveUserService", new String[]{connectionUsername, username, BUserService.TYPE.getDisplayName((Context)op)}, (Throwable)e);
                    details.complete(BJobState.failed);
                    if (util != null) {
                        if (var10_11 != null) {
                            try {
                                util.close();
                            }
                            catch (Throwable throwable) {
                                var10_11.addSuppressed(throwable);
                            }
                        } else {
                            util.close();
                        }
                    }
                    return;
                }
                service.lease();
                BUser user = service.getUser(this.getUsername());
                if (user == null) {
                    details.failed("provisioningNiagara", "SetStationUserPasswordJobStep.failed.userNotFound", new String[]{username});
                    details.complete(BJobState.failed);
                    return;
                }
                user.lease();
                BAbstractAuthenticator authenticator = user.getAuthenticator();
                if (authenticator instanceof BPasswordAuthenticator) {
                    authenticator.lease(1);
                    if (!((BPasswordAuthenticator)authenticator).getPassword().validate(this.getCurrentPassword())) {
                        details.failed("provisioningNiagara", "SetStationUserPasswordJobStep.failed.incorrectCurrent");
                        details.complete(BJobState.failed);
                        return;
                    }
                    authenticator.set(BPasswordAuthenticator.password, (BValue)newPassword, Context.forceValidate);
                    details.success();
                } else {
                    details.failed("provisioningNiagara", "SetStationUserPasswordJobStep.failed.noPasswordAuthenticator", new String[]{username});
                    details.complete(BJobState.failed);
                }
            }
            catch (Exception e) {
                details.failed("provisioningNiagara", "SetStationUserPasswordJobStep.failed", (Throwable)e);
                details.complete(BJobState.failed);
            }
        }
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }

    public String toString(Context context) {
        if (!this.getUsername().isEmpty()) {
            return this.getLexicon().getText("SetStationUserPasswordJobStep.displayName", new Object[]{this.getUsername()});
        }
        return this.getLexicon().getText("SetStationUserPasswordJobStep.displayNameUsingConnectionUsername");
    }
}

