/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.credentials;

import com.tridium.batchJob.driver.BIPrivilegedDeviceJobStep;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import java.security.AccessController;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="username", type="String", defaultValue=""), @NiagaraProperty(name="password", type="BPassword", defaultValue="BPassword.DEFAULT")})
public class BSetStationConnectionCredentialsStep
extends BDeviceJobStep
implements BIPrivilegedDeviceJobStep {
    @Generated
    public static final Property username = BSetStationConnectionCredentialsStep.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property password = BSetStationConnectionCredentialsStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSetStationConnectionCredentialsStep.class);

    @Generated
    public String getUsername() {
        return this.getString(username);
    }

    @Generated
    public void setUsername(String v) {
        this.setString(username, v, null);
    }

    @Generated
    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    @Generated
    public void setPassword(BPassword v) {
        this.set(password, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSetStationConnectionCredentialsStep() {
    }

    public BSetStationConnectionCredentialsStep(String username, BPassword password) {
        this.setUsername(username);
        this.setPassword(password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        ProvisioningConnectionUtil util = null;
        try {
            util = new ProvisioningConnectionUtil(device, details);
            this.updateStationConnection((BNiagaraStation)device, details);
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "SetStationConnectionCredentialsStep.failed", (Throwable)e);
            details.complete(BJobState.failed);
        }
        finally {
            try {
                if (util != null) {
                    util.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void updateStationConnection(BNiagaraStation station, BDeviceStepDetails details) {
        BFoxClientConnection clientConnection = station.getClientConnection();
        BPassword password = BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)this.getPassword()).getValue()));
        clientConnection.setCredentials((BIUserCredentials)new BUsernameAndPassword(this.getUsername(), password));
        BProvisioningNiagaraNetworkExt ext = (BProvisioningNiagaraNetworkExt)Sys.getService((Type)BProvisioningNiagaraNetworkExt.TYPE);
        BFoxSession foxSession = (BFoxSession)BProvisioningNiagaraNetworkExt.getFoxProxySession(station);
        foxSession.setCredentials((BICredentials)new BUsernameAndPassword(clientConnection.getUsername(), password));
        foxSession.disconnect();
        details.vaMessage("SetStationConnectionCredentialsStep.updatedConnection", new String[]{this.getUsername()});
        details.success();
    }

    public String toString(Context context) {
        return super.toString(context) + " (" + this.getUsername() + ")";
    }
}

