/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.credentials;

import com.tridium.batchJob.driver.BIPrivilegedDeviceJobStep;
import com.tridium.niagarad.util.DaemonAuthUtil;
import com.tridium.nre.auth.GroupAccount;
import com.tridium.nre.auth.NativeAccount;
import com.tridium.nre.auth.UserAccount;
import com.tridium.nre.util.LegacyStorageUtil;
import com.tridium.platDaemon.ui.FipsOptionsHelper;
import com.tridium.platform.daemon.message.AccountManagementMessage;
import com.tridium.platform.daemon.message.AuthenticationInfoMessage;
import com.tridium.platform.daemon.message.ChangePasswordMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.InitializeSessionMessage;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import java.io.InputStream;
import java.security.AccessController;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.SharedSecretKey;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="currentUsername", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="currentPassword", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="newPassword", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="isFips", type="BBoolean", defaultValue="BBoolean.FALSE")})
public class BSetPlatformUserPasswordJobStep
extends BDeviceJobStep
implements BIPrivilegedDeviceJobStep {
    @Generated
    public static final Property currentUsername = BSetPlatformUserPasswordJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property currentPassword = BSetPlatformUserPasswordJobStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property newPassword = BSetPlatformUserPasswordJobStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property isFips = BSetPlatformUserPasswordJobStep.newProperty((int)0, (boolean)((BBoolean)BBoolean.FALSE.as(BBoolean.class)).getBoolean(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSetPlatformUserPasswordJobStep.class);
    public static Logger log = Logger.getLogger("provisioning.setplatformuserpass");
    public static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");

    @Generated
    public String getCurrentUsername() {
        return this.getString(currentUsername);
    }

    @Generated
    public void setCurrentUsername(String v) {
        this.setString(currentUsername, v, null);
    }

    @Generated
    public BPassword getCurrentPassword() {
        return (BPassword)this.get(currentPassword);
    }

    @Generated
    public void setCurrentPassword(BPassword v) {
        this.set(currentPassword, (BValue)v, null);
    }

    @Generated
    public BPassword getNewPassword() {
        return (BPassword)this.get(newPassword);
    }

    @Generated
    public void setNewPassword(BPassword v) {
        this.set(newPassword, (BValue)v, null);
    }

    @Generated
    public boolean getIsFips() {
        return this.getBoolean(isFips);
    }

    @Generated
    public void setIsFips(boolean v) {
        this.setBoolean(isFips, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSetPlatformUserPasswordJobStep() {
    }

    public BSetPlatformUserPasswordJobStep(String currentUsername, BPassword currentPassword, BPassword newPassword, boolean isFips) {
        this.setCurrentUsername(currentUsername);
        this.setCurrentPassword(currentPassword);
        this.setNewPassword(newPassword);
        this.setIsFips(isFips);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        try (ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);){
            XElem authInfo = util.getDaemonResponse((DaemonMessage)new AuthenticationInfoMessage(false));
            XElem authElem = authInfo.elem("auth");
            assert (authElem != null);
            String authMethod = authElem.get("type");
            boolean authReadonly = authElem.getb("readonly", false);
            if (DaemonAuthUtil.isNativeScheme((String)authMethod)) {
                if (!util.getDaemonSession().getHostProperties().supportsServlet("acctmgt")) {
                    log.warning(lex.getText("SetPlatformUserPasswordJobStep.noAccountManagement"));
                    details.failed("provisioningNiagara", "SetPlatformUserPasswordJobStep.noAccountManagement");
                    details.complete(BJobState.failed);
                    return;
                }
                if (authReadonly) {
                    log.warning(lex.getText("SetPlatformUserPasswordJobStep.authReadonly"));
                    details.failed("provisioningNiagara", "SetPlatformUserPasswordJobStep.authReadonly");
                    details.complete(BJobState.failed);
                    return;
                }
                XElem elem = authElem.elem("admingroup");
                GroupAccount nativeAdminGroup = new GroupAccount(elem.get("name"), elem.get("id"));
                elem = authElem.elem("user");
                boolean isCurrentUser = false;
                boolean userNameIsQualified = NativeAccount.isAccountNameFullyQualified((String)this.getCurrentUsername());
                UserAccount userToUpdate = null;
                try {
                    XElem accountInfo = XParser.make((InputStream)util.getDaemonSession().getInputStream((DaemonMessage)new AccountManagementMessage())).parse();
                    block31: for (XElem group : accountInfo.elems("group")) {
                        for (XElem user : group.elems("user")) {
                            UserAccount existingUser = new UserAccount(user.get("name"), user.get("id", null), user.get("description", null), null);
                            if ((!userNameIsQualified || !this.getCurrentUsername().equals(existingUser.getFullyQualifiedName())) && (userNameIsQualified || !this.getCurrentUsername().equals(existingUser.getAccountName()))) continue;
                            if (user.get("canModify", "false").equals("false")) {
                                throw new IllegalArgumentException(String.format("user %s cannot be modified", this.getCurrentUsername()));
                            }
                            userToUpdate = existingUser;
                            userToUpdate.setOldPassword(LegacyStorageUtil.encode((String)AccessController.doPrivileged(() -> ((BPassword)this.getCurrentPassword()).getValue()), (int)0));
                            userToUpdate.setPassword(LegacyStorageUtil.encode((String)AccessController.doPrivileged(() -> ((BPassword)this.getNewPassword()).getValue()), (int)0));
                            isCurrentUser = userToUpdate.getAccountName().equals(NativeAccount.fullyQualifiedToUsername((String)util.getPlatformConnection().getCredentials().getUsername()));
                            continue block31;
                        }
                    }
                }
                catch (RuntimeException rethrow) {
                    throw rethrow;
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
                if (userToUpdate == null) {
                    log.warning(lex.getText("SetPlatformUserPasswordJobStep.userNotFoundError", new Object[]{this.getCurrentUsername()}));
                    details.failed("provisioningNiagara", "SetPlatformUserPasswordJobStep.userNotFoundError", this.getCurrentUsername());
                    details.complete(BJobState.failed);
                    return;
                }
                BPasswordStrength passwordStrength = new BPasswordStrength(util.getDaemonSession().getPlatformPasswordStrengthRequirements());
                try {
                    passwordStrength.isPasswordValid(AccessController.doPrivileged(() -> ((BPassword)this.getNewPassword()).getValue()));
                }
                catch (Exception e) {
                    log.warning(lex.getText("SetPlatformUserPasswordJobStep.strengthError"));
                    details.failed("provisioningNiagara", "SetPlatformUserPasswordJobStep.strengthError");
                    details.complete(BJobState.failed);
                    if (util == null) return;
                    if (var6_7 == null) {
                        util.close();
                        return;
                    }
                    try {
                        util.close();
                        return;
                    }
                    catch (Throwable throwable) {
                        var6_7.addSuppressed(throwable);
                        return;
                    }
                }
                ChangePasswordMessage changePasswordMessage = new ChangePasswordMessage(userToUpdate, userToUpdate.getOldPassword(), userToUpdate.getPassword(), isCurrentUser);
                SharedSecretKey secretKey = util.getDaemonSession().generateSharedSecretKey("setplatformuserpass_changePass");
                changePasswordMessage.setSharedKey(secretKey);
                util.sendDaemonMessage((DaemonMessage)changePasswordMessage);
                if (isCurrentUser) {
                    BUsernameAndPassword newUserCredentials = new BUsernameAndPassword(userToUpdate.getAccountName(), this.getNewPassword());
                    util.getPlatformConnection().setCredentials(newUserCredentials);
                    util.getDaemonSession().sendMessage((DaemonMessage)new InitializeSessionMessage());
                }
                FipsOptionsHelper.getInstance().updateUserCookie(this.getCurrentUsername(), util.getDaemonSession().getHostProperties().isFips() && this.getIsFips(), util.getDaemonSession());
                details.success();
                return;
            }
            log.warning(lex.getText("SetPlatformUserPasswordJobStep.nativeOnly"));
            details.failed("provisioningNiagara", "SetPlatformUserPasswordJobStep.nativeOnly");
            details.complete(BJobState.failed);
            return;
        }
        catch (Exception e) {
            log.log(Level.WARNING, this.lexValue("unexpectedError", new Object[0]), e);
            throw e;
        }
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }

    public String toString(Context context) {
        return this.getLexicon().getText("SetPlatformUserPasswordJobStep.displayName", new Object[]{this.getCurrentUsername(), this.getIsFips()});
    }
}

