/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.bootstrap;

import com.tridium.batchJob.driver.BIPrivilegedDeviceJobStep;
import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platform.RemoteStation;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BRenameStationStep
extends BDeviceJobStep
implements BIPrivilegedDeviceJobStep {
    @Generated
    public static final Type TYPE = Sys.loadType(BRenameStationStep.class);
    private static final Logger logger = Logger.getLogger(BRenameStationStep.class.getPackage().getName());

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BRenameStationStep() {
        logger.finest("BRenameStationStep() called");
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        logger.finest(() -> String.format("Entering doRun(), device = %s", device.getName()));
        BNiagaraStation station = (BNiagaraStation)device;
        try (ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);){
            RemoteStation[] remoteStations = util.getRemoteStationList();
            RemoteStation remoteStation = this.getRemoteStation(remoteStations, details, station);
            if (remoteStation != null) {
                String proxyStationName;
                String remoteStationName = remoteStation.getName();
                if (!remoteStationName.equals(proxyStationName = station.getName())) {
                    logger.fine(() -> String.format("Renaming remote station %s to %s", remoteStation.getName(), proxyStationName));
                    remoteStation.rename(proxyStationName, null);
                    logger.info(() -> this.lexValue("stationRenamed", new Object[]{remoteStationName, proxyStationName}));
                    details.vaSuccess(this.lexKey("stationRenamed"), new String[]{remoteStationName, proxyStationName});
                } else {
                    logger.info(() -> this.lexValue("renameNotNeeded", new Object[]{proxyStationName}));
                    details.vaSuccess(this.lexKey("renameNotNeeded"), new String[]{proxyStationName});
                }
            }
            logger.finest("Exiting doRun()");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, this.lexValue("unexpectedError", new Object[0]), e);
            throw e;
        }
    }

    private RemoteStation getRemoteStation(RemoteStation[] remoteStations, BDeviceStepDetails details, BNiagaraStation station) throws Exception {
        RemoteStation remoteStation = null;
        if (remoteStations == null || remoteStations.length < 1) {
            logger.info(() -> this.lexValue("noStations", new Object[]{station.getStationName()}));
            details.vaFailed(this.lexKey("noStations"), new String[]{station.getStationName()});
            details.complete(BJobState.failed);
        } else if (remoteStations.length > 1) {
            logger.info(() -> this.lexValue("tooManyStations", new Object[]{station.getStationName()}));
            details.vaFailed(this.lexKey("tooManyStations"), new String[]{station.getStationName()});
            details.complete(BJobState.failed);
        } else {
            remoteStation = remoteStations[0];
        }
        if (remoteStation == null) {
            logger.info(() -> this.lexValue("unableToConnect", new Object[]{station.getStationName()}));
            details.vaFailed(this.lexKey("unableToConnect"), new String[]{station.getStationName()});
            details.complete(BJobState.failed);
        }
        return remoteStation;
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }
}

